/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.BaseWizardRunner;
import com.primavera.database.tools.dbmt.actions.DataChangedListener;
import com.primavera.database.tools.dbmt.actions.FieldTester;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardNavigationAction;
import com.primavera.database.tools.dbmt.gui.InteractorPage;
import com.primavera.database.tools.dbmt.gui.LayoutManager;
import com.primavera.database.tools.dbmt.gui.PageLayoutLogic;
import com.primavera.database.tools.dbmt.gui.StandardWizardLayoutLogic;
import com.primavera.database.tools.dbmt.gui.StringFormatUtil;
import com.primavera.database.tools.dbmt.gui.dialogs.GUILayoutSpec;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.text.JTextComponent;

public abstract class GuiWizardRunner
extends BaseWizardRunner {
    public static final PageLayoutLogic DEFAULT_LAYOUT = new StandardWizardLayoutLogic();
    private final LayoutManager.WizardLayoutMap m_layoutMap;
    private InteractorPage m_currentPage;

    protected GuiWizardRunner(WizardInteractorData wizardData, String actionPath) {
        super(wizardData, actionPath);
        this.m_layoutMap = LayoutManager.getWizardLayouts(actionPath, wizardData);
    }

    public void setPage(String pageId) throws InteractorDataError {
        if (this.m_currentPage != null) {
            this.getContentPane().remove(this.m_currentPage.getContainerPanel());
        }
        GUILayoutSpec layoutSpec = this.getLayout(pageId);
        this.m_currentPage = this.createNewPage();
        this.getTitleLabel().setText(this.getData().getPageData(pageId).getTitle());
        this.getDescriptionLabel().setText(this.getData().getPageData(pageId).getDesc());
        this.getContentPane().add((Component)this.m_currentPage.getContainerPanel(), "Center");
        layoutSpec.layoutPanel(this.getData().getPageData(pageId), this.m_currentPage);
        this.connectBindings(this, this.getData(), pageId);
        this.getButton(WizardNavigationAction.PREV).setVisible(!this.firstPage() && this.getData().canPrevious(pageId));
        WizardNavigationAction nextOperation = this.getData().getPageNext(pageId);
        this.getButton(WizardNavigationAction.NEXT).setVisible(nextOperation == WizardNavigationAction.NEXT && this.getData().getNextPage(pageId) != null);
        this.getButton(WizardNavigationAction.INSTALL).setVisible(nextOperation == WizardNavigationAction.INSTALL && this.getData().getNextPage(pageId) != null);
        this.getButton(WizardNavigationAction.UPGRADE).setVisible(nextOperation == WizardNavigationAction.UPGRADE && this.getData().getNextPage(pageId) != null);
        this.getButton(WizardNavigationAction.CREATE).setVisible(nextOperation == WizardNavigationAction.CREATE && this.getData().getNextPage(pageId) != null);
        this.getButton(WizardNavigationAction.FINISH).setVisible(this.getData().canFinish(pageId));
        JButton defaultButton = this.getDefaultButton();
        if (defaultButton != null) {
            this.getRootPane().setDefaultButton(defaultButton);
            defaultButton.grabFocus();
        }
        this.getRootPane().repaint();
    }

    protected abstract Container getContentPane();

    protected abstract JRootPane getRootPane();

    protected abstract void setTitle(String var1);

    protected abstract Window getIconTarget();

    protected abstract InteractorPage createNewPage();

    protected abstract JButton getDefaultButton();

    protected void connectBindings(final GuiWizardRunner wizardRunner, final WizardInteractorData wizardData, final String pageId) {
        try {
            final InteractorData pageData = wizardData.getPageData(pageId);
            this.getData().getPageData(pageId).addDataChangedListener(new DataChangedListener(){

                @Override
                public void onDataChanged(InteractorData data, String field) {
                    ArrayList<String> reasons = new ArrayList<String>();
                    for (FieldTester tester : wizardData.getNextValidators(pageId)) {
                        try {
                            if (tester.doTest(pageData)) continue;
                            reasons.add(tester.getReason(pageData));
                        }
                        catch (InteractorDataError error) {
                            DBMTLogger.error(Channel.USER, error.getLocalizedMessage());
                        }
                    }
                    wizardRunner.getButton(WizardNavigationAction.NEXT).setEnabled(reasons.isEmpty());
                    wizardRunner.getButton(WizardNavigationAction.INSTALL).setEnabled(reasons.isEmpty());
                    wizardRunner.getButton(WizardNavigationAction.UPGRADE).setEnabled(reasons.isEmpty());
                    wizardRunner.getButton(WizardNavigationAction.CREATE).setEnabled(reasons.isEmpty());
                    reasons.clear();
                    for (FieldTester tester : pageData.getFinishValidators()) {
                        try {
                            if (tester.doTest(pageData)) continue;
                            reasons.add(tester.getReason(pageData));
                        }
                        catch (InteractorDataError error) {
                            DBMTLogger.error(Channel.USER, error.getLocalizedMessage());
                        }
                    }
                    wizardRunner.getButton(WizardNavigationAction.FINISH).setEnabled(reasons.isEmpty());
                }
            });
            ArrayList<String> reasons = new ArrayList<String>();
            for (FieldTester tester : wizardData.getNextValidators(pageId)) {
                try {
                    if (tester.doTest(pageData)) continue;
                    reasons.add(tester.getReason(pageData));
                }
                catch (InteractorDataError error) {
                    DBMTLogger.error(Channel.USER, error.getLocalizedMessage());
                }
            }
            wizardRunner.getButton(WizardNavigationAction.NEXT).setEnabled(reasons.isEmpty());
            wizardRunner.getButton(WizardNavigationAction.INSTALL).setEnabled(reasons.isEmpty());
            wizardRunner.getButton(WizardNavigationAction.UPGRADE).setEnabled(reasons.isEmpty());
            wizardRunner.getButton(WizardNavigationAction.CREATE).setEnabled(reasons.isEmpty());
            wizardRunner.getButton(WizardNavigationAction.CANCEL).setVisible(wizardData.getPageData(pageId).isCancel());
            reasons.clear();
            for (FieldTester tester : pageData.getFinishValidators()) {
                try {
                    if (tester.doTest(pageData)) continue;
                    reasons.add(tester.getReason(pageData));
                }
                catch (InteractorDataError error) {
                    DBMTLogger.error(Channel.USER, error.getLocalizedMessage());
                }
            }
            wizardRunner.getButton(WizardNavigationAction.FINISH).setEnabled(reasons.isEmpty());
            for (String fieldId : pageData.getFieldIds()) {
                Collection<FieldTester> testers = pageData.getDef().getValidatorMap().get(fieldId);
                if (testers == null) continue;
                reasons.clear();
                for (FieldTester tester : testers) {
                    try {
                        if (tester.doTest(pageData)) continue;
                        reasons.add(tester.getReason(pageData));
                    }
                    catch (InteractorDataError error) {
                        DBMTLogger.error(Channel.USER, error.getLocalizedMessage());
                    }
                }
                this.m_currentPage.getBinding(fieldId).setEnabled(reasons.isEmpty());
            }
        }
        catch (InteractorDataError error) {
            DBMTLogger.error(Channel.USER, error.getLocalizedMessage());
        }
    }

    protected GUILayoutSpec getLayout(String pageId) {
        GUILayoutSpec spec = this.m_layoutMap.get(pageId, this);
        if (spec == null) {
            return new GUILayoutSpec(DEFAULT_LAYOUT, new HashMap<String, String>());
        }
        return spec;
    }

    @Override
    protected final boolean performWizardAction() {
        String startId = this.getData().getStart();
        this.setTitle(this.getData().getName());
        this.pushPage(startId);
        try {
            this.setPage(startId);
        }
        catch (InteractorDataError error) {
            DBMTLogger.error(Channel.USER, error.getLocalizedMessage());
            return false;
        }
        return this.invokeWindow();
    }

    protected abstract boolean invokeWindow();

    public abstract JButton getButton(WizardNavigationAction var1);

    public abstract JLabel getTitleLabel();

    public abstract JTextComponent getDescriptionLabel();

    public abstract Window getWindow();

    public abstract boolean isAccept();

    @Override
    public void displayMessage(String message) {
        JOptionPane.showMessageDialog(this.getWindow(), StringFormatUtil.breakLines(message), "ERROR", 0);
    }

    static interface WindowCloseAction {
        public void windowClosed();
    }
}

