/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.gui.ActionLogicAction;
import com.primavera.database.tools.dbmt.xml.MenuActionMap;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class MenuDefinition {
    private final List<MenuItemFactory> m_topLevelItems = new ArrayList<MenuItemFactory>();
    private final MenuActionMap m_actionMgr;
    private Class<?> m_context = null;
    private boolean m_main = true;

    public MenuDefinition(MenuActionMap actionMgr) {
        this.m_actionMgr = actionMgr;
    }

    public void setContext(String className) {
        this.m_main = false;
        try {
            this.m_context = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            DBMTLogger.error(Channel.DEV, "Cannot load class " + className + " for menu context");
        }
    }

    public void add(MenuItemFactory factory) {
        this.m_topLevelItems.add(factory);
    }

    public void addToMenuBar(JMenuBar menuBar) {
        for (MenuItemFactory factory : this.m_topLevelItems) {
            for (JMenuItem item : factory.createMenuItems(this.m_actionMgr)) {
                menuBar.add(item);
            }
        }
    }

    public void addToPopupMenu(JPopupMenu menu) {
        for (MenuItemFactory factory : this.m_topLevelItems) {
            for (JMenuItem item : factory.createMenuItems(this.m_actionMgr)) {
                menu.add(item);
            }
        }
    }

    public final void merge(MenuDefinition def) {
        this.m_topLevelItems.addAll(def.m_topLevelItems);
    }

    public final boolean isMain() {
        return this.m_main;
    }

    public final Class<?> getContext() {
        return this.m_context;
    }

    public static class SubMenuItemFactory
    implements MenuItemFactory {
        private final String m_nameKey;
        private final String m_descKey;
        List<MenuItemFactory> m_children = new ArrayList<MenuItemFactory>();

        public SubMenuItemFactory(String nameKey, String descKey) {
            this.m_nameKey = nameKey;
            this.m_descKey = descKey;
        }

        public void addChild(MenuItemFactory factory) {
            this.m_children.add(factory);
        }

        @Override
        public JMenuItem[] createMenuItems(MenuActionMap actionMgr) {
            JMenu subMenu = new JMenu(StringLocalizer.get(this.m_nameKey));
            subMenu.setToolTipText(StringLocalizer.get(this.m_descKey));
            for (MenuItemFactory factory : this.m_children) {
                for (JMenuItem item : factory.createMenuItems(actionMgr)) {
                    subMenu.add(item);
                }
            }
            return new JMenuItem[]{subMenu};
        }
    }

    public static class ActionMenuItemFactory
    implements MenuItemFactory {
        private final String m_actionPath;

        public ActionMenuItemFactory(String actionPath) {
            this.m_actionPath = actionPath;
        }

        @Override
        public JMenuItem[] createMenuItems(MenuActionMap actionMgr) {
            ActionLogicAction action = null;
            action = (ActionLogicAction)actionMgr.findAction(this.m_actionPath);
            if (action != null) {
                return new JMenuItem[]{new JMenuItem(action)};
            }
            DBMTLogger.error(Channel.DEV, "Unable to find menu action object at " + this.m_actionPath);
            return new JMenuItem[0];
        }
    }

    public static interface MenuItemFactory {
        public JMenuItem[] createMenuItems(MenuActionMap var1);
    }
}

