/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.util;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.DataChangedListener;
import com.primavera.database.tools.dbmt.actions.FieldTester;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.gui.util.ValueChangedListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;

public abstract class ComponentBinding {
    private final InteractorData m_data;
    private final String m_fieldId;

    protected ComponentBinding(InteractorData data, String fieldId) {
        this.m_fieldId = fieldId;
        this.m_data = data;
    }

    public abstract void setComponentData(String var1);

    public abstract String getComponentData();

    public final InteractorData getData() {
        return this.m_data;
    }

    public final String getFieldId() {
        return this.m_fieldId;
    }

    public abstract JComponent[] getComponents();

    public abstract void addChangeListener(ValueChangedListener var1);

    public void bindToField(final Map<String, ComponentBinding> bindings) {
        this.addChangeListener(new ValueChangedListener(){

            @Override
            public void onValueChanged(String fieldId) {
                ComponentBinding.this.m_data.setValue(fieldId, ComponentBinding.this.getComponentData());
            }
        });
        this.m_data.addDataChangedListener(new DataChangedListener(){

            @Override
            public void onDataChanged(InteractorData data, String field) {
                Collection<String> dependentFields = data.getDef().getDependencyMap().get(field);
                if (dependentFields == null) {
                    return;
                }
                for (String depField : dependentFields) {
                    Collection<FieldTester> tests = data.getDef().getValidatorMap().get(depField);
                    HashSet<String> failures = new HashSet<String>();
                    if (tests != null) {
                        for (FieldTester test : tests) {
                            try {
                                if (test.doTest(data)) continue;
                                failures.add(test.getReason(data));
                            }
                            catch (InteractorDataError error) {
                                DBMTLogger.error(Channel.USER, error.getLocalizedMessage());
                            }
                        }
                    }
                    ((ComponentBinding)bindings.get(depField)).setEnabled(failures.isEmpty());
                }
            }
        });
    }

    public void setEnabled(boolean isEnabled) {
        for (JComponent comp : this.getComponents()) {
            comp.setEnabled(isEnabled);
        }
    }

    protected static class ValueBinding<T> {
        public T m_value;

        public ValueBinding() {
            this.m_value = null;
        }

        public ValueBinding(T value) {
            this.m_value = value;
        }

        public boolean isSet() {
            return this.m_value != null;
        }
    }
}

