/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.util;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.dbmt.actions.EnumDataEntry;
import com.primavera.database.tools.dbmt.actions.EnumTypeDef;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.gui.util.ComponentBinding;
import com.primavera.database.tools.dbmt.gui.util.ValueChangedListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EnumComponentBinding
extends ComponentBinding {
    private final ButtonGroup m_group = new ButtonGroup();
    private final List<JRadioButton> m_buttons = new ArrayList<JRadioButton>();
    private final List<String> m_ids = new ArrayList<String>();

    public EnumComponentBinding(InteractorData data, String fieldId) {
        super(data, fieldId);
        EnumDataEntry[] enumValues;
        EnumTypeDef enumTypeDef = (EnumTypeDef)this.getData().getDef().get(this.getFieldId()).getTypeDef();
        for (EnumDataEntry enumValue : enumValues = enumTypeDef.getValues()) {
            JRadioButton button = new JRadioButton(StringLocalizer.get(enumValue.getNameKey()));
            button.setToolTipText(StringLocalizer.get(enumValue.getDescKey()));
            button.setMnemonic(this.getMnemonicFromKey(enumValue.getMnemonicKey()));
            this.m_ids.add(enumValue.getId().toUpperCase());
            this.m_buttons.add(button);
            this.m_group.add(button);
        }
    }

    private char getMnemonicFromKey(String mnemonicKey) {
        if (mnemonicKey == null) {
            return '\u0000';
        }
        String mnemonicString = StringLocalizer.get(mnemonicKey);
        if (mnemonicString == null || mnemonicString.length() == 0 || !Character.isLetter(mnemonicString.charAt(0))) {
            return '\u0000';
        }
        return mnemonicString.charAt(0);
    }

    @Override
    public void addChangeListener(final ValueChangedListener listener) {
        for (JRadioButton button : this.m_buttons) {
            button.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    listener.onValueChanged(EnumComponentBinding.this.getFieldId());
                }
            });
        }
    }

    @Override
    public JComponent[] getComponents() {
        return this.m_buttons.toArray(new JRadioButton[0]);
    }

    @Override
    public void setComponentData(String dataString) {
        String selectedButton = dataString.toUpperCase();
        for (int i = 0; i < this.m_buttons.size(); ++i) {
            if (!selectedButton.equals(this.m_ids.get(i))) continue;
            this.m_buttons.get(i).setSelected(true);
        }
    }

    @Override
    public String getComponentData() {
        for (int i = 0; i < this.m_buttons.size(); ++i) {
            if (!this.m_buttons.get(i).isSelected()) continue;
            return this.m_ids.get(i);
        }
        return null;
    }
}

