/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.gui.util;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class FileDialogUtil {
    private static final FileDialogUtil s_inst = new FileDialogUtil();
    private final Map<String, String> m_lastDirectoryMap = new HashMap<String, String>();
    private FileDialogAsynchInstance m_TSChooser;

    private FileDialogUtil() {
    }

    public static FileDialogUtil inst() {
        return s_inst;
    }

    public static synchronized Set<Map.Entry<String, String>> getEntrySet() {
        return FileDialogUtil.inst().m_lastDirectoryMap.entrySet();
    }

    public static synchronized File getMostRecentDirectory(String key) {
        String dirName = FileDialogUtil.inst().m_lastDirectoryMap.get(key);
        if (dirName != null) {
            return new File(dirName);
        }
        return new File(".");
    }

    public static synchronized void setMostRecentDirectory(String key, File dir) {
        if (!dir.isDirectory()) {
            dir = dir.getParentFile();
        }
        FileDialogUtil.inst().m_lastDirectoryMap.put(key, dir.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized File request(FileRequest req, Component parent, String prefKey) {
        FileDialogUtil fileDialogUtil = this;
        synchronized (fileDialogUtil) {
            if (this.m_TSChooser == null) {
                this.m_TSChooser = new FileDialogAsynchInstance();
            }
        }
        return this.m_TSChooser.request(req, parent, prefKey);
    }

    public final void init() {
    }

    private final class FileDialogAsynchInstance {
        private JFileChooser m_chooser = null;

        public FileDialogAsynchInstance() {
            this.tsInitialize();
        }

        private final void tsInitialize() {
            System.out.println("Starting async_initializer ()");
            System.out.println("Finishing async_initializer ()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public File request(FileRequest req, Component parent, String prefKey) {
            FileDialogAsynchInstance fileDialogAsynchInstance = this;
            synchronized (fileDialogAsynchInstance) {
                if (this.m_chooser == null) {
                    this.m_chooser = new JFileChooser();
                }
            }
            JFileChooser chooser = this.m_chooser;
            chooser.setFileSelectionMode(req.getSelectioMode());
            chooser.setName(req.getTitle());
            chooser.setMultiSelectionEnabled(false);
            File dir = FileDialogUtil.getMostRecentDirectory(prefKey);
            chooser.setCurrentDirectory(dir);
            chooser.showSaveDialog(null);
            int result = chooser.showOpenDialog(parent);
            switch (result) {
                case -1: {
                    JOptionPane.showMessageDialog(parent, "An error occured");
                }
                case 0: {
                    return this.m_chooser.getSelectedFile();
                }
            }
            return null;
        }
    }

    public static class FileRequest {
        private final List<String> m_filterPatterns = new ArrayList<String>();
        private int m_selectioMode = 0;
        private File m_currentDirectory;
        private boolean m_multiSelection;
        private String m_title;

        public final File getCurrentDirectory() {
            return this.m_currentDirectory;
        }

        public final void setCurrentDirectory(File currentDirectory) {
            this.m_currentDirectory = currentDirectory;
        }

        public final Iterable<String> getFilterPatterns() {
            return this.m_filterPatterns;
        }

        public final void addFilterPattern(String filterPattern) {
            this.m_filterPatterns.add(filterPattern);
        }

        public final boolean isMultiSelection() {
            return this.m_multiSelection;
        }

        public final void setMultiSelection(boolean multiSelection) {
            this.m_multiSelection = multiSelection;
        }

        public final int getSelectioMode() {
            return this.m_selectioMode;
        }

        public final void setSelectioMode(int selectioMode) {
            this.m_selectioMode = selectioMode;
        }

        public String getTitle() {
            return this.m_title;
        }

        public final void setTitle(String title) {
            this.m_title = title;
        }
    }
}

