/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.updatelogins;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.common.logging.Log;
import com.primavera.database.tools.dbmt.gui.util.LookAndFeelUtil;
import com.primavera.database.tools.dbmt.updatelogins.SilentDBConfiguration;
import com.primavera.database.tools.dbmt.updatelogins.UpdatePrivateDabaseLoginsModel;
import com.primavera.database.tools.dbmt.updatelogins.ui.ComponentPanel;
import com.primavera.database.tools.dbmt.updatelogins.ui.DatabaseConnectionPanel;
import com.primavera.database.tools.dbmt.updatelogins.ui.LoginTablePanel;
import com.primavera.database.tools.dbmt.updatelogins.ui.UpdatePrivateDatabaseLoginsUI;
import com.primavera.database.tools.dbmt.util.DevelopmentStringLocalizer;
import com.primavera.database.tools.dbmt.xml.util.LogFileUtil;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;

public class UpdatePrivateDatabaseLogins {
    static boolean finished = true;
    private static boolean m_silentMode = false;
    private static String m_configType = null;
    private static String m_configFile = null;
    private static Properties m_stringProperties = new Properties();
    private static boolean m_deleteFile = false;

    public static void main(String[] args) {
        try {
            UpdatePrivateDatabaseLogins.parseCmdLine(args);
            UpdatePrivateDatabaseLogins.checkCmdLineArgs();
        }
        catch (Exception e) {
            System.out.println("Error: Invalid command line parameters. " + e.getMessage() + "\n");
            System.exit(0);
        }
        UpdatePrivateDatabaseLogins.initializeLogging();
        StringLocalizer.setInstance(new DevelopmentStringLocalizer());
        if (!m_silentMode) {
            LookAndFeelUtil.setLookAndFeelAndUIDefaults();
            UpdatePrivateDabaseLoginsModel model = new UpdatePrivateDabaseLoginsModel();
            model.m_transitionMap.put(ComponentPanel.getPanelId(DatabaseConnectionPanel.class), ComponentPanel.getPanelId(LoginTablePanel.class));
            UpdatePrivateDatabaseLogins.invokeUI(model);
            System.exit(0);
        } else {
            try {
                UpdatePrivateDatabaseLogins.importProperties(m_configFile);
                UpdatePrivateDatabaseLogins.checkPropertiesFileEntry();
                SilentDBConfiguration dbconfig = new SilentDBConfiguration(m_stringProperties);
                dbconfig.createConnection();
                System.out.println("Database Connection Created");
                dbconfig.doDBOperation();
                if (m_deleteFile) {
                    boolean deleted = UpdatePrivateDatabaseLogins.deletePropertyFile(m_configFile);
                    if (deleted) {
                        System.out.println("Property file " + m_configFile + " deleted successfully");
                    } else {
                        System.out.println("Property file " + m_configFile + " not deleted successfully");
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Problem during processing command: " + e.getMessage() + "\n");
                System.exit(0);
            }
        }
    }

    private static void initializeLogging() {
        DBMTLogger.LogLevel devLogLevel = LogFileUtil.getDevLogLevel();
        DBMTLogger.addAppender(DBMTLogger.LOG4J_APPENDER);
        DBMTLogger.addAppender(DBMTLogger.CONSOLE_APPENDER);
        DBMTLogger.addChannel(Channel.DEV);
        DBMTLogger.addChannel(Channel.USER);
        DBMTLogger.setLogLevel(Channel.USER, DBMTLogger.LOG4J_APPENDER, DBMTLogger.LogLevel.INFO);
        DBMTLogger.setLogLevel(Channel.DEV, DBMTLogger.CONSOLE_APPENDER, devLogLevel);
        DBMTLogger.setLogLevel(Channel.DEV, DBMTLogger.LOG4J_APPENDER, DBMTLogger.LogLevel.ERROR);
        String userHome = System.getProperty("user.home");
        Log.setLogFileName(userHome + File.separatorChar + LogFileUtil.getLogFileName());
        DBMTLogger.info(Channel.DEV, "Look and feel is " + UIManager.getSystemLookAndFeelClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeUI(UpdatePrivateDabaseLoginsModel model) {
        final UpdatePrivateDatabaseLoginsUI ui = new UpdatePrivateDatabaseLoginsUI(model).initialize();
        ui.m_root.pack();
        ui.m_root.setLocationByPlatform(true);
        Thread uiThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ui.m_root.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        UpdatePrivateDatabaseLogins.finishApplication();
                    }
                });
                ui.m_root.setVisible(true);
            }
        }, "User Interface Thread");
        finished = false;
        uiThread.start();
        Thread thread = uiThread;
        synchronized (thread) {
            while (!finished) {
                try {
                    uiThread.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static void finishApplication() {
        finished = true;
    }

    public static void exit() {
        UpdatePrivateDatabaseLogins.finishApplication();
    }

    private static void parseCmdLine(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].toLowerCase();
            if (arg.equals("-file")) {
                m_silentMode = true;
                m_configFile = UpdatePrivateDatabaseLogins.getArgumentValue(args, ++i);
                continue;
            }
            if (arg.equals("-createfile")) {
                m_configFile = UpdatePrivateDatabaseLogins.getArgumentValue(args, ++i);
                UpdatePrivateDatabaseLogins.createPropertyFile(m_configFile);
                System.exit(0);
                continue;
            }
            if (arg.equals("-h") || arg.equals("/h") || arg.equals("-help") || arg.equals("/?")) {
                UpdatePrivateDatabaseLogins.showHelp();
                System.exit(0);
                continue;
            }
            if (arg.equals("-deletefile")) {
                m_deleteFile = true;
                continue;
            }
            throw new Exception("Unknown Option: " + arg);
        }
    }

    private static String getArgumentValue(String[] args, int pos) throws Exception {
        if (pos >= args.length) {
            throw new Exception("Value not specified for an option");
        }
        return args[pos];
    }

    private static void checkCmdLineArgs() throws Exception {
        if (m_silentMode && StringUtils.isEmpty((CharSequence)m_configFile)) {
            throw new Exception("Required options are not specified");
        }
    }

    private static void importProperties(String propertiesFile) throws Exception {
        try (FileInputStream resStream = new FileInputStream(propertiesFile);){
            m_stringProperties.load(resStream);
        }
        catch (IOException e) {
            DBMTLogger.error(Channel.DEV, "Unable to find string properties at " + propertiesFile);
            throw new Exception("Unable to find string properties at " + propertiesFile);
        }
    }

    private static void checkPropertiesFileEntry() throws Exception {
        if (!(StringUtils.equalsIgnoreCase((CharSequence)"Oracle", (CharSequence)m_stringProperties.getProperty("dbtype").trim()) || StringUtils.equalsIgnoreCase((CharSequence)"SQLSERVER", (CharSequence)m_stringProperties.getProperty("dbtype").trim()) || StringUtils.equalsIgnoreCase((CharSequence)"OracleATP", (CharSequence)m_stringProperties.getProperty("dbtype").trim()))) {
            throw new Exception("Invalid argument for dbtype");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"Oracle", (CharSequence)m_stringProperties.getProperty("dbtype"))) {
            if (!StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("url")) && (StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("username")) || StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("password")))) {
                throw new Exception("Required properties are not entered in properties file for Oracle database");
            }
            if (!(StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("url")) || StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("username")) || StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("password")))) {
                return;
            }
            if (StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("host")) || StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("port")) || StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("username")) || StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("password")) || StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("dbname")) || StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("type"))) {
                throw new Exception("Required properties are not entered in properties file for Oracle database");
            }
        } else {
            if (StringUtils.equalsIgnoreCase((CharSequence)"SQLSERVER", (CharSequence)m_stringProperties.getProperty("dbtype")) && (StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("host")) || StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("port")) || StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("username")) || StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("password")) || StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("dbname")))) {
                throw new Exception("Required properties are not entered in properties file for SQL Server.");
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"OracleATP", (CharSequence)m_stringProperties.getProperty("dbtype")) && (StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("host")) || StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("username")) || StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("password")) || StringUtils.isEmpty((CharSequence)m_stringProperties.getProperty("dbname")))) {
                throw new Exception("Required properties are not entered in properties file for OracleATP.");
            }
        }
    }

    private static void showHelp() {
        String helpStr = "Optional command-line parameters:\nUsage: databaselogins [options]\noptions: \n    -file <File Name>              Text file having key-value pair to update\n\n    -createfile                    Creates the property file template\n\n    -deletefile                    Deletes the property file template(should be used with -file, see example)\n\n    -help                          Print usage text (this message)\n\nExample:\n    databaselogins -file keyvalue.properties \n\n    databaselogins -createfile keyvalue.properties\n\n    databaselogins -file keyvalue.properties -deletefile\n\n";
        System.out.println(helpStr);
    }

    private static void createPropertyFile(String fileName) {
        File propFile = new File(fileName);
        try (FileWriter fr = new FileWriter(propFile);){
            fr.write(UpdatePrivateDatabaseLogins.createContent());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean deletePropertyFile(String fileName) {
        File propFile = new File(fileName);
        if (propFile.exists()) {
            return propFile.delete();
        }
        System.out.println(fileName + " does not exist.");
        return false;
    }

    private static String createContent() {
        StringBuffer content = new StringBuffer("# dbtype must be ORACLE or SQLServer or OracleATP \n");
        content.append("dbtype=Oracle\n");
        content.append("# url is the full connection string for Oracle database. If url is populated host,port ,dbname, type is not considered \n");
        content.append("url= \n");
        content.append("#Self explanatory(For OracleATP host must be database unzipped wallet location) \n");
        content.append("host= \n");
        content.append("# Not required for OracleATP \n");
        content.append("port=1521 \n");
        content.append("username= \n");
        content.append("password= \n\n");
        content.append("# dbname is Oracle instance name or SQL Server database name or OracleATP service name\n");
        content.append("dbname=\n\n");
        content.append("# Required for Oracle only: type should be SID or SERVICE \n");
        content.append("type=SID \n");
        content.append("#Commands \n");
        content.append("# \n");
        content.append("# Commands must be specified as: \n");
        content.append("#  command1=<command details> \n");
        content.append("#  command2=<command details> \n");
        content.append("# \n");
        content.append("# Examples: \n");
        content.append("# command1=adduser privuser Welcome@123 \n");
        content.append("# command2=updatepassword privuser Welcome@321 \n");
        content.append("# command3=deleteuser privuser \n");
        content.append("# command4=listuser \n");
        content.append("# command5=updateuser privuser privuser1 \n");
        content.append("# command6=updatepublicgroupId 1 2 \n");
        content.append("# \n");
        content.append("# Command syntax: \n");
        content.append("#  adduser <username> <password> \n");
        content.append("#  updatepassword <username> <newpassword> \n");
        content.append("#  deleteuser <username> \n");
        content.append("#  listuser \n");
        content.append("#  updateuser <oldusername> <newusername> \n");
        content.append("#  updatepublicgroupId <oldpublicgroupid> <newpublicgroupid> \n");
        return content.toString();
    }
}

