/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.updatelogins.ui;

import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.BaseServerInfo;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.dbservers.mssql.MSSqlServerInfo;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleServerInfo;
import com.primavera.database.tools.dbmt.updatelogins.UpdatePrivateDabaseLoginsModel;
import com.primavera.database.tools.dbmt.updatelogins.ui.ComponentPanel;
import com.primavera.database.tools.dbmt.updatelogins.ui.NavigationOperation;
import com.primavera.database.tools.dbmt.updatelogins.ui.PanelIdentifier;
import com.primavera.database.tools.dbmt.updatelogins.ui.UnableToCreateConnectionFromConnectString;
import com.primavera.database.tools.dbmt.updatelogins.ui.UpdatePrivateDatabaseLoginsUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@PanelIdentifier(value="page.connections")
public class DatabaseConnectionPanel
extends ComponentPanel {
    private static final int LABEL_COLUMN_WIDTH = 100;
    private static final int TEXT_COLUMN_NUMBER = 20;
    private static final int SPACING_VERTICAL = 20;
    private static final int NUMERIC_COLUMN_NUMBER = 6;
    private static final String PANEL_NAME_CONNECTION_SQLSERVER = "connection.sqlserver";
    private static final String PANEL_NAME_CONNECTION_ORACLE = "connection.oracle";
    private static final String PANEL_NAME_CONNECTION_ORACLE_ATP = "connection.oracleatp";
    private static final String CONNECTION_LABEL_SS_NAME = "dbmt.update.private.database.connection.ss.name.title";
    private static final String CONNECTION_MNEMONIC_SS_NAME = "dbmt.update.private.database.connection.ss.name.mnemonic";
    private static final String CONNECTION_LABEL_SS_PASS = "dbmt.update.private.database.connection.ss.pass.title";
    private static final String CONNECTION_MNEMONIC_SS_PASS = "dbmt.update.private.database.connection.ss.pass.mnemonic";
    private static final String CONNECTION_LABEL_SS_PORT = "dbmt.update.private.database.connection.ss.port.title";
    private static final String CONNECTION_MNEMONIC_SS_PORT = "dbmt.update.private.database.connection.ss.port.mnemonic";
    private static final String CONNECTION_LABEL_SS_DATABASE = "dbmt.update.private.database.connection.ss.database.title";
    private static final String CONNECTION_MNEMONIC_SS_DATABASE = "dbmt.update.private.database.connection.ss.database.mnemonic";
    private static final String CONNECTION_LABEL_SS_HOST = "dbmt.update.private.database.connection.ss.host.title";
    private static final String CONNECTION_MNEMONIC_SS_HOST = "dbmt.update.private.database.connection.ss.host.mnemonic";
    private static final String CONNECTION_LABEL_OR_NAME = "dbmt.update.private.database.connection.or.name.title";
    private static final String CONNECTION_MNEMONIC_OR_NAME = "dbmt.update.private.database.connection.or.name.mnemonic";
    private static final String CONNECTION_LABEL_OR_PASS = "dbmt.update.private.database.connection.or.pass.title";
    private static final String CONNECTION_MNEMONIC_OR_PASS = "dbmt.update.private.database.connection.or.pass.mnemonic";
    private static final String CONNECTION_LABEL_OR_PORT = "dbmt.update.private.database.connection.or.port.title";
    private static final String CONNECTION_MNEMONIC_OR_PORT = "dbmt.update.private.database.connection.or.port.mnemonic";
    private static final String CONNECTION_LABEL_OR_INSTANCE = "dbmt.update.private.database.connection.or.instance.title";
    private static final String CONNECTION_MNEMONIC_OR_INSTANCE = "dbmt.update.private.database.connection.or.instance.mnemonic";
    private static final String CONNECTION_LABEL_OR_HOST = "dbmt.update.private.database.connection.or.host.title";
    private static final String CONNECTION_MNEMONIC_OR_HOST = "dbmt.update.private.database.connection.or.host.mnemonic";
    private static final String CONNECTION_LABEL_OR_ATP_HOST = "dbmt.update.private.database.connection.oratp.host.title";
    private static final String CONNECTION_MNEMONIC_OR_ATP_HOST = "dbmt.update.private.database.connection.oratp.host.mnemonic";
    private static final String DBTYPE_LABEL_OR = "dbmt.update.private.database.dbtype.or.title";
    private static final String DBTYPE_LABEL_SS = "dbmt.update.private.database.dbtype.ss.title";
    private static final String DBTYPE_LABEL_OR_ATP = "dbmt.update.private.database.dbtype.oratp.title";
    private static final String CONNECTION_LABEL_SSL = "dbmt.update.private.database.connection.ssl.title";
    private final ButtonGroup m_btnGroupDbType = new ButtonGroup();
    private final JRadioButton m_radioDbType_Oracle = new JRadioButton(StringLocalizer.get("dbmt.update.private.database.dbtype.or.title"));
    private final JRadioButton m_radioDbType_SqlServer = new JRadioButton(StringLocalizer.get("dbmt.update.private.database.dbtype.ss.title"));
    private final JRadioButton m_radioDbType_OracleATP = new JRadioButton(StringLocalizer.get("dbmt.update.private.database.dbtype.oratp.title"));
    private final ButtonGroup m_btnGroupInstanceType = new ButtonGroup();
    private final JRadioButton m_radioInstanceType_SID = new JRadioButton("SID");
    private final JRadioButton m_radioInstanceType_Service = new JRadioButton("Service");
    private final CardLayout m_cardLayoutManager = new CardLayout();
    private final JPanel m_dbTypePanel = new JPanel();
    private final JPanel m_dbConnectionRootPanel = new JPanel();
    private final JPanel m_oracleConnectionPanel = new JPanel();
    private final JPanel m_sqlserverConnectionPanel = new JPanel();
    private final JPanel m_oracleatpConnectionPanel = new JPanel();
    private final String m_hostName = DatabaseConnectionPanel.getHostname();
    private final JTextField m_txtSSusername = new JTextField("privuser");
    private final JPasswordField m_txtSSpassword = new JPasswordField();
    private final JTextField m_txtSShost = new JTextField(this.m_hostName);
    private final JTextField m_txtSSport = new JTextField("1433");
    private final JTextField m_txtSSdatabase = new JTextField();
    private final JTextField m_txtORusername = new JTextField("privuser");
    private final JPasswordField m_txtORpassword = new JPasswordField();
    private final JTextField m_txtORATPusername = new JTextField("privuser");
    private final JPasswordField m_txtORATPpassword = new JPasswordField();
    private final JTextField m_txtORhost = new JTextField(this.m_hostName);
    private final JTextField m_txtORATPwallet = new JTextField();
    private final JTextField m_txtORport = new JTextField("1521");
    private final JTextField m_txtORinstance = new JTextField();
    private final JTextField m_txtORATPinstance = new JTextField();
    private final JTextField[] m_ssFields = new JTextField[]{this.m_txtSSdatabase, this.m_txtSShost, this.m_txtSSport, this.m_txtSSusername};
    private final JTextField[] m_orFields = new JTextField[]{this.m_txtORinstance, this.m_txtORhost, this.m_txtORport, this.m_txtORusername};
    private final JTextField[] m_oratpFields = new JTextField[]{this.m_txtORATPinstance, this.m_txtORATPwallet, this.m_txtORATPusername};
    private final JCheckBox m_orCheckSSL = new JCheckBox();
    private final JCheckBox m_ssCheckSSL = new JCheckBox();

    public DatabaseConnectionPanel(UpdatePrivateDabaseLoginsModel m, UpdatePrivateDatabaseLoginsUI ui) {
        super(m, ui);
    }

    private static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e1) {
                return "";
            }
        }
    }

    @Override
    public boolean showButton(NavigationOperation op) {
        return op == NavigationOperation.NEXT || op == NavigationOperation.CANCEL;
    }

    @Override
    public void initialize() {
        this.m_btnGroupDbType.add(this.m_radioDbType_Oracle);
        this.m_btnGroupDbType.add(this.m_radioDbType_SqlServer);
        this.m_btnGroupDbType.add(this.m_radioDbType_OracleATP);
        this.m_radioDbType_Oracle.setSelected(this.model.dbType == ServerType.ORACLE);
        this.m_radioDbType_SqlServer.setSelected(this.model.dbType == ServerType.SQLSERVER);
        this.m_radioDbType_OracleATP.setSelected(this.model.dbType == ServerType.ORACLEATP);
        DBTypeRadioButtonChangeListener listener = new DBTypeRadioButtonChangeListener();
        this.m_radioDbType_Oracle.addActionListener(listener);
        this.m_radioDbType_SqlServer.addActionListener(listener);
        this.m_radioDbType_OracleATP.addActionListener(listener);
        this.m_dbTypePanel.setLayout(new FlowLayout());
        this.m_dbTypePanel.add(this.m_radioDbType_Oracle);
        this.m_dbTypePanel.add(this.m_radioDbType_SqlServer);
        this.m_dbTypePanel.add(this.m_radioDbType_OracleATP);
        this.m_dbConnectionRootPanel.setLayout(this.m_cardLayoutManager);
        this.m_dbConnectionRootPanel.add((Component)this.m_oracleConnectionPanel, PANEL_NAME_CONNECTION_ORACLE);
        this.m_dbConnectionRootPanel.add((Component)this.m_sqlserverConnectionPanel, PANEL_NAME_CONNECTION_SQLSERVER);
        this.m_dbConnectionRootPanel.add((Component)this.m_oracleatpConnectionPanel, PANEL_NAME_CONNECTION_ORACLE_ATP);
        this.initializeOracleConnectionPanel(this.m_oracleConnectionPanel);
        this.initializeSqlServerConnectionPanel(this.m_sqlserverConnectionPanel);
        this.initializeOracleATPConnectionPanel(this.m_oracleatpConnectionPanel);
        this.root.setLayout(new BorderLayout());
        this.root.add((Component)this.m_dbTypePanel, "North");
        this.root.add((Component)this.m_dbConnectionRootPanel, "Center");
        this.setupNextEnabler();
    }

    private void setupNextEnabler() {
        NextButtonEnableListener listener = new NextButtonEnableListener();
        this.m_radioDbType_Oracle.addChangeListener(listener);
        this.m_radioDbType_SqlServer.addChangeListener(listener);
        this.m_radioDbType_OracleATP.addChangeListener(listener);
        this.m_orCheckSSL.addChangeListener(listener);
        this.m_ssCheckSSL.addChangeListener(listener);
        this.m_txtORpassword.addCaretListener(listener);
        for (JTextField f : this.m_orFields) {
            f.addCaretListener(listener);
        }
        this.m_txtSSpassword.addCaretListener(listener);
        for (JTextField f : this.m_ssFields) {
            f.addCaretListener(listener);
        }
        this.m_txtORATPpassword.addCaretListener(listener);
        for (JTextField f : this.m_oratpFields) {
            f.addCaretListener(listener);
        }
        listener.setNextButtonEnabledStatus();
    }

    private void initializeSqlServerConnectionPanel(JPanel sqlserverConnectionPanel) {
        GroupLayout layout = new GroupLayout(sqlserverConnectionPanel);
        sqlserverConnectionPanel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        JLabel lblusername = new JLabel(StringLocalizer.get(CONNECTION_LABEL_SS_NAME));
        this.bindLabelToControl(lblusername, this.m_txtSSusername, StringLocalizer.get(CONNECTION_MNEMONIC_SS_NAME));
        JLabel lblpassword = new JLabel(StringLocalizer.get(CONNECTION_LABEL_SS_PASS));
        this.bindLabelToControl(lblpassword, this.m_txtSSpassword, StringLocalizer.get(CONNECTION_MNEMONIC_SS_PASS));
        JLabel lblhost = new JLabel(StringLocalizer.get(CONNECTION_LABEL_SS_HOST));
        this.bindLabelToControl(lblhost, this.m_txtSShost, StringLocalizer.get(CONNECTION_MNEMONIC_SS_HOST));
        JLabel lblport = new JLabel(StringLocalizer.get(CONNECTION_LABEL_SS_PORT));
        this.bindLabelToControl(lblport, this.m_txtSSport, StringLocalizer.get(CONNECTION_MNEMONIC_SS_PORT));
        JLabel lbldatabase = new JLabel(StringLocalizer.get(CONNECTION_LABEL_SS_DATABASE));
        this.bindLabelToControl(lbldatabase, this.m_txtSSdatabase, StringLocalizer.get(CONNECTION_MNEMONIC_SS_DATABASE));
        JLabel lblSSL = new JLabel(StringLocalizer.get(CONNECTION_LABEL_SSL));
        int labelGroupWidth = lblusername.getPreferredSize().width;
        labelGroupWidth = Math.max(labelGroupWidth, 100);
        labelGroupWidth = Math.max(labelGroupWidth, lblpassword.getPreferredSize().width);
        labelGroupWidth = Math.max(labelGroupWidth, lblhost.getPreferredSize().width);
        labelGroupWidth = Math.max(labelGroupWidth, lblport.getPreferredSize().width);
        labelGroupWidth = Math.max(labelGroupWidth, lbldatabase.getPreferredSize().width);
        GroupLayout.ParallelGroup hGrp1 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        ((GroupLayout.Group)hGrp1).addComponent(lblusername, labelGroupWidth, labelGroupWidth, labelGroupWidth);
        ((GroupLayout.Group)hGrp1).addComponent(lblpassword, labelGroupWidth, labelGroupWidth, labelGroupWidth);
        ((GroupLayout.Group)hGrp1).addComponent(lblhost, labelGroupWidth, labelGroupWidth, labelGroupWidth);
        ((GroupLayout.Group)hGrp1).addComponent(lblport, labelGroupWidth, labelGroupWidth, labelGroupWidth);
        ((GroupLayout.Group)hGrp1).addComponent(lbldatabase, labelGroupWidth, labelGroupWidth, labelGroupWidth);
        ((GroupLayout.Group)hGrp1).addComponent(lblSSL, labelGroupWidth, labelGroupWidth, labelGroupWidth);
        GroupLayout.ParallelGroup hGrp2 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        this.m_txtSSusername.setColumns(20);
        ((GroupLayout.Group)hGrp2).addComponent(this.m_txtSSusername, this.m_txtSSusername.getPreferredSize().width, this.m_txtSSusername.getPreferredSize().width, this.m_txtSSusername.getPreferredSize().width);
        this.m_txtSSpassword.setColumns(20);
        ((GroupLayout.Group)hGrp2).addComponent(this.m_txtSSpassword, this.m_txtSSpassword.getPreferredSize().width, this.m_txtSSpassword.getPreferredSize().width, this.m_txtSSpassword.getPreferredSize().width);
        this.m_txtSShost.setColumns(20);
        ((GroupLayout.Group)hGrp2).addComponent(this.m_txtSShost, this.m_txtSShost.getPreferredSize().width, this.m_txtSShost.getPreferredSize().width, this.m_txtSShost.getPreferredSize().width);
        this.m_txtSSport.setColumns(6);
        ((GroupLayout.Group)hGrp2).addComponent(this.m_txtSSport, this.m_txtSSport.getPreferredSize().width, this.m_txtSSport.getPreferredSize().width, this.m_txtSSport.getPreferredSize().width);
        this.m_txtSSdatabase.setColumns(20);
        ((GroupLayout.Group)hGrp2).addComponent(this.m_txtSSdatabase, this.m_txtSSdatabase.getPreferredSize().width, this.m_txtSSdatabase.getPreferredSize().width, this.m_txtSSdatabase.getPreferredSize().width);
        ((GroupLayout.Group)hGrp2).addComponent(this.m_ssCheckSSL, this.m_ssCheckSSL.getPreferredSize().width, this.m_ssCheckSSL.getPreferredSize().width, this.m_ssCheckSSL.getPreferredSize().width);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(hGrp1).addGroup(hGrp2));
        GroupLayout.SequentialGroup vSeqGrp = layout.createSequentialGroup();
        vSeqGrp.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblusername).addComponent(this.m_txtSSusername));
        vSeqGrp.addGap(20);
        vSeqGrp.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblpassword).addComponent(this.m_txtSSpassword));
        vSeqGrp.addGap(20);
        vSeqGrp.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblhost).addComponent(this.m_txtSShost));
        vSeqGrp.addGap(20);
        vSeqGrp.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblport).addComponent(this.m_txtSSport));
        vSeqGrp.addGap(20);
        vSeqGrp.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lbldatabase).addComponent(this.m_txtSSdatabase));
        vSeqGrp.addGap(20);
        vSeqGrp.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblSSL).addComponent(this.m_ssCheckSSL));
        layout.setVerticalGroup(vSeqGrp);
    }

    private void bindLabelToControl(JLabel label, JTextField component, String mnemonic) {
        label.setLabelFor(component);
        label.setDisplayedMnemonic(mnemonic.charAt(0));
        component.addFocusListener(new TextSelectFocusListener(component));
    }

    private void initializeOracleConnectionPanel(JPanel oracleConnectionPanel) {
        GroupLayout layout = new GroupLayout(oracleConnectionPanel);
        oracleConnectionPanel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        JLabel lblusername = new JLabel(StringLocalizer.get(CONNECTION_LABEL_OR_NAME));
        this.bindLabelToControl(lblusername, this.m_txtORusername, StringLocalizer.get(CONNECTION_MNEMONIC_OR_NAME));
        JLabel lblpassword = new JLabel(StringLocalizer.get(CONNECTION_LABEL_OR_PASS));
        this.bindLabelToControl(lblpassword, this.m_txtORpassword, StringLocalizer.get(CONNECTION_MNEMONIC_OR_PASS));
        JLabel lblhost = new JLabel(StringLocalizer.get(CONNECTION_LABEL_OR_HOST));
        this.bindLabelToControl(lblhost, this.m_txtORhost, StringLocalizer.get(CONNECTION_MNEMONIC_OR_HOST));
        JLabel lblport = new JLabel(StringLocalizer.get(CONNECTION_LABEL_OR_PORT));
        this.m_txtORport.setColumns(6);
        this.bindLabelToControl(lblport, this.m_txtORport, StringLocalizer.get(CONNECTION_MNEMONIC_OR_PORT));
        JLabel lblinstance = new JLabel(StringLocalizer.get(CONNECTION_LABEL_OR_INSTANCE));
        this.bindLabelToControl(lblinstance, this.m_txtORinstance, StringLocalizer.get(CONNECTION_MNEMONIC_OR_INSTANCE));
        JLabel lblSSL = new JLabel(StringLocalizer.get(CONNECTION_LABEL_SSL));
        this.m_btnGroupInstanceType.add(this.m_radioInstanceType_SID);
        this.m_btnGroupInstanceType.add(this.m_radioInstanceType_Service);
        this.m_radioInstanceType_SID.setSelected(true);
        int labelGroupWidth = lblusername.getPreferredSize().width;
        labelGroupWidth = Math.max(labelGroupWidth, 100);
        labelGroupWidth = Math.max(labelGroupWidth, lblpassword.getPreferredSize().width);
        labelGroupWidth = Math.max(labelGroupWidth, lblhost.getPreferredSize().width);
        labelGroupWidth = Math.max(labelGroupWidth, lblport.getPreferredSize().width);
        labelGroupWidth = Math.max(labelGroupWidth, lblinstance.getPreferredSize().width);
        GroupLayout.ParallelGroup hGrp1 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        ((GroupLayout.Group)hGrp1).addComponent(lblusername, labelGroupWidth, labelGroupWidth, labelGroupWidth);
        ((GroupLayout.Group)hGrp1).addComponent(lblpassword, labelGroupWidth, labelGroupWidth, labelGroupWidth);
        ((GroupLayout.Group)hGrp1).addComponent(lblhost, labelGroupWidth, labelGroupWidth, labelGroupWidth);
        ((GroupLayout.Group)hGrp1).addComponent(lblport, labelGroupWidth, labelGroupWidth, labelGroupWidth);
        ((GroupLayout.Group)hGrp1).addComponent(lblinstance, labelGroupWidth, labelGroupWidth, labelGroupWidth);
        ((GroupLayout.Group)hGrp1).addComponent(lblSSL, labelGroupWidth, labelGroupWidth, labelGroupWidth);
        GroupLayout.ParallelGroup hGrp2 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        this.m_txtORusername.setColumns(20);
        ((GroupLayout.Group)hGrp2).addComponent(this.m_txtORusername, this.m_txtORusername.getPreferredSize().width, this.m_txtORusername.getPreferredSize().width, this.m_txtORusername.getPreferredSize().width);
        this.m_txtORpassword.setColumns(20);
        ((GroupLayout.Group)hGrp2).addComponent(this.m_txtORpassword, this.m_txtORpassword.getPreferredSize().width, this.m_txtORpassword.getPreferredSize().width, this.m_txtORpassword.getPreferredSize().width);
        this.m_txtORhost.setColumns(20);
        ((GroupLayout.Group)hGrp2).addComponent(this.m_txtORhost, this.m_txtORhost.getPreferredSize().width, this.m_txtORhost.getPreferredSize().width, this.m_txtORhost.getPreferredSize().width);
        this.m_txtORport.setColumns(6);
        ((GroupLayout.Group)hGrp2).addComponent(this.m_txtORport, this.m_txtORport.getPreferredSize().width, this.m_txtORport.getPreferredSize().width, this.m_txtORport.getPreferredSize().width);
        this.m_txtORinstance.setColumns(20);
        ((GroupLayout.Group)hGrp2).addComponent(this.m_txtORinstance, this.m_txtORinstance.getPreferredSize().width, this.m_txtORinstance.getPreferredSize().width, this.m_txtORinstance.getPreferredSize().width);
        ((GroupLayout.Group)hGrp2).addComponent(this.m_orCheckSSL, this.m_orCheckSSL.getPreferredSize().width, this.m_orCheckSSL.getPreferredSize().width, this.m_orCheckSSL.getPreferredSize().width);
        GroupLayout.ParallelGroup hGrp3 = layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.m_radioInstanceType_SID, this.m_radioInstanceType_SID.getPreferredSize().width, this.m_radioInstanceType_SID.getPreferredSize().width, this.m_radioInstanceType_SID.getPreferredSize().width);
        GroupLayout.ParallelGroup hGrp4 = layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.m_radioInstanceType_Service, this.m_radioInstanceType_Service.getPreferredSize().width, this.m_radioInstanceType_Service.getPreferredSize().width, this.m_radioInstanceType_Service.getPreferredSize().width);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(hGrp1).addGroup(hGrp2).addGroup(hGrp3).addGroup(hGrp4));
        GroupLayout.SequentialGroup vSeqGrp = layout.createSequentialGroup();
        vSeqGrp.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblusername).addComponent(this.m_txtORusername));
        vSeqGrp.addGap(20);
        vSeqGrp.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblpassword).addComponent(this.m_txtORpassword));
        vSeqGrp.addGap(20);
        vSeqGrp.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblhost).addComponent(this.m_txtORhost));
        vSeqGrp.addGap(20);
        vSeqGrp.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblport).addComponent(this.m_txtORport));
        vSeqGrp.addGap(20);
        vSeqGrp.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblinstance).addComponent(this.m_txtORinstance).addComponent(this.m_radioInstanceType_SID).addComponent(this.m_radioInstanceType_Service));
        vSeqGrp.addGap(20);
        vSeqGrp.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblSSL).addComponent(this.m_orCheckSSL));
        layout.setVerticalGroup(vSeqGrp);
    }

    private void initializeOracleATPConnectionPanel(JPanel oracleatpConnectionPanel) {
        GroupLayout layout = new GroupLayout(oracleatpConnectionPanel);
        oracleatpConnectionPanel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        JLabel lblusername = new JLabel(StringLocalizer.get(CONNECTION_LABEL_OR_NAME));
        this.bindLabelToControl(lblusername, this.m_txtORATPusername, StringLocalizer.get(CONNECTION_MNEMONIC_OR_NAME));
        JLabel lblpassword = new JLabel(StringLocalizer.get(CONNECTION_LABEL_OR_PASS));
        this.bindLabelToControl(lblpassword, this.m_txtORATPpassword, StringLocalizer.get(CONNECTION_MNEMONIC_OR_PASS));
        JLabel lblhost = new JLabel(StringLocalizer.get(CONNECTION_LABEL_OR_ATP_HOST));
        this.bindLabelToControl(lblhost, this.m_txtORATPwallet, StringLocalizer.get(CONNECTION_MNEMONIC_OR_ATP_HOST));
        JLabel lblinstance = new JLabel(StringLocalizer.get(CONNECTION_LABEL_OR_INSTANCE));
        this.bindLabelToControl(lblinstance, this.m_txtORATPinstance, StringLocalizer.get(CONNECTION_MNEMONIC_OR_INSTANCE));
        int labelGroupWidth = lblusername.getPreferredSize().width;
        labelGroupWidth = Math.max(labelGroupWidth, 100);
        labelGroupWidth = Math.max(labelGroupWidth, lblpassword.getPreferredSize().width);
        labelGroupWidth = Math.max(labelGroupWidth, lblhost.getPreferredSize().width);
        labelGroupWidth = Math.max(labelGroupWidth, lblinstance.getPreferredSize().width);
        GroupLayout.ParallelGroup hGrp1 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        ((GroupLayout.Group)hGrp1).addComponent(lblusername, labelGroupWidth, labelGroupWidth, labelGroupWidth);
        ((GroupLayout.Group)hGrp1).addComponent(lblpassword, labelGroupWidth, labelGroupWidth, labelGroupWidth);
        ((GroupLayout.Group)hGrp1).addComponent(lblhost, labelGroupWidth, labelGroupWidth, labelGroupWidth);
        ((GroupLayout.Group)hGrp1).addComponent(lblinstance, labelGroupWidth, labelGroupWidth, labelGroupWidth);
        GroupLayout.ParallelGroup hGrp2 = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        this.m_txtORATPusername.setColumns(20);
        ((GroupLayout.Group)hGrp2).addComponent(this.m_txtORATPusername, this.m_txtORATPusername.getPreferredSize().width, this.m_txtORATPusername.getPreferredSize().width, this.m_txtORATPusername.getPreferredSize().width);
        this.m_txtORATPpassword.setColumns(20);
        ((GroupLayout.Group)hGrp2).addComponent(this.m_txtORATPpassword, this.m_txtORATPpassword.getPreferredSize().width, this.m_txtORATPpassword.getPreferredSize().width, this.m_txtORATPpassword.getPreferredSize().width);
        this.m_txtORATPwallet.setColumns(20);
        ((GroupLayout.Group)hGrp2).addComponent(this.m_txtORATPwallet, this.m_txtORATPwallet.getPreferredSize().width, this.m_txtORATPwallet.getPreferredSize().width, this.m_txtORATPwallet.getPreferredSize().width);
        this.m_txtORATPinstance.setColumns(20);
        ((GroupLayout.Group)hGrp2).addComponent(this.m_txtORATPinstance, this.m_txtORATPinstance.getPreferredSize().width, this.m_txtORATPinstance.getPreferredSize().width, this.m_txtORATPinstance.getPreferredSize().width);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(hGrp1).addGroup(hGrp2));
        GroupLayout.SequentialGroup vSeqGrp = layout.createSequentialGroup();
        vSeqGrp.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblusername).addComponent(this.m_txtORATPusername));
        vSeqGrp.addGap(20);
        vSeqGrp.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblpassword).addComponent(this.m_txtORATPpassword));
        vSeqGrp.addGap(20);
        vSeqGrp.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblhost).addComponent(this.m_txtORATPwallet));
        vSeqGrp.addGap(20);
        vSeqGrp.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblinstance).addComponent(this.m_txtORATPinstance));
        layout.setVerticalGroup(vSeqGrp);
    }

    @Override
    public void onExit(UpdatePrivateDabaseLoginsModel m_model) throws DBMTException {
        String connectString;
        BaseServerInfo info;
        String password;
        String username;
        String port;
        String host;
        if (m_model.dbType == ServerType.ORACLE) {
            host = this.m_txtORhost.getText();
            port = this.m_txtORport.getText();
            username = this.m_txtORusername.getText();
            password = new String(this.m_txtORpassword.getPassword());
            String instance = this.m_txtORinstance.getText();
            info = new OracleServerInfo(username, host, instance);
            info.setPort(Integer.parseInt(port));
            info.setDatabase(instance);
            info.setUsername(username);
            if (this.m_radioInstanceType_Service.isSelected()) {
                info.setService(true);
            }
            if (this.m_radioInstanceType_SID.isSelected()) {
                info.setService(false);
            }
            connectString = info.createConnectString(password);
            try {
                m_model.m_connection = new DatabaseConnection(connectString);
            }
            catch (SQLException e) {
                throw new UnableToCreateConnectionFromConnectString(info.createConnectString("*********"), e);
            }
        }
        if (m_model.dbType == ServerType.ORACLEATP) {
            host = this.m_txtORATPwallet.getText();
            String username2 = this.m_txtORATPusername.getText();
            String password2 = new String(this.m_txtORATPpassword.getPassword());
            String instance = this.m_txtORATPinstance.getText();
            OracleServerInfo info2 = new OracleServerInfo(username2, host, instance);
            info2.setDatabase(instance);
            info2.setUsername(username2);
            String connectString2 = info2.createATPConnectString(password2);
            try {
                m_model.m_connection = new DatabaseConnection(connectString2);
            }
            catch (SQLException e) {
                throw new UnableToCreateConnectionFromConnectString(info2.createConnectString("*********"), e);
            }
        }
        if (m_model.dbType == ServerType.SQLSERVER) {
            host = this.m_txtSShost.getText();
            port = this.m_txtSSport.getText();
            username = this.m_txtSSusername.getText();
            password = new String(this.m_txtSSpassword.getPassword());
            String database = this.m_txtSSdatabase.getText();
            info = new MSSqlServerInfo(database, host);
            info.setPort(Integer.parseInt(port));
            info.setDatabase(database);
            info.setUsername(username);
            connectString = info.createConnectString(password);
            try {
                m_model.m_connection = new DatabaseConnection(connectString);
            }
            catch (SQLException e) {
                throw new UnableToCreateConnectionFromConnectString(connectString, e);
            }
        }
    }

    @Override
    public void onUndo(UpdatePrivateDabaseLoginsModel m_model) {
        DatabaseConnection conn = m_model.m_connection;
        if (conn == null) {
            return;
        }
        m_model.m_connection = null;
        try {
            conn.close();
        }
        catch (SQLException e) {
            DBMTLogger.warn(Channel.USER, StringLocalizer.get("dbmt.warn.connection.not.closed"));
        }
    }

    private final class TextSelectFocusListener
    extends FocusAdapter {
        private final JTextField m_component;

        private TextSelectFocusListener(JTextField component) {
            this.m_component = component;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.m_component.selectAll();
        }
    }

    private final class NextButtonEnableListener
    implements ChangeListener,
    CaretListener {
        private NextButtonEnableListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.setNextButtonEnabledStatus();
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            this.setNextButtonEnabledStatus();
        }

        private void setNextButtonEnabledStatus() {
            boolean ready = true;
            if (DatabaseConnectionPanel.this.m_radioDbType_Oracle.isSelected()) {
                for (JTextField f : DatabaseConnectionPanel.this.m_orFields) {
                    ready = ready && !f.getText().isEmpty();
                }
                boolean bl = ready = ready && DatabaseConnectionPanel.this.m_txtORpassword.getPassword().length > 0;
            }
            if (DatabaseConnectionPanel.this.m_radioDbType_OracleATP.isSelected()) {
                for (JTextField f : DatabaseConnectionPanel.this.m_oratpFields) {
                    ready = ready && !f.getText().isEmpty();
                }
                boolean bl = ready = ready && DatabaseConnectionPanel.this.m_txtORATPpassword.getPassword().length > 0;
            }
            if (DatabaseConnectionPanel.this.m_radioDbType_SqlServer.isSelected()) {
                for (JTextField f : DatabaseConnectionPanel.this.m_ssFields) {
                    ready = ready && !f.getText().isEmpty();
                }
                boolean bl = ready = ready && DatabaseConnectionPanel.this.m_txtSSpassword.getPassword().length > 0;
            }
            if (DatabaseConnectionPanel.this.m_orCheckSSL.isSelected() || DatabaseConnectionPanel.this.m_ssCheckSSL.isSelected()) {
                System.setProperty("PRM_SSL_CONNECTION", "true");
            } else {
                System.setProperty("PRM_SSL_CONNECTION", "false");
            }
            DatabaseConnectionPanel.this.ui.setNavButtonEnabled(NavigationOperation.NEXT, ready);
        }
    }

    private final class DBTypeRadioButtonChangeListener
    implements ChangeListener,
    ActionListener {
        private DBTypeRadioButtonChangeListener() {
        }

        private void resetPanels() {
            if (DatabaseConnectionPanel.this.m_radioDbType_Oracle.isSelected()) {
                DatabaseConnectionPanel.this.m_cardLayoutManager.show(DatabaseConnectionPanel.this.m_dbConnectionRootPanel, DatabaseConnectionPanel.PANEL_NAME_CONNECTION_ORACLE);
                DatabaseConnectionPanel.this.model.dbType = ServerType.ORACLE;
            }
            if (DatabaseConnectionPanel.this.m_radioDbType_SqlServer.isSelected()) {
                DatabaseConnectionPanel.this.m_cardLayoutManager.show(DatabaseConnectionPanel.this.m_dbConnectionRootPanel, DatabaseConnectionPanel.PANEL_NAME_CONNECTION_SQLSERVER);
                DatabaseConnectionPanel.this.model.dbType = ServerType.SQLSERVER;
            }
            if (DatabaseConnectionPanel.this.m_radioDbType_OracleATP.isSelected()) {
                DatabaseConnectionPanel.this.m_cardLayoutManager.show(DatabaseConnectionPanel.this.m_dbConnectionRootPanel, DatabaseConnectionPanel.PANEL_NAME_CONNECTION_ORACLE_ATP);
                DatabaseConnectionPanel.this.model.dbType = ServerType.ORACLEATP;
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.resetPanels();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.resetPanels();
        }
    }
}

