/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.updatelogins.ui;

import com.primavera.database.tools.dbmt.DBMTException;

public class UnableToCreateConnectionFromConnectString
extends DBMTException {
    private static final long serialVersionUID = 2447285654254069822L;
    private final String m_connectString;
    private final Throwable m_error;
    private final String m_errMsg;

    public UnableToCreateConnectionFromConnectString(String connectString, Throwable error) {
        this.m_connectString = connectString;
        this.m_error = error;
        String msg = "";
        if (this.m_error.getMessage() != null) {
            msg = "(" + this.m_error.getMessage() + ")";
        }
        this.m_errMsg = msg;
    }

    @Override
    protected String getEnglishMessage() {
        String msg = "";
        if (this.m_error.getMessage() != null) {
            msg = ", " + this.m_error.getMessage();
        }
        return "Unable to create connection from connect string " + this.m_connectString + ": " + this.m_error.getClass().getSimpleName() + msg;
    }

    @Override
    protected String getMessageKey() {
        return "dbmt.error.cannot.create.connection";
    }

    @Override
    protected String[] getMessageParams() {
        return new String[]{this.m_connectString, this.m_error.getClass().getSimpleName(), this.m_errMsg};
    }
}

