/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.workflow;

import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.common.connection.DSType;
import com.primavera.database.common.job.JobFinishedEvent;
import com.primavera.database.common.job.JobListener;
import com.primavera.database.common.job.JobStartingEvent;
import com.primavera.database.common.job.JobWatcher;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.Dataloader.Dataloader;
import com.primavera.database.tools.Dataloader.DataloaderEvent;
import com.primavera.database.tools.Dataloader.DataloaderListener;
import com.primavera.database.tools.dbmt.AbstractJob;

public class DatapumpJob
extends AbstractJob {
    private final String m_connectSourceString;
    private final String m_connectTargetString;
    private final int m_commitRows;
    private static boolean m_isinstall;

    public DatapumpJob(String sourceString, String connectString, int commitRows) {
        this.m_connectSourceString = sourceString;
        this.m_connectTargetString = connectString;
        this.m_commitRows = commitRows;
    }

    @Override
    public boolean doJob(JobListener listener, JobWatcher watcher) throws Exception {
        Dataloader loader = new Dataloader();
        loader.setTargetConnectString(this.m_connectTargetString);
        loader.setSourceConnectString(this.m_connectSourceString);
        loader.addListener(this.getDataloaderListener(listener));
        loader.setCommitPoint(this.m_commitRows);
        loader.setClearTables(m_isinstall);
        String tables = System.getProperty("dataloader.tables");
        if (tables != null && tables.length() > 0) {
            DBMTLogger.info(Channel.DEV, "Tables to pump: " + tables.toLowerCase());
            String[] tabs = tables.toUpperCase().split(",");
            for (int j = 0; j < tabs.length; ++j) {
                loader.addTable(tabs[j]);
            }
        }
        if (!watcher.isContinue()) {
            return false;
        }
        loader.run();
        return true;
    }

    @Override
    public boolean isIndeterminateProgress() {
        return false;
    }

    private DataloaderListener getDataloaderListener(final JobListener listener) {
        final DatapumpJob datapumpJob = this;
        return new DataloaderListener(){

            @Override
            public void dataLoadBegin(DataloaderEvent event) {
                listener.jobStarting(new JobStartingEvent(datapumpJob), true);
            }

            @Override
            public void dataLoadComplete(DataloaderEvent event) {
                listener.jobFinished(new JobFinishedEvent(datapumpJob));
                DBMTLogger.info(Channel.USER, StringLocalizer.get("dbmt.dataloader.progress.complete.elapsed", new String[]{String.valueOf(event.getElapsedSeconds())}));
            }

            @Override
            public void dataLoadError(DataloaderEvent event) {
                DBMTLogger.info(Channel.USER, StringLocalizer.get("dbmt.dataloader.progress.error", new String[]{event.getException().getLocalizedMessage()}), event.getException());
            }

            @Override
            public void rowBegin(DataloaderEvent event) {
            }

            @Override
            public void rowComplete(DataloaderEvent event) {
            }

            @Override
            public void tableLoadBegin(DataloaderEvent event) {
                DBMTLogger.info(Channel.USER, StringLocalizer.get("dbmt.dataloader.progress.tableloading.begin", new String[]{event.getTableName()}));
            }

            @Override
            public void tableLoadComplete(DataloaderEvent event) {
                listener.jobProgressed(event.getTablesProcessed(), event.getTotalTables());
                DBMTLogger.info(Channel.USER, StringLocalizer.get("dbmt.dataloader.progress.tableloading.complete", new String[]{event.getTableName(), String.valueOf(event.getRowsProcessed()), String.valueOf(event.getElapsedSeconds())}));
            }

            @Override
            public void tableProgress(DataloaderEvent event) {
                DBMTLogger.info(Channel.USER, StringLocalizer.get("dbmt.dataloader.progress.tableloading.progress", new String[]{String.valueOf(event.getRowsProcessed())}));
            }
        };
    }

    public String toString() {
        ConnectStringParse parsedString = new ConnectStringParse(this.m_connectSourceString);
        String connectionName = this.m_connectSourceString;
        if (parsedString.getConnectionType() == DSType.DATABASE) {
            connectionName = parsedString.getUsername() + "/******@" + (Object)((Object)parsedString.getDbtype()) + ":" + parsedString.getServer() + ":" + parsedString.getPort() + ":" + parsedString.getDatabase();
        }
        return StringLocalizer.get("dbmt.dataloader.display.title", new String[]{connectionName});
    }

    public static void toLoad(boolean IsInstall) {
        if (IsInstall) {
            m_isinstall = false;
        }
    }
}

