/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.propgen.actions;

import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.SubNodeAdapter;
import com.primavera.database.tools.dbmt.xml.util.propgen.ActionContainer;
import com.primavera.database.tools.dbmt.xml.util.propgen.Identification;
import com.primavera.database.tools.dbmt.xml.util.propgen.actions.ActionNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.actions.ActionSetNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.actions.ImportNode;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ContextNode
extends SubNodeAdapter
implements ActionContainer {
    private final PrintStream m_out;
    private final String m_contextClass;
    private final Map<String, String> m_propertyMap = new HashMap<String, String>();
    private final Map<String, Map<String, Identification>> m_templateIds = new HashMap<String, Map<String, Identification>>();

    public ContextNode(Attributes attr, PrintStream out) {
        super("context", attr);
        String contextClass = null;
        try {
            contextClass = Class.forName(attr.getValue("type")).getSimpleName();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.m_contextClass = contextClass;
        this.m_out = out;
    }

    @Override
    public NodeHandler nextNode(String elemName, Attributes attr) {
        if ("actionset".equals(elemName)) {
            return new ActionSetNode(this, attr);
        }
        if ("action".equals(elemName)) {
            return new ActionNode(this, attr);
        }
        if ("import".equals(elemName)) {
            return new ImportNode(this, attr);
        }
        return super.nextNode(elemName, attr);
    }

    @Override
    public String path() {
        return "/" + this.getElemName();
    }

    @Override
    public String containerPath() {
        return "action." + this.m_contextClass;
    }

    @Override
    public void addProperty(String key, String value) {
        this.m_propertyMap.put(key, value);
    }

    @Override
    public void onEnd() throws SAXException {
        for (Map.Entry<String, String> propEntry : this.m_propertyMap.entrySet()) {
            this.m_out.println(propEntry.getKey() + "=" + propEntry.getValue());
        }
    }

    @Override
    public void addTemplateIds(Map<String, Map<String, Identification>> templateIdents) {
        this.m_templateIds.putAll(templateIdents);
    }

    @Override
    public Map<String, Identification> getTemplate(String templateId) {
        return this.m_templateIds.get(templateId);
    }
}

