/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.propgen.actions;

import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.RecursiveNoOpNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.ActionContainer;
import com.primavera.database.tools.dbmt.xml.util.propgen.Identification;
import com.primavera.database.tools.dbmt.xml.util.propgen.PropSubNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.TemplateAccessor;
import com.primavera.database.tools.dbmt.xml.util.propgen.actions.ActionNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.actions.EnumFieldNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.actions.SimpleFieldNode;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DialogNode
extends PropSubNode<ActionNode>
implements TemplateAccessor {
    private final Identification m_ident;
    private final Map<String, Identification> m_fields = new HashMap<String, Identification>();
    private final Map<String, Character> m_mnemonics = new HashMap<String, Character>();

    public DialogNode(ActionNode parent, Attributes attr) {
        super(parent, "dialog", attr);
        this.m_ident = new Identification(attr);
    }

    @Override
    public void onStart() {
        this.m_ident.addProperties(((ActionNode)this.getParent()).getPropertyPrefix(), this);
    }

    @Override
    public void onEnd() throws SAXException {
        String prefix = this.getPropertyPrefix() + ".fld.";
        for (Map.Entry<String, Identification> entry : this.m_fields.entrySet()) {
            entry.getValue().addProperties(prefix + entry.getKey(), this);
        }
        for (Map.Entry<String, Object> entry : this.m_mnemonics.entrySet()) {
            ((ActionNode)this.getParent()).addProperty(prefix + entry.getKey(), ((Character)entry.getValue()).toString());
        }
    }

    @Override
    public void addFieldIdent(String id, Identification ident) {
        this.m_fields.put(id, ident);
    }

    @Override
    public NodeHandler nextNode(String elemName, Attributes attr) {
        if ("string".equals(elemName) || "password".equals(elemName) || "bool".equals(elemName) || "int".equals(elemName) || "file".equals(elemName)) {
            return new SimpleFieldNode(this, elemName, attr);
        }
        if ("enum".equals(elemName) || "select".equals(elemName)) {
            return new EnumFieldNode(this, attr);
        }
        if ("test".equals(elemName)) {
            return new RecursiveNoOpNode(this, elemName, attr);
        }
        return super.nextNode(elemName, attr);
    }

    @Override
    public String getPropertyPrefix() {
        return ((ActionNode)this.getParent()).getPropertyPrefix() + ".dlg";
    }

    @Override
    public Map<String, Identification> getTemplate(String id) {
        return ((ActionContainer)((ActionNode)this.getParent()).getParent()).getTemplate(id);
    }
}

