/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.xml.util.propgen.actions;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.propgen.Identification;
import com.primavera.database.tools.dbmt.xml.util.propgen.PropSubNode;
import com.primavera.database.tools.dbmt.xml.util.propgen.TemplateAccessor;
import com.primavera.database.tools.dbmt.xml.util.propgen.actions.RemapNode;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReferenceNode
extends PropSubNode<TemplateAccessor> {
    private final String m_id;

    public ReferenceNode(TemplateAccessor parent, Attributes attr) {
        super(parent, "reference", attr);
        this.m_id = attr.getValue("id");
    }

    @Override
    public void onEnd() throws SAXException {
        Map<String, Identification> identMap = ((TemplateAccessor)this.getParent()).getTemplate(this.m_id);
        if (identMap == null) {
            DBMTLogger.warn(Channel.DEV, "No template found for id " + this.m_id);
        } else {
            String propertyRoot = ((TemplateAccessor)this.getParent()).getPropertyPrefix();
            for (Map.Entry<String, Identification> entry : identMap.entrySet()) {
                entry.getValue().addProperties(propertyRoot + ".fld." + entry.getKey(), this);
            }
        }
    }

    @Override
    public NodeHandler nextNode(String elemName, Attributes attr) {
        if ("remap".equals(elemName)) {
            return new RemapNode(this, attr);
        }
        return super.nextNode(elemName, attr);
    }

    public String getId() {
        return this.m_id;
    }
}

