set serveroutput on size 1000000
--METADATA NAME:OR_Enable_Constraint_Type TYPE:EXEC
CREATE OR REPLACE PROCEDURE OR_Enable_Constraint_Type(constraintType varchar)
AS
--first run constraint_type P, then R, and finally C
cursor c is select constraint_name,table_name from user_constraints where constraint_type = constraintType order by CONSTRAINT_NAME;
vconst_name varchar2(255);
vsql varchar2(255);

begin
	for constraintrec in c
	loop
		vsql:='ALTER TABLE ' || constraintrec.table_name || ' modify constraint '|| constraintrec.constraint_name || ' enable novalidate';
		execute immediate (vsql);
	end loop;
end;

/
show err

--METADATA NAME:OR_Enable_Constraint_Type TYPE:EXEC
BEGIN
  OR_Enable_Constraint_Type('P');
END;

/

--METADATA NAME:OR_Enable_Constraint_Type TYPE:EXEC
BEGIN
  OR_Enable_Constraint_Type('R');
END;
/

--METADATA NAME:OR_Enable_Constraint_Type TYPE:EXEC
BEGIN
  OR_Enable_Constraint_Type('C');
END;
/

--METADATA NAME:OR_Enable_Constraint_Type:PROCEDURE CHANGE:DROP
DROP PROCEDURE OR_Enable_Constraint_Type
/
