--METADATA NAME:PROJRISK TYPE:TABLE TARGET_OBJECT:PROJRISK CHANGE:DATA
declare @vcnt int
select @vcnt=count(*) from nextkey where key_name='pc_key_xref_execution_id';
if @vcnt=0
insert into nextkey values('pc_key_xref_execution_id',1);
go
--METADATA NAME:PROJRISK TYPE:TABLE TARGET_OBJECT:PROJRISK CHANGE:DATA
declare @vcnt int
select @vcnt=count(*) from nextkey where key_name='projetllist_projetllist_id';
if @vcnt=0
insert into nextkey values('projetllist_projetllist_id',1);
go

--METADATA NAME:PROJWBS TYPE:TRIGGER TARGET_OBJECT:PROJWBS CHANGE:DISABLE
IF EXISTS ( SELECT name FROM sysobjects where name = 'prmaud_projwbs' and 
 type = 'TR' )
disable trigger prmaud_projwbs on PROJWBS
go--EPPM Base DDL Scripts
SET QUOTED_IDENTIFIER ON

print 'Creating table ACTIVITYCODEHIERARCHY'

--METADATA NAME:ACTIVITYCODEHIERARCHY TYPE:TABLE CHANGE:CREATE

CREATE TABLE ACTIVITYCODEHIERARCHY(
  "codetypeobjectid"  integer NOT NULL,
  "codetypename"  nvarchar(40) NULL,
  "codetypesequencenumber"  integer NULL,
  "codetypeissecure"  nvarchar(1) NULL,
  "parentcodevalueobjectid"  integer NULL,
  "parentcodevaluename"  nvarchar(120) NULL,
  "parentcodevalueshortname"  nvarchar(60) NULL,
  "parentcodevaluesequencenumber"  integer NULL,
  "childcodevalueobjectid"  integer NULL,
  "childcodevaluename"  nvarchar(120) NULL,
  "childcodevalueshortname"  nvarchar(60) NULL,
  "childcodevaluesequencenumber"  integer NULL,
  "parentlevelsbelowroot"  integer NULL,
  "childlevelsbelowroot"  integer NULL,
  "levelsbetween"  integer NULL,
  "childhaschildren"  nvarchar(1) NULL,
  "fullpathname"  nvarchar(4000) NULL,
  "codetypescope"  nvarchar(10) NULL,
  "codetypeprojectid"  integer NULL
  )

go

print 'Creating table ACTIVITYCODETYPESECURITY'

--METADATA NAME:ACTIVITYCODETYPESECURITY TYPE:TABLE CHANGE:CREATE

CREATE TABLE ACTIVITYCODETYPESECURITY(
  "rdbmsuserid"  integer NULL,
  "projectobjectid"  integer NULL
  )

go

print 'Creating table ACTIVITYSPREAD'

--METADATA NAME:ACTIVITYSPREAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE ACTIVITYSPREAD(
  "activityobjectid"  integer NOT NULL,
  "startdate"  datetime NOT NULL,
  "enddate"  datetime NOT NULL,
  "activitycode"  nvarchar(40) NULL,
  "activityname"  nvarchar(120) NULL,
  "wbsobjectid"  integer NOT NULL,
  "projectobjectid"  integer NOT NULL,
  "actuallaborunits"  DECIMAL(28,10) NULL,
  "actualnonlaborunits"  DECIMAL(28,10) NULL,
  "atcompletionlaborunits"  DECIMAL(28,10) NULL,
  "atcompletionnonlaborunits"  DECIMAL(28,10) NULL,
  "baselineactuallaborunits"  DECIMAL(28,10) NULL,
  "baselineactualnonlaborunits"  DECIMAL(28,10) NULL,
  "baselineplannedlaborunits"  DECIMAL(28,10) NULL,
  "baselineplannednonlaborunits"  DECIMAL(28,10) NULL,
  "baseline1actuallaborunits"  DECIMAL(28,10) NULL,
  "baseline1actualnonlaborunits"  DECIMAL(28,10) NULL,
  "baseline1plannedlaborunits"  DECIMAL(28,10) NULL,
  "baseline1plannednonlaborunits"  DECIMAL(28,10) NULL,
  "earnedvaluelaborunits"  DECIMAL(28,10) NULL,
  "estimateatcompletionlaborunits"  DECIMAL(28,10) NULL,
  "estimatetocompletelaborunits"  DECIMAL(28,10) NULL,
  "plannedlaborunits"  DECIMAL(28,10) NULL,
  "plannednonlaborunits"  DECIMAL(28,10) NULL,
  "plannedvaluelaborunits"  DECIMAL(28,10) NULL,
  "remaininglaborunits"  DECIMAL(28,10) NULL,
  "remaininglatelaborunits"  DECIMAL(28,10) NULL,
  "remaininglatenonlaborunits"  DECIMAL(28,10) NULL,
  "remainingnonlaborunits"  DECIMAL(28,10) NULL,
  "actualcost"  DECIMAL(28,10) NULL,
  "actualexpensecost"  DECIMAL(28,10) NULL,
  "actuallaborcost"  DECIMAL(28,10) NULL,
  "actualmaterialcost"  DECIMAL(28,10) NULL,
  "actualnonlaborcost"  DECIMAL(28,10) NULL,
  "actualtotalcost"  DECIMAL(28,10) NULL,
  "atcompletionexpensecost"  DECIMAL(28,10) NULL,
  "atcompletionlaborcost"  DECIMAL(28,10) NULL,
  "atcompletionmaterialcost"  DECIMAL(28,10) NULL,
  "atcompletionnonlaborcost"  DECIMAL(28,10) NULL,
  "atcompletiontotalcost"  DECIMAL(28,10) NULL,
  "baselineplannedexpensecost"  DECIMAL(28,10) NULL,
  "baselineplannedlaborcost"  DECIMAL(28,10) NULL,
  "baselineplannedmaterialcost"  DECIMAL(28,10) NULL,
  "baselineplannednonlaborcost"  DECIMAL(28,10) NULL,
  "baselineplannedtotalcost"  DECIMAL(28,10) NULL,
  "baselineactualexpensecost"  DECIMAL(28,10) NULL,
  "baselineactuallaborcost"  DECIMAL(28,10) NULL,
  "baselineactualmaterialcost"  DECIMAL(28,10) NULL,
  "baselineactualnonlaborcost"  DECIMAL(28,10) NULL,
  "baselineactualtotalcost"  DECIMAL(28,10) NULL,
  "baseline1actualexpensecost"  DECIMAL(28,10) NULL,
  "baseline1actuallaborcost"  DECIMAL(28,10) NULL,
  "baseline1actualmaterialcost"  DECIMAL(28,10) NULL,
  "baseline1actualnonlaborcost"  DECIMAL(28,10) NULL,
  "baseline1actualtotalcost"  DECIMAL(28,10) NULL,
  "baseline1plannedexpensecost"  DECIMAL(28,10) NULL,
  "baseline1plannedlaborcost"  DECIMAL(28,10) NULL,
  "baseline1plannedmaterialcost"  DECIMAL(28,10) NULL,
  "baseline1plannednonlaborcost"  DECIMAL(28,10) NULL,
  "baseline1plannedtotalcost"  DECIMAL(28,10) NULL,
  "earnedvaluecost"  DECIMAL(28,10) NULL,
  "estimateatcompletioncost"  DECIMAL(28,10) NULL,
  "estimatetocompletecost"  DECIMAL(28,10) NULL,
  "plannedexpensecost"  DECIMAL(28,10) NULL,
  "plannedlaborcost"  DECIMAL(28,10) NULL,
  "plannedmaterialcost"  DECIMAL(28,10) NULL,
  "plannednonlaborcost"  DECIMAL(28,10) NULL,
  "plannedtotalcost"  DECIMAL(28,10) NULL,
  "plannedvaluecost"  DECIMAL(28,10) NULL,
  "remainingexpensecost"  DECIMAL(28,10) NULL,
  "remaininglaborcost"  DECIMAL(28,10) NULL,
  "remaininglateexpensecost"  DECIMAL(28,10) NULL,
  "remaininglatelaborcost"  DECIMAL(28,10) NULL,
  "remaininglatematerialcost"  DECIMAL(28,10) NULL,
  "remaininglatenonlaborcost"  DECIMAL(28,10) NULL,
  "remaininglatetotalcost"  DECIMAL(28,10) NULL,
  "remainingmaterialcost"  DECIMAL(28,10) NULL,
  "remainingnonlaborcost"  DECIMAL(28,10) NULL,
  "remainingtotalcost"  DECIMAL(28,10) NULL,
  "update_date"  datetime DEFAULT getDate() NOT NULL
  )

go

print 'Creating table ACTVCODEX'

--METADATA NAME:ACTVCODEX TYPE:TABLE CHANGE:CREATE

CREATE TABLE ACTVCODEX(
  "actv_code_id"  integer NOT NULL,
  "codetypename"  nvarchar(255) NULL,
  "issecurecode"  nvarchar(1) NULL,
  "projectobjectid"  integer NULL,
  "codetypescope"  nvarchar(24) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_activitycodex PRIMARY KEY (actv_code_id)  )

go

print 'Creating table AC_PROJRSRCROLELIST'

--METADATA NAME:AC_PROJRSRCROLELIST TYPE:TABLE CHANGE:CREATE

CREATE TABLE AC_PROJRSRCROLELIST(
  "proj_id"  integer NULL,
  "rsrc_id"  nvarchar(30) NULL,
  "role_id"  nvarchar(30) NULL
  )

go

print 'Creating table ADDTASKPROC'

--METADATA NAME:ADDTASKPROC TYPE:TABLE CHANGE:CREATE

CREATE TABLE ADDTASKPROC(
  "proc_id"  integer NOT NULL,
  "transaction_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "status_code"  nvarchar(20) NOT NULL,
  "proj_id"  integer NOT NULL,
  "complete_pct"  numeric(10,2) NULL,
  "proc_name"  nvarchar(120) NULL,
  "proc_wt"  numeric(10,2) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_addtaskproc PRIMARY KEY (proc_id)  )

go

print 'Creating table ADDTASKPROCX'

--METADATA NAME:ADDTASKPROCX TYPE:TABLE CHANGE:CREATE

CREATE TABLE ADDTASKPROCX(
  "transaction_id"  integer NOT NULL,
  "proc_id"  integer NOT NULL,
  "changedate"  datetime NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_addtaskprocx PRIMARY KEY (proc_id)  )

go

print 'Creating table ADDTRSRC'

--METADATA NAME:ADDTRSRC TYPE:TABLE CHANGE:CREATE

CREATE TABLE ADDTRSRC(
  "addtrsrc_id"  integer NOT NULL,
  "taskrsrc_id"  integer NULL,
  "transaction_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "status_code"  nvarchar(20) DEFAULT 'Approved' NOT NULL,
  "proj_id"  integer NULL,
  "rsrc_id"  integer NULL,
  "act_start_date"  datetime NULL,
  "act_end_date"  datetime NULL,
  "act_reg_qty"  numeric(17,6) NULL,
  "remain_qty"  numeric(17,6) NULL,
  "remain_drtn"  numeric(17,6) NULL,
  "reend_date"  datetime NULL,
  "assignment_is_read"  nvarchar(10) DEFAULT 'false' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_addtrsrc PRIMARY KEY (addtrsrc_id)  )

go

print 'Creating table ALERT'

--METADATA NAME:ALERT TYPE:TABLE CHANGE:CREATE

CREATE TABLE ALERT(
  "alert_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "alert_type"  nvarchar(56) NULL,
  "action_key"  nvarchar(56) NULL,
  "alert_status"  nvarchar(56) NULL,
  "alert_date"  datetime NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_alert PRIMARY KEY (alert_id)  )

go

print 'Creating table ALERTPARAM'

--METADATA NAME:ALERTPARAM TYPE:TABLE CHANGE:CREATE

CREATE TABLE ALERTPARAM(
  "alert_id"  integer NOT NULL,
  "setting_id"  integer NOT NULL,
  "setting_name"  nvarchar(128) NULL,
  "setting_value"  nvarchar(4000) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_alertparam PRIMARY KEY (alert_id,setting_id)  )

go

print 'Creating table ANNOUNCEMENT'

--METADATA NAME:ANNOUNCEMENT TYPE:TABLE CHANGE:CREATE

CREATE TABLE ANNOUNCEMENT(
  "announcement_id"  integer NOT NULL,
  "announcement_title"  nvarchar(255) NOT NULL,
  "announcement_message"  TEXT NOT NULL,
  "announce_cloud_id"  integer NOT NULL,
  "status_code"  nvarchar(10) NOT NULL,
  "start_date"  datetime NULL,
  "end_date"  datetime NULL,
  "create_date"  datetime NULL,
  "update_date"  datetime NULL,
  "create_user"  nvarchar(40) NULL,
  "update_user"  nvarchar(40) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_announcement PRIMARY KEY (announcement_id)  )

go

print 'Creating table ANNOUNCEMENT_USER'

--METADATA NAME:ANNOUNCEMENT_USER TYPE:TABLE CHANGE:CREATE

CREATE TABLE ANNOUNCEMENT_USER(
  "user_id"  integer NOT NULL,
  "announcement_id"  integer NOT NULL,
  "status_code"  nvarchar(1) DEFAULT 'U' NOT NULL,
  "read_date"  datetime NULL,
  "create_date"  datetime NULL,
  "update_date"  datetime NULL,
  "create_user"  nvarchar(40) NULL,
  "update_user"  nvarchar(40) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_announcement_user PRIMARY KEY (user_id,announcement_id)  )

go

print 'Creating table ARBITER_COUNTER'

--METADATA NAME:ARBITER_COUNTER TYPE:TABLE CHANGE:CREATE

CREATE TABLE ARBITER_COUNTER(
  "arb_id"  bigint NOT NULL,
  "sub_date"  datetime NULL,
  "proj_id"  integer NULL,
  "core_complete_flag"  nvarchar(1) NULL
  )

go

print 'Creating table ASGNMNTACATX'

--METADATA NAME:ASGNMNTACATX TYPE:TABLE CHANGE:CREATE

CREATE TABLE ASGNMNTACATX(
  "taskrsrc_id"  integer NOT NULL,
  "asgnmnt_catg_type_id"  integer NOT NULL,
  "asgnmntcodedescription"  nvarchar(255) NULL,
  "asgnmntcodetypename"  nvarchar(255) NULL,
  "asgnmntcodevalue"  nvarchar(255) NULL,
  "asgnmntid"  nvarchar(255) NULL,
  "asgnmntname"  nvarchar(255) NULL,
  "issecurecode"  nvarchar(1) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_assignmentcodeassignmentx PRIMARY KEY (taskrsrc_id,asgnmnt_catg_type_id)  )

go

print 'Creating table ASGNMNTCATVALX'

--METADATA NAME:ASGNMNTCATVALX TYPE:TABLE CHANGE:CREATE

CREATE TABLE ASGNMNTCATVALX(
  "asgnmnt_catg_id"  integer NOT NULL,
  "codetypename"  nvarchar(255) NULL,
  "issecurecode"  nvarchar(1) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_assignmentcodex PRIMARY KEY (asgnmnt_catg_id)  )

go

print 'Creating table ASSIGNMENTCODEHIERARCHY'

--METADATA NAME:ASSIGNMENTCODEHIERARCHY TYPE:TABLE CHANGE:CREATE

CREATE TABLE ASSIGNMENTCODEHIERARCHY(
  "codetypeobjectid"  integer NOT NULL,
  "codetypename"  nvarchar(60) NOT NULL,
  "codetypesequencenumber"  integer NOT NULL,
  "codetypeissecure"  nvarchar(1) NOT NULL,
  "parentcodevalueobjectid"  integer NULL,
  "parentcodevaluename"  nvarchar(100) NULL,
  "parentcodevalueshortname"  nvarchar(60) NULL,
  "parentcodevaluesequencenumber"  integer NULL,
  "childcodevalueobjectid"  integer NULL,
  "childcodevaluename"  nvarchar(100) NULL,
  "childcodevalueshortname"  nvarchar(60) NULL,
  "childcodevaluesequencenumber"  integer NULL,
  "parentlevelsbelowroot"  integer NOT NULL,
  "childlevelsbelowroot"  integer NOT NULL,
  "levelsbetween"  integer NOT NULL,
  "childhaschildren"  nvarchar(1) NULL,
  "fullpathname"  nvarchar(4000) NULL
  )

go

print 'Creating table ATTR_MASTER'

--METADATA NAME:ATTR_MASTER TYPE:TABLE CHANGE:CREATE

CREATE TABLE ATTR_MASTER(
  "attr_id"  integer NOT NULL,
  "attr_name"  nvarchar(120) NOT NULL,
  "attr_type"  nvarchar(120) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_attr_master PRIMARY KEY (attr_id)  )

go

print 'Creating table AUTOVUE_ATTR'

--METADATA NAME:AUTOVUE_ATTR TYPE:TABLE CHANGE:CREATE

CREATE TABLE AUTOVUE_ATTR(
  "property_id"  integer NOT NULL,
  "document_external_key"  nvarchar(4000) NOT NULL,
  "property_name"  nvarchar(4000) NULL,
  "property_last_updated"  datetime NULL,
  "property_external_key"  nvarchar(4000) NOT NULL,
  "property_doc_type"  nvarchar(4000) NULL,
  "property_create_user"  nvarchar(4000) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_autovue_attr PRIMARY KEY (property_id)  )

go

print 'Creating table BUDGCHNGX'

--METADATA NAME:BUDGCHNGX TYPE:TABLE CHANGE:CREATE

CREATE TABLE BUDGCHNGX(
  "budg_chng_id"  integer NOT NULL,
  "epsid"  nvarchar(255) NULL,
  "epsname"  nvarchar(255) NULL,
  "projectid"  nvarchar(255) NULL,
  "wbscode"  nvarchar(255) NULL,
  "wbsname"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_projectbudgetchangelogx PRIMARY KEY (budg_chng_id)  )

go

print 'Creating table CALENDARX'

--METADATA NAME:CALENDARX TYPE:TABLE CHANGE:CREATE

CREATE TABLE CALENDARX(
  "clndr_id"  integer NOT NULL,
  "daydate"  datetime NOT NULL,
  "weekdaynumber"  integer NULL,
  "workdayflag"  nvarchar(1) NULL,
  "totalworkhours"  numeric(10,2) NULL,
  "workhoursbyhalfhour"  nvarchar(48) NULL,
  "workdaystarttime"  datetime NULL,
  "workdayfinishtime"  datetime NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_calendarx PRIMARY KEY (clndr_id,daydate)  )

go

print 'Creating table CBS'

--METADATA NAME:CBS TYPE:TABLE CHANGE:CREATE

CREATE TABLE CBS(
  "cbs_id"  integer NOT NULL,
  "cbs_code"  nvarchar(120) NOT NULL,
  "proj_id"  integer NOT NULL,
  "parent_cbs_id"  integer NULL,
  "description"  nvarchar(4000) NULL,
  "status"  nvarchar(20) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_cbs PRIMARY KEY (cbs_id)  )

go

print 'Creating table CHGHEAD'

--METADATA NAME:CHGHEAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGHEAD(
  "transaction_id"  integer NOT NULL,
  "transaction_date"  datetime NOT NULL,
  "request_user_name"  nvarchar(255) NOT NULL,
  "request_user_id"  integer NULL,
  "update_date"  datetime DEFAULT getDate() NULL,
  "update_user"  nvarchar(255) DEFAULT 'SYSTEM' NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "create_user"  nvarchar(255) DEFAULT 'SYSTEM' NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_chghead PRIMARY KEY (transaction_id)  )

go

print 'Creating table CHGTASK'

--METADATA NAME:CHGTASK TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTASK(
  "transaction_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "status_code"  nvarchar(20) DEFAULT 'TS_Pending' NOT NULL,
  "proj_id"  integer NOT NULL,
  "new_act_start_date"  datetime NULL,
  "ovr_act_start_date"  datetime NULL,
  "new_act_end_date"  datetime NULL,
  "ovr_act_end_date"  datetime NULL,
  "new_remain_drtn"  numeric(17,6) NULL,
  "ovr_remain_drtn"  numeric(17,6) NULL,
  "new_complete_pct"  numeric(10,2) NULL,
  "ovr_complete_pct"  numeric(10,2) NULL,
  "ovr_act_work_qty"  numeric(17,6) NULL,
  "new_act_work_qty"  numeric(17,6) NULL,
  "new_act_equip_qty"  numeric(17,6) NULL,
  "ovr_act_equip_qty"  numeric(17,6) NULL,
  "ovr_remain_work_qty"  numeric(17,6) NULL,
  "new_remain_work_qty"  numeric(17,6) NULL,
  "new_remain_equip_qty"  numeric(17,6) NULL,
  "ovr_remain_equip_qty"  numeric(17,6) NULL,
  "new_exp_end_date"  datetime NULL,
  "ovr_exp_end_date"  datetime NULL,
  "approval_date"  datetime NULL,
  "approval_user_name"  nvarchar(255) NULL,
  "approval_user_id"  integer NULL,
  "held_date"  datetime NULL,
  "rejected_by"  nvarchar(255) NULL,
  "resubmitted_by"  nvarchar(255) NULL,
  "rejected_date"  datetime NULL,
  "resubmitted_date"  datetime NULL,
  "all_data"  TEXT NULL,
  "new_suspend_date"  datetime NULL,
  "ovr_suspend_date"  datetime NULL,
  "new_resume_date"  datetime NULL,
  "ovr_resume_date"  datetime NULL,
  "offset_val"  nvarchar(3000) NULL,
  "new_cstr_date"  datetime NULL,
  "ovr_cstr_date"  datetime NULL,
  "new_cstr_type"  nvarchar(12) NULL,
  "ovr_cstr_type"  nvarchar(12) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_chgtask PRIMARY KEY (transaction_id,task_id)  )

go

print 'Creating table CHGTASKACTV'

--METADATA NAME:CHGTASKACTV TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTASKACTV(
  "transaction_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "status_code"  nvarchar(20) DEFAULT 'TS_Pending' NOT NULL,
  "proj_id"  integer NOT NULL,
  "actv_code_type_id"  integer NULL,
  "ovr_actv_code_id"  integer NULL,
  "new_actv_code_id"  integer NULL,
  "approval_date"  datetime NULL,
  "approval_user_name"  nvarchar(255) NULL,
  "approval_user_id"  integer NULL,
  "held_date"  datetime NULL,
  "rejected_by"  nvarchar(255) NULL,
  "resubmitted_by"  nvarchar(255) NULL,
  "rejected_date"  datetime NULL,
  "resubmitted_date"  datetime NULL,
  "all_data"  TEXT NULL,
  "offset"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_chgtaskactv PRIMARY KEY (transaction_id,task_id)  )

go

print 'Creating table CHGTASKACTVX'

--METADATA NAME:CHGTASKACTVX TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTASKACTVX(
  "transaction_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "changedate"  datetime NULL,
  "requestuserobjectid"  integer NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_chgtaskactvx PRIMARY KEY (transaction_id,task_id)  )

go

print 'Creating table CHGTASKMEMO'

--METADATA NAME:CHGTASKMEMO TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTASKMEMO(
  "transaction_id"  integer NOT NULL,
  "memo_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "status_code"  nvarchar(20) DEFAULT 'TS_Pending' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_chgtaskmemo PRIMARY KEY (transaction_id,memo_id)  )

go

print 'Creating table CHGTASKMEMOX'

--METADATA NAME:CHGTASKMEMOX TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTASKMEMOX(
  "transaction_id"  integer NOT NULL,
  "memo_id"  integer NOT NULL,
  "changedate"  datetime NULL,
  "requestusername"  nvarchar(255) NULL,
  "requestuserobjectid"  integer NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_chgtaskmemox PRIMARY KEY (transaction_id,memo_id)  )

go

print 'Creating table CHGTASKPROC'

--METADATA NAME:CHGTASKPROC TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTASKPROC(
  "transaction_id"  integer NOT NULL,
  "proc_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "status_code"  nvarchar(20) DEFAULT 'TS_Pending' NOT NULL,
  "proj_id"  integer NOT NULL,
  "new_complete_pct"  numeric(10,2) NULL,
  "ovr_complete_pct"  numeric(10,2) NULL,
  "approval_date"  datetime NULL,
  "approval_user_name"  nvarchar(255) NULL,
  "approval_user_id"  integer NULL,
  "held_date"  datetime NULL,
  "proc_name"  nvarchar(120) NULL,
  "ovr_proc_name"  nvarchar(120) NULL,
  "rejected_by"  nvarchar(255) NULL,
  "resubmitted_by"  nvarchar(255) NULL,
  "rejected_date"  datetime NULL,
  "resubmitted_date"  datetime NULL,
  "all_data"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_chgtaskproc PRIMARY KEY (transaction_id,proc_id)  )

go

print 'Creating table CHGTASKPROCX'

--METADATA NAME:CHGTASKPROCX TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTASKPROCX(
  "transaction_id"  integer NOT NULL,
  "proc_id"  integer NOT NULL,
  "changedate"  datetime NULL,
  "requestusername"  nvarchar(255) NULL,
  "requestuserobjectid"  integer NULL,
  "pendingstepname"  nvarchar(120) NULL,
  "overridestepname"  nvarchar(120) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_chgtaskprocx PRIMARY KEY (transaction_id,proc_id)  )

go

print 'Creating table CHGTASKX'

--METADATA NAME:CHGTASKX TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTASKX(
  "transaction_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "changedate"  datetime NULL,
  "requestusername"  nvarchar(255) NULL,
  "requestuserobjectid"  integer NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_chgtaskx PRIMARY KEY (transaction_id,task_id)  )

go

print 'Creating table CHGTRSRC'

--METADATA NAME:CHGTRSRC TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTRSRC(
  "transaction_id"  integer NOT NULL,
  "taskrsrc_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "status_code"  nvarchar(20) DEFAULT 'TS_Pending' NOT NULL,
  "proj_id"  integer NOT NULL,
  "new_act_start_date"  datetime NULL,
  "ovr_act_start_date"  datetime NULL,
  "new_act_end_date"  datetime NULL,
  "ovr_act_end_date"  datetime NULL,
  "ovr_act_reg_qty"  numeric(17,6) NULL,
  "new_act_reg_qty"  numeric(17,6) NULL,
  "ovr_remain_qty"  numeric(17,6) NULL,
  "new_remain_qty"  numeric(17,6) NULL,
  "new_remain_drtn"  numeric(17,6) NULL,
  "ovr_remain_drtn"  numeric(17,6) NULL,
  "approval_date"  datetime NULL,
  "approval_user_name"  nvarchar(255) NULL,
  "approval_user_id"  integer NULL,
  "held_date"  datetime NULL,
  "new_reend_date"  datetime NULL,
  "ovr_reend_date"  datetime NULL,
  "rejected_by"  nvarchar(255) NULL,
  "resubmitted_by"  nvarchar(255) NULL,
  "rejected_date"  datetime NULL,
  "resubmitted_date"  datetime NULL,
  "all_data"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_chgtrsrc PRIMARY KEY (transaction_id,taskrsrc_id)  )

go

print 'Creating table CHGTRSRCX'

--METADATA NAME:CHGTRSRCX TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGTRSRCX(
  "transaction_id"  integer NOT NULL,
  "taskrsrc_id"  integer NOT NULL,
  "changedate"  datetime NULL,
  "requestusername"  nvarchar(255) NULL,
  "requestuserobjectid"  integer NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_chgtrsrcx PRIMARY KEY (transaction_id,taskrsrc_id)  )

go

print 'Creating table CHGUDFVALUE'

--METADATA NAME:CHGUDFVALUE TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGUDFVALUE(
  "transaction_id"  integer NOT NULL,
  "fk_id"  integer NOT NULL,
  "status_code"  nvarchar(20) DEFAULT 'TS_Pending' NOT NULL,
  "proj_id"  integer NOT NULL,
  "udf_type_id"  integer NULL,
  "ovr_udf_text"  nvarchar(255) NULL,
  "ovr_udf_number"  DECIMAL(28,10) NULL,
  "ovr_udf_code_id"  integer NULL,
  "ovr_udf_date"  datetime NULL,
  "new_udf_text"  nvarchar(255) NULL,
  "new_udf_number"  DECIMAL(28,10) NULL,
  "new_udf_code_id"  integer NULL,
  "new_udf_date"  datetime NULL,
  "approval_date"  datetime NULL,
  "approval_user_name"  nvarchar(255) NULL,
  "approval_user_id"  integer NULL,
  "held_date"  datetime NULL,
  "rejected_by"  nvarchar(255) NULL,
  "resubmitted_by"  nvarchar(255) NULL,
  "rejected_date"  datetime NULL,
  "resubmitted_date"  datetime NULL,
  "all_data"  TEXT NULL,
  "offset"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_chgudfvalue PRIMARY KEY (transaction_id,fk_id)  )

go

print 'Creating table CHGUDFVALUEX'

--METADATA NAME:CHGUDFVALUEX TYPE:TABLE CHANGE:CREATE

CREATE TABLE CHGUDFVALUEX(
  "transaction_id"  integer NOT NULL,
  "fk_id"  integer NULL,
  "udf_type_id"  integer NOT NULL,
  "changedate"  datetime NULL,
  "overrideudfnumber"  DECIMAL(28,10) NULL,
  "pendingudfnumber"  DECIMAL(28,10) NULL,
  "overrideudfinteger"  DECIMAL(28,10) NULL,
  "pendingudfinteger"  DECIMAL(28,10) NULL,
  "overrideudfcost"  DECIMAL(28,10) NULL,
  "pendingudfcost"  DECIMAL(28,10) NULL,
  "requestuserobjectid"  integer NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_chgudfvaluex PRIMARY KEY (transaction_id,udf_type_id)  )

go

print 'Creating table COSTACCOUNTHIERARCHY'

--METADATA NAME:COSTACCOUNTHIERARCHY TYPE:TABLE CHANGE:CREATE

CREATE TABLE COSTACCOUNTHIERARCHY(
  "parentobjectid"  integer NULL,
  "parentsequencenumber"  integer NULL,
  "parentname"  nvarchar(100) NULL,
  "parentid"  nvarchar(40) NULL,
  "childobjectid"  integer NULL,
  "childsequencenumber"  integer NULL,
  "childname"  nvarchar(100) NULL,
  "childid"  nvarchar(40) NULL,
  "parentlevelsbelowroot"  integer NOT NULL,
  "childlevelsbelowroot"  integer NOT NULL,
  "levelsbetween"  integer NOT NULL,
  "childhaschildren"  nvarchar(1) NULL,
  "fullpathname"  nvarchar(4000) NULL
  )

go

print 'Creating table COSTSECURITY'

--METADATA NAME:COSTSECURITY TYPE:TABLE CHANGE:CREATE

CREATE TABLE COSTSECURITY(
  "rdbmsuserid"  integer NULL,
  "projectobjectid"  integer NULL,
  "wholeprojectflag"  char(1) NULL
  )

go

print 'Creating table CURRTYPEX'

--METADATA NAME:CURRTYPEX TYPE:TABLE CHANGE:CREATE

CREATE TABLE CURRTYPEX(
  "curr_id"  integer NOT NULL,
  "isbasecurrency"  nvarchar(1) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_currencyx PRIMARY KEY (curr_id)  )

go

print 'Creating table DBERRLOG'

--METADATA NAME:DBERRLOG TYPE:TABLE CHANGE:CREATE

CREATE TABLE DBERRLOG(
  "log_id"  integer NOT NULL,
  "created_on"  datetime NULL,
  "created_by"  nvarchar(3000) NULL,
  "errorcode"  integer NULL,
  "callstack"  nvarchar(3000) NULL,
  "errorstack"  nvarchar(3000) NULL,
  "backtrace"  nvarchar(3000) NULL,
  "error_info"  nvarchar(3000) NULL
,CONSTRAINT pk_dberrlog PRIMARY KEY (log_id)  )

go

print 'Creating table DELTASKPROC'

--METADATA NAME:DELTASKPROC TYPE:TABLE CHANGE:CREATE

CREATE TABLE DELTASKPROC(
  "transaction_id"  integer NOT NULL,
  "proc_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "proc_name"  nvarchar(120) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_deltaskproc PRIMARY KEY (transaction_id,proc_id)  )

go

print 'Creating table DELTASKPROCX'

--METADATA NAME:DELTASKPROCX TYPE:TABLE CHANGE:CREATE

CREATE TABLE DELTASKPROCX(
  "transaction_id"  integer NOT NULL,
  "proc_id"  integer NOT NULL,
  "changedate"  datetime NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_deltaskprocx PRIMARY KEY (proc_id,transaction_id)  )

go

print 'Creating table DM_ATTR'

--METADATA NAME:DM_ATTR TYPE:TABLE CHANGE:CREATE

CREATE TABLE DM_ATTR(
  "dm_attr_id"  integer NOT NULL,
  "attr_id"  integer NOT NULL,
  "guid"  nvarchar(255) NOT NULL,
  "attr_value"  nvarchar(120) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_dm_attr PRIMARY KEY (dm_attr_id)  )

go

print 'Creating table DOC'

--METADATA NAME:DOC TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOC(
  "doc_id"  integer NOT NULL,
  "doc_folder_id"  integer NOT NULL,
  "doc_uuid"  nvarchar(255) NULL,
  "current_version"  nvarchar(255) NULL,
  "version_label"  nvarchar(255) NULL,
  "doc_title"  nvarchar(255) NULL,
  "doc_type"  nvarchar(255) NULL,
  "author_name"  nvarchar(255) NULL,
  "file_name"  nvarchar(255) NULL,
  "checkout_flag"  nvarchar(1) NULL,
  "checkout_user"  nvarchar(255) NULL,
  "doc_comment"  nvarchar(4000) NULL,
  "doc_update_date"  datetime NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_doc PRIMARY KEY (doc_id)  )

go

print 'Creating table DOCUMENTX'

--METADATA NAME:DOCUMENTX TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOCUMENTX(
  "doc_id"  integer NOT NULL,
  "documentcategoryname"  nvarchar(255) NULL,
  "documentstatuscodename"  nvarchar(255) NULL,
  "projectid"  nvarchar(255) NULL,
  "resourceid"  nvarchar(255) NULL,
  "resourcename"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_documentx PRIMARY KEY (doc_id)  )

go

print 'Creating table DOCUMENT_MAPPER'

--METADATA NAME:DOCUMENT_MAPPER TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOCUMENT_MAPPER(
  "doc_id"  integer NOT NULL,
  "doc_name"  nvarchar(255) NULL,
  "doc_type"  nvarchar(255) NULL,
  "doc_size"  nvarchar(255) NULL,
  "doc_external_key"  nvarchar(255) NULL,
  "parent_external_key"  nvarchar(255) NULL,
  "parent_version"  nvarchar(255) NULL,
  "page_number"  integer NOT NULL
,CONSTRAINT pk_document_mapper PRIMARY KEY (doc_id)  )

go

print 'Creating table DOC_FOLDER'

--METADATA NAME:DOC_FOLDER TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOC_FOLDER(
  "doc_folder_id"  integer NOT NULL,
  "doc_folder_name"  nvarchar(255) NOT NULL,
  "parent_folder_id"  integer NULL,
  "folder_comment"  nvarchar(4000) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_doc_folder PRIMARY KEY (doc_folder_id)  )

go

print 'Creating table DOC_RECENT'

--METADATA NAME:DOC_RECENT TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOC_RECENT(
  "doc_recent_id"  integer NOT NULL,
  "doc_user_id"  integer NOT NULL,
  "doc_id"  integer NOT NULL,
  "doc_folder_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_doc_recent PRIMARY KEY (doc_recent_id)  )

go

print 'Creating table DOC_VERSION'

--METADATA NAME:DOC_VERSION TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOC_VERSION(
  "doc_version_id"  integer NOT NULL,
  "doc_id"  integer NOT NULL,
  "doc_uuid"  nvarchar(255) NULL,
  "version"  nvarchar(255) NULL,
  "doc_size"  integer NULL,
  "version_comment"  nvarchar(4000) NULL,
  "doc_data"  TEXT NULL,
  "doc_scan_status"  nvarchar(255) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_doc_version PRIMARY KEY (doc_version_id)  )

go

print 'Creating table EPSHIERARCHY'

--METADATA NAME:EPSHIERARCHY TYPE:TABLE CHANGE:CREATE

CREATE TABLE EPSHIERARCHY(
  "parentobjectid"  integer NULL,
  "parentprojectid"  integer NULL,
  "parentsequencenumber"  integer NULL,
  "parentname"  nvarchar(100) NULL,
  "parentid"  nvarchar(40) NULL,
  "childobjectid"  integer NULL,
  "childprojectid"  integer NULL,
  "childsequencenumber"  integer NULL,
  "childname"  nvarchar(100) NULL,
  "childid"  nvarchar(40) NULL,
  "parentlevelsbelowroot"  integer NOT NULL,
  "childlevelsbelowroot"  integer NOT NULL,
  "levelsbetween"  integer NOT NULL,
  "childhaschildren"  nvarchar(1) NULL,
  "fullpathname"  nvarchar(4000) NULL,
  "update_date"  datetime DEFAULT getDate() NOT NULL
  )

go

print 'Creating table EPSSPREAD'

--METADATA NAME:EPSSPREAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE EPSSPREAD(
  "objectid"  integer NULL,
  "id"  nvarchar(40) NULL,
  "name"  nvarchar(100) NULL,
  "parentobjectid"  integer NULL,
  "projectobjectid"  integer NULL,
  "obsobjectid"  integer NULL,
  "obsname"  nvarchar(100) NULL,
  "startdate"  datetime NULL,
  "enddate"  datetime NULL,
  "actuallaborunits"  numeric(23,6) NULL,
  "actualnonlaborunits"  numeric(23,6) NULL,
  "atcompletionlaborunits"  numeric(23,6) NULL,
  "atcompletionnonlaborunits"  numeric(23,6) NULL,
  "baselineplannedlaborunits"  numeric(23,6) NULL,
  "baselineplannednonlaborunits"  numeric(23,6) NULL,
  "earnedvaluelaborunits"  numeric(23,6) NULL,
  "estimateatcompletionlaborunits"  numeric(23,6) NULL,
  "estimatetocompletelaborunits"  numeric(23,6) NULL,
  "plannedvaluelaborunits"  numeric(23,6) NULL,
  "remaininglaborunits"  numeric(23,6) NULL,
  "remainingnonlaborunits"  numeric(23,6) NULL,
  "actualcost"  numeric(23,6) NULL,
  "actualexpensecost"  numeric(23,6) NULL,
  "actuallaborcost"  numeric(23,6) NULL,
  "actualmaterialcost"  numeric(23,6) NULL,
  "actualnonlaborcost"  numeric(23,6) NULL,
  "actualtotalcost"  numeric(23,6) NULL,
  "atcompletionexpensecost"  numeric(23,6) NULL,
  "atcompletionlaborcost"  numeric(23,6) NULL,
  "atcompletionmaterialcost"  numeric(23,6) NULL,
  "atcompletionnonlaborcost"  numeric(23,6) NULL,
  "atcompletiontotalcost"  numeric(23,6) NULL,
  "baselineplannedexpensecost"  numeric(23,6) NULL,
  "baselineplannedlaborcost"  numeric(23,6) NULL,
  "baselineplannedmaterialcost"  numeric(23,6) NULL,
  "baselineplannednonlaborcost"  numeric(23,6) NULL,
  "baselineplannedtotalcost"  numeric(23,6) NULL,
  "earnedvaluecost"  numeric(23,6) NULL,
  "estimateatcompletioncost"  numeric(23,6) NULL,
  "estimatetocompletecost"  numeric(23,6) NULL,
  "plannedvaluecost"  numeric(23,6) NULL,
  "remainingexpensecost"  numeric(23,6) NULL,
  "remaininglaborcost"  numeric(23,6) NULL,
  "remainingmaterialcost"  numeric(23,6) NULL,
  "remainingnonlaborcost"  numeric(23,6) NULL,
  "remainingtotalcost"  numeric(23,6) NULL
  )

go

print 'Creating table GATEWAYDEPLOYMENT'

--METADATA NAME:GATEWAYDEPLOYMENT TYPE:TABLE CHANGE:CREATE

CREATE TABLE GATEWAYDEPLOYMENT(
  "deplmnt_id"  integer NOT NULL,
  "deployment_name"  nvarchar(255) NOT NULL,
  "provider_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_deplmnt_id PRIMARY KEY (deplmnt_id)  )

go

print 'Creating table GATEWAYPROVIDER'

--METADATA NAME:GATEWAYPROVIDER TYPE:TABLE CHANGE:CREATE

CREATE TABLE GATEWAYPROVIDER(
  "provider_id"  integer NOT NULL,
  "provider_name"  nvarchar(255) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_provider_id PRIMARY KEY (provider_id)  )

go

print 'Creating table GATEWAYSYNCACTION'

--METADATA NAME:GATEWAYSYNCACTION TYPE:TABLE CHANGE:CREATE

CREATE TABLE GATEWAYSYNCACTION(
  "action_id"  integer NOT NULL,
  "sync_type"  nvarchar(25) NOT NULL,
  "sync_name"  nvarchar(255) NOT NULL,
  "sync_id"  integer NULL,
  "action_name"  nvarchar(255) NOT NULL,
  "deplmnt_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_action_id PRIMARY KEY (action_id)  )

go

print 'Creating table GLOBALSECURITY'

--METADATA NAME:GLOBALSECURITY TYPE:TABLE CHANGE:CREATE

CREATE TABLE GLOBALSECURITY(
  "rdbmsuserid"  integer NULL,
  "securecodeflag"  nvarchar(1) NULL,
  "resourcecostflag"  nvarchar(1) NULL,
  "proficiencyflag"  nvarchar(1) NULL,
  "auditdataflag"  nvarchar(1) NULL
  )

go

print 'Creating table GREPLACE'

--METADATA NAME:GREPLACE TYPE:TABLE CHANGE:CREATE

CREATE TABLE GREPLACE(
  "greplace_id"  integer NOT NULL,
  "greplace_name"  nvarchar(40) NULL,
  "greplace_data"  TEXT NULL,
  "user_id"  integer NULL,
  "table_name"  nvarchar(30) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL,
  "template_type"  nvarchar(7) NULL
,CONSTRAINT pk_greplace PRIMARY KEY (greplace_id)  )

go

print 'Creating table GTT_PKLIST'

--METADATA NAME:GTT_PKLIST TYPE:TABLE CHANGE:CREATE

CREATE TABLE GTT_PKLIST(
  "pk_id"  integer NULL
  )

go

print 'Creating table ITERTASK'

--METADATA NAME:ITERTASK TYPE:TABLE CHANGE:CREATE

CREATE TABLE ITERTASK(
  "iteration_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_itertask PRIMARY KEY (iteration_id,task_id)  )

go

print 'Creating table ITERTEAM'

--METADATA NAME:ITERTEAM TYPE:TABLE CHANGE:CREATE

CREATE TABLE ITERTEAM(
  "iteration_id"  integer NOT NULL,
  "rfolio_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_iterteam PRIMARY KEY (iteration_id,rfolio_id)  )

go

print 'Creating table JOBPROJ_LKP'

--METADATA NAME:JOBPROJ_LKP TYPE:TABLE CHANGE:CREATE

CREATE TABLE JOBPROJ_LKP(
  "jobproj_lkp_id"  integer NOT NULL,
  "job_id"  integer NULL,
  "proj_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table JOBSET'

--METADATA NAME:JOBSET TYPE:TABLE CHANGE:CREATE

CREATE TABLE JOBSET(
  "job_id"  integer NOT NULL,
  "setting_name"  nvarchar(255) NOT NULL,
  "setting_value"  nvarchar(4000) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_jobset PRIMARY KEY (job_id,setting_name)  )

go

print 'Creating table LEANTASK'

--METADATA NAME:LEANTASK TYPE:TABLE CHANGE:CREATE

CREATE TABLE LEANTASK(
  "lean_task_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "task_type"  nvarchar(255) NOT NULL,
  "seq_num"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "lean_task_name"  nvarchar(120) NULL,
  "lean_task_short_name"  nvarchar(30) NOT NULL,
  "start_date"  datetime NULL,
  "use_only_work_days"  nvarchar(1) NULL,
  "completed_date"  datetime NULL,
  "due_date"  datetime NULL,
  "duration"  DECIMAL(28,10) NULL,
  "company"  nvarchar(255) NULL,
  "overdue"  nvarchar(1) NULL,
  "status"  nvarchar(255) NULL,
  "status_cmpl"  nvarchar(255) NULL,
  "status_dts"  nvarchar(255) NULL,
  "imp_tsk_flag"  nvarchar(1) NULL,
  "proposed_due_date"  datetime NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_leantask PRIMARY KEY (lean_task_id)  )

go

print 'Creating table MTXSCRTYP'

--METADATA NAME:MTXSCRTYP TYPE:TABLE CHANGE:CREATE

CREATE TABLE MTXSCRTYP(
  "matrix_id"  integer NOT NULL,
  "scoretype_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_mtxscrtyp PRIMARY KEY (matrix_id,scoretype_id)  )

go

print 'Creating table PAUDIT'

--METADATA NAME:PAUDIT TYPE:TABLE CHANGE:CREATE

CREATE TABLE PAUDIT(
  "audit_ts"  datetime NULL,
  "table_name"  nvarchar(30) NULL,
  "tx_ident"  nvarchar(30) NULL,
  "pk1"  nvarchar(255) NULL,
  "pk2"  nvarchar(255) NULL,
  "pk3"  nvarchar(255) NULL,
  "pk4"  nvarchar(255) NULL,
  "proj_id"  integer NULL,
  "oper"  nvarchar(1) NULL,
  "prm_user_name"  nvarchar(255) NULL,
  "audit_old"  nvarchar(4000) NULL,
  "audit_new"  nvarchar(4000) NULL,
  "audit_ext_old"  TEXT NULL,
  "audit_ext_new"  TEXT NULL,
  "logical_delete_flag"  nvarchar(1) NULL,
  "rdbms_user_name"  nvarchar(255) NULL,
  "os_user_name"  nvarchar(255) NULL,
  "program"  nvarchar(255) NULL,
  "host_name"  nvarchar(255) NULL,
  "app_name"  nvarchar(25) NULL,
  "netaddress"  nvarchar(64) NULL
  )

go

print 'Creating table PAUDITX'

--METADATA NAME:PAUDITX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PAUDITX(
  "table_name"  nvarchar(30) NULL,
  "tab_primary_keys"  nvarchar(4000) NULL,
  "tab_col_name"  nvarchar(4000) NULL,
  "old_value"  nvarchar(4000) NULL,
  "new_value"  nvarchar(4000) NULL,
  "proj_id"  integer NULL,
  "oper"  nvarchar(1) NULL,
  "prm_user_name"  nvarchar(255) NULL,
  "host_name"  nvarchar(255) NULL,
  "app_name"  nvarchar(25) NULL,
  "audit_ts"  datetime NULL
  )

go

print 'Creating table PCATUSERX'

--METADATA NAME:PCATUSERX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PCATUSERX(
  "proj_catg_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "codetypeobjectid"  integer NULL,
  "codevalue"  nvarchar(255) NULL,
  "username"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_projectcodeuserx PRIMARY KEY (proj_catg_id,user_id)  )

go

print 'Creating table PCATVALX'

--METADATA NAME:PCATVALX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PCATVALX(
  "proj_catg_id"  integer NOT NULL,
  "codetypename"  nvarchar(255) NULL,
  "issecurecode"  nvarchar(1) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_projectcodex PRIMARY KEY (proj_catg_id)  )

go

print 'Creating table PC_KEY_XREF'

--METADATA NAME:PC_KEY_XREF TYPE:TABLE CHANGE:CREATE

CREATE TABLE PC_KEY_XREF(
  "execution_id"  integer NULL,
  "ref_table"  nvarchar(30) NULL,
  "source_id"  integer NULL,
  "new_id"  integer NULL,
  "new_value"  nvarchar(100) NULL
  )

go

print 'Creating table PC_PROCESS_STAT'

--METADATA NAME:PC_PROCESS_STAT TYPE:TABLE CHANGE:CREATE

CREATE TABLE PC_PROCESS_STAT(
  "pc_process_stat_id"  integer identity(1,1) NOT NULL,
  "execution_id"  integer NULL,
  "process_name"  nvarchar(60) NULL,
  "step_name"  nvarchar(60) NULL,
  "status"  nvarchar(10) NULL,
  "start_ts"  datetime NULL,
  "end_ts"  datetime NULL,
  "estimated_time"  numeric(17,6) NULL,
  "actual_time"  numeric(17,6) NULL,
  "row_processed"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_pc_process_stat PRIMARY KEY (pc_process_stat_id)  )

go

print 'Creating table PFOLIOX'

--METADATA NAME:PFOLIOX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PFOLIOX(
  "pfolio_id"  integer NOT NULL,
  "username"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_projectportfoliox PRIMARY KEY (pfolio_id)  )

go

print 'Creating table PLPROJREF'

--METADATA NAME:PLPROJREF TYPE:TABLE CHANGE:CREATE

CREATE TABLE PLPROJREF(
  "proj_id"  integer NOT NULL,
  "ref_cnt"  integer NOT NULL,
  "last_queued_date"  datetime NULL
,CONSTRAINT pk_plprojref PRIMARY KEY (proj_id)  )

go

print 'Creating table PROFPRIVX'

--METADATA NAME:PROFPRIVX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROFPRIVX(
  "prof_id"  integer NOT NULL,
  "priv_num"  integer NOT NULL,
  "privlegename"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_userprofileprivilegex PRIMARY KEY (prof_id,priv_num)  )

go

print 'Creating table PROJCOSTX'

--METADATA NAME:PROJCOSTX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJCOSTX(
  "cost_item_id"  integer NOT NULL,
  "activityid"  nvarchar(255) NULL,
  "activityname"  nvarchar(255) NULL,
  "actualunits"  DECIMAL(28,10) NULL,
  "atcompletioncost"  DECIMAL(28,10) NULL,
  "atcompletionunits"  DECIMAL(28,10) NULL,
  "costaccountid"  nvarchar(255) NULL,
  "costaccountname"  nvarchar(255) NULL,
  "expensecategoryname"  nvarchar(255) NULL,
  "expensepercentcomplete"  DECIMAL(28,10) NULL,
  "overbudget"  nvarchar(1) NULL,
  "projectid"  nvarchar(255) NULL,
  "remainingunits"  DECIMAL(28,10) NULL,
  "wbsobjectid"  integer NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_activityexpensex PRIMARY KEY (cost_item_id)  )

go

print 'Creating table PROJDEPLMENT'

--METADATA NAME:PROJDEPLMENT TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJDEPLMENT(
  "proj_deplmnt_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "deplmnt_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_proj_deplmnt_id PRIMARY KEY (proj_deplmnt_id)  )

go

print 'Creating table PROJECTCODEHIERARCHY'

--METADATA NAME:PROJECTCODEHIERARCHY TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJECTCODEHIERARCHY(
  "codetypeobjectid"  integer NOT NULL,
  "codetypename"  nvarchar(60) NOT NULL,
  "codetypesequencenumber"  integer NOT NULL,
  "codetypeissecure"  nvarchar(1) NOT NULL,
  "parentcodevalueobjectid"  integer NULL,
  "parentcodevaluename"  nvarchar(100) NULL,
  "parentcodevalueshortname"  nvarchar(60) NULL,
  "parentcodevaluesequencenumber"  integer NULL,
  "childcodevalueobjectid"  integer NULL,
  "childcodevaluename"  nvarchar(100) NULL,
  "childcodevalueshortname"  nvarchar(60) NULL,
  "childcodevaluesequencenumber"  integer NULL,
  "parentlevelsbelowroot"  integer NOT NULL,
  "childlevelsbelowroot"  integer NOT NULL,
  "levelsbetween"  integer NOT NULL,
  "childhaschildren"  nvarchar(1) NULL,
  "fullpathname"  nvarchar(4000) NULL,
  "codetypeweight"  numeric(23,6) NULL,
  "maxcodevalueweight"  numeric(23,6) NULL,
  "parentcodevalueweight"  numeric(23,6) NULL,
  "childcodevalueweight"  numeric(23,6) NULL
  )

go

print 'Creating table PROJECTCOSTCBSSPREAD'

--METADATA NAME:PROJECTCOSTCBSSPREAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJECTCOSTCBSSPREAD(
  "cost_type_id"  integer NOT NULL,
  "cbs_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "spread_date"  datetime NULL,
  "target_qty"  numeric(22,6) NULL,
  "act_qty"  numeric(22,6) NULL,
  "act_this_per_qty"  numeric(22,6) NULL,
  "remain_qty"  numeric(22,6) NULL,
  "total_qty"  numeric(22,6) NULL,
  "total_period_qty"  numeric(22,6) NULL,
  "target_cost"  numeric(25,6) NULL,
  "act_cost"  numeric(25,6) NULL,
  "act_this_period_cost"  numeric(25,6) NULL,
  "remain_cost"  numeric(25,6) NULL,
  "total_cost"  numeric(25,6) NULL,
  "total_period_cost"  numeric(25,6) NULL
  )

go

print 'Creating table PROJECTSECURITY'

--METADATA NAME:PROJECTSECURITY TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJECTSECURITY(
  "rdbmsuserid"  integer NULL,
  "projectobjectid"  integer NULL,
  "costflag"  nvarchar(1) NULL,
  "update_date"  datetime DEFAULT getDate() NOT NULL
  )

go

print 'Creating table PROJECTSPREAD'

--METADATA NAME:PROJECTSPREAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJECTSPREAD(
  "objectid"  integer NULL,
  "id"  nvarchar(40) NULL,
  "name"  nvarchar(100) NULL,
  "parentepsobjectid"  integer NULL,
  "obsobjectid"  integer NULL,
  "obsname"  nvarchar(100) NULL,
  "startdate"  datetime NULL,
  "enddate"  datetime NULL,
  "actuallaborunits"  numeric(23,6) NULL,
  "actualnonlaborunits"  numeric(23,6) NULL,
  "atcompletionlaborunits"  numeric(23,6) NULL,
  "atcompletionnonlaborunits"  numeric(23,6) NULL,
  "baselineplannedlaborunits"  numeric(23,6) NULL,
  "baselineplannednonlaborunits"  numeric(23,6) NULL,
  "earnedvaluelaborunits"  numeric(23,6) NULL,
  "estimateatcompletionlaborunits"  numeric(23,6) NULL,
  "estimatetocompletelaborunits"  numeric(23,6) NULL,
  "plannedlaborunits"  numeric(23,6) NULL,
  "plannednonlaborunits"  numeric(23,6) NULL,
  "plannedvaluelaborunits"  numeric(23,6) NULL,
  "remaininglaborunits"  numeric(23,6) NULL,
  "remainingnonlaborunits"  numeric(23,6) NULL,
  "actualcost"  numeric(23,6) NULL,
  "actualexpensecost"  numeric(23,6) NULL,
  "actuallaborcost"  numeric(23,6) NULL,
  "actualmaterialcost"  numeric(23,6) NULL,
  "actualnonlaborcost"  numeric(23,6) NULL,
  "actualtotalcost"  numeric(23,6) NULL,
  "atcompletionexpensecost"  numeric(23,6) NULL,
  "atcompletionlaborcost"  numeric(23,6) NULL,
  "atcompletionmaterialcost"  numeric(23,6) NULL,
  "atcompletionnonlaborcost"  numeric(23,6) NULL,
  "atcompletiontotalcost"  numeric(23,6) NULL,
  "baselineplannedexpensecost"  numeric(23,6) NULL,
  "baselineplannedlaborcost"  numeric(23,6) NULL,
  "baselineplannedmaterialcost"  numeric(23,6) NULL,
  "baselineplannednonlaborcost"  numeric(23,6) NULL,
  "baselineplannedtotalcost"  numeric(23,6) NULL,
  "earnedvaluecost"  numeric(23,6) NULL,
  "estimateatcompletioncost"  numeric(23,6) NULL,
  "estimatetocompletecost"  numeric(23,6) NULL,
  "plannedexpensecost"  numeric(23,6) NULL,
  "plannedlaborcost"  numeric(23,6) NULL,
  "plannedmaterialcost"  numeric(23,6) NULL,
  "plannednonlaborcost"  numeric(23,6) NULL,
  "plannedtotalcost"  numeric(23,6) NULL,
  "plannedvaluecost"  numeric(23,6) NULL,
  "remainingexpensecost"  numeric(23,6) NULL,
  "remaininglaborcost"  numeric(23,6) NULL,
  "remainingmaterialcost"  numeric(23,6) NULL,
  "remainingnonlaborcost"  numeric(23,6) NULL,
  "remainingtotalcost"  numeric(23,6) NULL
  )

go

print 'Creating table PROJECTX'

--METADATA NAME:PROJECTX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJECTX(
  "proj_id"  integer NOT NULL,
  "annualdiscountrate"  DECIMAL(28,10) NULL,
  "anticipatedfinishdate"  datetime NULL,
  "anticipatedstartdate"  datetime NULL,
  "containssummarydata"  nvarchar(1) NULL,
  "currentbudget"  DECIMAL(28,10) NULL,
  "currentvariance"  DECIMAL(28,10) NULL,
  "datadate"  datetime NULL,
  "discountapplicationperiod"  nvarchar(24) NULL,
  "distributedcurrentbudget"  DECIMAL(28,10) NULL,
  "earnedvaluecomputetype"  nvarchar(255) NULL,
  "earnedvalueetccomputetype"  nvarchar(255) NULL,
  "earnedvalueetcuservalue"  DECIMAL(28,10) NULL,
  "earnedvalueuserpercent"  DECIMAL(28,10) NULL,
  "finishdate"  datetime NULL,
  "forecastfinishdate"  datetime NULL,
  "forecaststartdate"  datetime NULL,
  "independentetclaborunits"  DECIMAL(28,10) NULL,
  "independentetctotalcost"  DECIMAL(28,10) NULL,
  "last_fin_dates_id"  integer NULL,
  "name"  nvarchar(255) NULL,
  "obsname"  nvarchar(255) NULL,
  "obsobjectid"  integer NULL,
  "originalbudget"  DECIMAL(28,10) NULL,
  "overallprojectscore"  DECIMAL(28,10) NULL,
  "parentepsobjectid"  integer NULL,
  "proposedbudget"  DECIMAL(28,10) NULL,
  "risklevel"  nvarchar(24) NULL,
  "riskscore"  integer NULL,
  "riskexposure"  DECIMAL(28,10) NULL,
  "startdate"  datetime NULL,
  "status"  nvarchar(24) NULL,
  "sumaccountingvarbylaborunits"  DECIMAL(28,10) NULL,
  "sumaccountingvariancebycost"  DECIMAL(28,10) NULL,
  "sumactthisperiodmaterialcost"  DECIMAL(28,10) NULL,
  "sumactthisperiodnonlaborcost"  DECIMAL(28,10) NULL,
  "sumactthisperiodnonlaborunits"  DECIMAL(28,10) NULL,
  "sumactualthisperiodlaborcost"  DECIMAL(28,10) NULL,
  "sumactualthisperiodlaborunits"  DECIMAL(28,10) NULL,
  "sumatcompletionmaterialcost"  DECIMAL(28,10) NULL,
  "sumatcompletionnonlaborcost"  DECIMAL(28,10) NULL,
  "sumatcompletionnonlaborunits"  DECIMAL(28,10) NULL,
  "sumatcompletiontotalcostvar"  DECIMAL(28,10) NULL,
  "sumbaselinecompactivitycount"  DECIMAL(28,10) NULL,
  "sumbaselinenotstartedactcnt"  DECIMAL(28,10) NULL,
  "sumblinprogressactivitycount"  DECIMAL(28,10) NULL,
  "sumbudgetatcmpbylaborunits"  DECIMAL(28,10) NULL,
  "sumbudgetatcompletionbycost"  DECIMAL(28,10) NULL,
  "sumcostperfindexbycost"  DECIMAL(28,10) NULL,
  "sumcostperfindexbylaborunits"  DECIMAL(28,10) NULL,
  "sumcostvariancebylaborunits"  DECIMAL(28,10) NULL,
  "sumcostvarindexbylaborunits"  DECIMAL(28,10) NULL,
  "sumdurationpercentofplanned"  DECIMAL(28,10) NULL,
  "sumeacbycost"  DECIMAL(28,10) NULL,
  "sumeacbylaborunits"  DECIMAL(28,10) NULL,
  "sumeachighpctbylaborunits"  DECIMAL(28,10) NULL,
  "sumeaclowpctbylaborunits"  DECIMAL(28,10) NULL,
  "sumetcbycost"  DECIMAL(28,10) NULL,
  "sumetcbylaborunits"  DECIMAL(28,10) NULL,
  "sumexpensecostpctcomplete"  DECIMAL(28,10) NULL,
  "sumlaborcostpercentcomplete"  DECIMAL(28,10) NULL,
  "sumlaborunitspercentcomplete"  DECIMAL(28,10) NULL,
  "sumactivitycount"  DECIMAL(28,10) NULL,
  "sumactualduration"  DECIMAL(28,10) NULL,
  "sumactualexpensecost"  DECIMAL(28,10) NULL,
  "sumactualfinishdate"  datetime NULL,
  "summaxactualfinishdate"  datetime NULL,
  "summaxrestartdate"  datetime NULL,
  "sumactuallaborcost"  DECIMAL(28,10) NULL,
  "sumactuallaborunits"  DECIMAL(28,10) NULL,
  "sumactualmaterialcost"  DECIMAL(28,10) NULL,
  "sumactualnonlaborcost"  DECIMAL(28,10) NULL,
  "sumactualnonlaborunits"  DECIMAL(28,10) NULL,
  "sumactualstartdate"  datetime NULL,
  "sumactualthisperiodcost"  DECIMAL(28,10) NULL,
  "sumactualtotalcost"  DECIMAL(28,10) NULL,
  "sumactualvaluebycost"  DECIMAL(28,10) NULL,
  "sumactualvaluebylaborunits"  DECIMAL(28,10) NULL,
  "sumatcompletionduration"  DECIMAL(28,10) NULL,
  "sumatcompletionexpensecost"  DECIMAL(28,10) NULL,
  "sumatcompletionlaborcost"  DECIMAL(28,10) NULL,
  "sumatcompletionlaborunits"  DECIMAL(28,10) NULL,
  "sumatcompletiontotalcost"  DECIMAL(28,10) NULL,
  "sumbaselineduration"  DECIMAL(28,10) NULL,
  "sumbaselineexpensecost"  DECIMAL(28,10) NULL,
  "sumbaselinefinishdate"  datetime NULL,
  "sumbaselinelaborcost"  DECIMAL(28,10) NULL,
  "sumbaselinelaborunits"  DECIMAL(28,10) NULL,
  "sumbaselinematerialcost"  DECIMAL(28,10) NULL,
  "sumbaselinenonlaborcost"  DECIMAL(28,10) NULL,
  "sumbaselinenonlaborunits"  DECIMAL(28,10) NULL,
  "sumbaselinestartdate"  datetime NULL,
  "sumbaselinetotalcost"  DECIMAL(28,10) NULL,
  "sumcompletedactivitycount"  DECIMAL(28,10) NULL,
  "sumcostpercentcomplete"  DECIMAL(28,10) NULL,
  "sumcostpercentofplanned"  DECIMAL(28,10) NULL,
  "sumcostvariancebycost"  DECIMAL(28,10) NULL,
  "sumcostvarianceindex"  DECIMAL(28,10) NULL,
  "sumcostvarianceindexbycost"  DECIMAL(28,10) NULL,
  "sumdurationpercentcomplete"  DECIMAL(28,10) NULL,
  "sumdurationvariance"  DECIMAL(28,10) NULL,
  "sumearnedvaluebycost"  DECIMAL(28,10) NULL,
  "sumearnedvaluebylaborunits"  DECIMAL(28,10) NULL,
  "sumexpensecostvariance"  DECIMAL(28,10) NULL,
  "sumfinishdatevariance"  DECIMAL(28,10) NULL,
  "suminprogressactivitycount"  DECIMAL(28,10) NULL,
  "sumlaborcostvariance"  DECIMAL(28,10) NULL,
  "sumlaborunitsvariance"  DECIMAL(28,10) NULL,
  "summaterialcostvariance"  DECIMAL(28,10) NULL,
  "sumnonlaborcostvariance"  DECIMAL(28,10) NULL,
  "sumnonlaborunitsvariance"  DECIMAL(28,10) NULL,
  "sumnotstartedactivitycount"  DECIMAL(28,10) NULL,
  "sumplannedvaluebycost"  DECIMAL(28,10) NULL,
  "sumprogressfinishdate"  datetime NULL,
  "sumremainingduration"  DECIMAL(28,10) NULL,
  "sumremainingexpensecost"  DECIMAL(28,10) NULL,
  "sumremainingfinishdate"  datetime NULL,
  "sumremaininglaborcost"  DECIMAL(28,10) NULL,
  "sumremaininglaborunits"  DECIMAL(28,10) NULL,
  "sumremainingmaterialcost"  DECIMAL(28,10) NULL,
  "sumremainingnonlaborcost"  DECIMAL(28,10) NULL,
  "sumremainingnonlaborunits"  DECIMAL(28,10) NULL,
  "sumremainingstartdate"  datetime NULL,
  "sumremainingtotalcost"  DECIMAL(28,10) NULL,
  "sumschedulepercentcomplete"  DECIMAL(28,10) NULL,
  "sumperformancepercentcomplete"  DECIMAL(28,10) NULL,
  "sumschedulevariancebycost"  DECIMAL(28,10) NULL,
  "sumschedulevarianceindex"  DECIMAL(28,10) NULL,
  "sumstartdatevariance"  DECIMAL(28,10) NULL,
  "sumtotalcostvariance"  DECIMAL(28,10) NULL,
  "sumtotalfloat"  DECIMAL(28,10) NULL,
  "sumunitspercentcomplete"  DECIMAL(28,10) NULL,
  "summaterialcostpctcomplete"  DECIMAL(28,10) NULL,
  "sumnonlaborcostpctcomplete"  DECIMAL(28,10) NULL,
  "sumnonlaborunitspctcomplete"  DECIMAL(28,10) NULL,
  "sumperfpctcmpbylaborunits"  DECIMAL(28,10) NULL,
  "sumplannedvaluebylaborunits"  DECIMAL(28,10) NULL,
  "sumschdpctcmpbylaborunits"  DECIMAL(28,10) NULL,
  "sumschdperfindexbylaborunits"  DECIMAL(28,10) NULL,
  "sumschdvariancebylaborunits"  DECIMAL(28,10) NULL,
  "sumschdvarianceindexbycost"  DECIMAL(28,10) NULL,
  "sumschdvarindexbylaborunits"  DECIMAL(28,10) NULL,
  "sumscheduleperfindexbycost"  DECIMAL(28,10) NULL,
  "sumtocompleteperfindexbycost"  DECIMAL(28,10) NULL,
  "sumvaratcmpbylaborunits"  DECIMAL(28,10) NULL,
  "sumearlystartdate"  datetime NULL,
  "sumearlyenddate"  datetime NULL,
  "sumlatestartdate"  datetime NULL,
  "sumlateenddate"  datetime NULL,
  "summaxcalendarid"  DECIMAL(28,10) NULL,
  "summincalendarid"  DECIMAL(28,10) NULL,
  "totalbenefitplan"  DECIMAL(28,10) NULL,
  "totalbenefitplantally"  DECIMAL(28,10) NULL,
  "totalfunding"  DECIMAL(28,10) NULL,
  "totalspendingplan"  DECIMAL(28,10) NULL,
  "totalspendingplantally"  DECIMAL(28,10) NULL,
  "unallocatedbudget"  DECIMAL(28,10) NULL,
  "undistributedcurrentvariance"  DECIMAL(28,10) NULL,
  "sumactualprogressdate"  datetime NULL,
  "netpresentvalue"  numeric(23,6) NULL,
  "returnoninvestment"  numeric(23,6) NULL,
  "paybackperiod"  integer NULL,
  "sumplannedstartdate"  datetime NULL,
  "sumplannedfinishdate"  datetime NULL,
  "sumplannedduration"  DECIMAL(28,10) NULL,
  "sumplannedlaborunits"  DECIMAL(28,10) NULL,
  "sumplannednonlaborunits"  DECIMAL(28,10) NULL,
  "sumplannedlaborcost"  DECIMAL(28,10) NULL,
  "sumplannednonlaborcost"  DECIMAL(28,10) NULL,
  "sumplannedexpensecost"  DECIMAL(28,10) NULL,
  "sumplannedmaterialcost"  DECIMAL(28,10) NULL,
  "sumplannedtotalcost"  DECIMAL(28,10) NULL,
  "locationname"  nvarchar(255) NULL,
  "fintmpl_id"  integer NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL,
  "update_dim_hash"  DECIMAL(28,10) DEFAULT 0 NULL,
  "update_dim_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_projectx PRIMARY KEY (proj_id)  )

go

print 'Creating table PROJECT_ETL_LIST'

--METADATA NAME:PROJECT_ETL_LIST TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJECT_ETL_LIST(
  "etl_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "update_date"  datetime DEFAULT getDate() NOT NULL
,CONSTRAINT pk_project_etl_list PRIMARY KEY (etl_id)  )

go

print 'Creating table PROJFUNDX'

--METADATA NAME:PROJFUNDX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJFUNDX(
  "proj_fund_id"  integer NOT NULL,
  "epsid"  nvarchar(255) NULL,
  "epsname"  nvarchar(255) NULL,
  "epsobjectid"  integer NULL,
  "projectid"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_projectfundingx PRIMARY KEY (proj_fund_id)  )

go

print 'Creating table PROJISSUX'

--METADATA NAME:PROJISSUX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJISSUX(
  "issue_id"  integer NOT NULL,
  "activityid"  nvarchar(255) NULL,
  "activityname"  nvarchar(255) NULL,
  "obsname"  nvarchar(255) NULL,
  "projectid"  nvarchar(255) NULL,
  "rawtextnote"  TEXT NULL,
  "resourceid"  nvarchar(255) NULL,
  "resourcename"  nvarchar(255) NULL,
  "wbscode"  nvarchar(255) NULL,
  "wbsname"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_projectissuex PRIMARY KEY (issue_id)  )

go

print 'Creating table PROJPCATX'

--METADATA NAME:PROJPCATX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJPCATX(
  "proj_id"  integer NOT NULL,
  "proj_catg_type_id"  integer NOT NULL,
  "projectcodedescription"  nvarchar(255) NULL,
  "projectcodetypename"  nvarchar(255) NULL,
  "projectcodevalue"  nvarchar(255) NULL,
  "projectname"  nvarchar(255) NULL,
  "issecurecode"  nvarchar(1) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_projectcodeassignmentx PRIMARY KEY (proj_id,proj_catg_type_id)  )

go

print 'Creating table PROJSET'

--METADATA NAME:PROJSET TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJSET(
  "proj_id"  integer NOT NULL,
  "setting_name"  nvarchar(255) NOT NULL,
  "setting_value"  nvarchar(4000) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_projset PRIMARY KEY (proj_id,setting_name)  )

go

print 'Creating table PROJWBSX'

--METADATA NAME:PROJWBSX TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJWBSX(
  "wbs_id"  integer NOT NULL,
  "id"  nvarchar(255) NULL,
  "lastsummarizeddate"  datetime NULL,
  "plannedstartdate"  datetime NULL,
  "totalfunding"  DECIMAL(28,10) NULL,
  "currentbudget"  DECIMAL(28,10) NULL,
  "currentvariance"  DECIMAL(28,10) NULL,
  "distributedcurrentbudget"  DECIMAL(28,10) NULL,
  "finishdate"  datetime NULL,
  "forecastfinishdate"  datetime NULL,
  "forecaststartdate"  datetime NULL,
  "fullname"  nvarchar(2000) NULL,
  "fullsequence"  nvarchar(2000) NULL,
  "obsname"  nvarchar(255) NULL,
  "projectid"  nvarchar(255) NULL,
  "proposedbudget"  DECIMAL(28,10) NULL,
  "startdate"  datetime NULL,
  "sumaccountingvarbylaborunits"  DECIMAL(28,10) NULL,
  "sumaccountingvariancebycost"  DECIMAL(28,10) NULL,
  "sumactthisperiodmaterialcost"  DECIMAL(28,10) NULL,
  "sumactthisperiodnonlaborcost"  DECIMAL(28,10) NULL,
  "sumactthisperiodnonlaborunits"  DECIMAL(28,10) NULL,
  "sumactualthisperiodlaborcost"  DECIMAL(28,10) NULL,
  "sumactualthisperiodlaborunits"  DECIMAL(28,10) NULL,
  "sumatcompletionmaterialcost"  DECIMAL(28,10) NULL,
  "sumatcompletionnonlaborcost"  DECIMAL(28,10) NULL,
  "sumatcompletionnonlaborunits"  DECIMAL(28,10) NULL,
  "sumatcompletiontotalcostvar"  DECIMAL(28,10) NULL,
  "sumbaselinecompactivitycount"  DECIMAL(28,10) NULL,
  "sumbaselinenotstartedactcnt"  DECIMAL(28,10) NULL,
  "sumblinprogressactivitycount"  DECIMAL(28,10) NULL,
  "sumbudgetatcmpbylaborunits"  DECIMAL(28,10) NULL,
  "sumbudgetatcompletionbycost"  DECIMAL(28,10) NULL,
  "sumcostperfindexbycost"  DECIMAL(28,10) NULL,
  "sumcostperfindexbylaborunits"  DECIMAL(28,10) NULL,
  "sumcostvariancebylaborunits"  DECIMAL(28,10) NULL,
  "sumcostvarindexbylaborunits"  DECIMAL(28,10) NULL,
  "sumdurationpercentofplanned"  DECIMAL(28,10) NULL,
  "sumeacbycost"  DECIMAL(28,10) NULL,
  "sumeacbylaborunits"  DECIMAL(28,10) NULL,
  "sumeachighpctbylaborunits"  DECIMAL(28,10) NULL,
  "sumeaclowpctbylaborunits"  DECIMAL(28,10) NULL,
  "sumetcbycost"  DECIMAL(28,10) NULL,
  "sumetcbylaborunits"  DECIMAL(28,10) NULL,
  "sumexpensecostpctcomplete"  DECIMAL(28,10) NULL,
  "sumlaborcostpercentcomplete"  DECIMAL(28,10) NULL,
  "sumlaborunitspercentcomplete"  DECIMAL(28,10) NULL,
  "sumactivitycount"  DECIMAL(28,10) NULL,
  "sumactualduration"  DECIMAL(28,10) NULL,
  "sumactualexpensecost"  DECIMAL(28,10) NULL,
  "sumactualfinishdate"  datetime NULL,
  "summaxactualfinishdate"  datetime NULL,
  "summaxrestartdate"  datetime NULL,
  "sumactuallaborcost"  DECIMAL(28,10) NULL,
  "sumactuallaborunits"  DECIMAL(28,10) NULL,
  "sumactualmaterialcost"  DECIMAL(28,10) NULL,
  "sumactualnonlaborcost"  DECIMAL(28,10) NULL,
  "sumactualnonlaborunits"  DECIMAL(28,10) NULL,
  "sumactualstartdate"  datetime NULL,
  "sumactualthisperiodcost"  DECIMAL(28,10) NULL,
  "sumactualtotalcost"  DECIMAL(28,10) NULL,
  "sumactualvaluebycost"  DECIMAL(28,10) NULL,
  "sumactualvaluebylaborunits"  DECIMAL(28,10) NULL,
  "sumatcompletionduration"  DECIMAL(28,10) NULL,
  "sumatcompletionexpensecost"  DECIMAL(28,10) NULL,
  "sumatcompletionlaborcost"  DECIMAL(28,10) NULL,
  "sumatcompletionlaborunits"  DECIMAL(28,10) NULL,
  "sumatcompletiontotalcost"  DECIMAL(28,10) NULL,
  "sumbaselineduration"  DECIMAL(28,10) NULL,
  "sumbaselineexpensecost"  DECIMAL(28,10) NULL,
  "sumbaselinefinishdate"  datetime NULL,
  "sumbaselinelaborcost"  DECIMAL(28,10) NULL,
  "sumbaselinelaborunits"  DECIMAL(28,10) NULL,
  "sumbaselinematerialcost"  DECIMAL(28,10) NULL,
  "sumbaselinenonlaborcost"  DECIMAL(28,10) NULL,
  "sumbaselinenonlaborunits"  DECIMAL(28,10) NULL,
  "sumbaselinestartdate"  datetime NULL,
  "sumbaselinetotalcost"  DECIMAL(28,10) NULL,
  "sumcompletedactivitycount"  DECIMAL(28,10) NULL,
  "sumcostpercentcomplete"  DECIMAL(28,10) NULL,
  "sumcostpercentofplanned"  DECIMAL(28,10) NULL,
  "sumcostvariancebycost"  DECIMAL(28,10) NULL,
  "sumcostvarianceindex"  DECIMAL(28,10) NULL,
  "sumcostvarianceindexbycost"  DECIMAL(28,10) NULL,
  "sumdurationpercentcomplete"  DECIMAL(28,10) NULL,
  "sumdurationvariance"  DECIMAL(28,10) NULL,
  "sumearnedvaluebycost"  DECIMAL(28,10) NULL,
  "sumearnedvaluebylaborunits"  DECIMAL(28,10) NULL,
  "sumexpensecostvariance"  DECIMAL(28,10) NULL,
  "sumfinishdatevariance"  DECIMAL(28,10) NULL,
  "suminprogressactivitycount"  DECIMAL(28,10) NULL,
  "sumlaborcostvariance"  DECIMAL(28,10) NULL,
  "sumlaborunitsvariance"  DECIMAL(28,10) NULL,
  "summaterialcostvariance"  DECIMAL(28,10) NULL,
  "sumnonlaborcostvariance"  DECIMAL(28,10) NULL,
  "sumnonlaborunitsvariance"  DECIMAL(28,10) NULL,
  "sumnotstartedactivitycount"  DECIMAL(28,10) NULL,
  "sumplannedvaluebycost"  DECIMAL(28,10) NULL,
  "sumprogressfinishdate"  datetime NULL,
  "sumremainingduration"  DECIMAL(28,10) NULL,
  "sumremainingexpensecost"  DECIMAL(28,10) NULL,
  "sumremainingfinishdate"  datetime NULL,
  "sumremaininglaborcost"  DECIMAL(28,10) NULL,
  "sumremaininglaborunits"  DECIMAL(28,10) NULL,
  "sumremainingmaterialcost"  DECIMAL(28,10) NULL,
  "sumremainingnonlaborcost"  DECIMAL(28,10) NULL,
  "sumremainingnonlaborunits"  DECIMAL(28,10) NULL,
  "sumremainingstartdate"  datetime NULL,
  "sumremainingtotalcost"  DECIMAL(28,10) NULL,
  "sumschedulepercentcomplete"  DECIMAL(28,10) NULL,
  "sumperformancepercentcomplete"  DECIMAL(28,10) NULL,
  "sumschedulevariancebycost"  DECIMAL(28,10) NULL,
  "sumschedulevarianceindex"  DECIMAL(28,10) NULL,
  "sumstartdatevariance"  DECIMAL(28,10) NULL,
  "sumtotalcostvariance"  DECIMAL(28,10) NULL,
  "sumtotalfloat"  DECIMAL(28,10) NULL,
  "sumunitspercentcomplete"  DECIMAL(28,10) NULL,
  "summaterialcostpctcomplete"  DECIMAL(28,10) NULL,
  "sumnonlaborcostpctcomplete"  DECIMAL(28,10) NULL,
  "sumnonlaborunitspctcomplete"  DECIMAL(28,10) NULL,
  "sumperfpctcmpbylaborunits"  DECIMAL(28,10) NULL,
  "sumplannedvaluebylaborunits"  DECIMAL(28,10) NULL,
  "sumschdpctcmpbylaborunits"  DECIMAL(28,10) NULL,
  "sumschdperfindexbylaborunits"  DECIMAL(28,10) NULL,
  "sumschdvariancebylaborunits"  DECIMAL(28,10) NULL,
  "sumschdvarianceindexbycost"  DECIMAL(28,10) NULL,
  "sumschdvarindexbylaborunits"  DECIMAL(28,10) NULL,
  "sumscheduleperfindexbycost"  DECIMAL(28,10) NULL,
  "sumtocompleteperfindexbycost"  DECIMAL(28,10) NULL,
  "sumvaratcmpbylaborunits"  DECIMAL(28,10) NULL,
  "sumearlystartdate"  datetime NULL,
  "sumearlyenddate"  datetime NULL,
  "sumlatestartdate"  datetime NULL,
  "sumlateenddate"  datetime NULL,
  "summaxcalendarid"  DECIMAL(28,10) NULL,
  "summincalendarid"  DECIMAL(28,10) NULL,
  "totalbenefitplan"  DECIMAL(28,10) NULL,
  "totalbenefitplantally"  DECIMAL(28,10) NULL,
  "totalspendingplan"  DECIMAL(28,10) NULL,
  "totalspendingplantally"  DECIMAL(28,10) NULL,
  "unallocatedbudget"  DECIMAL(28,10) NULL,
  "undistributedcurrentvariance"  DECIMAL(28,10) NULL,
  "sumactualprogressdate"  datetime NULL,
  "sumplannedstartdate"  datetime NULL,
  "sumplannedfinishdate"  datetime NULL,
  "sumplannedduration"  DECIMAL(28,10) NULL,
  "sumplannedlaborunits"  DECIMAL(28,10) NULL,
  "sumplannednonlaborunits"  DECIMAL(28,10) NULL,
  "sumplannedlaborcost"  DECIMAL(28,10) NULL,
  "sumplannednonlaborcost"  DECIMAL(28,10) NULL,
  "sumplannedexpensecost"  DECIMAL(28,10) NULL,
  "sumplannedmaterialcost"  DECIMAL(28,10) NULL,
  "sumplannedtotalcost"  DECIMAL(28,10) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL,
  "update_dim_hash"  DECIMAL(28,10) DEFAULT 0 NULL,
  "update_dim_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_wbsx PRIMARY KEY (wbs_id)  )

go

print 'Creating table PXJOBRUN'

--METADATA NAME:PXJOBRUN TYPE:TABLE CHANGE:CREATE

CREATE TABLE PXJOBRUN(
  "jobrun_id"  integer NOT NULL,
  "job_type"  nvarchar(20) NOT NULL,
  "job_type_key"  nvarchar(255) NULL,
  "job_name"  nvarchar(255) NOT NULL,
  "user_id"  integer NULL,
  "run_start_date"  datetime NULL,
  "run_end_date"  datetime NULL,
  "run_duration"  integer NULL,
  "status_code"  nvarchar(20) NOT NULL,
  "recur_data"  nvarchar(255) NULL,
  "recur_type"  nvarchar(20) NULL,
  "submitted_date"  datetime NULL,
  "last_error_descr"  nvarchar(255) NULL,
  "jab_data"  TEXT NULL,
  "worker_host"  nvarchar(50) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_pxjobrun PRIMARY KEY (jobrun_id)  )

go

print 'Creating table RCATVALX'

--METADATA NAME:RCATVALX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RCATVALX(
  "rsrc_catg_id"  integer NOT NULL,
  "codetypename"  nvarchar(255) NULL,
  "issecurecode"  nvarchar(1) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_resourcecodex PRIMARY KEY (rsrc_catg_id)  )

go

print 'Creating table RELITER'

--METADATA NAME:RELITER TYPE:TABLE CHANGE:CREATE

CREATE TABLE RELITER(
  "release_id"  integer NOT NULL,
  "iteration_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_reliter PRIMARY KEY (release_id,iteration_id)  )

go

print 'Creating table RELPROJ'

--METADATA NAME:RELPROJ TYPE:TABLE CHANGE:CREATE

CREATE TABLE RELPROJ(
  "release_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_relproj PRIMARY KEY (release_id,proj_id)  )

go

print 'Creating table REPORTDATE'

--METADATA NAME:REPORTDATE TYPE:TABLE CHANGE:CREATE

CREATE TABLE REPORTDATE(
  "datename"  integer NULL,
  "daydate"  datetime NULL,
  "dayname"  nvarchar(20) NULL,
  "dayofmonth"  integer NULL,
  "dayofyear"  integer NULL,
  "ordinaldayofmonth"  nvarchar(4) NULL,
  "ordinaldayofyear"  nvarchar(5) NULL,
  "weekbegindate"  datetime NULL,
  "dayofweek"  integer NULL,
  "weeknumber"  integer NULL,
  "monthnumber"  integer NULL,
  "monthname"  nvarchar(10) NULL,
  "monthshortname"  nvarchar(5) NULL,
  "monthenddate"  datetime NULL,
  "daysinmonth"  integer NULL,
  "yearmonth"  integer NULL,
  "quarternumber"  integer NULL,
  "quartername"  nvarchar(6) NULL,
  "year"  integer NULL,
  "etlprocess"  datetime NULL,
  "etluser"  nvarchar(255) NULL
  )

go

print 'Creating table REPORTTIME'

--METADATA NAME:REPORTTIME TYPE:TABLE CHANGE:CREATE

CREATE TABLE REPORTTIME(
  "civiliantime"  nvarchar(5) NULL,
  "militarytime"  nvarchar(4) NULL,
  "twochar"  nvarchar(2) NULL,
  "timename"  nvarchar(2) NULL,
  "timeofday"  integer NULL,
  "etlprocess"  datetime NULL,
  "etluser"  nvarchar(255) NULL
  )

go

print 'Creating table RESOURCEASSIGNMENTCBSSPREAD'

--METADATA NAME:RESOURCEASSIGNMENTCBSSPREAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE RESOURCEASSIGNMENTCBSSPREAD(
  "rsrc_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "cbs_id"  integer NOT NULL,
  "spread_date"  datetime NULL,
  "target_start_date"  datetime NULL,
  "target_end_date"  datetime NULL,
  "act_start_date"  datetime NULL,
  "act_end_date"  datetime NULL,
  "restart_date"  datetime NULL,
  "reend_date"  datetime NULL,
  "target_qty"  numeric(22,6) NULL,
  "act_qty"  numeric(22,6) NULL,
  "act_this_per_qty"  numeric(22,6) NULL,
  "remain_qty"  numeric(22,6) NULL,
  "total_qty"  numeric(22,6) NULL,
  "total_period_qty"  numeric(22,6) NULL,
  "target_cost"  numeric(25,6) NULL,
  "act_cost"  numeric(25,6) NULL,
  "act_this_period_cost"  numeric(25,6) NULL,
  "remain_cost"  numeric(25,6) NULL,
  "total_cost"  numeric(25,6) NULL,
  "total_period_cost"  numeric(25,6) NULL
  )

go

print 'Creating table RESOURCEASSIGNMENTSPREAD'

--METADATA NAME:RESOURCEASSIGNMENTSPREAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE RESOURCEASSIGNMENTSPREAD(
  "resourceassignmentobjectid"  integer NOT NULL,
  "startdate"  datetime NOT NULL,
  "enddate"  datetime NOT NULL,
  "resourceobjectid"  integer NULL,
  "roleobjectid"  integer NULL,
  "activityobjectid"  integer NOT NULL,
  "wbsobjectid"  integer NOT NULL,
  "projectobjectid"  integer NOT NULL,
  "costaccountobjectid"  integer NULL,
  "actualregularunits"  DECIMAL(28,10) NULL,
  "actualovertimeunits"  DECIMAL(28,10) NULL,
  "actualunits"  DECIMAL(28,10) NULL,
  "atcompletionunits"  DECIMAL(28,10) NULL,
  "plannedunits"  DECIMAL(28,10) NULL,
  "remainingunits"  DECIMAL(28,10) NULL,
  "remaininglateunits"  DECIMAL(28,10) NULL,
  "staffedremainingunits"  DECIMAL(28,10) NULL,
  "staffedremaininglateunits"  DECIMAL(28,10) NULL,
  "unstaffedremainingunits"  DECIMAL(28,10) NULL,
  "unstaffedremaininglateunits"  DECIMAL(28,10) NULL,
  "actualregularcost"  DECIMAL(28,10) NULL,
  "actualovertimecost"  DECIMAL(28,10) NULL,
  "actualcost"  DECIMAL(28,10) NULL,
  "atcompletioncost"  DECIMAL(28,10) NULL,
  "plannedcost"  DECIMAL(28,10) NULL,
  "remainingcost"  DECIMAL(28,10) NULL,
  "remaininglatecost"  DECIMAL(28,10) NULL,
  "staffedremainingcost"  DECIMAL(28,10) NULL,
  "staffedremaininglatecost"  DECIMAL(28,10) NULL,
  "unstaffedremainingcost"  DECIMAL(28,10) NULL,
  "unstaffedremaininglatecost"  DECIMAL(28,10) NULL,
  "update_date"  datetime DEFAULT getDate() NOT NULL
  )

go

print 'Creating table RESOURCECODEHIERARCHY'

--METADATA NAME:RESOURCECODEHIERARCHY TYPE:TABLE CHANGE:CREATE

CREATE TABLE RESOURCECODEHIERARCHY(
  "codetypeobjectid"  integer NOT NULL,
  "codetypename"  nvarchar(40) NOT NULL,
  "codetypesequencenumber"  integer NOT NULL,
  "codetypeissecure"  nvarchar(1) NOT NULL,
  "parentcodevalueobjectid"  integer NULL,
  "parentcodevaluename"  nvarchar(100) NULL,
  "parentcodevalueshortname"  nvarchar(32) NULL,
  "parentcodevaluesequencenumber"  integer NULL,
  "childcodevalueobjectid"  integer NULL,
  "childcodevaluename"  nvarchar(100) NULL,
  "childcodevalueshortname"  nvarchar(32) NULL,
  "childcodevaluesequencenumber"  integer NULL,
  "parentlevelsbelowroot"  integer NOT NULL,
  "childlevelsbelowroot"  integer NOT NULL,
  "levelsbetween"  integer NOT NULL,
  "childhaschildren"  nvarchar(1) NULL,
  "fullpathname"  nvarchar(4000) NULL
  )

go

print 'Creating table RESOURCEHIERARCHY'

--METADATA NAME:RESOURCEHIERARCHY TYPE:TABLE CHANGE:CREATE

CREATE TABLE RESOURCEHIERARCHY(
  "parentobjectid"  integer NULL,
  "parentsequencenumber"  integer NULL,
  "parentname"  nvarchar(255) NULL,
  "parentid"  nvarchar(255) NULL,
  "childobjectid"  integer NULL,
  "childsequencenumber"  integer NULL,
  "childname"  nvarchar(255) NULL,
  "childid"  nvarchar(255) NULL,
  "parentlevelsbelowroot"  integer NOT NULL,
  "childlevelsbelowroot"  integer NOT NULL,
  "levelsbetween"  integer NOT NULL,
  "childhaschildren"  nvarchar(1) NULL,
  "fullpathname"  nvarchar(4000) NULL,
  "update_date"  datetime DEFAULT getDate() NOT NULL
  )

go

print 'Creating table RESOURCELIMIT'

--METADATA NAME:RESOURCELIMIT TYPE:TABLE CHANGE:CREATE

CREATE TABLE RESOURCELIMIT(
  "rsrc_id"  integer NOT NULL,
  "startdate"  datetime NOT NULL,
  "enddate"  datetime NOT NULL,
  "limit"  DECIMAL(28,10) NULL,
  "update_date"  datetime DEFAULT getDate() NOT NULL
,CONSTRAINT pk_resourcelimit PRIMARY KEY (rsrc_id,startdate)  )

go

print 'Creating table RFOLIOX'

--METADATA NAME:RFOLIOX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RFOLIOX(
  "rfolio_id"  integer NOT NULL,
  "username"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_resourceteamx PRIMARY KEY (rfolio_id)  )

go

print 'Creating table RISK'

--METADATA NAME:RISK TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISK(
  "risk_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "id"  nvarchar(40) NOT NULL,
  "name"  nvarchar(200) NULL,
  "total_cost"  numeric(23,6) NOT NULL,
  "rsrc_id"  integer NULL,
  "type"  nvarchar(10) NOT NULL,
  "status"  nvarchar(10) NOT NULL,
  "category_id"  integer NULL,
  "description"  nvarchar(4000) NULL,
  "cause"  nvarchar(4000) NULL,
  "effect"  nvarchar(4000) NULL,
  "note"  nvarchar(4000) NULL,
  "identified_by_id"  integer NULL,
  "identified_date"  datetime NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_risk PRIMARY KEY (risk_id)  )

go

print 'Creating table RISKIMPACT'

--METADATA NAME:RISKIMPACT TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKIMPACT(
  "risk_id"  integer NOT NULL,
  "scoretype_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "threshold_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_riskimpact PRIMARY KEY (risk_id,scoretype_id)  )

go

print 'Creating table RISKMIT'

--METADATA NAME:RISKMIT TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKMIT(
  "mitigation_id"  integer NOT NULL,
  "id"  nvarchar(40) NOT NULL,
  "response_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "task_id"  integer NULL,
  "rsrc_id"  integer NULL,
  "name"  nvarchar(200) NULL,
  "start_date"  datetime NOT NULL,
  "finish_date"  datetime NOT NULL,
  "base_start_date"  datetime NOT NULL,
  "base_finish_date"  datetime NOT NULL,
  "remaining_cost"  numeric(23,6) NOT NULL,
  "actual_cost"  numeric(23,6) NOT NULL,
  "budget_cost"  numeric(23,6) NOT NULL,
  "status"  nvarchar(10) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_riskmit PRIMARY KEY (mitigation_id)  )

go

print 'Creating table RISKMITIMP'

--METADATA NAME:RISKMITIMP TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKMITIMP(
  "mitigation_id"  integer NOT NULL,
  "scoretype_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "threshold_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_riskmitimp PRIMARY KEY (mitigation_id,scoretype_id)  )

go

print 'Creating table RISKMITX'

--METADATA NAME:RISKMITX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKMITX(
  "mitigation_id"  integer NOT NULL,
  "score"  integer NULL,
  "scoretext"  nvarchar(40) NULL,
  "scorecolor"  nvarchar(8) NULL,
  "physicalstartdate"  datetime NULL,
  "physicalfinishdate"  datetime NULL,
  "physicalbasestartdate"  datetime NULL,
  "physicalbasefinishdate"  datetime NULL,
  "remainingcost"  numeric(23,6) NULL,
  "actualcost"  numeric(23,6) NULL,
  "plannedcost"  numeric(23,6) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_riskresponseactionx PRIMARY KEY (mitigation_id)  )

go

print 'Creating table RISKMTXSCR'

--METADATA NAME:RISKMTXSCR TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKMTXSCR(
  "score_id"  integer NOT NULL,
  "matrix_id"  integer NOT NULL,
  "probability_threshold_level"  integer NOT NULL,
  "severity1"  integer NULL,
  "severity1label"  nvarchar(40) NULL,
  "severity2"  integer NULL,
  "severity2label"  nvarchar(40) NULL,
  "severity3"  integer NULL,
  "severity3label"  nvarchar(40) NULL,
  "severity4"  integer NULL,
  "severity4label"  nvarchar(40) NULL,
  "severity5"  integer NULL,
  "severity5label"  nvarchar(40) NULL,
  "severity6"  integer NULL,
  "severity6label"  nvarchar(40) NULL,
  "severity7"  integer NULL,
  "severity7label"  nvarchar(40) NULL,
  "severity8"  integer NULL,
  "severity8label"  nvarchar(40) NULL,
  "severity9"  integer NULL,
  "severity9label"  nvarchar(40) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_riskmtxscr PRIMARY KEY (score_id)  )

go

print 'Creating table RISKRSPPLN'

--METADATA NAME:RISKRSPPLN TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKRSPPLN(
  "response_id"  integer NOT NULL,
  "id"  nvarchar(40) NOT NULL,
  "risk_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "name"  nvarchar(200) NOT NULL,
  "used"  char(1) NOT NULL,
  "type"  nvarchar(10) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_riskrsppln PRIMARY KEY (response_id)  )

go

print 'Creating table RISKRSPPLNX'

--METADATA NAME:RISKRSPPLNX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKRSPPLNX(
  "response_id"  integer NOT NULL,
  "actualcost"  numeric(23,6) NULL,
  "remainingcost"  numeric(23,6) NULL,
  "plannedcost"  numeric(23,6) NULL,
  "startdate"  datetime NULL,
  "finishdate"  datetime NULL,
  "plannedstartdate"  datetime NULL,
  "plannedfinishdate"  datetime NULL,
  "score"  integer NULL,
  "scoretext"  nvarchar(40) NULL,
  "scorecolor"  nvarchar(8) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_riskresponseplanx PRIMARY KEY (response_id)  )

go

print 'Creating table RISKSCRMTX'

--METADATA NAME:RISKSCRMTX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKSCRMTX(
  "matrix_id"  integer NOT NULL,
  "name"  nvarchar(40) NOT NULL,
  "description"  nvarchar(4000) NULL,
  "method"  nvarchar(10) NOT NULL,
  "impact_levels"  integer NOT NULL,
  "probability_levels"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_riskscrmtx PRIMARY KEY (matrix_id)  )

go

print 'Creating table RISKSCRTHR'

--METADATA NAME:RISKSCRTHR TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKSCRTHR(
  "threshold_id"  integer NOT NULL,
  "scoretype_id"  integer NOT NULL,
  "short_name"  nvarchar(10) NOT NULL,
  "full_name"  nvarchar(40) NOT NULL,
  "color"  char(6) NOT NULL,
  "lvl"  integer NOT NULL,
  "value"  nvarchar(100) NULL,
  "probability_value"  numeric(10,6) NULL,
  "tolerance_value"  integer NULL,
  "schedule_value"  numeric(17,6) NULL,
  "cost_value"  numeric(23,6) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_riskscrthr PRIMARY KEY (threshold_id)  )

go

print 'Creating table RISKSCRTYP'

--METADATA NAME:RISKSCRTYP TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKSCRTYP(
  "scoretype_id"  integer NOT NULL,
  "name"  nvarchar(40) NOT NULL,
  "type"  nvarchar(10) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_riskscrtyp PRIMARY KEY (scoretype_id)  )

go

print 'Creating table RISKX'

--METADATA NAME:RISKX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKX(
  "risk_id"  integer NOT NULL,
  "score"  integer NULL,
  "scoretext"  nvarchar(40) NULL,
  "scorecolor"  nvarchar(8) NULL,
  "exposure"  DECIMAL(28,10) NULL,
  "identifiedbyresourceid"  nvarchar(255) NULL,
  "identifiedbyresourcename"  nvarchar(255) NULL,
  "exposurestartdate"  datetime NULL,
  "exposurefinishdate"  datetime NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_riskx PRIMARY KEY (risk_id)  )

go

print 'Creating table RLFOLIOX'

--METADATA NAME:RLFOLIOX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RLFOLIOX(
  "rlfolio_id"  integer NOT NULL,
  "username"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_roleteamx PRIMARY KEY (rlfolio_id)  )

go

print 'Creating table ROLECATVALX'

--METADATA NAME:ROLECATVALX TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLECATVALX(
  "role_catg_id"  integer NOT NULL,
  "codetypename"  nvarchar(255) NULL,
  "issecurecode"  nvarchar(1) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_rolecodex PRIMARY KEY (role_catg_id)  )

go

print 'Creating table ROLECODEHIERARCHY'

--METADATA NAME:ROLECODEHIERARCHY TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLECODEHIERARCHY(
  "codetypeobjectid"  integer NOT NULL,
  "codetypename"  nvarchar(60) NOT NULL,
  "codetypesequencenumber"  integer NOT NULL,
  "codetypeissecure"  nvarchar(1) NOT NULL,
  "parentcodevalueobjectid"  integer NULL,
  "parentcodevaluename"  nvarchar(100) NULL,
  "parentcodevalueshortname"  nvarchar(60) NULL,
  "parentcodevaluesequencenumber"  integer NULL,
  "childcodevalueobjectid"  integer NULL,
  "childcodevaluename"  nvarchar(100) NULL,
  "childcodevalueshortname"  nvarchar(60) NULL,
  "childcodevaluesequencenumber"  integer NULL,
  "parentlevelsbelowroot"  integer NOT NULL,
  "childlevelsbelowroot"  integer NOT NULL,
  "levelsbetween"  integer NOT NULL,
  "childhaschildren"  nvarchar(1) NULL,
  "fullpathname"  nvarchar(4000) NULL
  )

go

print 'Creating table ROLERATEX'

--METADATA NAME:ROLERATEX TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLERATEX(
  "role_rate_id"  integer NOT NULL,
  "roleid"  nvarchar(255) NULL,
  "rolename"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_roleratex PRIMARY KEY (role_rate_id)  )

go

print 'Creating table ROLERCATX'

--METADATA NAME:ROLERCATX TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLERCATX(
  "role_id"  integer NOT NULL,
  "role_catg_type_id"  integer NOT NULL,
  "rolecodedescription"  nvarchar(255) NULL,
  "rolecodetypename"  nvarchar(255) NULL,
  "rolecodevalue"  nvarchar(255) NULL,
  "roleid"  nvarchar(255) NULL,
  "rolename"  nvarchar(255) NULL,
  "issecurecode"  nvarchar(1) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_rolecodeassignmentx PRIMARY KEY (role_id,role_catg_type_id)  )

go

print 'Creating table RSRCCURVX'

--METADATA NAME:RSRCCURVX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCCURVX(
  "curv_id"  integer NOT NULL,
  "value0"  DECIMAL(28,10) NULL,
  "value5"  DECIMAL(28,10) NULL,
  "value10"  DECIMAL(28,10) NULL,
  "value15"  DECIMAL(28,10) NULL,
  "value20"  DECIMAL(28,10) NULL,
  "value25"  DECIMAL(28,10) NULL,
  "value30"  DECIMAL(28,10) NULL,
  "value35"  DECIMAL(28,10) NULL,
  "value40"  DECIMAL(28,10) NULL,
  "value45"  DECIMAL(28,10) NULL,
  "value50"  DECIMAL(28,10) NULL,
  "value55"  DECIMAL(28,10) NULL,
  "value60"  DECIMAL(28,10) NULL,
  "value65"  DECIMAL(28,10) NULL,
  "value70"  DECIMAL(28,10) NULL,
  "value75"  DECIMAL(28,10) NULL,
  "value80"  DECIMAL(28,10) NULL,
  "value85"  DECIMAL(28,10) NULL,
  "value90"  DECIMAL(28,10) NULL,
  "value95"  DECIMAL(28,10) NULL,
  "value100"  DECIMAL(28,10) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_resourcecurvex PRIMARY KEY (curv_id)  )

go

print 'Creating table RSRCHOURX'

--METADATA NAME:RSRCHOURX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCHOURX(
  "rsrc_hr_id"  integer NOT NULL,
  "projectid"  nvarchar(255) NULL,
  "projectname"  nvarchar(255) NULL,
  "resourceid"  nvarchar(255) NULL,
  "resourcename"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_resourcehourx PRIMARY KEY (rsrc_hr_id)  )

go

print 'Creating table RSRCLOC'

--METADATA NAME:RSRCLOC TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCLOC(
  "rsrc_loc_id"  integer NOT NULL,
  "rsrc_id"  integer NOT NULL,
  "longitude"  DECIMAL(28,10) NULL,
  "latitude"  DECIMAL(28,10) NULL,
  "geo_location"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_rsrcloc PRIMARY KEY (rsrc_loc_id)  )

go

print 'Creating table RSRCOVERALLOC'

--METADATA NAME:RSRCOVERALLOC TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCOVERALLOC(
  "rsrc_id"  integer NULL,
  "role_id"  integer NULL,
  "overalloc_date"  datetime NULL
  )

go

print 'Creating table RSRCRATEX'

--METADATA NAME:RSRCRATEX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCRATEX(
  "rsrc_rate_id"  integer NOT NULL,
  "resourceid"  nvarchar(255) NULL,
  "resourcename"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_resourceratex PRIMARY KEY (rsrc_rate_id)  )

go

print 'Creating table RSRCRCATX'

--METADATA NAME:RSRCRCATX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCRCATX(
  "rsrc_id"  integer NOT NULL,
  "rsrc_catg_type_id"  integer NOT NULL,
  "resourcecodedescription"  nvarchar(255) NULL,
  "resourcecodetypename"  nvarchar(255) NULL,
  "resourcecodevalue"  nvarchar(255) NULL,
  "resourceid"  nvarchar(255) NULL,
  "resourcename"  nvarchar(255) NULL,
  "issecurecode"  nvarchar(1) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_resourcecodeassignmentx PRIMARY KEY (rsrc_id,rsrc_catg_type_id)  )

go

print 'Creating table RSRCROLEASGNMENTSPREAD'

--METADATA NAME:RSRCROLEASGNMENTSPREAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCROLEASGNMENTSPREAD(
  "id"  integer NULL,
  "proj_id"  integer NULL,
  "rsrc_id"  integer NULL,
  "role_id"  integer NULL,
  "spread_start_date"  datetime NULL,
  "spread_end_date"  datetime NULL,
  "plan_start_date"  datetime NULL,
  "plan_end_date"  datetime NULL,
  "act_start_date"  datetime NULL,
  "act_end_date"  datetime NULL,
  "rem_start_date"  datetime NULL,
  "rem_end_date"  datetime NULL,
  "plan_qty"  numeric(22,6) NULL,
  "staffed_act_qty"  numeric(22,6) NULL,
  "unstaffed_act_qty"  numeric(22,6) NULL,
  "act_this_per_qty"  numeric(22,6) NULL,
  "staffed_remain_qty"  numeric(22,6) NULL,
  "unstaffed_remain_qty"  numeric(22,6) NULL,
  "staffed_total_qty"  numeric(22,6) NULL,
  "unstaffed_total_qty"  numeric(22,6) NULL,
  "total_period_qty"  numeric(22,6) NULL,
  "plan_cost"  numeric(25,6) NULL,
  "staffed_act_cost"  numeric(25,6) NULL,
  "unstaffed_act_cost"  numeric(25,6) NULL,
  "act_this_period_cost"  numeric(25,6) NULL,
  "staffed_remain_cost"  numeric(25,6) NULL,
  "unstaffed_remain_cost"  numeric(25,6) NULL,
  "staffed_total_cost"  numeric(25,6) NULL,
  "unstaffed_total_cost"  numeric(25,6) NULL,
  "total_period_cost"  numeric(25,6) NULL,
  "rolledup_record"  nvarchar(1) DEFAULT 'N' NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL,
  "overalloc_date"  datetime NULL
  )

go

print 'Creating table RSRCROLEX'

--METADATA NAME:RSRCROLEX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCROLEX(
  "rsrc_id"  integer NOT NULL,
  "role_id"  integer NOT NULL,
  "proficiency"  nvarchar(24) NULL,
  "resourceid"  nvarchar(255) NULL,
  "resourcename"  nvarchar(255) NULL,
  "roleid"  nvarchar(255) NULL,
  "rolename"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_resourcerolex PRIMARY KEY (rsrc_id,role_id)  )

go

print 'Creating table RSRCSECX'

--METADATA NAME:RSRCSECX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCSECX(
  "user_id"  integer NOT NULL,
  "rsrc_id"  integer NOT NULL,
  "resourceid"  nvarchar(255) NULL,
  "resourcename"  nvarchar(255) NULL,
  "username"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_resourceaccessx PRIMARY KEY (user_id,rsrc_id)  )

go

print 'Creating table RSRCX'

--METADATA NAME:RSRCX TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCX(
  "rsrc_id"  integer NOT NULL,
  "calendarname"  nvarchar(255) NULL,
  "currencyid"  nvarchar(255) NULL,
  "currencyname"  nvarchar(255) NULL,
  "primaryroleid"  nvarchar(255) NULL,
  "primaryrolename"  nvarchar(255) NULL,
  "timesheetapprovalmanager"  nvarchar(255) NULL,
  "username"  nvarchar(255) NULL,
  "locationname"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_resourcesx PRIMARY KEY (rsrc_id)  )

go

print 'Creating table SAFETYDATE'

--METADATA NAME:SAFETYDATE TYPE:TABLE CHANGE:CREATE

CREATE TABLE SAFETYDATE(
  "setting_name"  nvarchar(30) NOT NULL,
  "setting_value"  datetime NULL
,CONSTRAINT pk_setting_name PRIMARY KEY (setting_name)  )

go

print 'Creating table SNAPGROUP'

--METADATA NAME:SNAPGROUP TYPE:TABLE CHANGE:CREATE

CREATE TABLE SNAPGROUP(
  "snap_group_id"  integer NOT NULL,
  "snap_group_name"  nvarchar(60) NOT NULL,
  "snap_group_desc"  nvarchar(255) NOT NULL,
  "snap_interval"  nvarchar(20) DEFAULT 'SG_Weekly' NOT NULL,
  "update_date"  datetime DEFAULT getDate() NULL,
  "update_user"  nvarchar(255) DEFAULT 'SYSTEM' NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "create_user"  nvarchar(255) DEFAULT 'SYSTEM' NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_snapgroup PRIMARY KEY (snap_group_id)  )

go

print 'Creating table SNAPPROJ'

--METADATA NAME:SNAPPROJ TYPE:TABLE CHANGE:CREATE

CREATE TABLE SNAPPROJ(
  "snap_group_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_snapproj PRIMARY KEY (snap_group_id,proj_id)  )

go

print 'Creating table SNAPSHOT'

--METADATA NAME:SNAPSHOT TYPE:TABLE CHANGE:CREATE

CREATE TABLE SNAPSHOT(
  "snapshot_id"  integer NOT NULL,
  "snapshot_name"  nvarchar(60) NOT NULL,
  "snapshot_date"  datetime NOT NULL,
  "snap_group_id"  integer NOT NULL,
  "update_date"  datetime DEFAULT getDate() NULL,
  "update_user"  nvarchar(255) DEFAULT 'SYSTEM' NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "create_user"  nvarchar(255) DEFAULT 'SYSTEM' NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_snapshot PRIMARY KEY (snapshot_id)  )

go

print 'Creating table TASKACTVX'

--METADATA NAME:TASKACTVX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKACTVX(
  "task_id"  integer NOT NULL,
  "actv_code_type_id"  integer NOT NULL,
  "activitycodedescription"  nvarchar(255) NULL,
  "activitycodetypename"  nvarchar(255) NULL,
  "activitycodetypescope"  nvarchar(255) NULL,
  "activitycodevalue"  nvarchar(255) NULL,
  "activityid"  nvarchar(255) NULL,
  "activityname"  nvarchar(255) NULL,
  "issecurecode"  nvarchar(1) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_activitycodeassignmentx PRIMARY KEY (task_id,actv_code_type_id)  )

go

print 'Creating table TASKCBSX'

--METADATA NAME:TASKCBSX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKCBSX(
  "proj_id"  integer NOT NULL,
  "cbs_id"  integer NOT NULL,
  "target_start_date"  datetime NULL,
  "target_end_date"  datetime NULL,
  "act_start_date"  datetime NULL,
  "act_end_date"  datetime NULL,
  "remain_start_date"  datetime NULL,
  "remain_end_date"  datetime NULL,
  "total_drtn_hr_cnt"  numeric(17,6) NULL,
  "remain_drtn_hr_cnt"  numeric(17,6) NULL,
  "act_drtn_hr_cnt"  numeric(17,6) NULL,
  "total_percent_complete"  numeric(10,2) NULL
,CONSTRAINT pk_taskcbsx PRIMARY KEY (proj_id,cbs_id)  )

go

print 'Creating table TASKDOCX'

--METADATA NAME:TASKDOCX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKDOCX(
  "taskdoc_id"  integer NOT NULL,
  "activityid"  nvarchar(255) NULL,
  "activityname"  nvarchar(255) NULL,
  "documenttitle"  nvarchar(255) NULL,
  "projectid"  nvarchar(255) NULL,
  "wbscode"  nvarchar(255) NULL,
  "wbsname"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_projectdocumentx PRIMARY KEY (taskdoc_id)  )

go

print 'Creating table TASKFINX'

--METADATA NAME:TASKFINX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKFINX(
  "fin_dates_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "wbsobjectid"  integer NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_activityperiodactualx PRIMARY KEY (fin_dates_id,task_id)  )

go

print 'Creating table TASKMEMOX'

--METADATA NAME:TASKMEMOX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKMEMOX(
  "memo_id"  integer NOT NULL,
  "activityid"  nvarchar(255) NULL,
  "activityname"  nvarchar(255) NULL,
  "notebooktopicname"  nvarchar(255) NULL,
  "projectid"  nvarchar(255) NULL,
  "rawtextnote"  TEXT NULL,
  "wbsobjectid"  integer NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_activitynotex PRIMARY KEY (memo_id)  )

go

print 'Creating table TASKPREDX'

--METADATA NAME:TASKPREDX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKPREDX(
  "task_pred_id"  integer NOT NULL,
  "predecessoractivityid"  nvarchar(255) NULL,
  "predecessoractivityname"  nvarchar(255) NULL,
  "predecessorprojectid"  nvarchar(255) NULL,
  "successoractivityid"  nvarchar(255) NULL,
  "successoractivityname"  nvarchar(255) NULL,
  "successorprojectid"  nvarchar(255) NULL,
  "driving"  nvarchar(1) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_relationshipx PRIMARY KEY (task_pred_id)  )

go

print 'Creating table TASKPROCX'

--METADATA NAME:TASKPROCX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKPROCX(
  "proc_id"  integer NOT NULL,
  "activityid"  nvarchar(255) NULL,
  "activityname"  nvarchar(255) NULL,
  "projectid"  nvarchar(255) NULL,
  "wbsobjectid"  integer NULL,
  "weightpercent"  DECIMAL(28,10) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_activitystepx PRIMARY KEY (proc_id)  )

go

print 'Creating table TASKRISKX'

--METADATA NAME:TASKRISKX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKRISKX(
  "task_id"  integer NOT NULL,
  "risk_id"  integer NOT NULL,
  "projectid"  nvarchar(40) NULL,
  "projectname"  nvarchar(100) NULL,
  "activityid"  nvarchar(40) NULL,
  "activityname"  nvarchar(125) NULL,
  "riskname"  nvarchar(200) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_activityriskx PRIMARY KEY (task_id,risk_id)  )

go

print 'Creating table TASKRSRCX'

--METADATA NAME:TASKRSRCX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKRSRCX(
  "taskrsrc_id"  integer NOT NULL,
  "proficiency"  nvarchar(24) NULL,
  "remaininglag"  DECIMAL(28,10) NULL,
  "activityid"  nvarchar(255) NULL,
  "activityname"  nvarchar(255) NULL,
  "actualcost"  DECIMAL(28,10) NULL,
  "actualduration"  DECIMAL(28,10) NULL,
  "actualunits"  DECIMAL(28,10) NULL,
  "atcompletioncost"  DECIMAL(28,10) NULL,
  "atcompletionduration"  DECIMAL(28,10) NULL,
  "atcompletionunits"  DECIMAL(28,10) NULL,
  "autocomputeactuals"  nvarchar(1) NULL,
  "calendarname"  nvarchar(255) NULL,
  "calendarobjectid"  integer NULL,
  "costaccountid"  nvarchar(255) NULL,
  "costaccountname"  nvarchar(255) NULL,
  "finishdate"  datetime NULL,
  "isactive"  nvarchar(1) NULL,
  "isovertimeallowed"  nvarchar(1) NULL,
  "isprimaryresource"  nvarchar(1) NULL,
  "plannedduration"  DECIMAL(28,10) NULL,
  "priceperunit"  DECIMAL(28,10) NULL,
  "projectid"  nvarchar(255) NULL,
  "remainingduration"  DECIMAL(28,10) NULL,
  "resourcecalendarname"  nvarchar(255) NULL,
  "resourcecurvename"  nvarchar(255) NULL,
  "resourceid"  nvarchar(255) NULL,
  "resourcename"  nvarchar(255) NULL,
  "roleid"  nvarchar(255) NULL,
  "rolename"  nvarchar(255) NULL,
  "staffedremainingcost"  DECIMAL(28,10) NULL,
  "staffedremainingunits"  DECIMAL(28,10) NULL,
  "startdate"  datetime NULL,
  "unitspercentcomplete"  DECIMAL(28,10) NULL,
  "unstaffedremainingcost"  DECIMAL(28,10) NULL,
  "unstaffedremainingunits"  DECIMAL(28,10) NULL,
  "wbsobjectid"  integer NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_resourceassignmentx PRIMARY KEY (taskrsrc_id)  )

go

print 'Creating table TASKX'

--METADATA NAME:TASKX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKX(
  "task_id"  integer NOT NULL,
  "accountingvariance"  DECIMAL(28,10) NULL,
  "accountingvariancelaborunits"  DECIMAL(28,10) NULL,
  "actualduration"  DECIMAL(28,10) NULL,
  "actualexpensecost"  DECIMAL(28,10) NULL,
  "actuallaborcost"  DECIMAL(28,10) NULL,
  "actualmaterialcost"  DECIMAL(28,10) NULL,
  "actualnonlaborcost"  DECIMAL(28,10) NULL,
  "actualthisperiodlaborcost"  DECIMAL(28,10) NULL,
  "actualthisperiodmaterialcost"  DECIMAL(28,10) NULL,
  "actualthisperiodnonlaborcost"  DECIMAL(28,10) NULL,
  "actualtotalcost"  DECIMAL(28,10) NULL,
  "actualtotalunits"  DECIMAL(28,10) NULL,
  "atcompletionduration"  DECIMAL(28,10) NULL,
  "atcompletionexpensecost"  DECIMAL(28,10) NULL,
  "atcompletionlaborcost"  DECIMAL(28,10) NULL,
  "atcompletionlaborunits"  DECIMAL(28,10) NULL,
  "atcompletionlaborunitsvariance"  DECIMAL(28,10) NULL,
  "atcompletionmaterialcost"  DECIMAL(28,10) NULL,
  "atcompletionnonlaborcost"  DECIMAL(28,10) NULL,
  "atcompletionnonlaborunits"  DECIMAL(28,10) NULL,
  "atcompletiontotalcost"  DECIMAL(28,10) NULL,
  "atcompletiontotalunits"  DECIMAL(28,10) NULL,
  "atcompletionvariance"  DECIMAL(28,10) NULL,
  "baselineduration"  DECIMAL(28,10) NULL,
  "baselinefinishdate"  datetime NULL,
  "baselineplannedduration"  DECIMAL(28,10) NULL,
  "baselineplannedexpensecost"  DECIMAL(28,10) NULL,
  "baselineplannedlaborcost"  DECIMAL(28,10) NULL,
  "baselineplannedlaborunits"  DECIMAL(28,10) NULL,
  "baselineplannedmaterialcost"  DECIMAL(28,10) NULL,
  "baselineplannednonlaborcost"  DECIMAL(28,10) NULL,
  "baselineplannednonlaborunits"  DECIMAL(28,10) NULL,
  "baselineplannedtotalcost"  DECIMAL(28,10) NULL,
  "baselinestartdate"  datetime NULL,
  "baselinelatestartdate"  datetime NULL,
  "baseline1latestartdate"  datetime NULL,
  "baselinelatefinishdate"  datetime NULL,
  "baseline1latefinishdate"  datetime NULL,
  "budgetatcompletion"  DECIMAL(28,10) NULL,
  "calendarname"  nvarchar(255) NULL,
  "costpercentcomplete"  DECIMAL(28,10) NULL,
  "costpercentofplanned"  DECIMAL(28,10) NULL,
  "costperformanceindex"  DECIMAL(28,10) NULL,
  "costperformanceindexlaborunits"  DECIMAL(28,10) NULL,
  "costvariance"  DECIMAL(28,10) NULL,
  "costvarianceindex"  DECIMAL(28,10) NULL,
  "costvarianceindexlaborunits"  DECIMAL(28,10) NULL,
  "costvariancelaborunits"  DECIMAL(28,10) NULL,
  "datadate"  datetime NULL,
  "duration1variance"  DECIMAL(28,10) NULL,
  "durationpercentcomplete"  DECIMAL(28,10) NULL,
  "durationpercentofplanned"  DECIMAL(28,10) NULL,
  "durationvariance"  DECIMAL(28,10) NULL,
  "earnedvaluecost"  DECIMAL(28,10) NULL,
  "earnedvaluelaborunits"  DECIMAL(28,10) NULL,
  "estimateatcompletioncost"  DECIMAL(28,10) NULL,
  "estimateatcompletionlaborunits"  DECIMAL(28,10) NULL,
  "estimatetocomplete"  DECIMAL(28,10) NULL,
  "estimatetocompletelaborunits"  DECIMAL(28,10) NULL,
  "expensecost1variance"  DECIMAL(28,10) NULL,
  "expensecostpercentcomplete"  DECIMAL(28,10) NULL,
  "expensecostvariance"  DECIMAL(28,10) NULL,
  "finishdate"  datetime NULL,
  "finishdate1variance"  DECIMAL(28,10) NULL,
  "finishdatevariance"  DECIMAL(28,10) NULL,
  "iscritical"  nvarchar(1) NULL,
  "laborcost1variance"  DECIMAL(28,10) NULL,
  "laborcostpercentcomplete"  DECIMAL(28,10) NULL,
  "laborcostvariance"  DECIMAL(28,10) NULL,
  "laborunits1variance"  DECIMAL(28,10) NULL,
  "laborunitspercentcomplete"  DECIMAL(28,10) NULL,
  "laborunitsvariance"  DECIMAL(28,10) NULL,
  "materialcost1variance"  DECIMAL(28,10) NULL,
  "materialcostpercentcomplete"  DECIMAL(28,10) NULL,
  "materialcostvariance"  DECIMAL(28,10) NULL,
  "nonlaborcost1variance"  DECIMAL(28,10) NULL,
  "nonlaborcostpercentcomplete"  DECIMAL(28,10) NULL,
  "nonlaborcostvariance"  DECIMAL(28,10) NULL,
  "nonlaborunits1variance"  DECIMAL(28,10) NULL,
  "nonlaborunitspercentcomplete"  DECIMAL(28,10) NULL,
  "nonlaborunitsvariance"  DECIMAL(28,10) NULL,
  "percentcomplete"  DECIMAL(28,10) NULL,
  "performancepercentcomplete"  DECIMAL(28,10) NULL,
  "physicalpercentcomplete"  DECIMAL(28,10) NULL,
  "plannedexpensecost"  DECIMAL(28,10) NULL,
  "plannedlaborcost"  DECIMAL(28,10) NULL,
  "plannedmaterialcost"  DECIMAL(28,10) NULL,
  "plannednonlaborcost"  DECIMAL(28,10) NULL,
  "plannedtotalcost"  DECIMAL(28,10) NULL,
  "plannedtotalunits"  DECIMAL(28,10) NULL,
  "plannedvaluecost"  DECIMAL(28,10) NULL,
  "plannedvaluelaborunits"  DECIMAL(28,10) NULL,
  "primaryresourceid"  nvarchar(255) NULL,
  "primaryresourcename"  nvarchar(255) NULL,
  "remainingexpensecost"  DECIMAL(28,10) NULL,
  "remainingfloat"  DECIMAL(28,10) NULL,
  "remaininglaborcost"  DECIMAL(28,10) NULL,
  "remainingmaterialcost"  DECIMAL(28,10) NULL,
  "remainingnonlaborcost"  DECIMAL(28,10) NULL,
  "remainingtotalcost"  DECIMAL(28,10) NULL,
  "remainingtotalunits"  DECIMAL(28,10) NULL,
  "schedulepercentcomplete"  DECIMAL(28,10) NULL,
  "scheduleperfindexlaborunits"  DECIMAL(28,10) NULL,
  "scheduleperformanceindex"  DECIMAL(28,10) NULL,
  "schedulevariance"  DECIMAL(28,10) NULL,
  "schedulevarianceindex"  DECIMAL(28,10) NULL,
  "schedulevariancelaborunits"  DECIMAL(28,10) NULL,
  "schedulevarindexlaborunits"  DECIMAL(28,10) NULL,
  "startdate"  datetime NULL,
  "startdate1variance"  DECIMAL(28,10) NULL,
  "startdatevariance"  DECIMAL(28,10) NULL,
  "tocompleteperformanceindex"  DECIMAL(28,10) NULL,
  "totalcost1variance"  DECIMAL(28,10) NULL,
  "totalcostvariance"  DECIMAL(28,10) NULL,
  "unitspercentcomplete"  DECIMAL(28,10) NULL,
  "wbscode"  nvarchar(255) NULL,
  "wbsname"  nvarchar(255) NULL,
  "activityownerobjectid"  integer NULL,
  "activityowner"  nvarchar(255) NULL,
  "actualprogressdate"  datetime NULL,
  "locationname"  nvarchar(255) NULL,
  "cbscode"  nvarchar(120) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_activityx PRIMARY KEY (task_id)  )

go

print 'Creating table TIMESHTX'

--METADATA NAME:TIMESHTX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TIMESHTX(
  "ts_id"  integer NOT NULL,
  "rsrc_id"  integer NOT NULL,
  "resourceid"  nvarchar(255) NULL,
  "resourcename"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_timesheetx PRIMARY KEY (ts_id,rsrc_id)  )

go

print 'Creating table TRACKOFFLINEUSER'

--METADATA NAME:TRACKOFFLINEUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE TRACKOFFLINEUSER(
  "trackofflineuser_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "status"  nvarchar(20) NULL,
  "offline_date"  datetime NOT NULL,
  "last_online_date"  datetime NULL,
  "hard_drive_code"  nvarchar(40) NOT NULL,
  "offline_data"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_trackofflineuser PRIMARY KEY (trackofflineuser_id)  )

go

print 'Creating table TRSRCFINX'

--METADATA NAME:TRSRCFINX TYPE:TABLE CHANGE:CREATE

CREATE TABLE TRSRCFINX(
  "fin_dates_id"  integer NOT NULL,
  "taskrsrc_id"  integer NOT NULL,
  "resourcetype"  nvarchar(24) NULL,
  "wbsobjectid"  integer NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_resassignmentperiodactualx PRIMARY KEY (fin_dates_id,taskrsrc_id)  )

go

print 'Creating table TSAPPROVERS'

--METADATA NAME:TSAPPROVERS TYPE:TABLE CHANGE:CREATE

CREATE TABLE TSAPPROVERS(
  "ts_id"  integer NOT NULL,
  "rsrc_id"  integer NOT NULL,
  "status_code"  nvarchar(20) NOT NULL,
  "user_id"  integer NOT NULL
,CONSTRAINT pk_tsapprovers PRIMARY KEY (ts_id,rsrc_id,user_id)  )

go

print 'Creating table UDFCODEX'

--METADATA NAME:UDFCODEX TYPE:TABLE CHANGE:CREATE

CREATE TABLE UDFCODEX(
  "udf_code_id"  integer NOT NULL,
  "codetypetitle"  nvarchar(255) NULL,
  "issecurecode"  nvarchar(1) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_udfcodex PRIMARY KEY (udf_code_id)  )

go

print 'Creating table UDFVALUEX'

--METADATA NAME:UDFVALUEX TYPE:TABLE CHANGE:CREATE

CREATE TABLE UDFVALUEX(
  "udf_type_id"  integer NOT NULL,
  "fk_id"  integer NOT NULL,
  "subjectarea"  nvarchar(48) NULL,
  "datatype"  nvarchar(24) NULL,
  "issecurecode"  nvarchar(1) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_udfvaluex PRIMARY KEY (udf_type_id,fk_id)  )

go

print 'Creating table USEROBSX'

--METADATA NAME:USEROBSX TYPE:TABLE CHANGE:CREATE

CREATE TABLE USEROBSX(
  "user_id"  integer NOT NULL,
  "obs_id"  integer NOT NULL,
  "obsname"  nvarchar(255) NULL,
  "profilename"  nvarchar(255) NULL,
  "username"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_userobsx PRIMARY KEY (user_id,obs_id)  )

go

print 'Creating table USERSX'

--METADATA NAME:USERSX TYPE:TABLE CHANGE:CREATE

CREATE TABLE USERSX(
  "user_id"  integer NOT NULL,
  "respectactivitydurationtype"  nvarchar(255) NULL,
  "assignmentstaffingpreference"  nvarchar(33) NULL,
  "currencyid"  nvarchar(255) NULL,
  "currencyname"  nvarchar(255) NULL,
  "financialperiodendobjectid"  integer NULL,
  "financialperiodstartobjectid"  integer NULL,
  "newprojectdurationtype"  nvarchar(33) NULL,
  "ratesourcepreference"  nvarchar(33) NULL,
  "lastprojectsecuritydate"  datetime NULL,
  "lastresourcesecuritydate"  datetime NULL,
  "lastglobalsecuritydate"  datetime NULL,
  "issuperuser"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_usersx PRIMARY KEY (user_id)  )

go

print 'Creating table WBSBUDGX'

--METADATA NAME:WBSBUDGX TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSBUDGX(
  "wbs_budg_id"  integer NOT NULL,
  "epsid"  nvarchar(255) NULL,
  "epsname"  nvarchar(255) NULL,
  "epsobjectid"  integer NULL,
  "projectid"  nvarchar(255) NULL,
  "wbscode"  nvarchar(255) NULL,
  "wbsname"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_projectspendingplanx PRIMARY KEY (wbs_budg_id)  )

go

print 'Creating table WBSHIERARCHY'

--METADATA NAME:WBSHIERARCHY TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSHIERARCHY(
  "parentobjectid"  integer NULL,
  "parentprojectid"  integer NULL,
  "parentsequencenumber"  integer NULL,
  "parentname"  nvarchar(100) NULL,
  "parentid"  nvarchar(40) NULL,
  "childobjectid"  integer NULL,
  "childprojectid"  integer NULL,
  "childsequencenumber"  integer NULL,
  "childname"  nvarchar(100) NULL,
  "childid"  nvarchar(40) NULL,
  "parentlevelsbelowroot"  integer NOT NULL,
  "childlevelsbelowroot"  integer NOT NULL,
  "levelsbetween"  integer NOT NULL,
  "childhaschildren"  nvarchar(1) NULL,
  "fullpathname"  nvarchar(4000) NULL,
  "update_date"  datetime DEFAULT getDate() NOT NULL
  )

go

print 'Creating table WBSMEMOX'

--METADATA NAME:WBSMEMOX TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSMEMOX(
  "wbs_memo_id"  integer NOT NULL,
  "epsid"  nvarchar(255) NULL,
  "epsname"  nvarchar(255) NULL,
  "epsobjectid"  integer NULL,
  "notebooktopicname"  nvarchar(255) NULL,
  "projectid"  nvarchar(255) NULL,
  "rawtextnote"  TEXT NULL,
  "wbscode"  nvarchar(255) NULL,
  "wbsname"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_projectnotex PRIMARY KEY (wbs_memo_id)  )

go

print 'Creating table WBSREVIEWERS'

--METADATA NAME:WBSREVIEWERS TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSREVIEWERS(
  "wbsreviewers_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "status_reviewer"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_wbsreviewers PRIMARY KEY (wbsreviewers_id)  )

go

print 'Creating table WBSREVIEWSTATUS'

--METADATA NAME:WBSREVIEWSTATUS TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSREVIEWSTATUS(
  "wbsreviewstatus_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "status_reviewer"  integer NOT NULL,
  "fk_id"  integer NOT NULL,
  "table_name"  nvarchar(30) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
,CONSTRAINT pk_wbsreviewstatus PRIMARY KEY (wbsreviewstatus_id)  )

go

print 'Creating table WBSRSRCX'

--METADATA NAME:WBSRSRCX TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSRSRCX(
  "wbsrsrc_id"  integer NOT NULL,
  "projectid"  nvarchar(255) NULL,
  "resourcename"  nvarchar(255) NULL,
  "rolename"  nvarchar(255) NULL,
  "status"  nvarchar(24) NULL,
  "wbscode"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_projectresourcex PRIMARY KEY (wbsrsrc_id)  )

go

print 'Creating table WBSRSRC_QTYX'

--METADATA NAME:WBSRSRC_QTYX TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSRSRC_QTYX(
  "wbsrsrc_id"  integer NOT NULL,
  "week_start"  datetime NOT NULL,
  "month_start"  datetime NOT NULL,
  "committedflag"  nvarchar(1) NULL,
  "projectobjectid"  integer NULL,
  "resourceobjectid"  integer NULL,
  "wbsobjectid"  integer NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_projectresourcequantityx PRIMARY KEY (wbsrsrc_id,week_start,month_start)  )

go

print 'Creating table WBSSPREAD'

--METADATA NAME:WBSSPREAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSSPREAD(
  "objectid"  integer NULL,
  "parentobjectid"  integer NULL,
  "code"  nvarchar(40) NULL,
  "name"  nvarchar(100) NULL,
  "projectobjectid"  integer NULL,
  "obsobjectid"  integer NULL,
  "obsname"  nvarchar(100) NULL,
  "startdate"  datetime NULL,
  "enddate"  datetime NULL,
  "actuallaborunits"  numeric(23,6) NULL,
  "actualnonlaborunits"  numeric(23,6) NULL,
  "atcompletionlaborunits"  numeric(23,6) NULL,
  "atcompletionnonlaborunits"  numeric(23,6) NULL,
  "baselineplannedlaborunits"  numeric(23,6) NULL,
  "baselineplannednonlaborunits"  numeric(23,6) NULL,
  "earnedvaluelaborunits"  numeric(23,6) NULL,
  "estimateatcompletionlaborunits"  numeric(23,6) NULL,
  "estimatetocompletelaborunits"  numeric(23,6) NULL,
  "plannedlaborunits"  numeric(23,6) NULL,
  "plannednonlaborunits"  numeric(23,6) NULL,
  "plannedvaluelaborunits"  numeric(23,6) NULL,
  "remaininglaborunits"  numeric(23,6) NULL,
  "remainingnonlaborunits"  numeric(23,6) NULL,
  "actualcost"  numeric(23,6) NULL,
  "actualexpensecost"  numeric(23,6) NULL,
  "actuallaborcost"  numeric(23,6) NULL,
  "actualmaterialcost"  numeric(23,6) NULL,
  "actualnonlaborcost"  numeric(23,6) NULL,
  "actualtotalcost"  numeric(23,6) NULL,
  "atcompletionexpensecost"  numeric(23,6) NULL,
  "atcompletionlaborcost"  numeric(23,6) NULL,
  "atcompletionmaterialcost"  numeric(23,6) NULL,
  "atcompletionnonlaborcost"  numeric(23,6) NULL,
  "atcompletiontotalcost"  numeric(23,6) NULL,
  "baselineplannedexpensecost"  numeric(23,6) NULL,
  "baselineplannedlaborcost"  numeric(23,6) NULL,
  "baselineplannedmaterialcost"  numeric(23,6) NULL,
  "baselineplannednonlaborcost"  numeric(23,6) NULL,
  "baselineplannedtotalcost"  numeric(23,6) NULL,
  "earnedvaluecost"  numeric(23,6) NULL,
  "estimateatcompletioncost"  numeric(23,6) NULL,
  "estimatetocompletecost"  numeric(23,6) NULL,
  "plannedexpensecost"  numeric(23,6) NULL,
  "plannedlaborcost"  numeric(23,6) NULL,
  "plannedmaterialcost"  numeric(23,6) NULL,
  "plannednonlaborcost"  numeric(23,6) NULL,
  "plannedtotalcost"  numeric(23,6) NULL,
  "plannedvaluecost"  numeric(23,6) NULL,
  "remainingexpensecost"  numeric(23,6) NULL,
  "remaininglaborcost"  numeric(23,6) NULL,
  "remainingmaterialcost"  numeric(23,6) NULL,
  "remainingnonlaborcost"  numeric(23,6) NULL,
  "remainingtotalcost"  numeric(23,6) NULL
  )

go

print 'Creating table WBSSTEPX'

--METADATA NAME:WBSSTEPX TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSSTEPX(
  "wbs_step_id"  integer NOT NULL,
  "projectid"  nvarchar(255) NULL,
  "wbscode"  nvarchar(255) NULL,
  "wbsname"  nvarchar(255) NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "update_date"  datetime DEFAULT getDate() NULL
,CONSTRAINT pk_wbsmilestonex PRIMARY KEY (wbs_step_id)  )

go

print 'Creating table WRK_LOG_RESULTS'

--METADATA NAME:WRK_LOG_RESULTS TYPE:TABLE CHANGE:CREATE

CREATE TABLE WRK_LOG_RESULTS(
  "spid"  integer NULL,
  "seq_num"  integer NULL,
  "log_message"  nvarchar(4000) NULL
  )

go
	 
--METADATA NAME:is_rejected TYPE:FIELD TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION 
  add   "is_rejected"  nvarchar(1) NULL
go
	 
--METADATA NAME:rej_dis_data TYPE:FIELD TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION 
  add   "rej_dis_data"  TEXT NULL
go
	 
--METADATA NAME:assignment_id TYPE:FIELD TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION 
  add   "assignment_id"  integer NULL
go
	 
--METADATA NAME:proj_id TYPE:FIELD TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION 
  add   "proj_id"  integer
go

--METADATA  TYPE:ADHOC_SQL
UPDATE DISCUSSION SET DISCUSSION.PROJ_ID = TASK.PROJ_ID FROM DISCUSSION INNER JOIN TASK ON TASK.TASK_ID = DISCUSSION.TASK_ID
go
--METADATA  TYPE:ADHOC_SQL
ALTER TABLE DISCUSSION ALTER COLUMN PROJ_ID INTEGER NOT NULL
go
	 
--METADATA NAME:delete_user TYPE:FIELD TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION 
  add   "delete_user"  nvarchar(255) NULL
go
	 
--METADATA NAME:job_type_key TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:CREATE
ALTER TABLE JOBSVC 
  add   "job_type_key"  nvarchar(255) NULL
go
	 
--METADATA NAME:job_data_x TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:CREATE
ALTER TABLE JOBSVC 
  add   "job_data_x"  TEXT NULL
go
	 
--METADATA NAME:worker_host TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:CREATE
ALTER TABLE JOBSVC 
  add   "worker_host"  nvarchar(255) NULL
go
	 
--METADATA NAME:repaving_update_date TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:CREATE
ALTER TABLE JOBSVC 
  add   "repaving_update_date"  datetime NULL
go
	 
--METADATA NAME:datasource_id TYPE:FIELD TABLE_NAME:PREFER CHANGE:CREATE
ALTER TABLE PREFER 
  add   "datasource_id"  integer NULL
go
	 
--METADATA NAME:cbs_id TYPE:FIELD TABLE_NAME:PROJCOST CHANGE:CREATE
ALTER TABLE PROJCOST 
  add   "cbs_id"  integer NULL
go
	 
--METADATA NAME:rsrc_self_add_out_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   "rsrc_self_add_out_flag"  nvarchar(1) DEFAULT 'Y' with values  NOT NULL
go
	 
--METADATA NAME:px_last_update_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   "px_last_update_date"  datetime NULL
go
	 
--METADATA NAME:px_priority TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   "px_priority"  numeric(3,0) DEFAULT 50 with values  NULL
go
	 
--METADATA NAME:px_next_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   "px_next_date"  datetime NULL
go
	 
--METADATA NAME:px_enable_publication_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   "px_enable_publication_flag"  nvarchar(1) DEFAULT 'Y' with values  NOT NULL
go
	 
--METADATA NAME:last_level_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   "last_level_date"  datetime NULL
go
	 
--METADATA NAME:px_safety_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   "px_safety_date"  datetime NULL
go
	 
--METADATA NAME:schedule_type TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   "schedule_type"  nvarchar(40) NULL
go
	 
--METADATA NAME:pre_pess_start_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   "pre_pess_start_date"  datetime NULL
go
	 
--METADATA NAME:pre_pess_finish_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   "pre_pess_finish_date"  datetime NULL
go
	 
--METADATA NAME:post_pess_start_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   "post_pess_start_date"  datetime NULL
go
	 
--METADATA NAME:post_pess_finish_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   "post_pess_finish_date"  datetime NULL
go
	 
--METADATA NAME:allow_update_date_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   "allow_update_date_flag"  nvarchar(1) DEFAULT 'Y' with values  NOT NULL
go
	 
--METADATA NAME:proj_update_date TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   "proj_update_date"  datetime NULL
go
	 
--METADATA NAME:publish_spread_assign_level TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   "publish_spread_assign_level"  nvarchar(12) DEFAULT 'SL_Taskrsrc' with values  NULL
go
	 
--METADATA NAME:etl_interval TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   "etl_interval"  integer DEFAULT 24 with values  NOT NULL
go
	 
--METADATA NAME:etl_hour TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   "etl_hour"  integer DEFAULT 0 with values  NOT NULL
go
	 
--METADATA NAME:enable_prime_sync_flag TYPE:FIELD TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT 
  add   "enable_prime_sync_flag"  nvarchar(1) DEFAULT 'N' with values  NOT NULL
go
	 
--METADATA NAME:wbs_id TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK 
  add   "wbs_id"  integer
	NULL
    
go
	 
--METADATA NAME:priority_type TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK 
  add   "priority_type"  nvarchar(12)
	NULL
    
go
	 
--METADATA NAME:obs_id TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK 
  add   "obs_id"  integer NULL
go
	 
--METADATA NAME:prbly_pct TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK 
  add   "prbly_pct"  integer NULL
go
	 
--METADATA NAME:impact_work_qty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK 
  add   "impact_work_qty"  numeric(17,6) NULL
go
	 
--METADATA NAME:impact_equip_qty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK 
  add   "impact_equip_qty"  numeric(17,6) NULL
go
	 
--METADATA NAME:impact_expense_cost TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK 
  add   "impact_expense_cost"  numeric(23,6) NULL
go
	 
--METADATA NAME:impact_date TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK 
  add   "impact_date"  datetime NULL
go
	 
--METADATA NAME:impact_mat_qty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:CREATE
ALTER TABLE PROJRISK 
  add   "impact_mat_qty"  numeric(17,6) NULL
go
	 
--METADATA NAME:intg_wbs TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS 
  add   "intg_wbs"  nvarchar(1) DEFAULT 'N' with values  NOT NULL
go
	 
--METADATA NAME:workpackage_flag TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS 
  add   "workpackage_flag"  nvarchar(1) DEFAULT 'N' with values  NULL
go
	 
--METADATA NAME:review_type TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:CREATE
ALTER TABLE PROJWBS 
  add   "review_type"  nvarchar(255) NULL
go
	 
--METADATA NAME:last_sum_date TYPE:FIELD TABLE_NAME:ROLES CHANGE:CREATE
ALTER TABLE ROLES 
  add   "last_sum_date"  datetime NULL
go
	 
--METADATA NAME:last_sum_date TYPE:FIELD TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC 
  add   "last_sum_date"  datetime NULL
go
	 
--METADATA NAME:seq_num TYPE:FIELD TABLE_NAME:RSRCSEC CHANGE:CREATE
ALTER TABLE RSRCSEC 
  add   "seq_num"  integer DEFAULT 10 with values  NOT NULL
go
	 
--METADATA NAME:setting_id TYPE:FIELD TABLE_NAME:SETTINGS CHANGE:CREATE
ALTER TABLE SETTINGS 
  add   "setting_id"  integer NULL
go
	 
--METADATA NAME:audit_ext_old TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:CREATE
ALTER TABLE SPIDMAP 
  add   "audit_ext_old"  TEXT NULL
go
	 
--METADATA NAME:audit_ext_new TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:CREATE
ALTER TABLE SPIDMAP 
  add   "audit_ext_new"  TEXT NULL
go
	 
--METADATA NAME:starred_flag TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   "starred_flag"  nvarchar(1) DEFAULT 'N' with values  NOT NULL
go
	 
--METADATA NAME:cbs_code TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   "cbs_code"  nvarchar(1024) NULL
go
	 
--METADATA NAME:cbs_id TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   "cbs_id"  integer NULL
go
	 
--METADATA NAME:act_min_drtn TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   "act_min_drtn"  numeric(17,6) NULL
go
	 
--METADATA NAME:act_prob_drtn TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   "act_prob_drtn"  numeric(17,6) NULL
go
	 
--METADATA NAME:act_max_drtn TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   "act_max_drtn"  numeric(17,6) NULL
go
	 
--METADATA NAME:pre_pess_start_date TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   "pre_pess_start_date"  datetime NULL
go
	 
--METADATA NAME:pre_pess_finish_date TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   "pre_pess_finish_date"  datetime NULL
go
	 
--METADATA NAME:post_pess_start_date TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   "post_pess_start_date"  datetime NULL
go
	 
--METADATA NAME:post_pess_finish_date TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   "post_pess_finish_date"  datetime NULL
go
	 
--METADATA NAME:task_status_ind TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   "task_status_ind"  nvarchar(1) NULL
go
	 
--METADATA NAME:task_status_dts TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   "task_status_dts"  nvarchar(255) NULL
go
	 
--METADATA NAME:task_status_cmpl TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   "task_status_cmpl"  nvarchar(255) NULL
go
	 
--METADATA NAME:scp_pct_complete TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   "scp_pct_complete"  numeric(10,2) DEFAULT 0 with values  NOT NULL
go
	 
--METADATA NAME:wrk_pkg_id TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   "wrk_pkg_id"  nvarchar(60) NULL
go
	 
--METADATA NAME:wrk_pkg_name TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   "wrk_pkg_name"  nvarchar(255) NULL
go
	 
--METADATA NAME:pre_criticality_index TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   "pre_criticality_index"  numeric(10,2) NULL
go
	 
--METADATA NAME:post_criticality_index TYPE:FIELD TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK 
  add   "post_criticality_index"  numeric(10,2) NULL
go
	 
--METADATA NAME:starred_flag TYPE:FIELD TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC 
  add   "starred_flag"  nvarchar(1) DEFAULT 'N' with values  NOT NULL
go
	 
--METADATA NAME:cbs_id TYPE:FIELD TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC 
  add   "cbs_id"  integer NULL
go
	 
--METADATA NAME:prev_cost_per_qty TYPE:FIELD TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC 
  add   "prev_cost_per_qty"  nvarchar(22) NULL
go
	 
--METADATA NAME:starred_flag TYPE:FIELD TABLE_NAME:TASKUSER CHANGE:CREATE
ALTER TABLE TASKUSER 
  add   "starred_flag"  nvarchar(1) DEFAULT 'N' with values  NOT NULL
go
	 
--METADATA NAME:systemuser TYPE:FIELD TABLE_NAME:USERS CHANGE:CREATE
ALTER TABLE USERS 
  add   "systemuser"  nvarchar(1) DEFAULT 'N' with values  NOT NULL
go
	 
--METADATA NAME:force_logout_flag TYPE:FIELD TABLE_NAME:USESSION CHANGE:CREATE
ALTER TABLE USESSION 
  add   "force_logout_flag"  nvarchar(1) DEFAULT 'N' with values  NOT NULL
go

print 'Creating constraint fk_addtaskproc_header on table ADDTASKPROC'


--METADATA NAME:fk_addtaskproc_header TYPE:CONSTRAINT TABLE_NAME:ADDTASKPROC CHANGE:CREATE
ALTER TABLE ADDTASKPROC
WITH NOCHECK
ADD CONSTRAINT fk_addtaskproc_header FOREIGN KEY (transaction_id)
REFERENCES CHGHEAD (transaction_id) 
go
 ALTER TABLE ADDTASKPROC  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_addtaskproc_task on table ADDTASKPROC'


--METADATA NAME:fk_addtaskproc_task TYPE:CONSTRAINT TABLE_NAME:ADDTASKPROC CHANGE:CREATE
ALTER TABLE ADDTASKPROC
WITH NOCHECK
ADD CONSTRAINT fk_addtaskproc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go
 ALTER TABLE ADDTASKPROC  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_addtrsrc_header on table ADDTRSRC'


--METADATA NAME:fk_addtrsrc_header TYPE:CONSTRAINT TABLE_NAME:ADDTRSRC CHANGE:CREATE
ALTER TABLE ADDTRSRC
WITH NOCHECK
ADD CONSTRAINT fk_addtrsrc_header FOREIGN KEY (transaction_id)
REFERENCES CHGHEAD (transaction_id) 
go
 ALTER TABLE ADDTRSRC  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_addtrsrc_task on table ADDTRSRC'


--METADATA NAME:fk_addtrsrc_task TYPE:CONSTRAINT TABLE_NAME:ADDTRSRC CHANGE:CREATE
ALTER TABLE ADDTRSRC
WITH NOCHECK
ADD CONSTRAINT fk_addtrsrc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go
 ALTER TABLE ADDTRSRC  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_alert_users on table ALERT'


--METADATA NAME:fk_alert_users TYPE:CONSTRAINT TABLE_NAME:ALERT CHANGE:CREATE
ALTER TABLE ALERT
WITH NOCHECK
ADD CONSTRAINT fk_alert_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go
 ALTER TABLE ALERT  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_alertparam_alert on table ALERTPARAM'


--METADATA NAME:fk_alertparam_alert TYPE:CONSTRAINT TABLE_NAME:ALERTPARAM CHANGE:CREATE
ALTER TABLE ALERTPARAM
WITH NOCHECK
ADD CONSTRAINT fk_alertparam_alert FOREIGN KEY (alert_id)
REFERENCES ALERT (alert_id) 
go
 ALTER TABLE ALERTPARAM  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_announcement_user_user_id on table ANNOUNCEMENT_USER'


--METADATA NAME:fk_announcement_user_user_id TYPE:CONSTRAINT TABLE_NAME:ANNOUNCEMENT_USER CHANGE:CREATE
ALTER TABLE ANNOUNCEMENT_USER
WITH NOCHECK
ADD CONSTRAINT fk_announcement_user_user_id FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go
 ALTER TABLE ANNOUNCEMENT_USER  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_announcement_user_ancmnt_id on table ANNOUNCEMENT_USER'


--METADATA NAME:fk_announcement_user_ancmnt_id TYPE:CONSTRAINT TABLE_NAME:ANNOUNCEMENT_USER CHANGE:CREATE
ALTER TABLE ANNOUNCEMENT_USER
WITH NOCHECK
ADD CONSTRAINT fk_announcement_user_ancmnt_id FOREIGN KEY (announcement_id)
REFERENCES ANNOUNCEMENT (announcement_id) 
go
 ALTER TABLE ANNOUNCEMENT_USER  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_cbs_project on table CBS'


--METADATA NAME:fk_cbs_project TYPE:CONSTRAINT TABLE_NAME:CBS CHANGE:CREATE
ALTER TABLE CBS
WITH NOCHECK
ADD CONSTRAINT fk_cbs_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go
 ALTER TABLE CBS  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_chgtask_header on table CHGTASK'


--METADATA NAME:fk_chgtask_header TYPE:CONSTRAINT TABLE_NAME:CHGTASK CHANGE:CREATE
ALTER TABLE CHGTASK
WITH NOCHECK
ADD CONSTRAINT fk_chgtask_header FOREIGN KEY (transaction_id)
REFERENCES CHGHEAD (transaction_id) 
go
 ALTER TABLE CHGTASK  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_chgtask_task on table CHGTASK'


--METADATA NAME:fk_chgtask_task TYPE:CONSTRAINT TABLE_NAME:CHGTASK CHANGE:CREATE
ALTER TABLE CHGTASK
WITH NOCHECK
ADD CONSTRAINT fk_chgtask_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go
 ALTER TABLE CHGTASK  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_chgtaskactv_header on table CHGTASKACTV'


--METADATA NAME:fk_chgtaskactv_header TYPE:CONSTRAINT TABLE_NAME:CHGTASKACTV CHANGE:CREATE
ALTER TABLE CHGTASKACTV
WITH NOCHECK
ADD CONSTRAINT fk_chgtaskactv_header FOREIGN KEY (transaction_id)
REFERENCES CHGHEAD (transaction_id) 
go
 ALTER TABLE CHGTASKACTV  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_chgtaskactv_proj on table CHGTASKACTV'


--METADATA NAME:fk_chgtaskactv_proj TYPE:CONSTRAINT TABLE_NAME:CHGTASKACTV CHANGE:CREATE
ALTER TABLE CHGTASKACTV
WITH NOCHECK
ADD CONSTRAINT fk_chgtaskactv_proj FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go
 ALTER TABLE CHGTASKACTV  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_chgtaskactv_actvtype on table CHGTASKACTV'


--METADATA NAME:fk_chgtaskactv_actvtype TYPE:CONSTRAINT TABLE_NAME:CHGTASKACTV CHANGE:CREATE
ALTER TABLE CHGTASKACTV
WITH NOCHECK
ADD CONSTRAINT fk_chgtaskactv_actvtype FOREIGN KEY (actv_code_type_id)
REFERENCES ACTVTYPE (actv_code_type_id) 
go
 ALTER TABLE CHGTASKACTV  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_chgtaskactv_task on table CHGTASKACTV'


--METADATA NAME:fk_chgtaskactv_task TYPE:CONSTRAINT TABLE_NAME:CHGTASKACTV CHANGE:CREATE
ALTER TABLE CHGTASKACTV
WITH NOCHECK
ADD CONSTRAINT fk_chgtaskactv_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go
 ALTER TABLE CHGTASKACTV  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_chgtaskmemo_header on table CHGTASKMEMO'


--METADATA NAME:fk_chgtaskmemo_header TYPE:CONSTRAINT TABLE_NAME:CHGTASKMEMO CHANGE:CREATE
ALTER TABLE CHGTASKMEMO
WITH NOCHECK
ADD CONSTRAINT fk_chgtaskmemo_header FOREIGN KEY (transaction_id)
REFERENCES CHGHEAD (transaction_id) 
go
 ALTER TABLE CHGTASKMEMO  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_chgtaskmemo_taskmemo on table CHGTASKMEMO'


--METADATA NAME:fk_chgtaskmemo_taskmemo TYPE:CONSTRAINT TABLE_NAME:CHGTASKMEMO CHANGE:CREATE
ALTER TABLE CHGTASKMEMO
WITH NOCHECK
ADD CONSTRAINT fk_chgtaskmemo_taskmemo FOREIGN KEY (memo_id)
REFERENCES TASKMEMO (memo_id) 
go
 ALTER TABLE CHGTASKMEMO  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_chgtaskmemo_task on table CHGTASKMEMO'


--METADATA NAME:fk_chgtaskmemo_task TYPE:CONSTRAINT TABLE_NAME:CHGTASKMEMO CHANGE:CREATE
ALTER TABLE CHGTASKMEMO
WITH NOCHECK
ADD CONSTRAINT fk_chgtaskmemo_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go
 ALTER TABLE CHGTASKMEMO  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_chgtaskproc_header on table CHGTASKPROC'


--METADATA NAME:fk_chgtaskproc_header TYPE:CONSTRAINT TABLE_NAME:CHGTASKPROC CHANGE:CREATE
ALTER TABLE CHGTASKPROC
WITH NOCHECK
ADD CONSTRAINT fk_chgtaskproc_header FOREIGN KEY (transaction_id)
REFERENCES CHGHEAD (transaction_id) 
go
 ALTER TABLE CHGTASKPROC  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_chgtaskproc_task on table CHGTASKPROC'


--METADATA NAME:fk_chgtaskproc_task TYPE:CONSTRAINT TABLE_NAME:CHGTASKPROC CHANGE:CREATE
ALTER TABLE CHGTASKPROC
WITH NOCHECK
ADD CONSTRAINT fk_chgtaskproc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go
 ALTER TABLE CHGTASKPROC  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_chgtaskproc_taskproc on table CHGTASKPROC'


--METADATA NAME:fk_chgtaskproc_taskproc TYPE:CONSTRAINT TABLE_NAME:CHGTASKPROC CHANGE:CREATE
ALTER TABLE CHGTASKPROC
WITH NOCHECK
ADD CONSTRAINT fk_chgtaskproc_taskproc FOREIGN KEY (proc_id)
REFERENCES TASKPROC (proc_id) 
go
 ALTER TABLE CHGTASKPROC  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_chgtrsrc_header on table CHGTRSRC'


--METADATA NAME:fk_chgtrsrc_header TYPE:CONSTRAINT TABLE_NAME:CHGTRSRC CHANGE:CREATE
ALTER TABLE CHGTRSRC
WITH NOCHECK
ADD CONSTRAINT fk_chgtrsrc_header FOREIGN KEY (transaction_id)
REFERENCES CHGHEAD (transaction_id) 
go
 ALTER TABLE CHGTRSRC  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_chgtrsrc_task on table CHGTRSRC'


--METADATA NAME:fk_chgtrsrc_task TYPE:CONSTRAINT TABLE_NAME:CHGTRSRC CHANGE:CREATE
ALTER TABLE CHGTRSRC
WITH NOCHECK
ADD CONSTRAINT fk_chgtrsrc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go
 ALTER TABLE CHGTRSRC  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_chgudfvalue_header on table CHGUDFVALUE'


--METADATA NAME:fk_chgudfvalue_header TYPE:CONSTRAINT TABLE_NAME:CHGUDFVALUE CHANGE:CREATE
ALTER TABLE CHGUDFVALUE
WITH NOCHECK
ADD CONSTRAINT fk_chgudfvalue_header FOREIGN KEY (transaction_id)
REFERENCES CHGHEAD (transaction_id) 
go
 ALTER TABLE CHGUDFVALUE  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_chgudfvalue_udftype on table CHGUDFVALUE'


--METADATA NAME:fk_chgudfvalue_udftype TYPE:CONSTRAINT TABLE_NAME:CHGUDFVALUE CHANGE:CREATE
ALTER TABLE CHGUDFVALUE
WITH NOCHECK
ADD CONSTRAINT fk_chgudfvalue_udftype FOREIGN KEY (udf_type_id)
REFERENCES UDFTYPE (udf_type_id) 
go
 ALTER TABLE CHGUDFVALUE  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_deltaskproc_header on table DELTASKPROC'


--METADATA NAME:fk_deltaskproc_header TYPE:CONSTRAINT TABLE_NAME:DELTASKPROC CHANGE:CREATE
ALTER TABLE DELTASKPROC
WITH NOCHECK
ADD CONSTRAINT fk_deltaskproc_header FOREIGN KEY (transaction_id)
REFERENCES CHGHEAD (transaction_id) 
go
 ALTER TABLE DELTASKPROC  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_deltaskproc_task on table DELTASKPROC'


--METADATA NAME:fk_deltaskproc_task TYPE:CONSTRAINT TABLE_NAME:DELTASKPROC CHANGE:CREATE
ALTER TABLE DELTASKPROC
WITH NOCHECK
ADD CONSTRAINT fk_deltaskproc_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go
 ALTER TABLE DELTASKPROC  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_discussion_project on table DISCUSSION'


--METADATA NAME:fk_discussion_project TYPE:CONSTRAINT TABLE_NAME:DISCUSSION CHANGE:CREATE
ALTER TABLE DISCUSSION
WITH NOCHECK
ADD CONSTRAINT fk_discussion_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go
 ALTER TABLE DISCUSSION  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_dm_attr_attr_master on table DM_ATTR'


--METADATA NAME:fk_dm_attr_attr_master TYPE:CONSTRAINT TABLE_NAME:DM_ATTR CHANGE:CREATE
ALTER TABLE DM_ATTR
WITH NOCHECK
ADD CONSTRAINT fk_dm_attr_attr_master FOREIGN KEY (attr_id)
REFERENCES ATTR_MASTER (attr_id) 
go
 ALTER TABLE DM_ATTR  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_doc_docfolder on table DOC'


--METADATA NAME:fk_doc_docfolder TYPE:CONSTRAINT TABLE_NAME:DOC CHANGE:CREATE
ALTER TABLE DOC
WITH NOCHECK
ADD CONSTRAINT fk_doc_docfolder FOREIGN KEY (doc_folder_id)
REFERENCES DOC_FOLDER (doc_folder_id) 
go
 ALTER TABLE DOC  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_docrecent_docfolder on table DOC_RECENT'


--METADATA NAME:fk_docrecent_docfolder TYPE:CONSTRAINT TABLE_NAME:DOC_RECENT CHANGE:CREATE
ALTER TABLE DOC_RECENT
WITH NOCHECK
ADD CONSTRAINT fk_docrecent_docfolder FOREIGN KEY (doc_folder_id)
REFERENCES DOC_FOLDER (doc_folder_id) 
go
 ALTER TABLE DOC_RECENT  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_docrecent_doc on table DOC_RECENT'


--METADATA NAME:fk_docrecent_doc TYPE:CONSTRAINT TABLE_NAME:DOC_RECENT CHANGE:CREATE
ALTER TABLE DOC_RECENT
WITH NOCHECK
ADD CONSTRAINT fk_docrecent_doc FOREIGN KEY (doc_id)
REFERENCES DOC (doc_id) 
go
 ALTER TABLE DOC_RECENT  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_provider_id on table GATEWAYDEPLOYMENT'


--METADATA NAME:fk_provider_id TYPE:CONSTRAINT TABLE_NAME:GATEWAYDEPLOYMENT CHANGE:CREATE
ALTER TABLE GATEWAYDEPLOYMENT
WITH NOCHECK
ADD CONSTRAINT fk_provider_id FOREIGN KEY (provider_id)
REFERENCES GATEWAYPROVIDER (provider_id) 
go
 ALTER TABLE GATEWAYDEPLOYMENT  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_gs_deployment_id on table GATEWAYSYNCACTION'


--METADATA NAME:fk_gs_deployment_id TYPE:CONSTRAINT TABLE_NAME:GATEWAYSYNCACTION CHANGE:CREATE
ALTER TABLE GATEWAYSYNCACTION
WITH NOCHECK
ADD CONSTRAINT fk_gs_deployment_id FOREIGN KEY (deplmnt_id)
REFERENCES GATEWAYDEPLOYMENT (deplmnt_id) 
go
 ALTER TABLE GATEWAYSYNCACTION  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_itertask_iteration on table ITERTASK'


--METADATA NAME:fk_itertask_iteration TYPE:CONSTRAINT TABLE_NAME:ITERTASK CHANGE:CREATE
ALTER TABLE ITERTASK
WITH NOCHECK
ADD CONSTRAINT fk_itertask_iteration FOREIGN KEY (iteration_id)
REFERENCES ITERATION (iteration_id) 
go
 ALTER TABLE ITERTASK  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_itertask_task on table ITERTASK'


--METADATA NAME:fk_itertask_task TYPE:CONSTRAINT TABLE_NAME:ITERTASK CHANGE:CREATE
ALTER TABLE ITERTASK
WITH NOCHECK
ADD CONSTRAINT fk_itertask_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go
 ALTER TABLE ITERTASK  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_iterteam_iteration on table ITERTEAM'


--METADATA NAME:fk_iterteam_iteration TYPE:CONSTRAINT TABLE_NAME:ITERTEAM CHANGE:CREATE
ALTER TABLE ITERTEAM
WITH NOCHECK
ADD CONSTRAINT fk_iterteam_iteration FOREIGN KEY (iteration_id)
REFERENCES ITERATION (iteration_id) 
go
 ALTER TABLE ITERTEAM  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_iterteam_rfolio on table ITERTEAM'


--METADATA NAME:fk_iterteam_rfolio TYPE:CONSTRAINT TABLE_NAME:ITERTEAM CHANGE:CREATE
ALTER TABLE ITERTEAM
WITH NOCHECK
ADD CONSTRAINT fk_iterteam_rfolio FOREIGN KEY (rfolio_id)
REFERENCES RFOLIO (rfolio_id) 
go
 ALTER TABLE ITERTEAM  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_jobproj_jobsvc on table JOBPROJ_LKP'


--METADATA NAME:fk_jobproj_jobsvc TYPE:CONSTRAINT TABLE_NAME:JOBPROJ_LKP CHANGE:CREATE
ALTER TABLE JOBPROJ_LKP
WITH NOCHECK
ADD CONSTRAINT fk_jobproj_jobsvc FOREIGN KEY (job_id)
REFERENCES JOBSVC (job_id) 
go
 ALTER TABLE JOBPROJ_LKP  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_jobset_jobsvc on table JOBSET'


--METADATA NAME:fk_jobset_jobsvc TYPE:CONSTRAINT TABLE_NAME:JOBSET CHANGE:CREATE
ALTER TABLE JOBSET
WITH NOCHECK
ADD CONSTRAINT fk_jobset_jobsvc FOREIGN KEY (job_id)
REFERENCES JOBSVC (job_id) 
go
 ALTER TABLE JOBSET  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_leantask_project on table LEANTASK'


--METADATA NAME:fk_leantask_project TYPE:CONSTRAINT TABLE_NAME:LEANTASK CHANGE:CREATE
ALTER TABLE LEANTASK
WITH NOCHECK
ADD CONSTRAINT fk_leantask_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go
 ALTER TABLE LEANTASK  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_leantask_task on table LEANTASK'


--METADATA NAME:fk_leantask_task TYPE:CONSTRAINT TABLE_NAME:LEANTASK CHANGE:CREATE
ALTER TABLE LEANTASK
WITH NOCHECK
ADD CONSTRAINT fk_leantask_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go
 ALTER TABLE LEANTASK  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_mtxscrtyp_matrix on table MTXSCRTYP'


--METADATA NAME:fk_mtxscrtyp_matrix TYPE:CONSTRAINT TABLE_NAME:MTXSCRTYP CHANGE:CREATE
ALTER TABLE MTXSCRTYP
WITH NOCHECK
ADD CONSTRAINT fk_mtxscrtyp_matrix FOREIGN KEY (matrix_id)
REFERENCES RISKSCRMTX (matrix_id) 
go
 ALTER TABLE MTXSCRTYP  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_mtxscrtyp_type on table MTXSCRTYP'


--METADATA NAME:fk_mtxscrtyp_type TYPE:CONSTRAINT TABLE_NAME:MTXSCRTYP CHANGE:CREATE
ALTER TABLE MTXSCRTYP
WITH NOCHECK
ADD CONSTRAINT fk_mtxscrtyp_type FOREIGN KEY (scoretype_id)
REFERENCES RISKSCRTYP (scoretype_id) 
go
 ALTER TABLE MTXSCRTYP  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_projcost_cbs on table PROJCOST'


--METADATA NAME:fk_projcost_cbs TYPE:CONSTRAINT TABLE_NAME:PROJCOST CHANGE:CREATE
ALTER TABLE PROJCOST
WITH NOCHECK
ADD CONSTRAINT fk_projcost_cbs FOREIGN KEY (cbs_id)
REFERENCES CBS (cbs_id) 
go
 ALTER TABLE PROJCOST  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_pdp_proj_id on table PROJDEPLMENT'


--METADATA NAME:fk_pdp_proj_id TYPE:CONSTRAINT TABLE_NAME:PROJDEPLMENT CHANGE:CREATE
ALTER TABLE PROJDEPLMENT
WITH NOCHECK
ADD CONSTRAINT fk_pdp_proj_id FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go
 ALTER TABLE PROJDEPLMENT  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_dplmnt_id on table PROJDEPLMENT'


--METADATA NAME:fk_dplmnt_id TYPE:CONSTRAINT TABLE_NAME:PROJDEPLMENT CHANGE:CREATE
ALTER TABLE PROJDEPLMENT
WITH NOCHECK
ADD CONSTRAINT fk_dplmnt_id FOREIGN KEY (deplmnt_id)
REFERENCES GATEWAYDEPLOYMENT (deplmnt_id) 
go
 ALTER TABLE PROJDEPLMENT  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_project_matrix on table PROJECT'


--METADATA NAME:fk_project_matrix TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
WITH NOCHECK
ADD CONSTRAINT fk_project_matrix FOREIGN KEY (matrix_id)
REFERENCES RISKSCRMTX (matrix_id) 
go
 ALTER TABLE PROJECT  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_project_location on table PROJECT'


--METADATA NAME:fk_project_location TYPE:CONSTRAINT TABLE_NAME:PROJECT CHANGE:CREATE
ALTER TABLE PROJECT
WITH NOCHECK
ADD CONSTRAINT fk_project_location FOREIGN KEY (location_id)
REFERENCES LOCATION (location_id) 
go
 ALTER TABLE PROJECT  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_projcostcbsspread_cost on table PROJECTCOSTCBSSPREAD'


--METADATA NAME:fk_projcostcbsspread_cost TYPE:CONSTRAINT TABLE_NAME:PROJECTCOSTCBSSPREAD CHANGE:CREATE
ALTER TABLE PROJECTCOSTCBSSPREAD
WITH NOCHECK
ADD CONSTRAINT fk_projcostcbsspread_cost FOREIGN KEY (cost_type_id)
REFERENCES COSTTYPE (cost_type_id) 
go
 ALTER TABLE PROJECTCOSTCBSSPREAD  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_projcostcbsspread_project on table PROJECTCOSTCBSSPREAD'


--METADATA NAME:fk_projcostcbsspread_project TYPE:CONSTRAINT TABLE_NAME:PROJECTCOSTCBSSPREAD CHANGE:CREATE
ALTER TABLE PROJECTCOSTCBSSPREAD
WITH NOCHECK
ADD CONSTRAINT fk_projcostcbsspread_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go
 ALTER TABLE PROJECTCOSTCBSSPREAD  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_projcostcbsspread_cbs on table PROJECTCOSTCBSSPREAD'


--METADATA NAME:fk_projcostcbsspread_cbs TYPE:CONSTRAINT TABLE_NAME:PROJECTCOSTCBSSPREAD CHANGE:CREATE
ALTER TABLE PROJECTCOSTCBSSPREAD
WITH NOCHECK
ADD CONSTRAINT fk_projcostcbsspread_cbs FOREIGN KEY (cbs_id)
REFERENCES CBS (cbs_id) 
go
 ALTER TABLE PROJECTCOSTCBSSPREAD  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_proj_project_etl_list on table PROJECT_ETL_LIST'


--METADATA NAME:fk_proj_project_etl_list TYPE:CONSTRAINT TABLE_NAME:PROJECT_ETL_LIST CHANGE:CREATE
ALTER TABLE PROJECT_ETL_LIST
WITH NOCHECK
ADD CONSTRAINT fk_proj_project_etl_list FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ON DELETE CASCADE 
go
 ALTER TABLE PROJECT_ETL_LIST  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_projset_project on table PROJSET'


--METADATA NAME:fk_projset_project TYPE:CONSTRAINT TABLE_NAME:PROJSET CHANGE:CREATE
ALTER TABLE PROJSET
WITH NOCHECK
ADD CONSTRAINT fk_projset_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
 ON DELETE CASCADE 
go
 ALTER TABLE PROJSET  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_reliter_release on table RELITER'


--METADATA NAME:fk_reliter_release TYPE:CONSTRAINT TABLE_NAME:RELITER CHANGE:CREATE
ALTER TABLE RELITER
WITH NOCHECK
ADD CONSTRAINT fk_reliter_release FOREIGN KEY (release_id)
REFERENCES RELEASE (release_id) 
go
 ALTER TABLE RELITER  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_reliter_iteration on table RELITER'


--METADATA NAME:fk_reliter_iteration TYPE:CONSTRAINT TABLE_NAME:RELITER CHANGE:CREATE
ALTER TABLE RELITER
WITH NOCHECK
ADD CONSTRAINT fk_reliter_iteration FOREIGN KEY (iteration_id)
REFERENCES ITERATION (iteration_id) 
go
 ALTER TABLE RELITER  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_relproj_release on table RELPROJ'


--METADATA NAME:fk_relproj_release TYPE:CONSTRAINT TABLE_NAME:RELPROJ CHANGE:CREATE
ALTER TABLE RELPROJ
WITH NOCHECK
ADD CONSTRAINT fk_relproj_release FOREIGN KEY (release_id)
REFERENCES RELEASE (release_id) 
go
 ALTER TABLE RELPROJ  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_relproj_project on table RELPROJ'


--METADATA NAME:fk_relproj_project TYPE:CONSTRAINT TABLE_NAME:RELPROJ CHANGE:CREATE
ALTER TABLE RELPROJ
WITH NOCHECK
ADD CONSTRAINT fk_relproj_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go
 ALTER TABLE RELPROJ  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_rascbsspread_rsrc on table RESOURCEASSIGNMENTCBSSPREAD'


--METADATA NAME:fk_rascbsspread_rsrc TYPE:CONSTRAINT TABLE_NAME:RESOURCEASSIGNMENTCBSSPREAD CHANGE:CREATE
ALTER TABLE RESOURCEASSIGNMENTCBSSPREAD
WITH NOCHECK
ADD CONSTRAINT fk_rascbsspread_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
go
 ALTER TABLE RESOURCEASSIGNMENTCBSSPREAD  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_rascbsspread_project on table RESOURCEASSIGNMENTCBSSPREAD'


--METADATA NAME:fk_rascbsspread_project TYPE:CONSTRAINT TABLE_NAME:RESOURCEASSIGNMENTCBSSPREAD CHANGE:CREATE
ALTER TABLE RESOURCEASSIGNMENTCBSSPREAD
WITH NOCHECK
ADD CONSTRAINT fk_rascbsspread_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go
 ALTER TABLE RESOURCEASSIGNMENTCBSSPREAD  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_rascbsspread_cbs on table RESOURCEASSIGNMENTCBSSPREAD'


--METADATA NAME:fk_rascbsspread_cbs TYPE:CONSTRAINT TABLE_NAME:RESOURCEASSIGNMENTCBSSPREAD CHANGE:CREATE
ALTER TABLE RESOURCEASSIGNMENTCBSSPREAD
WITH NOCHECK
ADD CONSTRAINT fk_rascbsspread_cbs FOREIGN KEY (cbs_id)
REFERENCES CBS (cbs_id) 
go
 ALTER TABLE RESOURCEASSIGNMENTCBSSPREAD  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_risk_project on table RISK'


--METADATA NAME:fk_risk_project TYPE:CONSTRAINT TABLE_NAME:RISK CHANGE:CREATE
ALTER TABLE RISK
WITH NOCHECK
ADD CONSTRAINT fk_risk_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go
 ALTER TABLE RISK  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_risk_resource on table RISK'


--METADATA NAME:fk_risk_resource TYPE:CONSTRAINT TABLE_NAME:RISK CHANGE:CREATE
ALTER TABLE RISK
WITH NOCHECK
ADD CONSTRAINT fk_risk_resource FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
go
 ALTER TABLE RISK  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_riskimpact_risk on table RISKIMPACT'


--METADATA NAME:fk_riskimpact_risk TYPE:CONSTRAINT TABLE_NAME:RISKIMPACT CHANGE:CREATE
ALTER TABLE RISKIMPACT
WITH NOCHECK
ADD CONSTRAINT fk_riskimpact_risk FOREIGN KEY (risk_id)
REFERENCES RISK (risk_id) 
go
 ALTER TABLE RISKIMPACT  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_riskimpact_type on table RISKIMPACT'


--METADATA NAME:fk_riskimpact_type TYPE:CONSTRAINT TABLE_NAME:RISKIMPACT CHANGE:CREATE
ALTER TABLE RISKIMPACT
WITH NOCHECK
ADD CONSTRAINT fk_riskimpact_type FOREIGN KEY (scoretype_id)
REFERENCES RISKSCRTYP (scoretype_id) 
go
 ALTER TABLE RISKIMPACT  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_riskimpact_project on table RISKIMPACT'


--METADATA NAME:fk_riskimpact_project TYPE:CONSTRAINT TABLE_NAME:RISKIMPACT CHANGE:CREATE
ALTER TABLE RISKIMPACT
WITH NOCHECK
ADD CONSTRAINT fk_riskimpact_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go
 ALTER TABLE RISKIMPACT  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_riskmit_response on table RISKMIT'


--METADATA NAME:fk_riskmit_response TYPE:CONSTRAINT TABLE_NAME:RISKMIT CHANGE:CREATE
ALTER TABLE RISKMIT
WITH NOCHECK
ADD CONSTRAINT fk_riskmit_response FOREIGN KEY (response_id)
REFERENCES RISKRSPPLN (response_id) 
go
 ALTER TABLE RISKMIT  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_riskmit_project on table RISKMIT'


--METADATA NAME:fk_riskmit_project TYPE:CONSTRAINT TABLE_NAME:RISKMIT CHANGE:CREATE
ALTER TABLE RISKMIT
WITH NOCHECK
ADD CONSTRAINT fk_riskmit_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go
 ALTER TABLE RISKMIT  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_riskmit_task on table RISKMIT'


--METADATA NAME:fk_riskmit_task TYPE:CONSTRAINT TABLE_NAME:RISKMIT CHANGE:CREATE
ALTER TABLE RISKMIT
WITH NOCHECK
ADD CONSTRAINT fk_riskmit_task FOREIGN KEY (task_id)
REFERENCES TASK (task_id) 
go
 ALTER TABLE RISKMIT  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_riskmitimp_mitigation on table RISKMITIMP'


--METADATA NAME:fk_riskmitimp_mitigation TYPE:CONSTRAINT TABLE_NAME:RISKMITIMP CHANGE:CREATE
ALTER TABLE RISKMITIMP
WITH NOCHECK
ADD CONSTRAINT fk_riskmitimp_mitigation FOREIGN KEY (mitigation_id)
REFERENCES RISKMIT (mitigation_id) 
go
 ALTER TABLE RISKMITIMP  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_riskmitimp_type on table RISKMITIMP'


--METADATA NAME:fk_riskmitimp_type TYPE:CONSTRAINT TABLE_NAME:RISKMITIMP CHANGE:CREATE
ALTER TABLE RISKMITIMP
WITH NOCHECK
ADD CONSTRAINT fk_riskmitimp_type FOREIGN KEY (scoretype_id)
REFERENCES RISKSCRTYP (scoretype_id) 
go
 ALTER TABLE RISKMITIMP  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_riskmitimp_proj on table RISKMITIMP'


--METADATA NAME:fk_riskmitimp_proj TYPE:CONSTRAINT TABLE_NAME:RISKMITIMP CHANGE:CREATE
ALTER TABLE RISKMITIMP
WITH NOCHECK
ADD CONSTRAINT fk_riskmitimp_proj FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go
 ALTER TABLE RISKMITIMP  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_riskmtxscr_matrix on table RISKMTXSCR'


--METADATA NAME:fk_riskmtxscr_matrix TYPE:CONSTRAINT TABLE_NAME:RISKMTXSCR CHANGE:CREATE
ALTER TABLE RISKMTXSCR
WITH NOCHECK
ADD CONSTRAINT fk_riskmtxscr_matrix FOREIGN KEY (matrix_id)
REFERENCES RISKSCRMTX (matrix_id) 
go
 ALTER TABLE RISKMTXSCR  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_riskrsppln_risk on table RISKRSPPLN'


--METADATA NAME:fk_riskrsppln_risk TYPE:CONSTRAINT TABLE_NAME:RISKRSPPLN CHANGE:CREATE
ALTER TABLE RISKRSPPLN
WITH NOCHECK
ADD CONSTRAINT fk_riskrsppln_risk FOREIGN KEY (risk_id)
REFERENCES RISK (risk_id) 
go
 ALTER TABLE RISKRSPPLN  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_riskrsppln_project on table RISKRSPPLN'


--METADATA NAME:fk_riskrsppln_project TYPE:CONSTRAINT TABLE_NAME:RISKRSPPLN CHANGE:CREATE
ALTER TABLE RISKRSPPLN
WITH NOCHECK
ADD CONSTRAINT fk_riskrsppln_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go
 ALTER TABLE RISKRSPPLN  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_riskscrthr_type on table RISKSCRTHR'


--METADATA NAME:fk_riskscrthr_type TYPE:CONSTRAINT TABLE_NAME:RISKSCRTHR CHANGE:CREATE
ALTER TABLE RISKSCRTHR
WITH NOCHECK
ADD CONSTRAINT fk_riskscrthr_type FOREIGN KEY (scoretype_id)
REFERENCES RISKSCRTYP (scoretype_id) 
go
 ALTER TABLE RISKSCRTHR  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_rsrc_location on table RSRC'


--METADATA NAME:fk_rsrc_location TYPE:CONSTRAINT TABLE_NAME:RSRC CHANGE:CREATE
ALTER TABLE RSRC
WITH NOCHECK
ADD CONSTRAINT fk_rsrc_location FOREIGN KEY (location_id)
REFERENCES LOCATION (location_id) 
go
 ALTER TABLE RSRC  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_rsrcloc_rsrc on table RSRCLOC'


--METADATA NAME:fk_rsrcloc_rsrc TYPE:CONSTRAINT TABLE_NAME:RSRCLOC CHANGE:CREATE
ALTER TABLE RSRCLOC
WITH NOCHECK
ADD CONSTRAINT fk_rsrcloc_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
go
 ALTER TABLE RSRCLOC  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_rsrcrolespread_project on table RSRCROLEASGNMENTSPREAD'


--METADATA NAME:fk_rsrcrolespread_project TYPE:CONSTRAINT TABLE_NAME:RSRCROLEASGNMENTSPREAD CHANGE:CREATE
ALTER TABLE RSRCROLEASGNMENTSPREAD
WITH NOCHECK
ADD CONSTRAINT fk_rsrcrolespread_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go
 ALTER TABLE RSRCROLEASGNMENTSPREAD  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_snapproj_group on table SNAPPROJ'


--METADATA NAME:fk_snapproj_group TYPE:CONSTRAINT TABLE_NAME:SNAPPROJ CHANGE:CREATE
ALTER TABLE SNAPPROJ
WITH NOCHECK
ADD CONSTRAINT fk_snapproj_group FOREIGN KEY (snap_group_id)
REFERENCES SNAPGROUP (snap_group_id) 
go
 ALTER TABLE SNAPPROJ  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_snapproj_project on table SNAPPROJ'


--METADATA NAME:fk_snapproj_project TYPE:CONSTRAINT TABLE_NAME:SNAPPROJ CHANGE:CREATE
ALTER TABLE SNAPPROJ
WITH NOCHECK
ADD CONSTRAINT fk_snapproj_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go
 ALTER TABLE SNAPPROJ  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_snapshot_group on table SNAPSHOT'


--METADATA NAME:fk_snapshot_group TYPE:CONSTRAINT TABLE_NAME:SNAPSHOT CHANGE:CREATE
ALTER TABLE SNAPSHOT
WITH NOCHECK
ADD CONSTRAINT fk_snapshot_group FOREIGN KEY (snap_group_id)
REFERENCES SNAPGROUP (snap_group_id) 
go
 ALTER TABLE SNAPSHOT  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_task_cbs on table TASK'


--METADATA NAME:fk_task_cbs TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
WITH NOCHECK
ADD CONSTRAINT fk_task_cbs FOREIGN KEY (cbs_id)
REFERENCES CBS (cbs_id) 
go
 ALTER TABLE TASK  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_task_location on table TASK'


--METADATA NAME:fk_task_location TYPE:CONSTRAINT TABLE_NAME:TASK CHANGE:CREATE
ALTER TABLE TASK
WITH NOCHECK
ADD CONSTRAINT fk_task_location FOREIGN KEY (location_id)
REFERENCES LOCATION (location_id) 
go
 ALTER TABLE TASK  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_taskcbsx_project on table TASKCBSX'


--METADATA NAME:fk_taskcbsx_project TYPE:CONSTRAINT TABLE_NAME:TASKCBSX CHANGE:CREATE
ALTER TABLE TASKCBSX
WITH NOCHECK
ADD CONSTRAINT fk_taskcbsx_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id) 
go
 ALTER TABLE TASKCBSX  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_taskcbsx_cbs on table TASKCBSX'


--METADATA NAME:fk_taskcbsx_cbs TYPE:CONSTRAINT TABLE_NAME:TASKCBSX CHANGE:CREATE
ALTER TABLE TASKCBSX
WITH NOCHECK
ADD CONSTRAINT fk_taskcbsx_cbs FOREIGN KEY (cbs_id)
REFERENCES CBS (cbs_id) 
go
 ALTER TABLE TASKCBSX  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_taskrsrc_cbs on table TASKRSRC'


--METADATA NAME:fk_taskrsrc_cbs TYPE:CONSTRAINT TABLE_NAME:TASKRSRC CHANGE:CREATE
ALTER TABLE TASKRSRC
WITH NOCHECK
ADD CONSTRAINT fk_taskrsrc_cbs FOREIGN KEY (cbs_id)
REFERENCES CBS (cbs_id) 
go
 ALTER TABLE TASKRSRC  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_timesht_rsrc on table TIMESHT'


--METADATA NAME:fk_timesht_rsrc TYPE:CONSTRAINT TABLE_NAME:TIMESHT CHANGE:CREATE
ALTER TABLE TIMESHT
WITH NOCHECK
ADD CONSTRAINT fk_timesht_rsrc FOREIGN KEY (rsrc_id)
REFERENCES RSRC (rsrc_id) 
go
 ALTER TABLE TIMESHT  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_timesht_tsdates on table TIMESHT'


--METADATA NAME:fk_timesht_tsdates TYPE:CONSTRAINT TABLE_NAME:TIMESHT CHANGE:CREATE
ALTER TABLE TIMESHT
WITH NOCHECK
ADD CONSTRAINT fk_timesht_tsdates FOREIGN KEY (ts_id)
REFERENCES TSDATES (ts_id) 
go
 ALTER TABLE TIMESHT  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_trackofflineuser_users on table TRACKOFFLINEUSER'


--METADATA NAME:fk_trackofflineuser_users TYPE:CONSTRAINT TABLE_NAME:TRACKOFFLINEUSER CHANGE:CREATE
ALTER TABLE TRACKOFFLINEUSER
WITH NOCHECK
ADD CONSTRAINT fk_trackofflineuser_users FOREIGN KEY (user_id)
REFERENCES USERS (user_id) 
go
 ALTER TABLE TRACKOFFLINEUSER  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_ts_appr_rsrc on table TSAPPROVERS'


--METADATA NAME:fk_ts_appr_rsrc TYPE:CONSTRAINT TABLE_NAME:TSAPPROVERS CHANGE:CREATE
ALTER TABLE TSAPPROVERS
WITH NOCHECK
ADD CONSTRAINT fk_ts_appr_rsrc FOREIGN KEY (ts_id,rsrc_id)
REFERENCES TIMESHT (ts_id,rsrc_id) 
go
 ALTER TABLE TSAPPROVERS  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_wbsreviewers_projwbs on table WBSREVIEWERS'


--METADATA NAME:fk_wbsreviewers_projwbs TYPE:CONSTRAINT TABLE_NAME:WBSREVIEWERS CHANGE:CREATE
ALTER TABLE WBSREVIEWERS
WITH NOCHECK
ADD CONSTRAINT fk_wbsreviewers_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
go
 ALTER TABLE WBSREVIEWERS  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_wbsreviewers_users on table WBSREVIEWERS'


--METADATA NAME:fk_wbsreviewers_users TYPE:CONSTRAINT TABLE_NAME:WBSREVIEWERS CHANGE:CREATE
ALTER TABLE WBSREVIEWERS
WITH NOCHECK
ADD CONSTRAINT fk_wbsreviewers_users FOREIGN KEY (status_reviewer)
REFERENCES USERS (user_id) 
go
 ALTER TABLE WBSREVIEWERS  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_wbsreviewstatus_users on table WBSREVIEWSTATUS'


--METADATA NAME:fk_wbsreviewstatus_users TYPE:CONSTRAINT TABLE_NAME:WBSREVIEWSTATUS CHANGE:CREATE
ALTER TABLE WBSREVIEWSTATUS
WITH NOCHECK
ADD CONSTRAINT fk_wbsreviewstatus_users FOREIGN KEY (status_reviewer)
REFERENCES USERS (user_id) 
go
 ALTER TABLE WBSREVIEWSTATUS  CHECK CONSTRAINT ALL 
go
print 'Creating constraint fk_wbsreviewstatus_projwbs on table WBSREVIEWSTATUS'


--METADATA NAME:fk_wbsreviewstatus_projwbs TYPE:CONSTRAINT TABLE_NAME:WBSREVIEWSTATUS CHANGE:CREATE
ALTER TABLE WBSREVIEWSTATUS
WITH NOCHECK
ADD CONSTRAINT fk_wbsreviewstatus_projwbs FOREIGN KEY (wbs_id)
REFERENCES PROJWBS (wbs_id) 
go
 ALTER TABLE WBSREVIEWSTATUS  CHECK CONSTRAINT ALL 
go 
--METADATA NAME:exp_user_name TYPE:FIELD TABLE_NAME:EXPPROJ CHANGE:ALTER
ALTER TABLE EXPPROJ ALTER COLUMN exp_user_name nvarchar(255)
go
 
--METADATA NAME:exp_user_name TYPE:FIELD TABLE_NAME:EXPPROJ CHANGE:ALTER 
--METADATA NAME:app_user_name TYPE:FIELD TABLE_NAME:EXTAPP CHANGE:ALTER
ALTER TABLE EXTAPP ALTER COLUMN app_user_name nvarchar(255)
go
 
--METADATA NAME:app_user_name TYPE:FIELD TABLE_NAME:EXTAPP CHANGE:ALTER 
--METADATA NAME:user_id TYPE:FIELD TABLE_NAME:JOBSVC CHANGE:ALTER
ALTER TABLE JOBSVC ALTER COLUMN user_id integer NULL
go
 
--METADATA NAME:add_date TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:ALTER
ALTER TABLE PROJRISK ALTER COLUMN add_date datetime NULL
go
 
--METADATA NAME:risk_name TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:ALTER
ALTER TABLE PROJRISK ALTER COLUMN risk_name nvarchar(120) NOT NULL 
go
 
--METADATA NAME:risk_name TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:ALTER 
--METADATA NAME:email_addr TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER
ALTER TABLE RSRC ALTER COLUMN email_addr nvarchar(255)
go
 
--METADATA NAME:email_addr TYPE:FIELD TABLE_NAME:RSRC CHANGE:ALTER 
--METADATA NAME:email_srv_user_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER
ALTER TABLE USERS ALTER COLUMN email_srv_user_name nvarchar(255)
go
 
--METADATA NAME:email_srv_user_name TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER 
--METADATA NAME:email_addr TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER
ALTER TABLE USERS ALTER COLUMN email_addr nvarchar(255)
go
 
--METADATA NAME:email_addr TYPE:FIELD TABLE_NAME:USERS CHANGE:ALTER
print 'Creating index ndx_actvcodehier_type on table ACTIVITYCODEHIERARCHY'

--METADATA NAME:ndx_actvcodehier_type TYPE:INDEX TABLE_NAME:ACTIVITYCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_actvcodehier_type
ON ACTIVITYCODEHIERARCHY (codetypeobjectid)

go

print 'Creating index ndx_actvcodehier_parent on table ACTIVITYCODEHIERARCHY'

--METADATA NAME:ndx_actvcodehier_parent TYPE:INDEX TABLE_NAME:ACTIVITYCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_actvcodehier_parent
ON ACTIVITYCODEHIERARCHY (parentcodevalueobjectid)

go

print 'Creating index ndx_actvcodehier_child on table ACTIVITYCODEHIERARCHY'

--METADATA NAME:ndx_actvcodehier_child TYPE:INDEX TABLE_NAME:ACTIVITYCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_actvcodehier_child
ON ACTIVITYCODEHIERARCHY (childcodevalueobjectid)

go

print 'Creating index ndx_actvcodehier_projid on table ACTIVITYCODEHIERARCHY'

--METADATA NAME:ndx_actvcodehier_projid TYPE:INDEX TABLE_NAME:ACTIVITYCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_actvcodehier_projid
ON ACTIVITYCODEHIERARCHY (codetypeprojectid)

go

print 'Creating index ndx_pk_ActvityTypeSecurity on table ACTIVITYCODETYPESECURITY'

--METADATA NAME:ndx_pk_ActvityTypeSecurity TYPE:INDEX TABLE_NAME:ACTIVITYCODETYPESECURITY CHANGE:CREATE      
CREATE INDEX ndx_pk_ActvityTypeSecurity
ON ACTIVITYCODETYPESECURITY (rdbmsuserid,projectobjectid)

go

print 'Creating index ndx_activityspread_project on table ACTIVITYSPREAD'

--METADATA NAME:ndx_activityspread_project TYPE:INDEX TABLE_NAME:ACTIVITYSPREAD CHANGE:CREATE      
CREATE INDEX ndx_activityspread_project
ON ACTIVITYSPREAD (projectobjectid,startdate)

go

print 'Creating index ndx_activityspread on table ACTIVITYSPREAD'

--METADATA NAME:ndx_activityspread TYPE:INDEX TABLE_NAME:ACTIVITYSPREAD CHANGE:CREATE      
CREATE INDEX ndx_activityspread
ON ACTIVITYSPREAD (activityobjectid,startdate)

go

print 'Creating index ndx_addtaskproc_project on table ADDTASKPROC'

--METADATA NAME:ndx_addtaskproc_project TYPE:INDEX TABLE_NAME:ADDTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_addtaskproc_project
ON ADDTASKPROC (proj_id)

go

print 'Creating index ndx_addtaskproc_task on table ADDTASKPROC'

--METADATA NAME:ndx_addtaskproc_task TYPE:INDEX TABLE_NAME:ADDTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_addtaskproc_task
ON ADDTASKPROC (task_id)

go

print 'Creating index ndx_addtaskproc_chghead on table ADDTASKPROC'

--METADATA NAME:ndx_addtaskproc_chghead TYPE:INDEX TABLE_NAME:ADDTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_addtaskproc_chghead
ON ADDTASKPROC (transaction_id)

go

print 'Creating index ndx_addtaskproc_dsi on table ADDTASKPROC'

--METADATA NAME:ndx_addtaskproc_dsi TYPE:INDEX TABLE_NAME:ADDTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_addtaskproc_dsi
ON ADDTASKPROC (delete_session_id,delete_date)

go

print 'Creating index ndx_addtrsrc_header on table ADDTRSRC'

--METADATA NAME:ndx_addtrsrc_header TYPE:INDEX TABLE_NAME:ADDTRSRC CHANGE:CREATE      
CREATE INDEX ndx_addtrsrc_header
ON ADDTRSRC (transaction_id)

go

print 'Creating index ndx_addtrsrc_task on table ADDTRSRC'

--METADATA NAME:ndx_addtrsrc_task TYPE:INDEX TABLE_NAME:ADDTRSRC CHANGE:CREATE      
CREATE INDEX ndx_addtrsrc_task
ON ADDTRSRC (task_id)

go

print 'Creating index ndx_alert_users on table ALERT'

--METADATA NAME:ndx_alert_users TYPE:INDEX TABLE_NAME:ALERT CHANGE:CREATE      
CREATE INDEX ndx_alert_users
ON ALERT (user_id)

go

print 'Creating index ndx_announcement_user_status on table ANNOUNCEMENT_USER'

--METADATA NAME:ndx_announcement_user_status TYPE:INDEX TABLE_NAME:ANNOUNCEMENT_USER CHANGE:CREATE      
CREATE INDEX ndx_announcement_user_status
ON ANNOUNCEMENT_USER (status_code)

go

print 'Creating index ndx_assgnmntcodehier_type on table ASSIGNMENTCODEHIERARCHY'

--METADATA NAME:ndx_assgnmntcodehier_type TYPE:INDEX TABLE_NAME:ASSIGNMENTCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_assgnmntcodehier_type
ON ASSIGNMENTCODEHIERARCHY (codetypeobjectid)

go

print 'Creating index ndx_assgnmntcodehier_parent on table ASSIGNMENTCODEHIERARCHY'

--METADATA NAME:ndx_assgnmntcodehier_parent TYPE:INDEX TABLE_NAME:ASSIGNMENTCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_assgnmntcodehier_parent
ON ASSIGNMENTCODEHIERARCHY (parentcodevalueobjectid)

go

print 'Creating index ndx_assgnmntcodehier_child on table ASSIGNMENTCODEHIERARCHY'

--METADATA NAME:ndx_assgnmntcodehier_child TYPE:INDEX TABLE_NAME:ASSIGNMENTCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_assgnmntcodehier_child
ON ASSIGNMENTCODEHIERARCHY (childcodevalueobjectid)

go

print 'Creating index ndx_attr_master_dsi on table ATTR_MASTER'

--METADATA NAME:ndx_attr_master_dsi TYPE:INDEX TABLE_NAME:ATTR_MASTER CHANGE:CREATE      
CREATE INDEX ndx_attr_master_dsi
ON ATTR_MASTER (delete_session_id,delete_date)

go

print 'Creating index ndx_attr_master_upd on table ATTR_MASTER'

--METADATA NAME:ndx_attr_master_upd TYPE:INDEX TABLE_NAME:ATTR_MASTER CHANGE:CREATE      
CREATE INDEX ndx_attr_master_upd
ON ATTR_MASTER (update_date,delete_session_id)

go

print 'Creating index ndx_calendar_default_flag on table CALENDAR'

--METADATA NAME:ndx_calendar_default_flag TYPE:INDEX TABLE_NAME:CALENDAR CHANGE:CREATE      
CREATE INDEX ndx_calendar_default_flag
ON CALENDAR (default_flag)

go

print 'Creating index ndx_calendar_clndr_type on table CALENDAR'

--METADATA NAME:ndx_calendar_clndr_type TYPE:INDEX TABLE_NAME:CALENDAR CHANGE:CREATE      
CREATE INDEX ndx_calendar_clndr_type
ON CALENDAR (clndr_type)

go

print 'Creating index ndx_cbs_project on table CBS'

--METADATA NAME:ndx_cbs_project TYPE:INDEX TABLE_NAME:CBS CHANGE:CREATE      
CREATE INDEX ndx_cbs_project
ON CBS (proj_id)

go

print 'Creating index ndx_chghead_dsi on table CHGHEAD'

--METADATA NAME:ndx_chghead_dsi TYPE:INDEX TABLE_NAME:CHGHEAD CHANGE:CREATE      
CREATE INDEX ndx_chghead_dsi
ON CHGHEAD (delete_session_id,delete_date)

go

print 'Creating index ndx_chgtask_task on table CHGTASK'

--METADATA NAME:ndx_chgtask_task TYPE:INDEX TABLE_NAME:CHGTASK CHANGE:CREATE      
CREATE INDEX ndx_chgtask_task
ON CHGTASK (task_id)

go

print 'Creating index ndx_chgtask_project on table CHGTASK'

--METADATA NAME:ndx_chgtask_project TYPE:INDEX TABLE_NAME:CHGTASK CHANGE:CREATE      
CREATE INDEX ndx_chgtask_project
ON CHGTASK (proj_id)

go

print 'Creating index ndx_chgtask_dsi on table CHGTASK'

--METADATA NAME:ndx_chgtask_dsi TYPE:INDEX TABLE_NAME:CHGTASK CHANGE:CREATE      
CREATE INDEX ndx_chgtask_dsi
ON CHGTASK (delete_session_id,delete_date)

go

print 'Creating index ndx_chgtaskactv_task on table CHGTASKACTV'

--METADATA NAME:ndx_chgtaskactv_task TYPE:INDEX TABLE_NAME:CHGTASKACTV CHANGE:CREATE      
CREATE INDEX ndx_chgtaskactv_task
ON CHGTASKACTV (task_id)

go

print 'Creating index ndx_chgtaskactv_project on table CHGTASKACTV'

--METADATA NAME:ndx_chgtaskactv_project TYPE:INDEX TABLE_NAME:CHGTASKACTV CHANGE:CREATE      
CREATE INDEX ndx_chgtaskactv_project
ON CHGTASKACTV (proj_id)

go

print 'Creating index ndx_chgtaskactv_actvcode on table CHGTASKACTV'

--METADATA NAME:ndx_chgtaskactv_actvcode TYPE:INDEX TABLE_NAME:CHGTASKACTV CHANGE:CREATE      
CREATE INDEX ndx_chgtaskactv_actvcode
ON CHGTASKACTV (actv_code_type_id)

go

print 'Creating index ndx_chgtaskactv_dsi on table CHGTASKACTV'

--METADATA NAME:ndx_chgtaskactv_dsi TYPE:INDEX TABLE_NAME:CHGTASKACTV CHANGE:CREATE      
CREATE INDEX ndx_chgtaskactv_dsi
ON CHGTASKACTV (delete_session_id,delete_date)

go

print 'Creating index ndx_chgtaskmemo_taskmemo on table CHGTASKMEMO'

--METADATA NAME:ndx_chgtaskmemo_taskmemo TYPE:INDEX TABLE_NAME:CHGTASKMEMO CHANGE:CREATE      
CREATE INDEX ndx_chgtaskmemo_taskmemo
ON CHGTASKMEMO (memo_id)

go

print 'Creating index ndx_chgtaskmemo_task on table CHGTASKMEMO'

--METADATA NAME:ndx_chgtaskmemo_task TYPE:INDEX TABLE_NAME:CHGTASKMEMO CHANGE:CREATE      
CREATE INDEX ndx_chgtaskmemo_task
ON CHGTASKMEMO (task_id)

go

print 'Creating index ndx_chgtaskmemo_dsi on table CHGTASKMEMO'

--METADATA NAME:ndx_chgtaskmemo_dsi TYPE:INDEX TABLE_NAME:CHGTASKMEMO CHANGE:CREATE      
CREATE INDEX ndx_chgtaskmemo_dsi
ON CHGTASKMEMO (delete_session_id,delete_date)

go

print 'Creating index ndx_chgtaskproc_taskproc on table CHGTASKPROC'

--METADATA NAME:ndx_chgtaskproc_taskproc TYPE:INDEX TABLE_NAME:CHGTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_chgtaskproc_taskproc
ON CHGTASKPROC (proc_id)

go

print 'Creating index ndx_chgtaskproc_project on table CHGTASKPROC'

--METADATA NAME:ndx_chgtaskproc_project TYPE:INDEX TABLE_NAME:CHGTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_chgtaskproc_project
ON CHGTASKPROC (proj_id)

go

print 'Creating index ndx_chgtaskproc_task on table CHGTASKPROC'

--METADATA NAME:ndx_chgtaskproc_task TYPE:INDEX TABLE_NAME:CHGTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_chgtaskproc_task
ON CHGTASKPROC (task_id)

go

print 'Creating index ndx_chgtaskproc_dsi on table CHGTASKPROC'

--METADATA NAME:ndx_chgtaskproc_dsi TYPE:INDEX TABLE_NAME:CHGTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_chgtaskproc_dsi
ON CHGTASKPROC (delete_session_id,delete_date)

go

print 'Creating index ndx_chgtrsrc_taskrsrc on table CHGTRSRC'

--METADATA NAME:ndx_chgtrsrc_taskrsrc TYPE:INDEX TABLE_NAME:CHGTRSRC CHANGE:CREATE      
CREATE INDEX ndx_chgtrsrc_taskrsrc
ON CHGTRSRC (taskrsrc_id)

go

print 'Creating index ndx_chgtrsrc_task on table CHGTRSRC'

--METADATA NAME:ndx_chgtrsrc_task TYPE:INDEX TABLE_NAME:CHGTRSRC CHANGE:CREATE      
CREATE INDEX ndx_chgtrsrc_task
ON CHGTRSRC (task_id)

go

print 'Creating index ndx_chgtrsrc_dsi on table CHGTRSRC'

--METADATA NAME:ndx_chgtrsrc_dsi TYPE:INDEX TABLE_NAME:CHGTRSRC CHANGE:CREATE      
CREATE INDEX ndx_chgtrsrc_dsi
ON CHGTRSRC (delete_session_id,delete_date)

go

print 'Creating index ndx_chgudfvalue_udfvalue on table CHGUDFVALUE'

--METADATA NAME:ndx_chgudfvalue_udfvalue TYPE:INDEX TABLE_NAME:CHGUDFVALUE CHANGE:CREATE      
CREATE INDEX ndx_chgudfvalue_udfvalue
ON CHGUDFVALUE (fk_id)

go

print 'Creating index ndx_chgudfvalue_udftype on table CHGUDFVALUE'

--METADATA NAME:ndx_chgudfvalue_udftype TYPE:INDEX TABLE_NAME:CHGUDFVALUE CHANGE:CREATE      
CREATE INDEX ndx_chgudfvalue_udftype
ON CHGUDFVALUE (udf_type_id)

go

print 'Creating index ndx_chgudfvalue_project on table CHGUDFVALUE'

--METADATA NAME:ndx_chgudfvalue_project TYPE:INDEX TABLE_NAME:CHGUDFVALUE CHANGE:CREATE      
CREATE INDEX ndx_chgudfvalue_project
ON CHGUDFVALUE (proj_id)

go

print 'Creating index ndx_chgudfvalue_dsi on table CHGUDFVALUE'

--METADATA NAME:ndx_chgudfvalue_dsi TYPE:INDEX TABLE_NAME:CHGUDFVALUE CHANGE:CREATE      
CREATE INDEX ndx_chgudfvalue_dsi
ON CHGUDFVALUE (delete_session_id,delete_date)

go

print 'Creating index ndx_costaccthier_parentobj on table COSTACCOUNTHIERARCHY'

--METADATA NAME:ndx_costaccthier_parentobj TYPE:INDEX TABLE_NAME:COSTACCOUNTHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_costaccthier_parentobj
ON COSTACCOUNTHIERARCHY (parentobjectid)

go

print 'Creating index ndx_costaccthier_parent on table COSTACCOUNTHIERARCHY'

--METADATA NAME:ndx_costaccthier_parent TYPE:INDEX TABLE_NAME:COSTACCOUNTHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_costaccthier_parent
ON COSTACCOUNTHIERARCHY (parentid)

go

print 'Creating index ndx_costaccthier_child on table COSTACCOUNTHIERARCHY'

--METADATA NAME:ndx_costaccthier_child TYPE:INDEX TABLE_NAME:COSTACCOUNTHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_costaccthier_child
ON COSTACCOUNTHIERARCHY (childobjectid)

go

print 'Creating index ndx_pk_CostSecurity on table COSTSECURITY'

--METADATA NAME:ndx_pk_CostSecurity TYPE:INDEX TABLE_NAME:COSTSECURITY CHANGE:CREATE      
CREATE INDEX ndx_pk_CostSecurity
ON COSTSECURITY (rdbmsuserid,projectobjectid,wholeprojectflag)

go

print 'Creating index ndx_deltaskproc_taskproc on table DELTASKPROC'

--METADATA NAME:ndx_deltaskproc_taskproc TYPE:INDEX TABLE_NAME:DELTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_deltaskproc_taskproc
ON DELTASKPROC (proc_id)

go

print 'Creating index ndx_deltaskproc_project on table DELTASKPROC'

--METADATA NAME:ndx_deltaskproc_project TYPE:INDEX TABLE_NAME:DELTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_deltaskproc_project
ON DELTASKPROC (proj_id)

go

print 'Creating index ndx_deltaskproc_task on table DELTASKPROC'

--METADATA NAME:ndx_deltaskproc_task TYPE:INDEX TABLE_NAME:DELTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_deltaskproc_task
ON DELTASKPROC (task_id)

go

print 'Creating index ndx_deltaskproc_dsi on table DELTASKPROC'

--METADATA NAME:ndx_deltaskproc_dsi TYPE:INDEX TABLE_NAME:DELTASKPROC CHANGE:CREATE      
CREATE INDEX ndx_deltaskproc_dsi
ON DELTASKPROC (delete_session_id,delete_date)

go

print 'Creating index ndx_discussion_project on table DISCUSSION'

--METADATA NAME:ndx_discussion_project TYPE:INDEX TABLE_NAME:DISCUSSION CHANGE:CREATE      
CREATE INDEX ndx_discussion_project
ON DISCUSSION (proj_id)

go

print 'Creating index ndx_discussion_read_users on table DISCUSSION_READ'

--METADATA NAME:ndx_discussion_read_users TYPE:INDEX TABLE_NAME:DISCUSSION_READ CHANGE:CREATE      
CREATE INDEX ndx_discussion_read_users
ON DISCUSSION_READ (user_id)

go

print 'Creating index ndx_dm_attr_guid on table DM_ATTR'

--METADATA NAME:ndx_dm_attr_guid TYPE:INDEX TABLE_NAME:DM_ATTR CHANGE:CREATE      
CREATE INDEX ndx_dm_attr_guid
ON DM_ATTR (attr_id,guid)

go

print 'Creating index ndx_dm_attr_dsi on table DM_ATTR'

--METADATA NAME:ndx_dm_attr_dsi TYPE:INDEX TABLE_NAME:DM_ATTR CHANGE:CREATE      
CREATE INDEX ndx_dm_attr_dsi
ON DM_ATTR (delete_session_id,delete_date)

go

print 'Creating index ndx_dm_attr_upd on table DM_ATTR'

--METADATA NAME:ndx_dm_attr_upd TYPE:INDEX TABLE_NAME:DM_ATTR CHANGE:CREATE      
CREATE INDEX ndx_dm_attr_upd
ON DM_ATTR (update_date,delete_session_id)

go

print 'Creating index ndx_doc_dsi on table DOC'

--METADATA NAME:ndx_doc_dsi TYPE:INDEX TABLE_NAME:DOC CHANGE:CREATE      
CREATE INDEX ndx_doc_dsi
ON DOC (delete_session_id,delete_date)

go

print 'Creating index ndx_doc_upd on table DOC'

--METADATA NAME:ndx_doc_upd TYPE:INDEX TABLE_NAME:DOC CHANGE:CREATE      
CREATE INDEX ndx_doc_upd
ON DOC (update_date,delete_session_id)

go

print 'Creating index ndx_doc_1 on table DOC'

--METADATA NAME:ndx_doc_1 TYPE:INDEX TABLE_NAME:DOC CHANGE:CREATE      
CREATE INDEX ndx_doc_1
ON DOC (doc_folder_id)

go

print 'Creating index ndx_doc_2 on table DOC'

--METADATA NAME:ndx_doc_2 TYPE:INDEX TABLE_NAME:DOC CHANGE:CREATE      
CREATE INDEX ndx_doc_2
ON DOC (doc_uuid)

go

print 'Creating index ndx_doc_3 on table DOC'

--METADATA NAME:ndx_doc_3 TYPE:INDEX TABLE_NAME:DOC CHANGE:CREATE      
CREATE INDEX ndx_doc_3
ON DOC (file_name)

go

print 'Creating index ndx_doc_folder_dsi on table DOC_FOLDER'

--METADATA NAME:ndx_doc_folder_dsi TYPE:INDEX TABLE_NAME:DOC_FOLDER CHANGE:CREATE      
CREATE INDEX ndx_doc_folder_dsi
ON DOC_FOLDER (delete_session_id,delete_date)

go

print 'Creating index ndx_doc_folder_upd on table DOC_FOLDER'

--METADATA NAME:ndx_doc_folder_upd TYPE:INDEX TABLE_NAME:DOC_FOLDER CHANGE:CREATE      
CREATE INDEX ndx_doc_folder_upd
ON DOC_FOLDER (update_date,delete_session_id)

go

print 'Creating index ndx_doc_folder_1 on table DOC_FOLDER'

--METADATA NAME:ndx_doc_folder_1 TYPE:INDEX TABLE_NAME:DOC_FOLDER CHANGE:CREATE      
CREATE INDEX ndx_doc_folder_1
ON DOC_FOLDER (parent_folder_id)

go

print 'Creating index ndx_doc_folder_2 on table DOC_FOLDER'

--METADATA NAME:ndx_doc_folder_2 TYPE:INDEX TABLE_NAME:DOC_FOLDER CHANGE:CREATE      
CREATE INDEX ndx_doc_folder_2
ON DOC_FOLDER (doc_folder_name)

go

print 'Creating index ndx_doc_recent_doc_folder on table DOC_RECENT'

--METADATA NAME:ndx_doc_recent_doc_folder TYPE:INDEX TABLE_NAME:DOC_RECENT CHANGE:CREATE      
CREATE INDEX ndx_doc_recent_doc_folder
ON DOC_RECENT (doc_folder_id)

go

print 'Creating index ndx_doc_recent_doc on table DOC_RECENT'

--METADATA NAME:ndx_doc_recent_doc TYPE:INDEX TABLE_NAME:DOC_RECENT CHANGE:CREATE      
CREATE INDEX ndx_doc_recent_doc
ON DOC_RECENT (doc_id)

go

print 'Creating index ndx_doc_recent_dsi on table DOC_RECENT'

--METADATA NAME:ndx_doc_recent_dsi TYPE:INDEX TABLE_NAME:DOC_RECENT CHANGE:CREATE      
CREATE INDEX ndx_doc_recent_dsi
ON DOC_RECENT (delete_session_id,delete_date)

go

print 'Creating index ndx_doc_recent_upd on table DOC_RECENT'

--METADATA NAME:ndx_doc_recent_upd TYPE:INDEX TABLE_NAME:DOC_RECENT CHANGE:CREATE      
CREATE INDEX ndx_doc_recent_upd
ON DOC_RECENT (update_date,delete_session_id)

go

print 'Creating index ndx_doc_recent_1 on table DOC_RECENT'

--METADATA NAME:ndx_doc_recent_1 TYPE:INDEX TABLE_NAME:DOC_RECENT CHANGE:CREATE      
CREATE INDEX ndx_doc_recent_1
ON DOC_RECENT (doc_user_id)

go

print 'Creating index ndx_doc_version_dsi on table DOC_VERSION'

--METADATA NAME:ndx_doc_version_dsi TYPE:INDEX TABLE_NAME:DOC_VERSION CHANGE:CREATE      
CREATE INDEX ndx_doc_version_dsi
ON DOC_VERSION (delete_session_id,delete_date)

go

print 'Creating index ndx_doc_version_upd on table DOC_VERSION'

--METADATA NAME:ndx_doc_version_upd TYPE:INDEX TABLE_NAME:DOC_VERSION CHANGE:CREATE      
CREATE INDEX ndx_doc_version_upd
ON DOC_VERSION (update_date,delete_session_id)

go

print 'Creating index ndx_doc_version_1 on table DOC_VERSION'

--METADATA NAME:ndx_doc_version_1 TYPE:INDEX TABLE_NAME:DOC_VERSION CHANGE:CREATE      
CREATE INDEX ndx_doc_version_1
ON DOC_VERSION (doc_uuid,version)

go

print 'Creating index ndx_doc_version_2 on table DOC_VERSION'

--METADATA NAME:ndx_doc_version_2 TYPE:INDEX TABLE_NAME:DOC_VERSION CHANGE:CREATE      
CREATE INDEX ndx_doc_version_2
ON DOC_VERSION (doc_id,version)

go

print 'Creating index ndx_epshier_parentobj on table EPSHIERARCHY'

--METADATA NAME:ndx_epshier_parentobj TYPE:INDEX TABLE_NAME:EPSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_epshier_parentobj
ON EPSHIERARCHY (parentobjectid)

go

print 'Creating index ndx_epshier_parent on table EPSHIERARCHY'

--METADATA NAME:ndx_epshier_parent TYPE:INDEX TABLE_NAME:EPSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_epshier_parent
ON EPSHIERARCHY (parentid)

go

print 'Creating index ndx_epshier_childobj on table EPSHIERARCHY'

--METADATA NAME:ndx_epshier_childobj TYPE:INDEX TABLE_NAME:EPSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_epshier_childobj
ON EPSHIERARCHY (childobjectid)

go

print 'Creating index ndx_epshier_parentprojid on table EPSHIERARCHY'

--METADATA NAME:ndx_epshier_parentprojid TYPE:INDEX TABLE_NAME:EPSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_epshier_parentprojid
ON EPSHIERARCHY (parentprojectid)

go

print 'Creating index ndx_epshier_childprojid on table EPSHIERARCHY'

--METADATA NAME:ndx_epshier_childprojid TYPE:INDEX TABLE_NAME:EPSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_epshier_childprojid
ON EPSHIERARCHY (childprojectid)

go

print 'Creating index ndx_epsspread_objid on table EPSSPREAD'

--METADATA NAME:ndx_epsspread_objid TYPE:INDEX TABLE_NAME:EPSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_epsspread_objid
ON EPSSPREAD (objectid,startdate)

go

print 'Creating index ndx_epsspread_parentobjid on table EPSSPREAD'

--METADATA NAME:ndx_epsspread_parentobjid TYPE:INDEX TABLE_NAME:EPSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_epsspread_parentobjid
ON EPSSPREAD (parentobjectid)

go

print 'Creating index ndx_epsspread_obsid on table EPSSPREAD'

--METADATA NAME:ndx_epsspread_obsid TYPE:INDEX TABLE_NAME:EPSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_epsspread_obsid
ON EPSSPREAD (obsobjectid)

go

print 'Creating index ndx_filtprop_rpt on table FILTPROP'

--METADATA NAME:ndx_filtprop_rpt TYPE:INDEX TABLE_NAME:FILTPROP CHANGE:CREATE      
CREATE INDEX ndx_filtprop_rpt
ON FILTPROP (rpt_id)

go

print 'Creating index ndx_deplmnt_name_provider_id on table GATEWAYDEPLOYMENT'

--METADATA NAME:ndx_deplmnt_name_provider_id TYPE:INDEX TABLE_NAME:GATEWAYDEPLOYMENT CHANGE:CREATE      
CREATE UNIQUE INDEX ndx_deplmnt_name_provider_id
ON GATEWAYDEPLOYMENT (deployment_name,provider_id)

go

print 'Creating index ndx_deplmnt_gatewayprov on table GATEWAYDEPLOYMENT'

--METADATA NAME:ndx_deplmnt_gatewayprov TYPE:INDEX TABLE_NAME:GATEWAYDEPLOYMENT CHANGE:CREATE      
CREATE INDEX ndx_deplmnt_gatewayprov
ON GATEWAYDEPLOYMENT (provider_id)

go

print 'Creating index ndx_provider_name on table GATEWAYPROVIDER'

--METADATA NAME:ndx_provider_name TYPE:INDEX TABLE_NAME:GATEWAYPROVIDER CHANGE:CREATE      
CREATE UNIQUE INDEX ndx_provider_name
ON GATEWAYPROVIDER (provider_name)

go

print 'Creating index ndx_action_name on table GATEWAYSYNCACTION'

--METADATA NAME:ndx_action_name TYPE:INDEX TABLE_NAME:GATEWAYSYNCACTION CHANGE:CREATE      
CREATE UNIQUE INDEX ndx_action_name
ON GATEWAYSYNCACTION (action_name)

go

print 'Creating index ndx_gatewaysync_gatewaydepl on table GATEWAYSYNCACTION'

--METADATA NAME:ndx_gatewaysync_gatewaydepl TYPE:INDEX TABLE_NAME:GATEWAYSYNCACTION CHANGE:CREATE      
CREATE INDEX ndx_gatewaysync_gatewaydepl
ON GATEWAYSYNCACTION (deplmnt_id)

go

print 'Creating index ndx_sync_typ_name_deplmnt_id on table GATEWAYSYNCACTION'

--METADATA NAME:ndx_sync_typ_name_deplmnt_id TYPE:INDEX TABLE_NAME:GATEWAYSYNCACTION CHANGE:CREATE      
CREATE UNIQUE INDEX ndx_sync_typ_name_deplmnt_id
ON GATEWAYSYNCACTION (sync_type,sync_name,deplmnt_id)

go

print 'Creating index ndx_pk_globasecurity on table GLOBALSECURITY'

--METADATA NAME:ndx_pk_globasecurity TYPE:INDEX TABLE_NAME:GLOBALSECURITY CHANGE:CREATE      
CREATE INDEX ndx_pk_globasecurity
ON GLOBALSECURITY (rdbmsuserid,securecodeflag,resourcecostflag,proficiencyflag,auditdataflag)

go

print 'Creating index gtt_pklist_idx on table GTT_PKLIST'

--METADATA NAME:gtt_pklist_idx TYPE:INDEX TABLE_NAME:GTT_PKLIST CHANGE:CREATE      
CREATE INDEX gtt_pklist_idx
ON GTT_PKLIST (pk_id)

go

print 'Creating index ndx_iteration_name on table ITERATION'

--METADATA NAME:ndx_iteration_name TYPE:INDEX TABLE_NAME:ITERATION CHANGE:CREATE      
CREATE INDEX ndx_iteration_name
ON ITERATION (iteration_name,iteration_id)

go

print 'Creating index ndx_itertask_task on table ITERTASK'

--METADATA NAME:ndx_itertask_task TYPE:INDEX TABLE_NAME:ITERTASK CHANGE:CREATE      
CREATE INDEX ndx_itertask_task
ON ITERTASK (task_id,iteration_id)

go

print 'Creating index ndx_iterteam_rfolio on table ITERTEAM'

--METADATA NAME:ndx_iterteam_rfolio TYPE:INDEX TABLE_NAME:ITERTEAM CHANGE:CREATE      
CREATE INDEX ndx_iterteam_rfolio
ON ITERTEAM (rfolio_id,iteration_id)

go

print 'Creating index ndx_jobproj_lkp_jobsvc on table JOBPROJ_LKP'

--METADATA NAME:ndx_jobproj_lkp_jobsvc TYPE:INDEX TABLE_NAME:JOBPROJ_LKP CHANGE:CREATE      
CREATE INDEX ndx_jobproj_lkp_jobsvc
ON JOBPROJ_LKP (job_id)

go

print 'Creating index ndx_jobset_dsi on table JOBSET'

--METADATA NAME:ndx_jobset_dsi TYPE:INDEX TABLE_NAME:JOBSET CHANGE:CREATE      
CREATE INDEX ndx_jobset_dsi
ON JOBSET (delete_session_id,delete_date)

go

print 'Creating index ndx_jobsvc_logical_type_key on table JOBSVC'

--METADATA NAME:ndx_jobsvc_logical_type_key TYPE:INDEX TABLE_NAME:JOBSVC CHANGE:CREATE      
CREATE INDEX ndx_jobsvc_logical_type_key
ON JOBSVC (job_type,job_type_key,status_code)

go

print 'Creating index ndx_leantask_task_id on table LEANTASK'

--METADATA NAME:ndx_leantask_task_id TYPE:INDEX TABLE_NAME:LEANTASK CHANGE:CREATE      
CREATE INDEX ndx_leantask_task_id
ON LEANTASK (task_id)

go

print 'Creating index ndx_leantask_proj_id on table LEANTASK'

--METADATA NAME:ndx_leantask_proj_id TYPE:INDEX TABLE_NAME:LEANTASK CHANGE:CREATE      
CREATE INDEX ndx_leantask_proj_id
ON LEANTASK (proj_id)

go

print 'Creating index ndx_leantask_dsi on table LEANTASK'

--METADATA NAME:ndx_leantask_dsi TYPE:INDEX TABLE_NAME:LEANTASK CHANGE:CREATE      
CREATE INDEX ndx_leantask_dsi
ON LEANTASK (delete_session_id,delete_date)

go

print 'Creating index ndx_mtxscrtyp_scoretype on table MTXSCRTYP'

--METADATA NAME:ndx_mtxscrtyp_scoretype TYPE:INDEX TABLE_NAME:MTXSCRTYP CHANGE:CREATE      
CREATE INDEX ndx_mtxscrtyp_scoretype
ON MTXSCRTYP (scoretype_id)

go

print 'Creating index ndx_paudit_audit_ts on table PAUDIT'

--METADATA NAME:ndx_paudit_audit_ts TYPE:INDEX TABLE_NAME:PAUDIT CHANGE:CREATE      
CREATE INDEX ndx_paudit_audit_ts
ON PAUDIT (audit_ts)

go

print 'Creating index ndx_pauditx_audit_ts on table PAUDITX'

--METADATA NAME:ndx_pauditx_audit_ts TYPE:INDEX TABLE_NAME:PAUDITX CHANGE:CREATE      
CREATE INDEX ndx_pauditx_audit_ts
ON PAUDITX (audit_ts)

go

print 'Creating index ndx_pckeyxref_1 on table PC_KEY_XREF'

--METADATA NAME:ndx_pckeyxref_1 TYPE:INDEX TABLE_NAME:PC_KEY_XREF CHANGE:CREATE      
CREATE INDEX ndx_pckeyxref_1
ON PC_KEY_XREF (execution_id,ref_table,source_id)

go

print 'Creating index ndx_pc_process_stat_dsi on table PC_PROCESS_STAT'

--METADATA NAME:ndx_pc_process_stat_dsi TYPE:INDEX TABLE_NAME:PC_PROCESS_STAT CHANGE:CREATE      
CREATE INDEX ndx_pc_process_stat_dsi
ON PC_PROCESS_STAT (delete_session_id,delete_date)

go

print 'Creating index ndx_pc_process_stat_upd on table PC_PROCESS_STAT'

--METADATA NAME:ndx_pc_process_stat_upd TYPE:INDEX TABLE_NAME:PC_PROCESS_STAT CHANGE:CREATE      
CREATE INDEX ndx_pc_process_stat_upd
ON PC_PROCESS_STAT (update_date,delete_session_id)

go

print 'Creating index ndx_pc_process_stat_1 on table PC_PROCESS_STAT'

--METADATA NAME:ndx_pc_process_stat_1 TYPE:INDEX TABLE_NAME:PC_PROCESS_STAT CHANGE:CREATE      
CREATE INDEX ndx_pc_process_stat_1
ON PC_PROCESS_STAT (execution_id,process_name,step_name)

go

print 'Creating index ndx_prefer_currtype on table PREFER'

--METADATA NAME:ndx_prefer_currtype TYPE:INDEX TABLE_NAME:PREFER CHANGE:CREATE      
CREATE INDEX ndx_prefer_currtype
ON PREFER (curr_id)

go

print 'Creating index ndx_projcost_cbs on table PROJCOST'

--METADATA NAME:ndx_projcost_cbs TYPE:INDEX TABLE_NAME:PROJCOST CHANGE:CREATE      
CREATE INDEX ndx_projcost_cbs
ON PROJCOST (cbs_id)

go

print 'Creating index ndx_projdeplment_project on table PROJDEPLMENT'

--METADATA NAME:ndx_projdeplment_project TYPE:INDEX TABLE_NAME:PROJDEPLMENT CHANGE:CREATE      
CREATE INDEX ndx_projdeplment_project
ON PROJDEPLMENT (proj_id)

go

print 'Creating index ndx_projdeplment_gatewaydepl on table PROJDEPLMENT'

--METADATA NAME:ndx_projdeplment_gatewaydepl TYPE:INDEX TABLE_NAME:PROJDEPLMENT CHANGE:CREATE      
CREATE INDEX ndx_projdeplment_gatewaydepl
ON PROJDEPLMENT (deplmnt_id)

go

print 'Creating index ndx_project_location on table PROJECT'

--METADATA NAME:ndx_project_location TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE      
CREATE INDEX ndx_project_location
ON PROJECT (location_id)

go

print 'Creating index ndx_project_project_flag on table PROJECT'

--METADATA NAME:ndx_project_project_flag TYPE:INDEX TABLE_NAME:PROJECT CHANGE:CREATE      
CREATE INDEX ndx_project_project_flag
ON PROJECT (PROJECT_FLAG,ORIG_PROJ_ID,DELETE_SESSION_ID,PROJ_SHORT_NAME,PROJ_ID,FINTMPL_ID)

go

print 'Creating index ndx_projcodehier_type on table PROJECTCODEHIERARCHY'

--METADATA NAME:ndx_projcodehier_type TYPE:INDEX TABLE_NAME:PROJECTCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_projcodehier_type
ON PROJECTCODEHIERARCHY (codetypeobjectid)

go

print 'Creating index ndx_projcodehier_parent on table PROJECTCODEHIERARCHY'

--METADATA NAME:ndx_projcodehier_parent TYPE:INDEX TABLE_NAME:PROJECTCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_projcodehier_parent
ON PROJECTCODEHIERARCHY (parentcodevalueobjectid)

go

print 'Creating index ndx_projcodehier_child on table PROJECTCODEHIERARCHY'

--METADATA NAME:ndx_projcodehier_child TYPE:INDEX TABLE_NAME:PROJECTCODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_projcodehier_child
ON PROJECTCODEHIERARCHY (childcodevalueobjectid)

go

print 'Creating index ndx_projcostcbsspread_cost on table PROJECTCOSTCBSSPREAD'

--METADATA NAME:ndx_projcostcbsspread_cost TYPE:INDEX TABLE_NAME:PROJECTCOSTCBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_projcostcbsspread_cost
ON PROJECTCOSTCBSSPREAD (cost_type_id)

go

print 'Creating index ndx_projcostcbsspread_proj on table PROJECTCOSTCBSSPREAD'

--METADATA NAME:ndx_projcostcbsspread_proj TYPE:INDEX TABLE_NAME:PROJECTCOSTCBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_projcostcbsspread_proj
ON PROJECTCOSTCBSSPREAD (proj_id)

go

print 'Creating index ndx_projcostcbsspread_cbs on table PROJECTCOSTCBSSPREAD'

--METADATA NAME:ndx_projcostcbsspread_cbs TYPE:INDEX TABLE_NAME:PROJECTCOSTCBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_projcostcbsspread_cbs
ON PROJECTCOSTCBSSPREAD (cbs_id)

go

print 'Creating index ndx_pk_ProjectSecurity on table PROJECTSECURITY'

--METADATA NAME:ndx_pk_ProjectSecurity TYPE:INDEX TABLE_NAME:PROJECTSECURITY CHANGE:CREATE      
CREATE INDEX ndx_pk_ProjectSecurity
ON PROJECTSECURITY (rdbmsuserid,projectobjectid,costflag)

go

print 'Creating index ndx_projsec_projobjid on table PROJECTSECURITY'

--METADATA NAME:ndx_projsec_projobjid TYPE:INDEX TABLE_NAME:PROJECTSECURITY CHANGE:CREATE      
CREATE INDEX ndx_projsec_projobjid
ON PROJECTSECURITY (projectobjectid)

go

print 'Creating index ndx_projspread_objid on table PROJECTSPREAD'

--METADATA NAME:ndx_projspread_objid TYPE:INDEX TABLE_NAME:PROJECTSPREAD CHANGE:CREATE      
CREATE INDEX ndx_projspread_objid
ON PROJECTSPREAD (objectid,startdate)

go

print 'Creating index ndx_projspread_parentepsid on table PROJECTSPREAD'

--METADATA NAME:ndx_projspread_parentepsid TYPE:INDEX TABLE_NAME:PROJECTSPREAD CHANGE:CREATE      
CREATE INDEX ndx_projspread_parentepsid
ON PROJECTSPREAD (parentepsobjectid)

go

print 'Creating index ndx_projspread_obsid on table PROJECTSPREAD'

--METADATA NAME:ndx_projspread_obsid TYPE:INDEX TABLE_NAME:PROJECTSPREAD CHANGE:CREATE      
CREATE INDEX ndx_projspread_obsid
ON PROJECTSPREAD (obsobjectid)

go

print 'Creating index ndx_project_etl_list_project on table PROJECT_ETL_LIST'

--METADATA NAME:ndx_project_etl_list_project TYPE:INDEX TABLE_NAME:PROJECT_ETL_LIST CHANGE:CREATE      
CREATE INDEX ndx_project_etl_list_project
ON PROJECT_ETL_LIST (proj_id)

go

print 'Creating index ndx_projpcat_project on table PROJPCAT'

--METADATA NAME:ndx_projpcat_project TYPE:INDEX TABLE_NAME:PROJPCAT CHANGE:CREATE      
CREATE INDEX ndx_projpcat_project
ON PROJPCAT (DELETE_SESSION_ID,PROJ_ID,PROJ_CATG_TYPE_ID)

go

print 'Creating index ndx_projrisk_obs on table PROJRISK'

--METADATA NAME:ndx_projrisk_obs TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:CREATE      
CREATE INDEX ndx_projrisk_obs
ON PROJRISK (obs_id)

go

print 'Creating index ndx_projrisk_projwbs on table PROJRISK'

--METADATA NAME:ndx_projrisk_projwbs TYPE:INDEX TABLE_NAME:PROJRISK CHANGE:CREATE      
CREATE INDEX ndx_projrisk_projwbs
ON PROJRISK (wbs_id)

go

print 'Creating index ndx_projset_dsi on table PROJSET'

--METADATA NAME:ndx_projset_dsi TYPE:INDEX TABLE_NAME:PROJSET CHANGE:CREATE      
CREATE INDEX ndx_projset_dsi
ON PROJSET (delete_session_id,delete_date)

go

print 'Creating index ndx_projset_project on table PROJSET'

--METADATA NAME:ndx_projset_project TYPE:INDEX TABLE_NAME:PROJSET CHANGE:CREATE      
CREATE INDEX ndx_projset_project
ON PROJSET (proj_id)

go

print 'Creating index ndx_projshar_proj_id on table PROJSHAR'

--METADATA NAME:ndx_projshar_proj_id TYPE:INDEX TABLE_NAME:PROJSHAR CHANGE:CREATE      
CREATE INDEX ndx_projshar_proj_id
ON PROJSHAR (proj_id)

go

print 'Creating index ndx_projwbs_status_code on table PROJWBS'

--METADATA NAME:ndx_projwbs_status_code TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:CREATE      
CREATE INDEX ndx_projwbs_status_code
ON PROJWBS (proj_id,status_code,delete_session_id)

go

print 'Creating index ndx_release_name on table RELEASE'

--METADATA NAME:ndx_release_name TYPE:INDEX TABLE_NAME:RELEASE CHANGE:CREATE      
CREATE INDEX ndx_release_name
ON RELEASE (release_name,release_id)

go

print 'Creating index ndx_reliter_iteration on table RELITER'

--METADATA NAME:ndx_reliter_iteration TYPE:INDEX TABLE_NAME:RELITER CHANGE:CREATE      
CREATE INDEX ndx_reliter_iteration
ON RELITER (iteration_id,release_id)

go

print 'Creating index ndx_relproj_project on table RELPROJ'

--METADATA NAME:ndx_relproj_project TYPE:INDEX TABLE_NAME:RELPROJ CHANGE:CREATE      
CREATE INDEX ndx_relproj_project
ON RELPROJ (proj_id,release_id)

go

print 'Creating index ndx_rascbsspread_rsrc on table RESOURCEASSIGNMENTCBSSPREAD'

--METADATA NAME:ndx_rascbsspread_rsrc TYPE:INDEX TABLE_NAME:RESOURCEASSIGNMENTCBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_rascbsspread_rsrc
ON RESOURCEASSIGNMENTCBSSPREAD (rsrc_id)

go

print 'Creating index ndx_rascbsspread_proj on table RESOURCEASSIGNMENTCBSSPREAD'

--METADATA NAME:ndx_rascbsspread_proj TYPE:INDEX TABLE_NAME:RESOURCEASSIGNMENTCBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_rascbsspread_proj
ON RESOURCEASSIGNMENTCBSSPREAD (proj_id)

go

print 'Creating index ndx_rascbsspread_cbs on table RESOURCEASSIGNMENTCBSSPREAD'

--METADATA NAME:ndx_rascbsspread_cbs TYPE:INDEX TABLE_NAME:RESOURCEASSIGNMENTCBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_rascbsspread_cbs
ON RESOURCEASSIGNMENTCBSSPREAD (cbs_id)

go

print 'Creating index idx_comp_rsrcasgnmntcbssprd on table RESOURCEASSIGNMENTCBSSPREAD'

--METADATA NAME:idx_comp_rsrcasgnmntcbssprd TYPE:INDEX TABLE_NAME:RESOURCEASSIGNMENTCBSSPREAD CHANGE:CREATE      
CREATE INDEX idx_comp_rsrcasgnmntcbssprd
ON RESOURCEASSIGNMENTCBSSPREAD (proj_id,rsrc_id,cbs_id,spread_date)

go

print 'Creating index ndx_raspread_project on table RESOURCEASSIGNMENTSPREAD'

--METADATA NAME:ndx_raspread_project TYPE:INDEX TABLE_NAME:RESOURCEASSIGNMENTSPREAD CHANGE:CREATE      
CREATE INDEX ndx_raspread_project
ON RESOURCEASSIGNMENTSPREAD (projectobjectid,startdate)

go

print 'Creating index ndx_raspread on table RESOURCEASSIGNMENTSPREAD'

--METADATA NAME:ndx_raspread TYPE:INDEX TABLE_NAME:RESOURCEASSIGNMENTSPREAD CHANGE:CREATE      
CREATE INDEX ndx_raspread
ON RESOURCEASSIGNMENTSPREAD (activityobjectid,startdate)

go

print 'Creating index ndx_raspread_objid on table RESOURCEASSIGNMENTSPREAD'

--METADATA NAME:ndx_raspread_objid TYPE:INDEX TABLE_NAME:RESOURCEASSIGNMENTSPREAD CHANGE:CREATE      
CREATE INDEX ndx_raspread_objid
ON RESOURCEASSIGNMENTSPREAD (resourceassignmentobjectid,startdate)

go

print 'Creating index ndx_raspread_rsrcobjid on table RESOURCEASSIGNMENTSPREAD'

--METADATA NAME:ndx_raspread_rsrcobjid TYPE:INDEX TABLE_NAME:RESOURCEASSIGNMENTSPREAD CHANGE:CREATE      
CREATE INDEX ndx_raspread_rsrcobjid
ON RESOURCEASSIGNMENTSPREAD (resourceobjectid,startdate)

go

print 'Creating index ndx_rsrccodehier_type on table RESOURCECODEHIERARCHY'

--METADATA NAME:ndx_rsrccodehier_type TYPE:INDEX TABLE_NAME:RESOURCECODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_rsrccodehier_type
ON RESOURCECODEHIERARCHY (codetypeobjectid)

go

print 'Creating index ndx_rsrccodehier_parent on table RESOURCECODEHIERARCHY'

--METADATA NAME:ndx_rsrccodehier_parent TYPE:INDEX TABLE_NAME:RESOURCECODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_rsrccodehier_parent
ON RESOURCECODEHIERARCHY (parentcodevalueobjectid)

go

print 'Creating index ndx_rsrccodehier_child on table RESOURCECODEHIERARCHY'

--METADATA NAME:ndx_rsrccodehier_child TYPE:INDEX TABLE_NAME:RESOURCECODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_rsrccodehier_child
ON RESOURCECODEHIERARCHY (childcodevalueobjectid)

go

print 'Creating index ndx_rsrchier_parentobj on table RESOURCEHIERARCHY'

--METADATA NAME:ndx_rsrchier_parentobj TYPE:INDEX TABLE_NAME:RESOURCEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_rsrchier_parentobj
ON RESOURCEHIERARCHY (parentobjectid,childobjectid)

go

print 'Creating index ndx_rsrchier_parent on table RESOURCEHIERARCHY'

--METADATA NAME:ndx_rsrchier_parent TYPE:INDEX TABLE_NAME:RESOURCEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_rsrchier_parent
ON RESOURCEHIERARCHY (parentid)

go

print 'Creating index ndx_rsrchier_child on table RESOURCEHIERARCHY'

--METADATA NAME:ndx_rsrchier_child TYPE:INDEX TABLE_NAME:RESOURCEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_rsrchier_child
ON RESOURCEHIERARCHY (childobjectid,parentobjectid)

go

print 'Creating index ndx_risk_project on table RISK'

--METADATA NAME:ndx_risk_project TYPE:INDEX TABLE_NAME:RISK CHANGE:CREATE      
CREATE INDEX ndx_risk_project
ON RISK (proj_id)

go

print 'Creating index ndx_risk_rsrc on table RISK'

--METADATA NAME:ndx_risk_rsrc TYPE:INDEX TABLE_NAME:RISK CHANGE:CREATE      
CREATE INDEX ndx_risk_rsrc
ON RISK (rsrc_id)

go

print 'Creating index ndx_riskimpact_project on table RISKIMPACT'

--METADATA NAME:ndx_riskimpact_project TYPE:INDEX TABLE_NAME:RISKIMPACT CHANGE:CREATE      
CREATE INDEX ndx_riskimpact_project
ON RISKIMPACT (proj_id)

go

print 'Creating index ndx_riskimpact_scoretype on table RISKIMPACT'

--METADATA NAME:ndx_riskimpact_scoretype TYPE:INDEX TABLE_NAME:RISKIMPACT CHANGE:CREATE      
CREATE INDEX ndx_riskimpact_scoretype
ON RISKIMPACT (scoretype_id)

go

print 'Creating index ndx_riskmit_response on table RISKMIT'

--METADATA NAME:ndx_riskmit_response TYPE:INDEX TABLE_NAME:RISKMIT CHANGE:CREATE      
CREATE INDEX ndx_riskmit_response
ON RISKMIT (response_id)

go

print 'Creating index ndx_riskmit_task on table RISKMIT'

--METADATA NAME:ndx_riskmit_task TYPE:INDEX TABLE_NAME:RISKMIT CHANGE:CREATE      
CREATE INDEX ndx_riskmit_task
ON RISKMIT (task_id)

go

print 'Creating index ndx_riskmit_project on table RISKMIT'

--METADATA NAME:ndx_riskmit_project TYPE:INDEX TABLE_NAME:RISKMIT CHANGE:CREATE      
CREATE INDEX ndx_riskmit_project
ON RISKMIT (proj_id)

go

print 'Creating index ndx_riskmitimp_proj on table RISKMITIMP'

--METADATA NAME:ndx_riskmitimp_proj TYPE:INDEX TABLE_NAME:RISKMITIMP CHANGE:CREATE      
CREATE INDEX ndx_riskmitimp_proj
ON RISKMITIMP (proj_id)

go

print 'Creating index ndx_riskmitimp_scoretype on table RISKMITIMP'

--METADATA NAME:ndx_riskmitimp_scoretype TYPE:INDEX TABLE_NAME:RISKMITIMP CHANGE:CREATE      
CREATE INDEX ndx_riskmitimp_scoretype
ON RISKMITIMP (scoretype_id)

go

print 'Creating index ndx_riskmtxscr_matrix on table RISKMTXSCR'

--METADATA NAME:ndx_riskmtxscr_matrix TYPE:INDEX TABLE_NAME:RISKMTXSCR CHANGE:CREATE      
CREATE INDEX ndx_riskmtxscr_matrix
ON RISKMTXSCR (matrix_id)

go

print 'Creating index ndx_riskrsppln_risk on table RISKRSPPLN'

--METADATA NAME:ndx_riskrsppln_risk TYPE:INDEX TABLE_NAME:RISKRSPPLN CHANGE:CREATE      
CREATE INDEX ndx_riskrsppln_risk
ON RISKRSPPLN (risk_id)

go

print 'Creating index ndx_riskrsppln_project on table RISKRSPPLN'

--METADATA NAME:ndx_riskrsppln_project TYPE:INDEX TABLE_NAME:RISKRSPPLN CHANGE:CREATE      
CREATE INDEX ndx_riskrsppln_project
ON RISKRSPPLN (proj_id)

go

print 'Creating index ndx_riskscrthr_type on table RISKSCRTHR'

--METADATA NAME:ndx_riskscrthr_type TYPE:INDEX TABLE_NAME:RISKSCRTHR CHANGE:CREATE      
CREATE INDEX ndx_riskscrthr_type
ON RISKSCRTHR (scoretype_id)

go

print 'Creating index ndx_rolecodehier_type on table ROLECODEHIERARCHY'

--METADATA NAME:ndx_rolecodehier_type TYPE:INDEX TABLE_NAME:ROLECODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_rolecodehier_type
ON ROLECODEHIERARCHY (codetypeobjectid)

go

print 'Creating index ndx_rolecodehier_parent on table ROLECODEHIERARCHY'

--METADATA NAME:ndx_rolecodehier_parent TYPE:INDEX TABLE_NAME:ROLECODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_rolecodehier_parent
ON ROLECODEHIERARCHY (parentcodevalueobjectid)

go

print 'Creating index ndx_rolecodehier_child on table ROLECODEHIERARCHY'

--METADATA NAME:ndx_rolecodehier_child TYPE:INDEX TABLE_NAME:ROLECODEHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_rolecodehier_child
ON ROLECODEHIERARCHY (childcodevalueobjectid)

go

print 'Creating index ndx_rpt_users on table RPT'

--METADATA NAME:ndx_rpt_users TYPE:INDEX TABLE_NAME:RPT CHANGE:CREATE      
CREATE INDEX ndx_rpt_users
ON RPT (user_id)

go

print 'Creating index ndx_rsrc_location on table RSRC'

--METADATA NAME:ndx_rsrc_location TYPE:INDEX TABLE_NAME:RSRC CHANGE:CREATE      
CREATE INDEX ndx_rsrc_location
ON RSRC (location_id)

go

print 'Creating index ndx_rsrcloc_rsrc on table RSRCLOC'

--METADATA NAME:ndx_rsrcloc_rsrc TYPE:INDEX TABLE_NAME:RSRCLOC CHANGE:CREATE      
CREATE INDEX ndx_rsrcloc_rsrc
ON RSRCLOC (rsrc_id)

go

print 'Creating index ndx_rsrcoveralloc_rsrc_id on table RSRCOVERALLOC'

--METADATA NAME:ndx_rsrcoveralloc_rsrc_id TYPE:INDEX TABLE_NAME:RSRCOVERALLOC CHANGE:CREATE      
CREATE INDEX ndx_rsrcoveralloc_rsrc_id
ON RSRCOVERALLOC (rsrc_id)

go

print 'Creating index ndx_rsrcoveralloc_role_id on table RSRCOVERALLOC'

--METADATA NAME:ndx_rsrcoveralloc_role_id TYPE:INDEX TABLE_NAME:RSRCOVERALLOC CHANGE:CREATE      
CREATE INDEX ndx_rsrcoveralloc_role_id
ON RSRCOVERALLOC (role_id)

go

print 'Creating index ndx_rsrcroleasgnmntsprd_proj_id on table RSRCROLEASGNMENTSPREAD'

--METADATA NAME:ndx_rsrcroleasgnmntsprd_proj_id TYPE:INDEX TABLE_NAME:RSRCROLEASGNMENTSPREAD CHANGE:CREATE      
CREATE INDEX ndx_rsrcroleasgnmntsprd_proj_id
ON RSRCROLEASGNMENTSPREAD (proj_id)

go

print 'Creating index ndx_snapgroup_name on table SNAPGROUP'

--METADATA NAME:ndx_snapgroup_name TYPE:INDEX TABLE_NAME:SNAPGROUP CHANGE:CREATE      
CREATE INDEX ndx_snapgroup_name
ON SNAPGROUP (snap_group_name,snap_group_id)

go

print 'Creating index ndx_snapgroup_dsi on table SNAPGROUP'

--METADATA NAME:ndx_snapgroup_dsi TYPE:INDEX TABLE_NAME:SNAPGROUP CHANGE:CREATE      
CREATE INDEX ndx_snapgroup_dsi
ON SNAPGROUP (delete_session_id,delete_date)

go

print 'Creating index ndx_snapproj_project on table SNAPPROJ'

--METADATA NAME:ndx_snapproj_project TYPE:INDEX TABLE_NAME:SNAPPROJ CHANGE:CREATE      
CREATE INDEX ndx_snapproj_project
ON SNAPPROJ (proj_id,snap_group_id)

go

print 'Creating index ndx_snapshot_name on table SNAPSHOT'

--METADATA NAME:ndx_snapshot_name TYPE:INDEX TABLE_NAME:SNAPSHOT CHANGE:CREATE      
CREATE INDEX ndx_snapshot_name
ON SNAPSHOT (snapshot_name,snapshot_id)

go

print 'Creating index ndx_snapshot_group on table SNAPSHOT'

--METADATA NAME:ndx_snapshot_group TYPE:INDEX TABLE_NAME:SNAPSHOT CHANGE:CREATE      
CREATE INDEX ndx_snapshot_group
ON SNAPSHOT (snap_group_id)

go

print 'Creating index ndx_snapshot_dsi on table SNAPSHOT'

--METADATA NAME:ndx_snapshot_dsi TYPE:INDEX TABLE_NAME:SNAPSHOT CHANGE:CREATE      
CREATE INDEX ndx_snapshot_dsi
ON SNAPSHOT (delete_session_id,delete_date)

go

print 'Creating index ndx_sumtrsrc_role on table SUMTRSRC'

--METADATA NAME:ndx_sumtrsrc_role TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE      
CREATE INDEX ndx_sumtrsrc_role
ON SUMTRSRC (role_id)

go

print 'Creating index ndx_sumtrsrc_perf on table SUMTRSRC'

--METADATA NAME:ndx_sumtrsrc_perf TYPE:INDEX TABLE_NAME:SUMTRSRC CHANGE:CREATE      
CREATE INDEX ndx_sumtrsrc_perf
ON SUMTRSRC (role_id,spread_type)

go

print 'Creating index ndx_task_cbs on table TASK'

--METADATA NAME:ndx_task_cbs TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE      
CREATE INDEX ndx_task_cbs
ON TASK (cbs_id)

go

print 'Creating index ndx_task_code on table TASK'

--METADATA NAME:ndx_task_code TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE      
CREATE INDEX ndx_task_code
ON TASK (proj_id,task_code)

go

print 'Creating index ndx_task_update_date on table TASK'

--METADATA NAME:ndx_task_update_date TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE      
CREATE INDEX ndx_task_update_date
ON TASK (proj_id,update_date,task_id,delete_session_id)

go

print 'Creating index ndx_task_location on table TASK'

--METADATA NAME:ndx_task_location TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE      
CREATE INDEX ndx_task_location
ON TASK (location_id)

go

print 'Creating index ndx_task_upd on table TASK'

--METADATA NAME:ndx_task_upd TYPE:INDEX TABLE_NAME:TASK CHANGE:CREATE      
CREATE INDEX ndx_task_upd
ON TASK (update_date,delete_session_id,proj_id)

go

print 'Creating index ndx_taskactv_upd on table TASKACTV'

--METADATA NAME:ndx_taskactv_upd TYPE:INDEX TABLE_NAME:TASKACTV CHANGE:CREATE      
CREATE INDEX ndx_taskactv_upd
ON TASKACTV (update_date,delete_session_id,proj_id)

go

print 'Creating index ndx_taskcbsx_project on table TASKCBSX'

--METADATA NAME:ndx_taskcbsx_project TYPE:INDEX TABLE_NAME:TASKCBSX CHANGE:CREATE      
CREATE INDEX ndx_taskcbsx_project
ON TASKCBSX (proj_id)

go

print 'Creating index ndx_taskcbsx_cbs on table TASKCBSX'

--METADATA NAME:ndx_taskcbsx_cbs TYPE:INDEX TABLE_NAME:TASKCBSX CHANGE:CREATE      
CREATE INDEX ndx_taskcbsx_cbs
ON TASKCBSX (cbs_id)

go

print 'Creating index ndx_taskpred_plus_update_date on table TASKPRED'

--METADATA NAME:ndx_taskpred_plus_update_date TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:CREATE      
CREATE INDEX ndx_taskpred_plus_update_date
ON TASKPRED (update_date,proj_id,pred_proj_id,delete_session_id)

go

print 'Creating index ndx_taskrsrc_cbs on table TASKRSRC'

--METADATA NAME:ndx_taskrsrc_cbs TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE      
CREATE INDEX ndx_taskrsrc_cbs
ON TASKRSRC (cbs_id)

go

print 'Creating index ndx_taskrsrc_plus_update_date on table TASKRSRC'

--METADATA NAME:ndx_taskrsrc_plus_update_date TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:CREATE      
CREATE INDEX ndx_taskrsrc_plus_update_date
ON TASKRSRC (update_date,proj_id,delete_session_id)

go

print 'Creating index ndx_wbshier_parentobj on table WBSHIERARCHY'

--METADATA NAME:ndx_wbshier_parentobj TYPE:INDEX TABLE_NAME:WBSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_wbshier_parentobj
ON WBSHIERARCHY (parentobjectid)

go

print 'Creating index ndx_wbshier_parent on table WBSHIERARCHY'

--METADATA NAME:ndx_wbshier_parent TYPE:INDEX TABLE_NAME:WBSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_wbshier_parent
ON WBSHIERARCHY (parentid)

go

print 'Creating index ndx_wbshier_childobj on table WBSHIERARCHY'

--METADATA NAME:ndx_wbshier_childobj TYPE:INDEX TABLE_NAME:WBSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_wbshier_childobj
ON WBSHIERARCHY (childobjectid)

go

print 'Creating index ndx_wbshier_parentprojid on table WBSHIERARCHY'

--METADATA NAME:ndx_wbshier_parentprojid TYPE:INDEX TABLE_NAME:WBSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_wbshier_parentprojid
ON WBSHIERARCHY (parentprojectid)

go

print 'Creating index ndx_wbshier_childprojid on table WBSHIERARCHY'

--METADATA NAME:ndx_wbshier_childprojid TYPE:INDEX TABLE_NAME:WBSHIERARCHY CHANGE:CREATE      
CREATE INDEX ndx_wbshier_childprojid
ON WBSHIERARCHY (childprojectid)

go

print 'Creating index ndx_uk_wbsreviewers on table WBSREVIEWERS'

--METADATA NAME:ndx_uk_wbsreviewers TYPE:INDEX TABLE_NAME:WBSREVIEWERS CHANGE:CREATE      
CREATE UNIQUE INDEX ndx_uk_wbsreviewers
ON WBSREVIEWERS (wbs_id,status_reviewer)

go

print 'Creating index ndx_uk_wbsreviewstatus on table WBSREVIEWSTATUS'

--METADATA NAME:ndx_uk_wbsreviewstatus TYPE:INDEX TABLE_NAME:WBSREVIEWSTATUS CHANGE:CREATE      
CREATE UNIQUE INDEX ndx_uk_wbsreviewstatus
ON WBSREVIEWSTATUS (wbs_id,status_reviewer,fk_id,table_name)

go

print 'Creating index ndx_wbsspread_objid on table WBSSPREAD'

--METADATA NAME:ndx_wbsspread_objid TYPE:INDEX TABLE_NAME:WBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_wbsspread_objid
ON WBSSPREAD (objectid,startdate)

go

print 'Creating index ndx_wbsspread_parentobjid on table WBSSPREAD'

--METADATA NAME:ndx_wbsspread_parentobjid TYPE:INDEX TABLE_NAME:WBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_wbsspread_parentobjid
ON WBSSPREAD (parentobjectid)

go

print 'Creating index ndx_wbsspread_obsid on table WBSSPREAD'

--METADATA NAME:ndx_wbsspread_obsid TYPE:INDEX TABLE_NAME:WBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_wbsspread_obsid
ON WBSSPREAD (obsobjectid)

go

print 'Creating index ndx_wbsspread_projid on table WBSSPREAD'

--METADATA NAME:ndx_wbsspread_projid TYPE:INDEX TABLE_NAME:WBSSPREAD CHANGE:CREATE      
CREATE INDEX ndx_wbsspread_projid
ON WBSSPREAD (projectobjectid,startdate)

go

print 'Creating index ndx_wrk_log_results on table WRK_LOG_RESULTS'

--METADATA NAME:ndx_wrk_log_results TYPE:INDEX TABLE_NAME:WRK_LOG_RESULTS CHANGE:CREATE      
CREATE INDEX ndx_wrk_log_results
ON WRK_LOG_RESULTS (spid,seq_num)

go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ACTVCODEX_actv_code_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ACTVCODEX_actv_code_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ADDTASKPROC_proc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ADDTASKPROC_proc_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ADDTASKPROCX_proc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ADDTASKPROCX_proc_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ADDTRSRC_addtrsrc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ADDTRSRC_addtrsrc_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ALERT_alert_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ALERT_alert_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ANNOUNCEMENT_announcement_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ANNOUNCEMENT_announcement_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ASGNMNTCATVALX_asgnmnt_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ASGNMNTCATVALX_asgnmnt_catg_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ATTR_MASTER_attr_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ATTR_MASTER_attr_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('AUTOVUE_ATTR_property_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('AUTOVUE_ATTR_property_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('BUDGCHNGX_budg_chng_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('BUDGCHNGX_budg_chng_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('CBS_cbs_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('CBS_cbs_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('CHGHEAD_transaction_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('CHGHEAD_transaction_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('CURRTYPEX_curr_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('CURRTYPEX_curr_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DBERRLOG_log_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DBERRLOG_log_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DM_ATTR_dm_attr_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DM_ATTR_dm_attr_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOC_doc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOC_doc_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOCUMENTX_doc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOCUMENTX_doc_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOCUMENT_MAPPER_doc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOCUMENT_MAPPER_doc_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOC_FOLDER_doc_folder_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOC_FOLDER_doc_folder_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOC_RECENT_doc_recent_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOC_RECENT_doc_recent_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('DOC_VERSION_doc_version_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('DOC_VERSION_doc_version_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('GATEWAYDEPLOYMENT_deplmnt_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('GATEWAYDEPLOYMENT_deplmnt_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('GATEWAYPROVIDER_provider_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('GATEWAYPROVIDER_provider_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('GATEWAYSYNCACTION_action_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('GATEWAYSYNCACTION_action_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('GREPLACE_greplace_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('GREPLACE_greplace_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('LEANTASK_lean_task_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('LEANTASK_lean_task_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PCATVALX_proj_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PCATVALX_proj_catg_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PFOLIOX_pfolio_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PFOLIOX_pfolio_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PLPROJREF_proj_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PLPROJREF_proj_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PROJCOSTX_cost_item_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PROJCOSTX_cost_item_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PROJDEPLMENT_proj_deplmnt_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PROJDEPLMENT_proj_deplmnt_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PROJECTX_proj_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PROJECTX_proj_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PROJECT_ETL_LIST_etl_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PROJECT_ETL_LIST_etl_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PROJFUNDX_proj_fund_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PROJFUNDX_proj_fund_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PROJISSUX_issue_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PROJISSUX_issue_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PROJWBSX_wbs_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PROJWBSX_wbs_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('PXJOBRUN_jobrun_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PXJOBRUN_jobrun_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RCATVALX_rsrc_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RCATVALX_rsrc_catg_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RFOLIOX_rfolio_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RFOLIOX_rfolio_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISK_risk_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISK_risk_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISKMIT_mitigation_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISKMIT_mitigation_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISKMITX_mitigation_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISKMITX_mitigation_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISKMTXSCR_score_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISKMTXSCR_score_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISKRSPPLN_response_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISKRSPPLN_response_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISKRSPPLNX_response_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISKRSPPLNX_response_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISKSCRMTX_matrix_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISKSCRMTX_matrix_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISKSCRTHR_threshold_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISKSCRTHR_threshold_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISKSCRTYP_scoretype_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISKSCRTYP_scoretype_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RISKX_risk_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RISKX_risk_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RLFOLIOX_rlfolio_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RLFOLIOX_rlfolio_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ROLECATVALX_role_catg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ROLECATVALX_role_catg_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('ROLERATEX_role_rate_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('ROLERATEX_role_rate_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RSRCCURVX_curv_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RSRCCURVX_curv_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RSRCHOURX_rsrc_hr_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RSRCHOURX_rsrc_hr_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RSRCLOC_rsrc_loc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RSRCLOC_rsrc_loc_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RSRCRATEX_rsrc_rate_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RSRCRATEX_rsrc_rate_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('RSRCX_rsrc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('RSRCX_rsrc_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('SNAPGROUP_snap_group_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('SNAPGROUP_snap_group_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('SNAPSHOT_snapshot_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('SNAPSHOT_snapshot_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TASKDOCX_taskdoc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TASKDOCX_taskdoc_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TASKMEMOX_memo_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TASKMEMOX_memo_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TASKPREDX_task_pred_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TASKPREDX_task_pred_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TASKPROCX_proc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TASKPROCX_proc_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TASKRSRCX_taskrsrc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TASKRSRCX_taskrsrc_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TASKX_task_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TASKX_task_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('TRACKOFFLINEUSER_trackofflineuser_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('TRACKOFFLINEUSER_trackofflineuser_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('UDFCODEX_udf_code_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('UDFCODEX_udf_code_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('USERSX_user_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('USERSX_user_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('WBSBUDGX_wbs_budg_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('WBSBUDGX_wbs_budg_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('WBSMEMOX_wbs_memo_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('WBSMEMOX_wbs_memo_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('WBSREVIEWERS_wbsreviewers_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('WBSREVIEWERS_wbsreviewers_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('WBSREVIEWSTATUS_wbsreviewstatus_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('WBSREVIEWSTATUS_wbsreviewstatus_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('WBSRSRCX_wbsrsrc_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('WBSRSRCX_wbsrsrc_id')) 
go

--METADATA  TYPE:ADHOC_SQL 
insert into nextkey select  lower('WBSSTEPX_wbs_step_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('WBSSTEPX_wbs_step_id')) 
go

--EPPM Base Upgrade Scripts
SET QUOTED_IDENTIFIER ON

print 'Dropping index ndx_iteration_release on table ITERATION'

--METADATA NAME:ndx_iteration_release TYPE:INDEX TABLE_NAME:ITERATION CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_iteration_release')	  
if @indexists >= 1
DROP INDEX ITERATION.ndx_iteration_release;
      go

print 'Dropping constraint fk_iteration_release on table ITERATION'


--METADATA NAME:fk_iteration_release TYPE:CONSTRAINT TABLE_NAME:ITERATION CHANGE:DROP
declare @consexists int  , @ispk int, @vtablename varchar(30), @vconsname varchar(30)
declare @refconscur CURSOR 
SET @refconscur = CURSOR for
select t.name,r.name from sys.foreign_keys r,sys.objects o,sys.tables t 
where r.referenced_object_id= o.parent_object_id and upper(o.name)= upper('fk_iteration_release') and r.parent_object_id=t.object_id

SELECT @consexists=count(*) FROM sys.objects WHERE upper(name) = upper('fk_iteration_release') and type_desc LIKE '%CONSTRAINT'  
SELECT @ispk=count(*) FROM sys.objects WHERE upper(name) = upper('fk_iteration_release') and type_desc LIKE '%CONSTRAINT' and type ='PK'
if  @ispk > 0
 begin
   OPEN @refconscur
   FETCH @refconscur INTO @vtablename,@vconsname
   WHILE @@FETCH_STATUS = 0
    BEGIN
	  EXEC ('ALTER TABLE '+ @vtablename+ ' DROP CONSTRAINT '+ @vconsname);
      FETCH @refconscur INTO @vtablename,@vconsname
    END
  CLOSE @refconscur
  DEALLOCATE  @refconscur 
 end 
if @consexists >=1 
ALTER TABLE ITERATION DROP CONSTRAINT fk_iteration_release;
go

print 'Dropping index ndx_iterdays_project on table ITERDAYS'

--METADATA NAME:ndx_iterdays_project TYPE:INDEX TABLE_NAME:ITERDAYS CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_iterdays_project')	  
if @indexists >= 1
DROP INDEX ITERDAYS.ndx_iterdays_project;
      go

print 'Dropping index ndx_iterdays_iteration on table ITERDAYS'

--METADATA NAME:ndx_iterdays_iteration TYPE:INDEX TABLE_NAME:ITERDAYS CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_iterdays_iteration')	  
if @indexists >= 1
DROP INDEX ITERDAYS.ndx_iterdays_iteration;
      go

print 'Dropping index ndx_iterdays_task on table ITERDAYS'

--METADATA NAME:ndx_iterdays_task TYPE:INDEX TABLE_NAME:ITERDAYS CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_iterdays_task')	  
if @indexists >= 1
DROP INDEX ITERDAYS.ndx_iterdays_task;
      go

print 'Dropping index ndx_iterdays_dsi on table ITERDAYS'

--METADATA NAME:ndx_iterdays_dsi TYPE:INDEX TABLE_NAME:ITERDAYS CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_iterdays_dsi')	  
if @indexists >= 1
DROP INDEX ITERDAYS.ndx_iterdays_dsi;
      go

print 'Dropping constraint pk_iterdays on table ITERDAYS'


--METADATA NAME:pk_iterdays TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:DROP
declare @consexists int  , @ispk int, @vtablename varchar(30), @vconsname varchar(30)
declare @refconscur CURSOR 
SET @refconscur = CURSOR for
select t.name,r.name from sys.foreign_keys r,sys.objects o,sys.tables t 
where r.referenced_object_id= o.parent_object_id and upper(o.name)= upper('pk_iterdays') and r.parent_object_id=t.object_id

SELECT @consexists=count(*) FROM sys.objects WHERE upper(name) = upper('pk_iterdays') and type_desc LIKE '%CONSTRAINT'  
SELECT @ispk=count(*) FROM sys.objects WHERE upper(name) = upper('pk_iterdays') and type_desc LIKE '%CONSTRAINT' and type ='PK'
if  @ispk > 0
 begin
   OPEN @refconscur
   FETCH @refconscur INTO @vtablename,@vconsname
   WHILE @@FETCH_STATUS = 0
    BEGIN
	  EXEC ('ALTER TABLE '+ @vtablename+ ' DROP CONSTRAINT '+ @vconsname);
      FETCH @refconscur INTO @vtablename,@vconsname
    END
  CLOSE @refconscur
  DEALLOCATE  @refconscur 
 end 
if @consexists >=1 
ALTER TABLE ITERDAYS DROP CONSTRAINT pk_iterdays;
go

print 'Dropping constraint fk_iterdays_project on table ITERDAYS'


--METADATA NAME:fk_iterdays_project TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:DROP
declare @consexists int  , @ispk int, @vtablename varchar(30), @vconsname varchar(30)
declare @refconscur CURSOR 
SET @refconscur = CURSOR for
select t.name,r.name from sys.foreign_keys r,sys.objects o,sys.tables t 
where r.referenced_object_id= o.parent_object_id and upper(o.name)= upper('fk_iterdays_project') and r.parent_object_id=t.object_id

SELECT @consexists=count(*) FROM sys.objects WHERE upper(name) = upper('fk_iterdays_project') and type_desc LIKE '%CONSTRAINT'  
SELECT @ispk=count(*) FROM sys.objects WHERE upper(name) = upper('fk_iterdays_project') and type_desc LIKE '%CONSTRAINT' and type ='PK'
if  @ispk > 0
 begin
   OPEN @refconscur
   FETCH @refconscur INTO @vtablename,@vconsname
   WHILE @@FETCH_STATUS = 0
    BEGIN
	  EXEC ('ALTER TABLE '+ @vtablename+ ' DROP CONSTRAINT '+ @vconsname);
      FETCH @refconscur INTO @vtablename,@vconsname
    END
  CLOSE @refconscur
  DEALLOCATE  @refconscur 
 end 
if @consexists >=1 
ALTER TABLE ITERDAYS DROP CONSTRAINT fk_iterdays_project;
go

print 'Dropping constraint fk_iterdays_iteration on table ITERDAYS'


--METADATA NAME:fk_iterdays_iteration TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:DROP
declare @consexists int  , @ispk int, @vtablename varchar(30), @vconsname varchar(30)
declare @refconscur CURSOR 
SET @refconscur = CURSOR for
select t.name,r.name from sys.foreign_keys r,sys.objects o,sys.tables t 
where r.referenced_object_id= o.parent_object_id and upper(o.name)= upper('fk_iterdays_iteration') and r.parent_object_id=t.object_id

SELECT @consexists=count(*) FROM sys.objects WHERE upper(name) = upper('fk_iterdays_iteration') and type_desc LIKE '%CONSTRAINT'  
SELECT @ispk=count(*) FROM sys.objects WHERE upper(name) = upper('fk_iterdays_iteration') and type_desc LIKE '%CONSTRAINT' and type ='PK'
if  @ispk > 0
 begin
   OPEN @refconscur
   FETCH @refconscur INTO @vtablename,@vconsname
   WHILE @@FETCH_STATUS = 0
    BEGIN
	  EXEC ('ALTER TABLE '+ @vtablename+ ' DROP CONSTRAINT '+ @vconsname);
      FETCH @refconscur INTO @vtablename,@vconsname
    END
  CLOSE @refconscur
  DEALLOCATE  @refconscur 
 end 
if @consexists >=1 
ALTER TABLE ITERDAYS DROP CONSTRAINT fk_iterdays_iteration;
go

print 'Dropping constraint fk_iterdays_task on table ITERDAYS'


--METADATA NAME:fk_iterdays_task TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:DROP
declare @consexists int  , @ispk int, @vtablename varchar(30), @vconsname varchar(30)
declare @refconscur CURSOR 
SET @refconscur = CURSOR for
select t.name,r.name from sys.foreign_keys r,sys.objects o,sys.tables t 
where r.referenced_object_id= o.parent_object_id and upper(o.name)= upper('fk_iterdays_task') and r.parent_object_id=t.object_id

SELECT @consexists=count(*) FROM sys.objects WHERE upper(name) = upper('fk_iterdays_task') and type_desc LIKE '%CONSTRAINT'  
SELECT @ispk=count(*) FROM sys.objects WHERE upper(name) = upper('fk_iterdays_task') and type_desc LIKE '%CONSTRAINT' and type ='PK'
if  @ispk > 0
 begin
   OPEN @refconscur
   FETCH @refconscur INTO @vtablename,@vconsname
   WHILE @@FETCH_STATUS = 0
    BEGIN
	  EXEC ('ALTER TABLE '+ @vtablename+ ' DROP CONSTRAINT '+ @vconsname);
      FETCH @refconscur INTO @vtablename,@vconsname
    END
  CLOSE @refconscur
  DEALLOCATE  @refconscur 
 end 
if @consexists >=1 
ALTER TABLE ITERDAYS DROP CONSTRAINT fk_iterdays_task;
go

print 'Dropping index ndx_itergoal_iteration on table ITERGOAL'

--METADATA NAME:ndx_itergoal_iteration TYPE:INDEX TABLE_NAME:ITERGOAL CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_itergoal_iteration')	  
if @indexists >= 1
DROP INDEX ITERGOAL.ndx_itergoal_iteration;
      go

print 'Dropping index ndx_itergoal_rfolio on table ITERGOAL'

--METADATA NAME:ndx_itergoal_rfolio TYPE:INDEX TABLE_NAME:ITERGOAL CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_itergoal_rfolio')	  
if @indexists >= 1
DROP INDEX ITERGOAL.ndx_itergoal_rfolio;
      go

print 'Dropping index ndx_itergoal_dsi on table ITERGOAL'

--METADATA NAME:ndx_itergoal_dsi TYPE:INDEX TABLE_NAME:ITERGOAL CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_itergoal_dsi')	  
if @indexists >= 1
DROP INDEX ITERGOAL.ndx_itergoal_dsi;
      go

print 'Dropping constraint pk_itergoal on table ITERGOAL'


--METADATA NAME:pk_itergoal TYPE:CONSTRAINT TABLE_NAME:ITERGOAL CHANGE:DROP
declare @consexists int  , @ispk int, @vtablename varchar(30), @vconsname varchar(30)
declare @refconscur CURSOR 
SET @refconscur = CURSOR for
select t.name,r.name from sys.foreign_keys r,sys.objects o,sys.tables t 
where r.referenced_object_id= o.parent_object_id and upper(o.name)= upper('pk_itergoal') and r.parent_object_id=t.object_id

SELECT @consexists=count(*) FROM sys.objects WHERE upper(name) = upper('pk_itergoal') and type_desc LIKE '%CONSTRAINT'  
SELECT @ispk=count(*) FROM sys.objects WHERE upper(name) = upper('pk_itergoal') and type_desc LIKE '%CONSTRAINT' and type ='PK'
if  @ispk > 0
 begin
   OPEN @refconscur
   FETCH @refconscur INTO @vtablename,@vconsname
   WHILE @@FETCH_STATUS = 0
    BEGIN
	  EXEC ('ALTER TABLE '+ @vtablename+ ' DROP CONSTRAINT '+ @vconsname);
      FETCH @refconscur INTO @vtablename,@vconsname
    END
  CLOSE @refconscur
  DEALLOCATE  @refconscur 
 end 
if @consexists >=1 
ALTER TABLE ITERGOAL DROP CONSTRAINT pk_itergoal;
go

print 'Dropping constraint fk_itergoal_iteration on table ITERGOAL'


--METADATA NAME:fk_itergoal_iteration TYPE:CONSTRAINT TABLE_NAME:ITERGOAL CHANGE:DROP
declare @consexists int  , @ispk int, @vtablename varchar(30), @vconsname varchar(30)
declare @refconscur CURSOR 
SET @refconscur = CURSOR for
select t.name,r.name from sys.foreign_keys r,sys.objects o,sys.tables t 
where r.referenced_object_id= o.parent_object_id and upper(o.name)= upper('fk_itergoal_iteration') and r.parent_object_id=t.object_id

SELECT @consexists=count(*) FROM sys.objects WHERE upper(name) = upper('fk_itergoal_iteration') and type_desc LIKE '%CONSTRAINT'  
SELECT @ispk=count(*) FROM sys.objects WHERE upper(name) = upper('fk_itergoal_iteration') and type_desc LIKE '%CONSTRAINT' and type ='PK'
if  @ispk > 0
 begin
   OPEN @refconscur
   FETCH @refconscur INTO @vtablename,@vconsname
   WHILE @@FETCH_STATUS = 0
    BEGIN
	  EXEC ('ALTER TABLE '+ @vtablename+ ' DROP CONSTRAINT '+ @vconsname);
      FETCH @refconscur INTO @vtablename,@vconsname
    END
  CLOSE @refconscur
  DEALLOCATE  @refconscur 
 end 
if @consexists >=1 
ALTER TABLE ITERGOAL DROP CONSTRAINT fk_itergoal_iteration;
go

print 'Dropping constraint fk_itergoal_rfolio on table ITERGOAL'


--METADATA NAME:fk_itergoal_rfolio TYPE:CONSTRAINT TABLE_NAME:ITERGOAL CHANGE:DROP
declare @consexists int  , @ispk int, @vtablename varchar(30), @vconsname varchar(30)
declare @refconscur CURSOR 
SET @refconscur = CURSOR for
select t.name,r.name from sys.foreign_keys r,sys.objects o,sys.tables t 
where r.referenced_object_id= o.parent_object_id and upper(o.name)= upper('fk_itergoal_rfolio') and r.parent_object_id=t.object_id

SELECT @consexists=count(*) FROM sys.objects WHERE upper(name) = upper('fk_itergoal_rfolio') and type_desc LIKE '%CONSTRAINT'  
SELECT @ispk=count(*) FROM sys.objects WHERE upper(name) = upper('fk_itergoal_rfolio') and type_desc LIKE '%CONSTRAINT' and type ='PK'
if  @ispk > 0
 begin
   OPEN @refconscur
   FETCH @refconscur INTO @vtablename,@vconsname
   WHILE @@FETCH_STATUS = 0
    BEGIN
	  EXEC ('ALTER TABLE '+ @vtablename+ ' DROP CONSTRAINT '+ @vconsname);
      FETCH @refconscur INTO @vtablename,@vconsname
    END
  CLOSE @refconscur
  DEALLOCATE  @refconscur 
 end 
if @consexists >=1 
ALTER TABLE ITERGOAL DROP CONSTRAINT fk_itergoal_rfolio;
go

print 'Dropping index ndx_prmaudit_audit_date on table PRMAUDIT'

--METADATA NAME:ndx_prmaudit_audit_date TYPE:INDEX TABLE_NAME:PRMAUDIT CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_prmaudit_audit_date')	  
if @indexists >= 1
DROP INDEX PRMAUDIT.ndx_prmaudit_audit_date;
      go

print 'Dropping index ndx_project_update_date1 on table PROJECT'

--METADATA NAME:ndx_project_update_date1 TYPE:INDEX TABLE_NAME:PROJECT CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_project_update_date1')	  
if @indexists >= 1
DROP INDEX PROJECT.ndx_project_update_date1;
      go

print 'Dropping index ndx_projwbs_update_date1 on table PROJWBS'

--METADATA NAME:ndx_projwbs_update_date1 TYPE:INDEX TABLE_NAME:PROJWBS CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_projwbs_update_date1')	  
if @indexists >= 1
DROP INDEX PROJWBS.ndx_projwbs_update_date1;
      go

print 'Dropping index ndx_release_rfolio on table RELEASE'

--METADATA NAME:ndx_release_rfolio TYPE:INDEX TABLE_NAME:RELEASE CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_release_rfolio')	  
if @indexists >= 1
DROP INDEX RELEASE.ndx_release_rfolio;
      go

print 'Dropping index ndx_release_project on table RELEASE'

--METADATA NAME:ndx_release_project TYPE:INDEX TABLE_NAME:RELEASE CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_release_project')	  
if @indexists >= 1
DROP INDEX RELEASE.ndx_release_project;
      go

print 'Dropping constraint fk_release_rfolio on table RELEASE'


--METADATA NAME:fk_release_rfolio TYPE:CONSTRAINT TABLE_NAME:RELEASE CHANGE:DROP
declare @consexists int  , @ispk int, @vtablename varchar(30), @vconsname varchar(30)
declare @refconscur CURSOR 
SET @refconscur = CURSOR for
select t.name,r.name from sys.foreign_keys r,sys.objects o,sys.tables t 
where r.referenced_object_id= o.parent_object_id and upper(o.name)= upper('fk_release_rfolio') and r.parent_object_id=t.object_id

SELECT @consexists=count(*) FROM sys.objects WHERE upper(name) = upper('fk_release_rfolio') and type_desc LIKE '%CONSTRAINT'  
SELECT @ispk=count(*) FROM sys.objects WHERE upper(name) = upper('fk_release_rfolio') and type_desc LIKE '%CONSTRAINT' and type ='PK'
if  @ispk > 0
 begin
   OPEN @refconscur
   FETCH @refconscur INTO @vtablename,@vconsname
   WHILE @@FETCH_STATUS = 0
    BEGIN
	  EXEC ('ALTER TABLE '+ @vtablename+ ' DROP CONSTRAINT '+ @vconsname);
      FETCH @refconscur INTO @vtablename,@vconsname
    END
  CLOSE @refconscur
  DEALLOCATE  @refconscur 
 end 
if @consexists >=1 
ALTER TABLE RELEASE DROP CONSTRAINT fk_release_rfolio;
go

print 'Dropping constraint fk_release_proj_id on table RELEASE'


--METADATA NAME:fk_release_proj_id TYPE:CONSTRAINT TABLE_NAME:RELEASE CHANGE:DROP
declare @consexists int  , @ispk int, @vtablename varchar(30), @vconsname varchar(30)
declare @refconscur CURSOR 
SET @refconscur = CURSOR for
select t.name,r.name from sys.foreign_keys r,sys.objects o,sys.tables t 
where r.referenced_object_id= o.parent_object_id and upper(o.name)= upper('fk_release_proj_id') and r.parent_object_id=t.object_id

SELECT @consexists=count(*) FROM sys.objects WHERE upper(name) = upper('fk_release_proj_id') and type_desc LIKE '%CONSTRAINT'  
SELECT @ispk=count(*) FROM sys.objects WHERE upper(name) = upper('fk_release_proj_id') and type_desc LIKE '%CONSTRAINT' and type ='PK'
if  @ispk > 0
 begin
   OPEN @refconscur
   FETCH @refconscur INTO @vtablename,@vconsname
   WHILE @@FETCH_STATUS = 0
    BEGIN
	  EXEC ('ALTER TABLE '+ @vtablename+ ' DROP CONSTRAINT '+ @vconsname);
      FETCH @refconscur INTO @vtablename,@vconsname
    END
  CLOSE @refconscur
  DEALLOCATE  @refconscur 
 end 
if @consexists >=1 
ALTER TABLE RELEASE DROP CONSTRAINT fk_release_proj_id;
go

print 'Dropping index ndx_task_1 on table TASK'

--METADATA NAME:ndx_task_1 TYPE:INDEX TABLE_NAME:TASK CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_task_1')	  
if @indexists >= 1
DROP INDEX TASK.ndx_task_1;
      go

print 'Dropping index ndx_taskpred_1 on table TASKPRED'

--METADATA NAME:ndx_taskpred_1 TYPE:INDEX TABLE_NAME:TASKPRED CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_taskpred_1')	  
if @indexists >= 1
DROP INDEX TASKPRED.ndx_taskpred_1;
      go

print 'Dropping index ndx_taskrsrc_1 on table TASKRSRC'

--METADATA NAME:ndx_taskrsrc_1 TYPE:INDEX TABLE_NAME:TASKRSRC CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_taskrsrc_1')	  
if @indexists >= 1
DROP INDEX TASKRSRC.ndx_taskrsrc_1;
      go

print 'Dropping index ndx_usropnval_user_open_id on table USROPNVAL'

--METADATA NAME:ndx_usropnval_user_open_id TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_usropnval_user_open_id')	  
if @indexists >= 1
DROP INDEX USROPNVAL.ndx_usropnval_user_open_id;
      go

print 'Dropping index ndx_usropnval_dsi on table USROPNVAL'

--METADATA NAME:ndx_usropnval_dsi TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_usropnval_dsi')	  
if @indexists >= 1
DROP INDEX USROPNVAL.ndx_usropnval_dsi;
      go

print 'Dropping index ndx_usropnval_upd on table USROPNVAL'

--METADATA NAME:ndx_usropnval_upd TYPE:INDEX TABLE_NAME:USROPNVAL CHANGE:DROP
declare @indexists int
select @indexists=count(*) from sys.indexes where upper(name) = upper('ndx_usropnval_upd')	  
if @indexists >= 1
DROP INDEX USROPNVAL.ndx_usropnval_upd;
      go

print 'Dropping constraint fk_iterdays_project on table ITERDAYS'


--METADATA NAME:fk_iterdays_project TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:DROP
declare @consexists int  , @ispk int, @vtablename varchar(30), @vconsname varchar(30)
declare @refconscur CURSOR 
SET @refconscur = CURSOR for
select t.name,r.name from sys.foreign_keys r,sys.objects o,sys.tables t 
where r.referenced_object_id= o.parent_object_id and upper(o.name)= upper('fk_iterdays_project') and r.parent_object_id=t.object_id

SELECT @consexists=count(*) FROM sys.objects WHERE upper(name) = upper('fk_iterdays_project') and type_desc LIKE '%CONSTRAINT'  
SELECT @ispk=count(*) FROM sys.objects WHERE upper(name) = upper('fk_iterdays_project') and type_desc LIKE '%CONSTRAINT' and type ='PK'
if  @ispk > 0
 begin
   OPEN @refconscur
   FETCH @refconscur INTO @vtablename,@vconsname
   WHILE @@FETCH_STATUS = 0
    BEGIN
	  EXEC ('ALTER TABLE '+ @vtablename+ ' DROP CONSTRAINT '+ @vconsname);
      FETCH @refconscur INTO @vtablename,@vconsname
    END
  CLOSE @refconscur
  DEALLOCATE  @refconscur 
 end 
if @consexists >=1 
ALTER TABLE ITERDAYS DROP CONSTRAINT fk_iterdays_project;
go

print 'Dropping constraint fk_iterdays_iteration on table ITERDAYS'


--METADATA NAME:fk_iterdays_iteration TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:DROP
declare @consexists int  , @ispk int, @vtablename varchar(30), @vconsname varchar(30)
declare @refconscur CURSOR 
SET @refconscur = CURSOR for
select t.name,r.name from sys.foreign_keys r,sys.objects o,sys.tables t 
where r.referenced_object_id= o.parent_object_id and upper(o.name)= upper('fk_iterdays_iteration') and r.parent_object_id=t.object_id

SELECT @consexists=count(*) FROM sys.objects WHERE upper(name) = upper('fk_iterdays_iteration') and type_desc LIKE '%CONSTRAINT'  
SELECT @ispk=count(*) FROM sys.objects WHERE upper(name) = upper('fk_iterdays_iteration') and type_desc LIKE '%CONSTRAINT' and type ='PK'
if  @ispk > 0
 begin
   OPEN @refconscur
   FETCH @refconscur INTO @vtablename,@vconsname
   WHILE @@FETCH_STATUS = 0
    BEGIN
	  EXEC ('ALTER TABLE '+ @vtablename+ ' DROP CONSTRAINT '+ @vconsname);
      FETCH @refconscur INTO @vtablename,@vconsname
    END
  CLOSE @refconscur
  DEALLOCATE  @refconscur 
 end 
if @consexists >=1 
ALTER TABLE ITERDAYS DROP CONSTRAINT fk_iterdays_iteration;
go

print 'Dropping constraint fk_iterdays_task on table ITERDAYS'


--METADATA NAME:fk_iterdays_task TYPE:CONSTRAINT TABLE_NAME:ITERDAYS CHANGE:DROP
declare @consexists int  , @ispk int, @vtablename varchar(30), @vconsname varchar(30)
declare @refconscur CURSOR 
SET @refconscur = CURSOR for
select t.name,r.name from sys.foreign_keys r,sys.objects o,sys.tables t 
where r.referenced_object_id= o.parent_object_id and upper(o.name)= upper('fk_iterdays_task') and r.parent_object_id=t.object_id

SELECT @consexists=count(*) FROM sys.objects WHERE upper(name) = upper('fk_iterdays_task') and type_desc LIKE '%CONSTRAINT'  
SELECT @ispk=count(*) FROM sys.objects WHERE upper(name) = upper('fk_iterdays_task') and type_desc LIKE '%CONSTRAINT' and type ='PK'
if  @ispk > 0
 begin
   OPEN @refconscur
   FETCH @refconscur INTO @vtablename,@vconsname
   WHILE @@FETCH_STATUS = 0
    BEGIN
	  EXEC ('ALTER TABLE '+ @vtablename+ ' DROP CONSTRAINT '+ @vconsname);
      FETCH @refconscur INTO @vtablename,@vconsname
    END
  CLOSE @refconscur
  DEALLOCATE  @refconscur 
 end 
if @consexists >=1 
ALTER TABLE ITERDAYS DROP CONSTRAINT fk_iterdays_task;
go

print 'Dropping constraint fk_itergoal_iteration on table ITERGOAL'


--METADATA NAME:fk_itergoal_iteration TYPE:CONSTRAINT TABLE_NAME:ITERGOAL CHANGE:DROP
declare @consexists int  , @ispk int, @vtablename varchar(30), @vconsname varchar(30)
declare @refconscur CURSOR 
SET @refconscur = CURSOR for
select t.name,r.name from sys.foreign_keys r,sys.objects o,sys.tables t 
where r.referenced_object_id= o.parent_object_id and upper(o.name)= upper('fk_itergoal_iteration') and r.parent_object_id=t.object_id

SELECT @consexists=count(*) FROM sys.objects WHERE upper(name) = upper('fk_itergoal_iteration') and type_desc LIKE '%CONSTRAINT'  
SELECT @ispk=count(*) FROM sys.objects WHERE upper(name) = upper('fk_itergoal_iteration') and type_desc LIKE '%CONSTRAINT' and type ='PK'
if  @ispk > 0
 begin
   OPEN @refconscur
   FETCH @refconscur INTO @vtablename,@vconsname
   WHILE @@FETCH_STATUS = 0
    BEGIN
	  EXEC ('ALTER TABLE '+ @vtablename+ ' DROP CONSTRAINT '+ @vconsname);
      FETCH @refconscur INTO @vtablename,@vconsname
    END
  CLOSE @refconscur
  DEALLOCATE  @refconscur 
 end 
if @consexists >=1 
ALTER TABLE ITERGOAL DROP CONSTRAINT fk_itergoal_iteration;
go

print 'Dropping constraint fk_itergoal_rfolio on table ITERGOAL'


--METADATA NAME:fk_itergoal_rfolio TYPE:CONSTRAINT TABLE_NAME:ITERGOAL CHANGE:DROP
declare @consexists int  , @ispk int, @vtablename varchar(30), @vconsname varchar(30)
declare @refconscur CURSOR 
SET @refconscur = CURSOR for
select t.name,r.name from sys.foreign_keys r,sys.objects o,sys.tables t 
where r.referenced_object_id= o.parent_object_id and upper(o.name)= upper('fk_itergoal_rfolio') and r.parent_object_id=t.object_id

SELECT @consexists=count(*) FROM sys.objects WHERE upper(name) = upper('fk_itergoal_rfolio') and type_desc LIKE '%CONSTRAINT'  
SELECT @ispk=count(*) FROM sys.objects WHERE upper(name) = upper('fk_itergoal_rfolio') and type_desc LIKE '%CONSTRAINT' and type ='PK'
if  @ispk > 0
 begin
   OPEN @refconscur
   FETCH @refconscur INTO @vtablename,@vconsname
   WHILE @@FETCH_STATUS = 0
    BEGIN
	  EXEC ('ALTER TABLE '+ @vtablename+ ' DROP CONSTRAINT '+ @vconsname);
      FETCH @refconscur INTO @vtablename,@vconsname
    END
  CLOSE @refconscur
  DEALLOCATE  @refconscur 
 end 
if @consexists >=1 
ALTER TABLE ITERGOAL DROP CONSTRAINT fk_itergoal_rfolio;
go

--METADATA NAME:PROJ_LEVELED TYPE:PROCEDURE TARGET_OBJECT:PROJ_LEVELED CHANGE:DROP
declare @prccount int
SELECT @prccount=count(*) FROM sys.objects where type ='P' and name ='PROJ_LEVELED'
IF @prccount > 0  
DROP PROCEDURE  PROJ_LEVELED
go
--METADATA NAME:MODIFIED_BLOB_LEVELER TYPE:PROCEDURE TARGET_OBJECT:MODIFIED_BLOB_LEVELER CHANGE:DROP
declare @prccount int
SELECT @prccount=count(*) FROM sys.objects where type ='P' and name ='MODIFIED_BLOB_LEVELER'
IF @prccount > 0  
DROP PROCEDURE  MODIFIED_BLOB_LEVELER
go
--METADATA NAME:PRMAUDIT_CLEANUP TYPE:PROCEDURE TARGET_OBJECT:PRMAUDIT_CLEANUP CHANGE:DROP
declare @prccount int
SELECT @prccount=count(*) FROM sys.objects where type ='P' and name ='PRMAUDIT_CLEANUP'
IF @prccount > 0  
DROP PROCEDURE  PRMAUDIT_CLEANUP
go
--METADATA NAME:CHECK_DB_SIZE_LIMIT TYPE:PROCEDURE TARGET_OBJECT:CHECK_DB_SIZE_LIMIT CHANGE:DROP
declare @prccount int
SELECT @prccount=count(*) FROM sys.objects where type ='P' and name ='CHECK_DB_SIZE_LIMIT'
IF @prccount > 0  
DROP PROCEDURE  CHECK_DB_SIZE_LIMIT
go 
--METADATA NAME:release_id TYPE:FIELD TABLE_NAME:ITERATION CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERATION') and col_name(parent_object_id,parent_column_id)='release_id'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERATION')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERATION') and name ='release_id'
 if @default_name is not null 
  exec ('alter table dbo.ITERATION drop constraint '+@default_name)
 if @tab_name != 'ITERATION'
    begin
	if @stab_name  != 'ITERATION'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERATION drop column  release_id

      end
	end
go
 
--METADATA NAME:task_id TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERDAYS') and col_name(parent_object_id,parent_column_id)='task_id'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS') and name ='task_id'
 if @default_name is not null 
  exec ('alter table dbo.ITERDAYS drop constraint '+@default_name)
 if @tab_name != 'ITERDAYS'
    begin
	if @stab_name  != 'ITERDAYS'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERDAYS drop column  task_id

      end
	end
go
 
--METADATA NAME:day_number TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERDAYS') and col_name(parent_object_id,parent_column_id)='day_number'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS') and name ='day_number'
 if @default_name is not null 
  exec ('alter table dbo.ITERDAYS drop constraint '+@default_name)
 if @tab_name != 'ITERDAYS'
    begin
	if @stab_name  != 'ITERDAYS'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERDAYS drop column  day_number

      end
	end
go
 
--METADATA NAME:proj_id TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERDAYS') and col_name(parent_object_id,parent_column_id)='proj_id'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS') and name ='proj_id'
 if @default_name is not null 
  exec ('alter table dbo.ITERDAYS drop constraint '+@default_name)
 if @tab_name != 'ITERDAYS'
    begin
	if @stab_name  != 'ITERDAYS'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERDAYS drop column  proj_id

      end
	end
go
 
--METADATA NAME:iteration_id TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERDAYS') and col_name(parent_object_id,parent_column_id)='iteration_id'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS') and name ='iteration_id'
 if @default_name is not null 
  exec ('alter table dbo.ITERDAYS drop constraint '+@default_name)
 if @tab_name != 'ITERDAYS'
    begin
	if @stab_name  != 'ITERDAYS'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERDAYS drop column  iteration_id

      end
	end
go
 
--METADATA NAME:act_work_qty TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERDAYS') and col_name(parent_object_id,parent_column_id)='act_work_qty'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS') and name ='act_work_qty'
 if @default_name is not null 
  exec ('alter table dbo.ITERDAYS drop constraint '+@default_name)
 if @tab_name != 'ITERDAYS'
    begin
	if @stab_name  != 'ITERDAYS'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERDAYS drop column  act_work_qty

      end
	end
go
 
--METADATA NAME:remain_work_qty TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERDAYS') and col_name(parent_object_id,parent_column_id)='remain_work_qty'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS') and name ='remain_work_qty'
 if @default_name is not null 
  exec ('alter table dbo.ITERDAYS drop constraint '+@default_name)
 if @tab_name != 'ITERDAYS'
    begin
	if @stab_name  != 'ITERDAYS'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERDAYS drop column  remain_work_qty

      end
	end
go
 
--METADATA NAME:update_date TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERDAYS') and col_name(parent_object_id,parent_column_id)='update_date'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS') and name ='update_date'
 if @default_name is not null 
  exec ('alter table dbo.ITERDAYS drop constraint '+@default_name)
 if @tab_name != 'ITERDAYS'
    begin
	if @stab_name  != 'ITERDAYS'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERDAYS drop column  update_date

      end
	end
go
 
--METADATA NAME:update_user TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERDAYS') and col_name(parent_object_id,parent_column_id)='update_user'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS') and name ='update_user'
 if @default_name is not null 
  exec ('alter table dbo.ITERDAYS drop constraint '+@default_name)
 if @tab_name != 'ITERDAYS'
    begin
	if @stab_name  != 'ITERDAYS'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERDAYS drop column  update_user

      end
	end
go
 
--METADATA NAME:create_date TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERDAYS') and col_name(parent_object_id,parent_column_id)='create_date'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS') and name ='create_date'
 if @default_name is not null 
  exec ('alter table dbo.ITERDAYS drop constraint '+@default_name)
 if @tab_name != 'ITERDAYS'
    begin
	if @stab_name  != 'ITERDAYS'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERDAYS drop column  create_date

      end
	end
go
 
--METADATA NAME:create_user TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERDAYS') and col_name(parent_object_id,parent_column_id)='create_user'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS') and name ='create_user'
 if @default_name is not null 
  exec ('alter table dbo.ITERDAYS drop constraint '+@default_name)
 if @tab_name != 'ITERDAYS'
    begin
	if @stab_name  != 'ITERDAYS'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERDAYS drop column  create_user

      end
	end
go
 
--METADATA NAME:delete_session_id TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERDAYS') and col_name(parent_object_id,parent_column_id)='delete_session_id'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS') and name ='delete_session_id'
 if @default_name is not null 
  exec ('alter table dbo.ITERDAYS drop constraint '+@default_name)
 if @tab_name != 'ITERDAYS'
    begin
	if @stab_name  != 'ITERDAYS'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERDAYS drop column  delete_session_id

      end
	end
go
 
--METADATA NAME:delete_date TYPE:FIELD TABLE_NAME:ITERDAYS CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERDAYS') and col_name(parent_object_id,parent_column_id)='delete_date'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERDAYS') and name ='delete_date'
 if @default_name is not null 
  exec ('alter table dbo.ITERDAYS drop constraint '+@default_name)
 if @tab_name != 'ITERDAYS'
    begin
	if @stab_name  != 'ITERDAYS'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERDAYS drop column  delete_date

      end
	end
go
 
--METADATA NAME:iter_goal_id TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERGOAL') and col_name(parent_object_id,parent_column_id)='iter_goal_id'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL') and name ='iter_goal_id'
 if @default_name is not null 
  exec ('alter table dbo.ITERGOAL drop constraint '+@default_name)
 if @tab_name != 'ITERGOAL'
    begin
	if @stab_name  != 'ITERGOAL'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERGOAL drop column  iter_goal_id

      end
	end
go
 
--METADATA NAME:iteration_id TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERGOAL') and col_name(parent_object_id,parent_column_id)='iteration_id'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL') and name ='iteration_id'
 if @default_name is not null 
  exec ('alter table dbo.ITERGOAL drop constraint '+@default_name)
 if @tab_name != 'ITERGOAL'
    begin
	if @stab_name  != 'ITERGOAL'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERGOAL drop column  iteration_id

      end
	end
go
 
--METADATA NAME:goal_name TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERGOAL') and col_name(parent_object_id,parent_column_id)='goal_name'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL') and name ='goal_name'
 if @default_name is not null 
  exec ('alter table dbo.ITERGOAL drop constraint '+@default_name)
 if @tab_name != 'ITERGOAL'
    begin
	if @stab_name  != 'ITERGOAL'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERGOAL drop column  goal_name

      end
	end
go
 
--METADATA NAME:goal_descr TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERGOAL') and col_name(parent_object_id,parent_column_id)='goal_descr'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL') and name ='goal_descr'
 if @default_name is not null 
  exec ('alter table dbo.ITERGOAL drop constraint '+@default_name)
 if @tab_name != 'ITERGOAL'
    begin
	if @stab_name  != 'ITERGOAL'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERGOAL drop column  goal_descr

      end
	end
go
 
--METADATA NAME:status_code TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERGOAL') and col_name(parent_object_id,parent_column_id)='status_code'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL') and name ='status_code'
 if @default_name is not null 
  exec ('alter table dbo.ITERGOAL drop constraint '+@default_name)
 if @tab_name != 'ITERGOAL'
    begin
	if @stab_name  != 'ITERGOAL'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERGOAL drop column  status_code

      end
	end
go
 
--METADATA NAME:rfolio_id TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERGOAL') and col_name(parent_object_id,parent_column_id)='rfolio_id'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL') and name ='rfolio_id'
 if @default_name is not null 
  exec ('alter table dbo.ITERGOAL drop constraint '+@default_name)
 if @tab_name != 'ITERGOAL'
    begin
	if @stab_name  != 'ITERGOAL'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERGOAL drop column  rfolio_id

      end
	end
go
 
--METADATA NAME:update_date TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERGOAL') and col_name(parent_object_id,parent_column_id)='update_date'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL') and name ='update_date'
 if @default_name is not null 
  exec ('alter table dbo.ITERGOAL drop constraint '+@default_name)
 if @tab_name != 'ITERGOAL'
    begin
	if @stab_name  != 'ITERGOAL'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERGOAL drop column  update_date

      end
	end
go
 
--METADATA NAME:update_user TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERGOAL') and col_name(parent_object_id,parent_column_id)='update_user'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL') and name ='update_user'
 if @default_name is not null 
  exec ('alter table dbo.ITERGOAL drop constraint '+@default_name)
 if @tab_name != 'ITERGOAL'
    begin
	if @stab_name  != 'ITERGOAL'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERGOAL drop column  update_user

      end
	end
go
 
--METADATA NAME:create_date TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERGOAL') and col_name(parent_object_id,parent_column_id)='create_date'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL') and name ='create_date'
 if @default_name is not null 
  exec ('alter table dbo.ITERGOAL drop constraint '+@default_name)
 if @tab_name != 'ITERGOAL'
    begin
	if @stab_name  != 'ITERGOAL'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERGOAL drop column  create_date

      end
	end
go
 
--METADATA NAME:create_user TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERGOAL') and col_name(parent_object_id,parent_column_id)='create_user'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL') and name ='create_user'
 if @default_name is not null 
  exec ('alter table dbo.ITERGOAL drop constraint '+@default_name)
 if @tab_name != 'ITERGOAL'
    begin
	if @stab_name  != 'ITERGOAL'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERGOAL drop column  create_user

      end
	end
go
 
--METADATA NAME:delete_session_id TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERGOAL') and col_name(parent_object_id,parent_column_id)='delete_session_id'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL') and name ='delete_session_id'
 if @default_name is not null 
  exec ('alter table dbo.ITERGOAL drop constraint '+@default_name)
 if @tab_name != 'ITERGOAL'
    begin
	if @stab_name  != 'ITERGOAL'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERGOAL drop column  delete_session_id

      end
	end
go
 
--METADATA NAME:delete_date TYPE:FIELD TABLE_NAME:ITERGOAL CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('ITERGOAL') and col_name(parent_object_id,parent_column_id)='delete_date'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='ITERGOAL') and name ='delete_date'
 if @default_name is not null 
  exec ('alter table dbo.ITERGOAL drop constraint '+@default_name)
 if @tab_name != 'ITERGOAL'
    begin
	if @stab_name  != 'ITERGOAL'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE ITERGOAL drop column  delete_date

      end
	end
go
 
--METADATA NAME:audit_date TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PRMAUDIT') and col_name(parent_object_id,parent_column_id)='audit_date'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT') and name ='audit_date'
 if @default_name is not null 
  exec ('alter table dbo.PRMAUDIT drop constraint '+@default_name)
 if @tab_name != 'PRMAUDIT'
    begin
	if @stab_name  != 'PRMAUDIT'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PRMAUDIT drop column  audit_date

      end
	end
go
 
--METADATA NAME:table_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PRMAUDIT') and col_name(parent_object_id,parent_column_id)='table_name'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT') and name ='table_name'
 if @default_name is not null 
  exec ('alter table dbo.PRMAUDIT drop constraint '+@default_name)
 if @tab_name != 'PRMAUDIT'
    begin
	if @stab_name  != 'PRMAUDIT'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PRMAUDIT drop column  table_name

      end
	end
go
 
--METADATA NAME:pk1 TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PRMAUDIT') and col_name(parent_object_id,parent_column_id)='pk1'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT') and name ='pk1'
 if @default_name is not null 
  exec ('alter table dbo.PRMAUDIT drop constraint '+@default_name)
 if @tab_name != 'PRMAUDIT'
    begin
	if @stab_name  != 'PRMAUDIT'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PRMAUDIT drop column  pk1

      end
	end
go
 
--METADATA NAME:pk2 TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PRMAUDIT') and col_name(parent_object_id,parent_column_id)='pk2'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT') and name ='pk2'
 if @default_name is not null 
  exec ('alter table dbo.PRMAUDIT drop constraint '+@default_name)
 if @tab_name != 'PRMAUDIT'
    begin
	if @stab_name  != 'PRMAUDIT'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PRMAUDIT drop column  pk2

      end
	end
go
 
--METADATA NAME:pk3 TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PRMAUDIT') and col_name(parent_object_id,parent_column_id)='pk3'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT') and name ='pk3'
 if @default_name is not null 
  exec ('alter table dbo.PRMAUDIT drop constraint '+@default_name)
 if @tab_name != 'PRMAUDIT'
    begin
	if @stab_name  != 'PRMAUDIT'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PRMAUDIT drop column  pk3

      end
	end
go
 
--METADATA NAME:pk4 TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PRMAUDIT') and col_name(parent_object_id,parent_column_id)='pk4'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT') and name ='pk4'
 if @default_name is not null 
  exec ('alter table dbo.PRMAUDIT drop constraint '+@default_name)
 if @tab_name != 'PRMAUDIT'
    begin
	if @stab_name  != 'PRMAUDIT'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PRMAUDIT drop column  pk4

      end
	end
go
 
--METADATA NAME:oper TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PRMAUDIT') and col_name(parent_object_id,parent_column_id)='oper'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT') and name ='oper'
 if @default_name is not null 
  exec ('alter table dbo.PRMAUDIT drop constraint '+@default_name)
 if @tab_name != 'PRMAUDIT'
    begin
	if @stab_name  != 'PRMAUDIT'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PRMAUDIT drop column  oper

      end
	end
go
 
--METADATA NAME:prm_user_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PRMAUDIT') and col_name(parent_object_id,parent_column_id)='prm_user_name'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT') and name ='prm_user_name'
 if @default_name is not null 
  exec ('alter table dbo.PRMAUDIT drop constraint '+@default_name)
 if @tab_name != 'PRMAUDIT'
    begin
	if @stab_name  != 'PRMAUDIT'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PRMAUDIT drop column  prm_user_name

      end
	end
go
 
--METADATA NAME:audit_info TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PRMAUDIT') and col_name(parent_object_id,parent_column_id)='audit_info'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT') and name ='audit_info'
 if @default_name is not null 
  exec ('alter table dbo.PRMAUDIT drop constraint '+@default_name)
 if @tab_name != 'PRMAUDIT'
    begin
	if @stab_name  != 'PRMAUDIT'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PRMAUDIT drop column  audit_info

      end
	end
go
 
--METADATA NAME:audit_info_extended TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PRMAUDIT') and col_name(parent_object_id,parent_column_id)='audit_info_extended'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT') and name ='audit_info_extended'
 if @default_name is not null 
  exec ('alter table dbo.PRMAUDIT drop constraint '+@default_name)
 if @tab_name != 'PRMAUDIT'
    begin
	if @stab_name  != 'PRMAUDIT'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PRMAUDIT drop column  audit_info_extended

      end
	end
go
 
--METADATA NAME:logical_delete_flag TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PRMAUDIT') and col_name(parent_object_id,parent_column_id)='logical_delete_flag'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT') and name ='logical_delete_flag'
 if @default_name is not null 
  exec ('alter table dbo.PRMAUDIT drop constraint '+@default_name)
 if @tab_name != 'PRMAUDIT'
    begin
	if @stab_name  != 'PRMAUDIT'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PRMAUDIT drop column  logical_delete_flag

      end
	end
go
 
--METADATA NAME:rdbms_user_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PRMAUDIT') and col_name(parent_object_id,parent_column_id)='rdbms_user_name'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT') and name ='rdbms_user_name'
 if @default_name is not null 
  exec ('alter table dbo.PRMAUDIT drop constraint '+@default_name)
 if @tab_name != 'PRMAUDIT'
    begin
	if @stab_name  != 'PRMAUDIT'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PRMAUDIT drop column  rdbms_user_name

      end
	end
go
 
--METADATA NAME:os_user_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PRMAUDIT') and col_name(parent_object_id,parent_column_id)='os_user_name'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT') and name ='os_user_name'
 if @default_name is not null 
  exec ('alter table dbo.PRMAUDIT drop constraint '+@default_name)
 if @tab_name != 'PRMAUDIT'
    begin
	if @stab_name  != 'PRMAUDIT'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PRMAUDIT drop column  os_user_name

      end
	end
go
 
--METADATA NAME:program TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PRMAUDIT') and col_name(parent_object_id,parent_column_id)='program'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT') and name ='program'
 if @default_name is not null 
  exec ('alter table dbo.PRMAUDIT drop constraint '+@default_name)
 if @tab_name != 'PRMAUDIT'
    begin
	if @stab_name  != 'PRMAUDIT'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PRMAUDIT drop column  program

      end
	end
go
 
--METADATA NAME:host_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PRMAUDIT') and col_name(parent_object_id,parent_column_id)='host_name'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT') and name ='host_name'
 if @default_name is not null 
  exec ('alter table dbo.PRMAUDIT drop constraint '+@default_name)
 if @tab_name != 'PRMAUDIT'
    begin
	if @stab_name  != 'PRMAUDIT'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PRMAUDIT drop column  host_name

      end
	end
go
 
--METADATA NAME:app_name TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PRMAUDIT') and col_name(parent_object_id,parent_column_id)='app_name'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT') and name ='app_name'
 if @default_name is not null 
  exec ('alter table dbo.PRMAUDIT drop constraint '+@default_name)
 if @tab_name != 'PRMAUDIT'
    begin
	if @stab_name  != 'PRMAUDIT'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PRMAUDIT drop column  app_name

      end
	end
go
 
--METADATA NAME:netaddress TYPE:FIELD TABLE_NAME:PRMAUDIT CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PRMAUDIT') and col_name(parent_object_id,parent_column_id)='netaddress'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PRMAUDIT') and name ='netaddress'
 if @default_name is not null 
  exec ('alter table dbo.PRMAUDIT drop constraint '+@default_name)
 if @tab_name != 'PRMAUDIT'
    begin
	if @stab_name  != 'PRMAUDIT'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PRMAUDIT drop column  netaddress

      end
	end
go
 
--METADATA NAME:risk_to_type TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='risk_to_type'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK') and name ='risk_to_type'
 if @default_name is not null 
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
 if @tab_name != 'PROJRISK'
    begin
	if @stab_name  != 'PROJRISK'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PROJRISK drop column  risk_to_type

      end
	end
go
 
--METADATA NAME:identified_by_id TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='identified_by_id'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK') and name ='identified_by_id'
 if @default_name is not null 
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
 if @tab_name != 'PROJRISK'
    begin
	if @stab_name  != 'PROJRISK'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PROJRISK drop column  identified_by_id

      end
	end
go
 
--METADATA NAME:response_type TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='response_type'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK') and name ='response_type'
 if @default_name is not null 
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
 if @tab_name != 'PROJRISK'
    begin
	if @stab_name  != 'PROJRISK'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PROJRISK drop column  response_type

      end
	end
go
 
--METADATA NAME:response_text TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='response_text'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK') and name ='response_text'
 if @default_name is not null 
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
 if @tab_name != 'PROJRISK'
    begin
	if @stab_name  != 'PROJRISK'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PROJRISK drop column  response_text

      end
	end
go
 
--METADATA NAME:pre_rsp_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='pre_rsp_prblty'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK') and name ='pre_rsp_prblty'
 if @default_name is not null 
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
 if @tab_name != 'PROJRISK'
    begin
	if @stab_name  != 'PROJRISK'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PROJRISK drop column  pre_rsp_prblty

      end
	end
go
 
--METADATA NAME:pre_rsp_schd_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='pre_rsp_schd_prblty'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK') and name ='pre_rsp_schd_prblty'
 if @default_name is not null 
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
 if @tab_name != 'PROJRISK'
    begin
	if @stab_name  != 'PROJRISK'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PROJRISK drop column  pre_rsp_schd_prblty

      end
	end
go
 
--METADATA NAME:pre_rsp_cost_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='pre_rsp_cost_prblty'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK') and name ='pre_rsp_cost_prblty'
 if @default_name is not null 
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
 if @tab_name != 'PROJRISK'
    begin
	if @stab_name  != 'PROJRISK'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PROJRISK drop column  pre_rsp_cost_prblty

      end
	end
go
 
--METADATA NAME:post_rsp_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='post_rsp_prblty'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK') and name ='post_rsp_prblty'
 if @default_name is not null 
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
 if @tab_name != 'PROJRISK'
    begin
	if @stab_name  != 'PROJRISK'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PROJRISK drop column  post_rsp_prblty

      end
	end
go
 
--METADATA NAME:post_rsp_schd_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='post_rsp_schd_prblty'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK') and name ='post_rsp_schd_prblty'
 if @default_name is not null 
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
 if @tab_name != 'PROJRISK'
    begin
	if @stab_name  != 'PROJRISK'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PROJRISK drop column  post_rsp_schd_prblty

      end
	end
go
 
--METADATA NAME:post_rsp_cost_prblty TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='post_rsp_cost_prblty'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK') and name ='post_rsp_cost_prblty'
 if @default_name is not null 
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
 if @tab_name != 'PROJRISK'
    begin
	if @stab_name  != 'PROJRISK'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PROJRISK drop column  post_rsp_cost_prblty

      end
	end
go
 
--METADATA NAME:risk_cause TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='risk_cause'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK') and name ='risk_cause'
 if @default_name is not null 
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
 if @tab_name != 'PROJRISK'
    begin
	if @stab_name  != 'PROJRISK'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PROJRISK drop column  risk_cause

      end
	end
go
 
--METADATA NAME:risk_effect TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='risk_effect'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK') and name ='risk_effect'
 if @default_name is not null 
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
 if @tab_name != 'PROJRISK'
    begin
	if @stab_name  != 'PROJRISK'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PROJRISK drop column  risk_effect

      end
	end
go
 
--METADATA NAME:notes TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='notes'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK') and name ='notes'
 if @default_name is not null 
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
 if @tab_name != 'PROJRISK'
    begin
	if @stab_name  != 'PROJRISK'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PROJRISK drop column  notes

      end
	end
go
 
--METADATA NAME:risk_code TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='risk_code'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK') and name ='risk_code'
 if @default_name is not null 
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
 if @tab_name != 'PROJRISK'
    begin
	if @stab_name  != 'PROJRISK'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PROJRISK drop column  risk_code

      end
	end
go
 
--METADATA NAME:risk_desc TYPE:FIELD TABLE_NAME:PROJRISK CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJRISK') and col_name(parent_object_id,parent_column_id)='risk_desc'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJRISK') and name ='risk_desc'
 if @default_name is not null 
  exec ('alter table dbo.PROJRISK drop constraint '+@default_name)
 if @tab_name != 'PROJRISK'
    begin
	if @stab_name  != 'PROJRISK'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PROJRISK drop column  risk_desc

      end
	end
go
 
--METADATA NAME:status_reviewer TYPE:FIELD TABLE_NAME:PROJWBS CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJWBS') and col_name(parent_object_id,parent_column_id)='status_reviewer'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJWBS')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='PROJWBS') and name ='status_reviewer'
 if @default_name is not null 
  exec ('alter table dbo.PROJWBS drop constraint '+@default_name)
 if @tab_name != 'PROJWBS'
    begin
	if @stab_name  != 'PROJWBS'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE PROJWBS drop column  status_reviewer

      end
	end
go
 
--METADATA NAME:rfolio_id TYPE:FIELD TABLE_NAME:RELEASE CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('RELEASE') and col_name(parent_object_id,parent_column_id)='rfolio_id'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='RELEASE')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='RELEASE') and name ='rfolio_id'
 if @default_name is not null 
  exec ('alter table dbo.RELEASE drop constraint '+@default_name)
 if @tab_name != 'RELEASE'
    begin
	if @stab_name  != 'RELEASE'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE RELEASE drop column  rfolio_id

      end
	end
go
 
--METADATA NAME:proj_id TYPE:FIELD TABLE_NAME:RELEASE CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('RELEASE') and col_name(parent_object_id,parent_column_id)='proj_id'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='RELEASE')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='RELEASE') and name ='proj_id'
 if @default_name is not null 
  exec ('alter table dbo.RELEASE drop constraint '+@default_name)
 if @tab_name != 'RELEASE'
    begin
	if @stab_name  != 'RELEASE'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE RELEASE drop column  proj_id

      end
	end
go
 
--METADATA NAME:audit_info_extended TYPE:FIELD TABLE_NAME:SPIDMAP CHANGE:DROP
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int,@tab_name varchar(255),@stab_name varchar(255)
 set @tab_name = 'PRMAUDIT';
 set @stab_name = 'SPIDMAP';
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('SPIDMAP') and col_name(parent_object_id,parent_column_id)='audit_info_extended'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='SPIDMAP')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='SPIDMAP') and name ='audit_info_extended'
 if @default_name is not null 
  exec ('alter table dbo.SPIDMAP drop constraint '+@default_name)
 if @tab_name != 'SPIDMAP'
    begin
	if @stab_name  != 'SPIDMAP'
      begin
        if (@colcount >1) and (@colexists =1)
        ALTER TABLE SPIDMAP drop column  audit_info_extended

      end
	end
go

--METADATA NAME:ITERDAYS TYPE:TABLE CHANGE:DROP
declare @tblexists int
SELECT @tblexists=count(*) FROM sys.objects where type ='U' and name ='ITERDAYS' and upper(name) !='PRMAUDIT'
IF @tblexists > 0   
DROP TABLE ITERDAYS
go

--METADATA NAME:ITERGOAL TYPE:TABLE CHANGE:DROP
declare @tblexists int
SELECT @tblexists=count(*) FROM sys.objects where type ='U' and name ='ITERGOAL' and upper(name) !='PRMAUDIT'
IF @tblexists > 0   
DROP TABLE ITERGOAL
go

--METADATA NAME:PRMAUDIT TYPE:TABLE CHANGE:DROP
declare @tblexists int
SELECT @tblexists=count(*) FROM sys.objects where type ='U' and name ='PRMAUDIT' and upper(name) !='PRMAUDIT'
IF @tblexists > 0   
DROP TABLE PRMAUDIT
go

--EPPM Base data Update Scripts

--METADATA TYPE:UP2 GROUP:60to61 NAME:UPDATERPTAREA 
set nocount on
Declare @pret_val integer
Declare @pret_msg varchar(255)
DECLARE @ptrval varbinary(16)
Declare @pos1     integer
Declare @position integer
Declare @pos2     integer
Declare @str      varchar(2000)
Declare @tabname  varchar(32)
Declare @rpt_id   integer
Declare @err      integer
Declare @errors   integer
   begin
                set @errors=0
                declare rptcur
                cursor for
                        SELECT rpt_id FROM rpt
                open rptcur
                FETCH NEXT FROM rptcur INTO @rpt_id
                while (@@FETCH_STATUS =0)
                begin
                        set @pos1=0
                        set @pos2=0
                        set @position=0
                        select @position=patindex('%GroupByTableName%',rpt_data) from rpt where rpt_id=@rpt_id
                        select @err=@@error
                        if @err<> 0
                        set @errors=@errors+1
                        else
                        begin
                                if @position=0
                                        UPDATE rpt SET rpt_area='UNKNOWN' WHERE rpt_id=@rpt_id
                                else
                                begin
                                        select @str  =substring(rpt_data,@position,2000) from rpt where rpt_id=@rpt_id
                                        set @pos1    =charindex('''',@str,0)
                                        set @pos2    =charindex('''',@str,@pos1 +1)
                                        set @tabname =rtrim(substring(@str,@pos1+1,@pos2-@pos1-1))
                                        if @tabname is not null
                                            UPDATE rpt SET rpt_area=@tabname WHERE rpt_id=@rpt_id
                                        else
                                            UPDATE rpt SET rpt_area='UNKNOWN' WHERE rpt_id=@rpt_id
                                end
                        end
                        FETCH NEXT FROM rptcur INTO @rpt_id
                end
                close rptcur
                deallocate rptcur
        end
        if @errors=0
        begin
                set @pret_val=0
                set @pret_msg='RPT_AREA in RPT table update successful'
        end
        else
        begin
                set @pret_val=-1
                set @pret_msg='RPT_AREA for some reports could not be set'
        end
print @pret_msg

go 
--END TYPE:UP2 GROUP:60to61 NAME:UPDATERPTAREA
--METADATA TYPE:UP2 GROUP:60to61 NAME:MIGRATE_NAVIVIEW 
  SET NOCOUNT ON
  DECLARE @keys integer
  DECLARE @startkey integer
  DECLARE @existing_naviview_name varchar(255)
  DECLARE @existing_user_id integer
  DECLARE @existing_naviview_data varchar(4000)
  DECLARE @existing_naviview_id integer
  DECLARE @existing_default_flag varchar(1)
  DECLARE @TimesheetApproval varchar(4000)
  DECLARE @ProjectTimesheetApproval varchar(4000)
  DECLARE @ApproveTimesheets varchar(4000)
  DECLARE @start_pos integer
  DECLARE @end_pos integer
  DECLARE @tempstr varchar(255)
  DECLARE @done integer
  DECLARE @vwprefkey varchar(255)
  DECLARE @vwprefkey_val varchar(40)
  DECLARE @vwprefkeyseq_val varchar(40)
  DECLARE @dashboardid integer
  DECLARE @seqnum integer
  DECLARE @errors integer

BEGIN
  IF EXISTS(SELECT name FROM sysobjects where name = 'naviview' and   type = 'U' )
  BEGIN
    DECLARE nv CURSOR LOCAL FOR
    SELECT navi_view_id 
    FROM naviview
    OPEN nv

    SELECT @keys = COUNT(*)
    FROM naviview

    IF @keys > 0 BEGIN
      -- Get nextkeys for inserts
      EXEC getnextkeys 'viewpref_view_pref_id', @keys, @startkey OUTPUT
    END

    -- start a transaction to keep locks and block other transactions

  BEGIN transaction 


    FETCH NEXT FROM nv INTO @existing_naviview_id

    WHILE (@@FETCH_STATUS = 0)
    BEGIN

      SELECT @existing_naviview_name=navi_view_name, @existing_user_id=user_id, @existing_naviview_data=navi_view_data, 
           @existing_default_flag=default_flag
      FROM naviview
      WHERE navi_view_id=@existing_naviview_id

      --Add row to ViewPref
      INSERT INTO viewpref (view_pref_id, view_pref_name, view_pref_type, user_id )
      VALUES  (@startkey, @existing_naviview_name, 'VT_UIVIEW', @existing_user_id)

      IF (@@ERROR <> 0) BEGIN
        PRINT 'Unexpected error occurred in Naviview table migration'
        ROLLBACK TRAN
        RETURN
      END

      --Add rows to VWPREFDATA for each value in NAVIVIEW.navi_view_data
      SET @start_pos = CHARINDEX('<NavigationViewContentData>', @existing_naviview_data)
      SET @existing_naviview_data = RIGHT(@existing_naviview_data, LEN(@existing_naviview_data) - (@start_pos + LEN('<NavigationViewContentData>') - 1))

    
      SET @done = 0
      WHILE (@done <> 1)
        BEGIN
          SET @start_pos = CHARINDEX('<', @existing_naviview_data)
          SET @end_pos = CHARINDEX('/>', @existing_naviview_data)
          IF (@end_pos = 0) OR (@start_pos = 0)
	    SET @done = 1
          ELSE
          BEGIN
            SET @tempstr = SUBSTRING(@existing_naviview_data, @start_pos+1, @end_pos-@start_pos-1)
            SET @existing_naviview_data = RIGHT(@existing_naviview_data, LEN(@existing_naviview_data) - @end_pos -1 )
            SET @vwprefkey = RTRIM(LEFT(@tempstr, CHARINDEX(' ', @tempstr)))
            SET @start_pos = CHARINDEX('value="', @tempstr) + 7
            SET @vwprefkey_val = SUBSTRING(@tempstr, @start_pos, CHARINDEX('"', @tempstr, @start_pos)-@start_pos) 
          
            UPDATE users SET ui_view_pref_id = @startkey
            WHERE navi_view_id = @existing_naviview_id

            IF @vwprefkey = @ProjectTimesheetApproval
              SET @ProjectTimesheetApproval = @vwprefkey_val
            ELSE IF @vwprefkey = @ApproveTimesheets 
              SET @ApproveTimesheets = @vwprefkey_val
            ELSE
            BEGIN
              INSERT INTO vwprefdata (view_pref_id, view_pref_key, view_pref_value)
              VALUES  (@startkey, 'UIView.' + @vwprefkey, @vwprefkey_val) 
            
              IF (@@ERROR <> 0) BEGIN
                PRINT 'Unexpected error occurred in Naviview table migration'
                ROLLBACK TRAN
                RETURN
              END

              SET @start_pos = CHARINDEX('sequenceNum="', @tempstr) 
              IF @start_pos > 0 
              BEGIN
                SET @start_pos = @start_pos + 13
                SET @vwprefkeyseq_val = SUBSTRING(@tempstr, @start_pos, CHARINDEX('"', @tempstr, @start_pos)-@start_pos) 
	        INSERT INTO vwprefdata (view_pref_id, view_pref_key, view_pref_value)
                VALUES  (@startkey, 'UIView.' + @vwprefkey + 'Seq', @vwprefkeyseq_val)
                IF (@@ERROR <> 0) BEGIN
                  PRINT 'Unexpected error occurred in Naviview table migration'
                  ROLLBACK TRAN
                  RETURN
                END
              END
            END
          END

        END --WHILE 
      
        --Create new combo key for ProjectTimesheetApproval and ApprovedTimesheets
        SET @TimesheetApproval = 'true'
        IF (LOWER(@ProjectTimesheetApproval)='false') AND (LOWER(@ApproveTimesheets)='false')
          SET @TimesheetApproval = 'false' 
        INSERT INTO vwprefdata (view_pref_id, view_pref_key, view_pref_value)
        VALUES  (@startkey, 'UIView.' + 'TimesheetApproval', @TimesheetApproval) 

        IF (@@ERROR <> 0) BEGIN
          PRINT 'Unexpected error occurred in Naviview table migration'
          ROLLBACK TRAN
          RETURN
        END

        INSERT INTO vwprefdata (view_pref_id, view_pref_key, view_pref_value)
        VALUES  (@startkey, 'UIView.' + 'TimesheetApprovalSeq', '3')

        IF (@@ERROR <> 0) BEGIN
          PRINT 'Unexpected error occurred in Naviview table migration'
          ROLLBACK TRAN
          RETURN
        END

        --Populate VWPREFDASH
        DECLARE nd CURSOR LOCAL FOR
        SELECT dashboard_id, seq_num
        FROM navidash 
        WHERE navi_view_id = @existing_naviview_id
      
        OPEN nd
        FETCH NEXT FROM nd INTO @dashboardid, @seqnum

        WHILE (@@FETCH_STATUS = 0)
        BEGIN
	  INSERT INTO vwprefdash (dashboard_id, seq_num, view_pref_id)
          VALUES  (@dashboardid, @seqnum, @startkey)
 
          IF (@@ERROR <> 0) BEGIN
            PRINT 'Unexpected error occurred in Naviview table migration'
            ROLLBACK TRAN
            RETURN
          END

          FETCH NEXT FROM nd INTO @dashboardid, @seqnum
        END
      
        --Update Settings table with default view
        IF @existing_default_flag = 'Y'
          INSERT INTO settings (namespace, setting_name, setting_value) 
          VALUES  ('VT_UIVIEW', 'UIView.DefaultViewId', @startkey)

        CLOSE nd
        DEALLOCATE nd

        SET @startkey = @startkey + 1


      FETCH NEXT FROM nv INTO @existing_naviview_id
    END--WHILE

    CLOSE nv
    DEALLOCATE nv
    COMMIT transaction
  END --If NAVIVIEW table exists

  IF EXISTS(SELECT name FROM sysobjects where name = 'navidash' and   type = 'U' ) DROP TABLE dbo.navidash;

  IF EXISTS(SELECT name FROM sysobjects where name = 'naviview' and   type = 'U') DROP TABLE dbo.naviview;


  IF EXISTS ( SELECT name FROM sysobjects where name = 'navidash' and   type = 'V' )      drop view ${pm.ss.privileged_user}.navidash

  IF EXISTS ( SELECT name FROM sysobjects where name = 'naviview' and   type = 'V' )      drop view ${pm.ss.privileged_user}.naviview





END

go 
--END TYPE:UP2 GROUP:60to61 NAME:MIGRATE_NAVIVIEW
--METADATA TYPE:UP2 GROUP:61to62 NAME:UPDATE_VWPREFDATA 
declare vwcur cursor local for select view_pref_id from viewpref  where view_pref_type='VT_UIVIEW' 
declare @view_pref_id int
begin try
--delete rows for VWPREFDATA
delete from VWPREFDATA where VIEW_PREF_KEY in ('UIView.ApproveTimesheets','UIView.ApproveTimesheetsSeq','UIView.CreatePortfolio','UIView.CreatePortfolioSeq','UIView.InitiateProjectProcess','UIView.InitiateProjectProcessSeq','UIView.ProjectTimesheetApproval','UIView.ProjectTimesheetApprovalSeq');  
open vwcur
fetch vwcur into @view_pref_id
WHILE (@@FETCH_STATUS = 0)
BEGIN 
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) values(@view_pref_id,'UIView.DeleteProject','true')
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) values(@view_pref_id,'UIView.DeleteProjectSeq','5')
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) values(@view_pref_id,'UIView.ManagePortfoliosPort','true')
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) values(@view_pref_id,'UIView.ManagePortfoliosPortSeq','4')
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) values(@view_pref_id,'UIView.OpenPortfolios','true')
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) values(@view_pref_id,'UIView.OpenPortfoliosSeq','3')
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) values(@view_pref_id,'UIView.OpenProject','true')
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) values(@view_pref_id,'UIView.OpenProjectSeq','4')
fetch vwcur into @view_pref_id
END
close vwcur
deallocate vwcur
end try
begin catch
select ERROR_MESSAGE(),ERROR_NUMBER()
end catch
go


go 
--END TYPE:UP2 GROUP:61to62 NAME:UPDATE_VWPREFDATA
--METADATA TYPE:UP2 GROUP:61to62 NAME:DELETE_ADMIN_CONFIG 
begin
UPDATE TASKRSRC set act_this_per_qty=0.0 where act_this_per_qty is null
DELETE from admin_config where config_name = 'myprimavera.bre.INTERNAL_PLUGINS'
end
go

go 
--END TYPE:UP2 GROUP:61to62 NAME:DELETE_ADMIN_CONFIG
--METADATA TYPE:UP2 GROUP:61to62 NAME:UPDATE_SETTINGS 
begin
insert into settings (namespace, setting_name, setting_value) select distinct 'Table_Settings', 'udfvalue_denorm',
'N' from settings where not exists ( select 1 from settings where namespace='Table_Settings' and setting_name =
'udfvalue_denorm' )

insert into settings (namespace, setting_name, setting_value) select distinct 'Query_Settings',
'tasksum_query_split', 'N' from settings where not exists ( select 1 from settings where namespace='Query_Settings'
and setting_name = 'tasksum_query_split' )
end
go

go 
--END TYPE:UP2 GROUP:61to62 NAME:UPDATE_SETTINGS
--METADATA TYPE:UP2 GROUP:62to70 NAME:UPDATE_VWPREFDATA 
DECLARE @vpid int
DECLARE vpdata CURSOR FOR
  select DISTINCT view_pref_id 
  from VWPREFDATA
  where upper(view_pref_key) like upper('VT_ACTIVITY.FirstBarDisplayType')
  or    upper(view_pref_key) like upper('VT_ACTIVITY.SecondBarDisplayType');
OPEN vpdata
FETCH NEXT FROM vpdata INTO @vpid
WHILE @@Fetch_Status = 0
   BEGIN
insert into VWPREFDATA (view_pref_id, view_pref_key, view_pref_value)
select top 1 @vpid view_pref_id, 'VT_ACTIVITY.BarDisplayTypes' view_pref_key, 'NORMAL_BAR' view_pref_value
from VWPREFDATA 
where view_pref_id = @vpid
and not exists (select 1 from VWPREFDATA where upper(view_pref_key) = upper('VT_ACTIVITY.BarDisplayTypes') and view_pref_id = @vpid)

update VWPREFDATA
set view_pref_value = (select view_pref_value
   from VWPREFDATA
   where view_pref_id = @vpid and upper(view_pref_key) = upper('VT_ACTIVITY.FirstBarDisplayType'))
   + 
   case upper(IsNull((select view_pref_value
       from VWPREFDATA
       where view_pref_id = @vpid and upper(view_pref_key) = upper('VT_ACTIVITY.SecondBarDisplayType')
      ), ''))
   when 'NO_BAR' then ''
   when '' then ''
   when 'BASELINE_BAR' then ','+ 'PRIMARY_BASELINE_BAR'
   else ',' + upper(IsNull((select view_pref_value
      from VWPREFDATA
      where view_pref_id = @vpid and upper(view_pref_key) = upper('VT_ACTIVITY.SecondBarDisplayType')
      ), '')) 
   end
where view_pref_id = @vpid and upper(view_pref_key) = upper('VT_ACTIVITY.BarDisplayTypes')

delete from VWPREFDATA 
where view_pref_id = @vpid 
and   (upper(view_pref_key) like upper('VT_ACTIVITY.FirstBarDisplayType')
    or    
       upper(view_pref_key) like upper('VT_ACTIVITY.SecondBarDisplayType')
      )

FETCH NEXT FROM vpdata INTO @vpid             
END
CLOSE vpdata
DEALLOCATE vpdata
go

begin
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) select distinct(view_pref_id),'UIView.ImportExportProject','Y' from viewpref where view_pref_type='VT_UIVIEW'; 
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) select distinct(view_pref_id),'UIView.ImportExportProjectSeq','5' from viewpref where view_pref_type='VT_UIVIEW' ;
end
go

go 
--END TYPE:UP2 GROUP:62to70 NAME:UPDATE_VWPREFDATA
--METADATA TYPE:UP2 GROUP:62to70 NAME:REMOVE_JOBS 
declare
@db_version varchar(255);
begin
select @db_version=database_version from prefer;
if substring(@db_version, len ('PMDB,') + 1, 4) >'0600'
 exec drop_background_procs;
delete from settings where namespace='database.background.Damon';
delete from settings where namespace='database.background.Symon';
end;
go

go 
--END TYPE:UP2 GROUP:62to70 NAME:REMOVE_JOBS
--METADATA TYPE:UP2 GROUP:62to70 NAME:UPDATE_USERENG 
declare @dbengtype varchar(10)
declare @vuserid int
declare @vusereng_id int
begin try
create table ##dbenginetype ( dbenginetype char(10) )
insert into ##dbenginetype(dbenginetype) 
select  'PM'
union all select 'TS'
union all select 'WEB_PM'
union all select 'WEB_RM'
union all select 'WU'
union all select 'TS_ONLY'
select @vusereng_id=key_seq_num  from nextkey where key_name='usereng_user_eng_id';
declare usercur cursor for select user_id from users where prof_id=12;
open usercur
fetch usercur into @vuserid
WHILE (@@FETCH_STATUS = 0)
BEGIN 
	declare engtypecur cursor for select dbenginetype from ##dbenginetype
	open engtypecur
	fetch engtypecur into @dbengtype
      WHILE (@@FETCH_STATUS = 0)
      BEGIN
        If NOT (select count(*) from usereng where user_id=@vuserid and db_engine_type=@dbengtype) >0
        BEGIN
          insert into usereng(user_eng_id,user_id,db_engine_type) values (@vusereng_id,@vuserid,ltrim(rtrim(@dbengtype)))
          set @vusereng_id=@vusereng_id+1
       END
        fetch engtypecur into @dbengtype
      END
      close  engtypecur
      deallocate  engtypecur
      fetch usercur into @vuserid
END
close usercur
deallocate usercur
update nextkey set key_seq_num=@vusereng_id where key_name='usereng_user_eng_id';  
drop table ##dbenginetype
end try
begin catch
select ERROR_MESSAGE(),ERROR_NUMBER()
end catch
go

go 
--END TYPE:UP2 GROUP:62to70 NAME:UPDATE_USERENG
--METADATA TYPE:UP2 GROUP:70to71 NAME:MIGRATEFILTER_VWPREFDATA 
declare @vprefid integer,@max_view_pref_id integer,@vpid int,@pos int
declare vpdata  cursor for
  select DISTINCT view_pref_id
  from VWPREFDATA
  where upper(view_pref_key) like upper('VT_ACTIVITY.Filter')  and upper(view_pref_value) like upper('CustomFilter');
BEGIN
select @vprefid=key_seq_num  from nextkey where key_name='viewpref_view_pref_id';
  select @max_view_pref_id=max(view_pref_id)   from viewpref;
  if (@vprefid<=@max_view_pref_id ) 
   set  @vprefid=@max_view_pref_id+1
  open vpdata
FETCH NEXT FROM vpdata INTO @vpid
WHILE @@Fetch_Status = 0
   BEGIN
insert into viewpref(view_pref_id,view_pref_name,view_pref_type,user_id) select @vprefid,view_pref_name,'VT_FILTER',user_id from viewpref where view_pref_id=@vpid  ;
insert into VWPREFDATA (view_pref_id, view_pref_key, view_pref_value)
select @vprefid, 'VT_FILTER.FilterCriteria', view_pref_value
from VWPREFDATA
where view_pref_id = @vpid and upper(view_pref_key)=upper('VT_ACTIVITY.FilterCriteria') and not exists (select 1 from VWPREFDATA where upper(view_pref_key) = upper('VT_FILTER.FilterCriteria') and view_pref_id = @vprefid)
insert into vwprefuser(view_pref_id,user_id) select @vprefid,user_id from vwprefuser where view_pref_id=@vpid;
UPDATE VWPREFDATA SET VIEW_PREF_VALUE = 'TreeFilter' WHERE VIEW_PREF_KEY = 'VT_ACTIVITY.Filter' AND VIEW_PREF_ID =@vpid;
insert into VWPREFDATA (view_pref_id, view_pref_key, view_pref_value) values(@vpid,'VT_ACTIVITY.FiltersList',@vprefid) --from vwprefdata where not exists (select 1 from VWPREFDATA where upper(view_pref_key) = upper('VT_ACTIVITY.FiltersList') and view_pref_id = @vpid)
delete from VWPREFDATA where view_pref_id=@vpid and upper(view_pref_key)=upper('VT_ACTIVITY.FilterCriteria');
set @vprefid=@vprefid+1;
FETCH NEXT FROM vpdata INTO @vpid             
END
CLOSE vpdata
DEALLOCATE vpdata
update nextkey set key_seq_num=@vprefid where key_name='viewpref_view_pref_id';
declare vpfilterdata  cursor for
  select DISTINCT view_pref_id
  from VWPREFDATA
  where upper(view_pref_key) like upper('VT_FILTER.FilterCriteria') 
  open vpfilterdata
  FETCH NEXT FROM vpfilterdata INTO @vpid
  WHILE (@@FETCH_STATUS =0)
  BEGIN
     set @pos=0
     select @pos=charindex('UDF:',view_pref_value,0) from vwprefdata where view_pref_id=@vpid
     if @pos>0
	update vwprefdata set view_pref_value=replace(view_pref_value,'UDF:','UDF_') where view_pref_id=@vpid
     select @pos=charindex('ActivityCodeTypeId:',view_pref_value,0) from vwprefdata where view_pref_id=@vpid	
      if @pos>0
	update vwprefdata set view_pref_value=replace(view_pref_value,'ActivityCodeTypeId:','ActivityCodeTypeId_') where view_pref_id=@vpid
  FETCH NEXT FROM vpfilterdata INTO @vpid                 	
  END
CLOSE vpfilterdata
DEALLOCATE vpfilterdata
END
go

go 
--END TYPE:UP2 GROUP:70to71 NAME:MIGRATEFILTER_VWPREFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_VWPREFDATA 
declare vwcur cursor local for select view_pref_id from viewpref  where view_pref_type='VT_UIVIEW' 
declare @view_pref_id int
begin try
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,158,case p.prof_id when 12 then 'Y' else 'N' end,getdate(),session_user from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id
and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=158);
open vwcur
fetch vwcur into @view_pref_id
WHILE (@@FETCH_STATUS = 0)
BEGIN 
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) values(@view_pref_id,'UIView.CreateTemplateProject','true')
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) values(@view_pref_id,'UIView.CreateTemplateProjectSeq','6')
fetch vwcur into @view_pref_id
END
close vwcur
deallocate vwcur
end try
begin catch
select ERROR_MESSAGE(),ERROR_NUMBER()
end catch
go


go 
--END TYPE:UP2 GROUP:70to71 NAME:UPDATE_VWPREFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSRTADMCONFDATA 
Declare @earnedValue integer
Declare @valuePatternAtCompl VARCHAR(30) 
Declare @valuePatternBudgCur VARCHAR(30) 
Declare @valuePatternBudg VARCHAR(30)
 
Declare @insertValueAtCompl VARCHAR(30)
Declare @insertValueBudgCur VARCHAR(30)
Declare @insertValueBudg    VARCHAR(30)
Declare @settingsName VARCHAR(30)
Declare @position integer
   begin
	 set @valuePatternAtCompl = '%EV_AtCompl%'
	 set @valuePatternBudgCur = '%EV_Budg_With_Start_Dates%'
	 set @valuePatternBudg = '%EV_Budg%'

	 set @insertValueAtCompl = 'EV_AtCompl'
	 set @insertValueBudgCur = 'EV_BudgCur'
	 set @insertValueBudg    = 'EV_Budg'
     set @settingsName= 'EVCalculation'
	 set @earnedValue=0
     
	 select @earnedValue=1 from settings where setting_name='EVCalculation';
	 if @earnedValue=0
	 begin
		select @position=patindex(@valuePatternAtCompl,config_data) from admin_config where config_name='CS_ADMIN' and config_type='SETTINGS' and factory_version='1.0.0'
		if @position>0
        begin
			insert into settings(namespace, setting_name, setting_value) 
			values('Administrator_Settings', @settingsName, @insertValueAtCompl);
			return
        end
		select @position=patindex(@valuePatternBudgCur,config_data) from admin_config where config_name='CS_ADMIN' and config_type='SETTINGS' and factory_version='1.0.0'
		if @position>0
        begin
			 insert into settings(namespace, setting_name, setting_value) 
			 values('Administrator_Settings', @settingsName, @insertValueBudgCur);
			 return
        end
		select @position=patindex(@valuePatternBudg,config_data) from admin_config where config_name='CS_ADMIN' and config_type='SETTINGS' and factory_version='1.0.0'
		if @position>0
        begin
			  insert into settings(namespace, setting_name, setting_value) 
			  values('Administrator_Settings', @settingsName, @insertValueBudg);
			  return
        end
     end
	end

go 
--END TYPE:UP2 GROUP:70to71 NAME:INSRTADMCONFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_INSERT_SETTINGS_PROJECT 
Declare @valuePattern VARCHAR(30) 
 
Declare @position integer
begin
	 set @valuePattern = '%pvurl%'

   UPDATE settings SET namespace='Administrator_Settings', setting_name='MaxBaselinesCopiedWithProject' WHERE namespace='projectmanager.copyproject.baselines'
	 select @position=patindex(@valuePattern, config_data) from admin_config where config_name='CS_ADMIN'
		if @position>0
        begin
			insert into settings(namespace, setting_name) 
			values('Administrator_Settings', 'WebAccessURL')
			return
        end

   UPDATE project set batch_sum_flag = 'N' where sum_only_flag = 'Y';
   UPDATE project set msp_managed_flag = 'N',sum_only_flag = 'N' where msp_managed_flag != 'N' or sum_only_flag != 'N';
end

go 
--END TYPE:UP2 GROUP:70to71 NAME:UPDATE_INSERT_SETTINGS_PROJECT
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_NEW_PRIVILEDGES 
begin
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,160, case p.prof_id when 12 then 'Y' else 'N' END,getdate(),session_user from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=160) 

insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user)
select distinct p.prof_id,161,case p.allow_flag when 'Y' then 'Y' else 'N'  end , getdate(), session_user from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id  and p.priv_num = 18 and not exists(select * from profpriv where prof_id=p.prof_id and priv_num=161);


end
go

go 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_NEW_PRIVILEDGES
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_RISK 
begin
insert into Risk(risk_id,proj_id,id,name,rsrc_id,status,category_id,type,total_cost,cause,description,note)
 Select   P.Risk_id,P.Proj_id,P.risk_id,P.Risk_name,P.Rsrc_id,case P.Status_code when 'RS_Closed' then 'RS_Manage' else P.Status_code end,P.Risk_type_id,'RT_Threat',0,
 'Applies to WBS-'+ Pw.Wbs_name+char(10) +'Applies to Resource-'+isnull(r.rsrc_name,'')+char(10)+'Responsible Manager-'+isnull(o.obs_name,'')+char(10)
+ 'Priority-'+ isnull(P.Priority_type,'')+char(10) + 'Date Identified-'+ isnull(CONVERT(varchar(20) , p.add_date, 100),'')+char(10)+'Impact Date-'+isnull(CONVERT(varchar(20) , p.impact_date, 100),'')+char(10)+ 'Probability-' +isnull(str(p.prbly_pct),'') + char(10)+'Impact - Labor Units-'+isnull(str(p.impact_work_qty),'')+ char(10)+'Impact - Nonlabor Units-'+isnull(str(p.impact_equip_qty),'') +char(10)+'Impact - Material Units-'+isnull(str(p.impact_mat_qty),'') + char(10) +'Impact - Expenses-'+ isnull(str(p.impact_expense_cost),'')+  char(10),substring(p.risk_descr,1,4000),substring(rc.risk_control,1,4000) From  Projrisk P Left outer join Riskctrl rc on p.risk_id=rc.risk_id left outer join projwbs pw on p.wbs_id=pw.wbs_id  Left Outer Join Obs O On P.Obs_id=O.Obs_id Left Outer Join  Rsrc R On P.Rsrc_id=R.Rsrc_id 
where P.Risk_id not in (select risk_id from risk);
update nextkey set key_seq_num=(select key_seq_num from nextkey where KEY_NAME='projrisk_risk_id') where KEY_NAME='risk_risk_id';
Update Udftype Set Table_name='RISK',update_date=getdate(),update_user=session_user Where Table_name='PROJRISK';
update calendar set rsrc_private = 'N' where rsrc_private != 'N';

update calendar set rsrc_private = 'Y'
where clndr_id in (select c.clndr_id 
                      from rsrc r,calendar c 
                      where r.clndr_id=c.clndr_id and c.clndr_type='CA_Rsrc' 
                      group by c.clndr_id having count(1) = 1)
  and clndr_id in (select c.clndr_id 
                      from users u,profpriv p, rsrc r, calendar c 
                      where u.prof_id=p.prof_id and p.priv_num=100 and p.allow_flag='Y' 
                      and r.user_id = u.user_id and r.clndr_id= c.clndr_id);
end
go

go 
--END TYPE:UP2 GROUP:70to71 NAME:UPDATE_RISK
--METADATA TYPE:UP2 GROUP:70to71 NAME:CLEAN_JOBSVC_TASKRSRC 
begin
  DELETE FROM jobsvc WHERE job_type='JT_Batch' OR job_type='JT_XERExport' OR recur_type='RT_ASAP';
  UPDATE jobsvc SET recur_type='RT_WebEnabled' WHERE recur_type='RT_RecurEnabled';
  UPDATE taskrsrc SET ot_factor=0,update_date=getdate(),update_user=session_user WHERE rsrc_id IS NULL and (ot_factor is null or ot_factor!=0 );
end
go

go 
--END TYPE:UP2 GROUP:70to71 NAME:CLEAN_JOBSVC_TASKRSRC
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF 
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF 
declare @vprefid integer
begin
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'AssignINoWhatIf','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignINoWhatIf' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
  select @vprefid,'AssignHActive','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignHActive' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 

  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'AssignCInProgress','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignCInProgress' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
  select @vprefid,'AssignFFinDays','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignFFinDays' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
  select @vprefid,'AssignAMyAssign','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignAMyAssign' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
  select @vprefid,'AssignGUnStaffed','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignGUnStaffed' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'AssignEOccurDays','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignEOccurDays' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'AssignBNotStarted','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignBNotStarted' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'AssignDCompleted','VT_ASSGN_FILT_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='AssignDCompleted' and VIEW_PREF_TYPE = 'VT_ASSGN_FILT_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'InProgressActivitiesOnly','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='InProgressActivitiesOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
  select @vprefid,'ActivitiesFinishingSoon','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ActivitiesFinishingSoon' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'CompletedActivitiesOnly','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='CompletedActivitiesOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'NotStartedActivitiesOnly','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='NotStartedActivitiesOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
  select @vprefid,'MilestoneOnly','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='MilestoneOnly' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'MyActivities','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='MyActivities' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ActivitiesProgressing','VT_FILTER_STANDARD'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ActivitiesProgressing' and VIEW_PREF_TYPE = 'VT_FILTER_STANDARD') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectBEPS','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectBEPS' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectGWhatIf','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectGWhatIf' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectCActive','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectCActive' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectAOpenOnly','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectAOpenOnly' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectFTemplate','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectFTemplate' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectDInactive','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectDInactive' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
  
  exec pc_get_next_key 'viewpref_view_pref_id', @vprefid OUTPUT;
  insert into viewpref (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE)
  select @vprefid,'ProjectEPlanned','VT_PROJ_FILTER_STAND'
  where not exists ( select view_pref_id from viewpref where VIEW_PREF_NAME='ProjectEPlanned' and VIEW_PREF_TYPE = 'VT_PROJ_FILTER_STAND') ; 
end;

--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF 
DELETE FROM profpriv where priv_num=143;
go

go 
--END TYPE:UP2 GROUP:70to71 NAME:USERENG_VIEWPREF
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA 
--METADATA TYPE:UP2 GROUP:70to71 NAME:DELETE_VWPREFDATA
delete from vwprefdata where view_pref_key in ('UIView.ProjectDetailsSeq','UIView.ProjectToolsSeq','UIView.ProjectInvitedUsersSeq','UIView.ProjectIssueFormsSeq','UIView.ProjectDetails','UIView.ProjectTools','UIView.ProjectInvitedUsers','UIView.ProjectIssueForms')
go
--METADATA TYPE:UP2 GROUP:70to71 NAME:UPDATE_VWPREFDATA 
update vwprefdata set view_pref_value=view_pref_value+1,update_date=getdate()  where view_pref_id in (select view_pref_id from viewpref where  view_pref_type='VT_UIVIEW') and view_pref_key<>'UIView.ProjectEPSSeq' and view_pref_key like 'UIView.Pr%Seq' and view_pref_value>='1'
go
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA 
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value,create_date) select distinct vwp.view_pref_id,'UIView.ProjectEPSSeq','1',getdate() from vwprefdata vwp,viewpref vp where vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW'   and  not exists(select * from vwprefdata vw where vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ProjectEPSSeq' and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
go
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA 
insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value,create_date) select distinct vwp.view_pref_id,'UIView.ProjectEPS','true',getdate() from vwprefdata vwp,viewpref vp where vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW'   and  not exists(select * from vwprefdata vw where vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ProjectEPS' and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
go

go 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_VWPREFDATA
--METADATA TYPE:UP2 GROUP:70to71 NAME:VWPREFDATA_UPDATES 

DECLARE cur_notfin_vpid CURSOR FOR
  SELECT view_pref_id
  FROM   vwprefdata
  WHERE  view_pref_key = 'VT_ACTIVITY.Filter'
         AND view_pref_value = 'NotFinishedActivitiesOnly'
DECLARE @v_id_list VARCHAR(100),
        @v_pref_id INT
begin
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select distinct vwp.view_pref_id,'UIView.ResourceManagement','false' 
  from vwprefdata vwp,viewpref vp
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceManagement' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
    and vwp.view_pref_id not in (
      select distinct view_pref_id
      from vwprefdata 
      where view_pref_key in ('UIView.AddResource','UIView.ManageRoleTeams','UIView.CreateResourceTeam','UIView.ResourceDetails') and view_pref_value = 'true'
      ) ;
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select distinct vwp.view_pref_id,'UIView.ResourceManagement','true' 
  from vwprefdata vwp,viewpref vp
  where vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
    and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceManagement' 
    and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
    and vwp.view_pref_id in (
      select distinct view_pref_id
      from vwprefdata 
      where view_pref_key in ('UIView.AddResource','UIView.ManageRoleTeams','UIView.CreateResourceTeam','UIView.ResourceDetails') 
        and view_pref_value = 'true'
      ) ;
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select  distinct  vwp.view_pref_id,'UIView.ResourceRoleUsageAnalysis','false' 
  from vwprefdata vwp,viewpref vp 
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
     and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceRoleUsageAnalysis' 
     and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW') 
     and vwp.view_pref_id not in (select distinct view_pref_id
                                 from vwprefdata  
                                 where view_pref_key in ('UIView.ResourceAnalysis','UIView.ResourceUsage','UIView.ViewRoleUsage') 
      and view_pref_value = 'true');
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select  distinct  vwp.view_pref_id,'UIView.ResourceRoleUsageAnalysis','true' 
  from vwprefdata vwp,viewpref vp 
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
     and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.ResourceRoleUsageAnalysis' 
     and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW') 
     and vwp.view_pref_id in (select distinct view_pref_id from vwprefdata  where view_pref_key in ('UIView.ResourceAnalysis','UIView.ResourceUsage','UIView.ViewRoleUsage') 
     and view_pref_value = 'true');
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select  distinct  vwp.view_pref_id,'UIView.HighLevelPlanning','true' 
  from vwprefdata vwp,viewpref vp 
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
     and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.HighLevelPlanning' 
     and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
     and vwp.view_pref_id in (select distinct view_pref_id from vwprefdata  where view_pref_key='UIView.PlanResources' and view_pref_value = 'true');
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select  distinct  vwp.view_pref_id,'UIView.HighLevelPlanning','false' 
  from vwprefdata vwp,viewpref vp 
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
     and not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.HighLevelPlanning' 
     and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW')
     and vwp.view_pref_id not in (select distinct view_pref_id from vwprefdata  where view_pref_key='UIView.PlanResources' and view_pref_value = 'true');
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value)
  select  distinct  vwp.view_pref_id,'UIView.DetailedPlanning','true' 
  from vwprefdata vwp,viewpref vp 
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
     and not exists(select *
                    from vwprefdata vw
                    where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.DetailedPlanning'
                       and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW');
  insert into vwprefdata(view_pref_id,view_pref_key,view_pref_value) 
  select  distinct  vwp.view_pref_id,'UIView.EnterpriseResourceData','true' 
  from vwprefdata vwp,viewpref vp 
  where  vwp.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW' 
     and  not exists(select * from vwprefdata vw where  vw.view_pref_id=vwp.view_pref_id and vw.view_pref_key='UIView.EnterpriseResourceData' 
     and vw.view_pref_id=vp.view_pref_id and vp.view_pref_type='VT_UIVIEW');
     
    SELECT @v_id_list = CAST(Min(view_pref_id) AS varchar(30)) + ',' + CAST(Max(view_pref_id) AS varchar(30))
    FROM   viewpref
    WHERE  view_pref_name IN ( 'InProgressActivitiesOnly',
                               'NotStartedActivitiesOnly' );
    OPEN cur_notfin_vpid
    FETCH next FROM cur_notfin_vpid INTO @v_pref_id
    WHILE ( @@FETCH_STATUS = 0 )
      BEGIN
          UPDATE vwprefdata
          SET    view_pref_value = 'TreeFilter'
          WHERE  view_pref_key = 'VT_ACTIVITY.Filter'
                 AND view_pref_id = @v_pref_id;

          INSERT INTO vwprefdata
                      (view_pref_id,
                       view_pref_key,
                       view_pref_value)
          VALUES     (@v_pref_id,
                      'VT_ACTIVITY.FiltersList',
                      @v_id_list);

          INSERT INTO vwprefdata
                      (view_pref_id,
                       view_pref_key,
                       view_pref_value)
          VALUES     (@v_pref_id,
                      'VT_ACTIVITY.FiltersOperator',
                      'OR');

          FETCH next FROM cur_notfin_vpid INTO @v_pref_id
      END

    CLOSE cur_notfin_vpid
    DEALLOCATE cur_notfin_vpid     
end;


go 
--END TYPE:UP2 GROUP:70to71 NAME:VWPREFDATA_UPDATES
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV 
--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV 
DELETE from usereng
where db_engine_type ='TS'
  and user_id in (select user_id from usereng where db_engine_type != 'PM' and db_engine_type != 'TS');
go

--METADATA TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV 
DELETE FROM profpriv where priv_num=151;
go

go 
--END TYPE:UP2 GROUP:70to71 NAME:USERENG_PROFPRIV
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_WEB_PM 
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_WEB_PM 
declare @userengid integer
declare @userid integer
begin
  DECLARE curusers CURSOR LOCAL FOR
  SELECT user_id
  FROM users
  WHERE prof_id = 12 AND user_id NOT IN (
	  SELECT e.user_id 
	  FROM usereng e, users u
	  WHERE e.user_id = u.user_id AND 
	        u.prof_id = 12 AND e.db_engine_type = 'WEB_PM');
  OPEN curusers
  FETCH curusers INTO @userid
  WHILE (@@FETCH_STATUS = 0)
  BEGIN
    exec pc_get_next_key 'usereng_user_eng_id', @userengid OUTPUT;
  
    insert into usereng (user_eng_id, user_id, db_engine_type)
    values (@userengid, @userid, 'WEB_PM');

    FETCH curusers INTO @userid

  END
  CLOSE curusers
  DEALLOCATE curusers

end;
go

go 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_WEB_PM
--METADATA TYPE:UP2 GROUP:70to71 NAME:INSERT_EDIT_CURRENTCIES 
--METADATA  TYPE:ADHOC_SQL
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select prof_id,159,case p.allow_flag when 'Y' then 'Y' else 'N' END,getdate(),session_user from profpriv p where priv_num=22  and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=159)
go


go 
--END TYPE:UP2 GROUP:70to71 NAME:INSERT_EDIT_CURRENTCIES
--METADATA TYPE:UP2 GROUP:81to82 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:81to82 NAME:MISC_UPDATES

Update vwprefdata set view_pref_value = 'Name' where view_pref_value = 'ActivityName' and view_pref_key = 'VT_PROJECT.LabelField';
go
--METADATA TYPE:UP2 GROUP:81to82 NAME:MISC_UPDATES 

insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,168,'N',getdate(),session_user from profpriv p,profile pf  where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=168);
go
go 
--END TYPE:UP2 GROUP:81to82 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
INSERT INTO SETTINGS (namespace,setting_name,setting_value)
select  'Administrator_Settings','OnlineHelpRootUrl','http://docs.oracle.com/cd/E35157_01/client_help/' from prefer 
 where not exists (select * from SETTINGS where namespace= 'Administrator_Settings' and  setting_name = 'OnlineHelpRootUrl') 
go

--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
update settings set setting_value = 'http://docs.oracle.com/cd/E35157_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
declare @vpropid integer
begin
  exec pc_get_next_key 'viewprop_view_id', @vpropid OUTPUT;
  insert into viewprop (VIEW_ID,VIEW_NAME,VIEW_TYPE)
  select @vpropid,'Default Import Template','VP_XML_IMP_DET_OPT'
  where not exists ( select view_id from viewprop where VIEW_NAME='Default Import Template' and VIEW_TYPE = 'VP_XML_IMP_DET_OPT') ; 
  end;
go

--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES

UPDATE PROJECT SET px_enable_publication_flag = 'N' where orig_proj_id IS NOT NULL;
go

--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES

Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (1,'UserId','int');
go

Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (2,'AuthorId','int');
go

Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (3,'ProjectId','int');
go

Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (4,'LocalFilePath','String');
go

Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (5,'SecurityPolicy','String');
go

Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (6,'WorkflowId','int');
go

Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (7,'CheckedOutUserId','int');
go

Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (8,'WorkgroupId','int');
go

Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (9,'CheckedOutDate','Date');
go

Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (10,'Template','boolean');
go

Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (11,'WorkflowStatus','String');
go

Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (12,'WorkflowAction','String');
go

Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (13,'IsReviewAttachment','boolean');
go

Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) values (14,'CheckedOutGuid','String');
go

go 
--END TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:82to83 NAME:MISC_UPDATES

insert into nextkey select  lower('PC_KEY_XREF_execution_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('PC_KEY_XREF_execution_id')) 
go
go 
--END TYPE:UP2 GROUP:83to83 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
update PROFILE set prof_name = 'Timesheets only' where prof_name = 'Progress Reporters / Timesheets only'
go

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
update settings set setting_value = 'http://docs.oracle.com/cd/E35157_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
begin
insert into settings (namespace, setting_name, setting_value) select distinct 'Administrator_Settings', 'AlwaysLaunchOnlineHelp', 'Y' 
from settings where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name = 'AlwaysLaunchOnlineHelp')
end
go


--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
declare @p3 int,
  @userid int
declare uid_cur cursor 
for 
select ue1.user_id
from usereng ue1
where ue1.user_id = 25
and  ue1.db_engine_type = 'PM'
and  not exists (
   select 1 
   from usereng ue2
   where ue2.user_id = ue1.user_id
   and  ue2.db_engine_type = 'TM'
)
OPEN uid_cur
FETCH NEXT FROM uid_cur INTO @userid
WHILE @@FETCH_STATUS = 0
BEGIN
    PRINT 'userid : ' + cast(@userid as varchar(10))
 exec getnextkeys 'usereng_user_eng_id',1,@p3 output
 INSERT INTO usereng (user_eng_id, user_id, db_engine_type) 
 values(@p3, @userid, 'TM')
    FETCH NEXT FROM uid_cur INTO @userid
END 
CLOSE uid_cur
DEALLOCATE uid_cur
go

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
declare @p3 int,
  @userid int
declare uid_cur cursor 
for 
select ue1.user_id
from usereng ue1
where ue1.user_id = 91
and  ue1.db_engine_type = 'PM'
and  not exists (
   select 1 
   from usereng ue2
   where ue2.user_id = ue1.user_id
   and  ue2.db_engine_type = 'TM'
)
OPEN uid_cur
FETCH NEXT FROM uid_cur INTO @userid
WHILE @@FETCH_STATUS = 0
BEGIN
    PRINT 'userid : ' + cast(@userid as varchar(10))
 exec getnextkeys 'usereng_user_eng_id',1,@p3 output
 INSERT INTO usereng (user_eng_id, user_id, db_engine_type) 
 values(@p3, @userid, 'TM')
    FETCH NEXT FROM uid_cur INTO @userid
END 
CLOSE uid_cur
DEALLOCATE uid_cur
go

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
update RSRC set timesheet_flag = 'Y' where user_id = (select user_id from users where user_name = 'admin')
go

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
update settings set setting_value = 'Y' where setting_name = 'AlwaysLaunchOnlineHelp'
go

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
update settings set setting_value = 'http://docs.oracle.com/cd/E54700_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
declare
	@ts_count bit,
	@tm_count bit,
	@ts_flag_count bit,
	@userid int,
	@v_user_eng_id int
declare user_cur cursor
for select user_id from users
	OPEN user_cur
	FETCH NEXT FROM user_cur INTO @userid
	WHILE @@FETCH_STATUS = 0
	BEGIN
		set @ts_count = (select isnull(count(*), 0) from usereng where db_engine_type='TS_ONLY' and user_id = @userid)
		set @tm_count = (select isnull(count(*), 0) from usereng where db_engine_type='TM' and user_id = @userid)
		set @ts_flag_count = (select isnull(count(*), 0) from rsrc where user_id = @userid and timesheet_flag = 'Y')
		if(@ts_count > 0)
			begin
				if(@tm_count > 0 and @ts_flag_count = 0)
					delete from usereng where db_engine_type = 'TS_ONLY' and user_id = @userid
				else if(@tm_count = 0 and @ts_flag_count > 0)
					begin
						exec getnextkeys 'usereng_user_eng_id',1,@v_user_eng_id output
						insert into usereng (user_eng_id,user_id,db_engine_type) values (@v_user_eng_id, @userid, 'TM')
					end
				else if(@tm_count = 0 and @ts_flag_count = 0)
					begin
						delete from usereng where db_engine_type = 'TS_ONLY' and user_id = @userid
						exec getnextkeys 'usereng_user_eng_id',1,@v_user_eng_id output
						insert into usereng (user_eng_id,user_id,db_engine_type) values (@v_user_eng_id, @userid, 'TM')
					end	
			end
		FETCH NEXT FROM user_cur INTO @userid
	end
	close user_cur
	DEALLOCATE user_cur
	go
	
	
--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES	
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,171,'N',getdate(),session_user 
from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=171)
go

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,172,'N',getdate(),session_user 
from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=172)
go

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,173,'N',getdate(),session_user 
from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=173)
go

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,174,'N',getdate(),session_user 
from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=174)
go

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,175,'N',getdate(),session_user 
from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=175)
go

--METADATA TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user) select distinct p.prof_id,170,'N',getdate(),session_user from profpriv p,profile pf  
where scope_type='ST_Global' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=170)
go

go 
--END TYPE:UP2 GROUP:83to84 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E58732_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
insert into nextkey select  lower('settings_setting_id'),1 from PREFER where not exists (select * from nextkey where key_name=lower('settings_setting_id')) 
go

--METADATA TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
declare @p3 int,
  @userid int
declare uid_cur cursor 
for 
select distinct ue1.user_id from usereng ue1
where ue1.db_engine_type in ('PM','WEB_PM','WEB_RM')
OPEN uid_cur
FETCH NEXT FROM uid_cur INTO @userid
WHILE @@FETCH_STATUS = 0
BEGIN
    PRINT 'userid : ' + cast(@userid as varchar(10))
 exec getnextkeys 'usereng_user_eng_id',1,@p3 output
 INSERT INTO usereng (user_eng_id, user_id, db_engine_type) 
 values(@p3, @userid, 'VIS')
    FETCH NEXT FROM uid_cur INTO @userid
END 
CLOSE uid_cur
DEALLOCATE uid_cur
go
go 
--END TYPE:UP2 GROUP:84to151 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:151to151 NAME:TRIGGER_USESSION 
--METADATA NAME:RT_USESSION_DEL TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:DROP
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_USESSION_DEL' and type in ('TR'))
  DROP TRIGGER RT_USESSION_DEL
go

--METADATA  TYPE:SSCR NAME:RT_USESSION OBJECT_TYPE:TRIGGER
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'RT_USESSION' and type in ('TR'))
  DROP TRIGGER RT_USESSION
go

--METADATA NAME:RT_USESSION TYPE:TRIGGER SET:REFRESH_AUDIT CHANGE:CREATE
CREATE TRIGGER RT_USESSION
on USESSION
for update,insert
as     
declare @sid integer, @app_name varchar(25), @user_name varchar(255), @del_cnt integer
declare @pk1 varchar(255), @pk2 varchar(255),@pk3 varchar(255), @pk4 varchar(255) 
exec audit_prm_user @sid output, @user_name output , @app_name output
select @del_cnt=count(*) from deleted;

update USESSION
set update_date = getdate()    
, update_user = @user_name
, create_user =  case @del_cnt WHEN 0 then @user_name else USESSION.create_user end
, create_date =  case @del_cnt WHEN 0 then getdate() else USESSION.create_date end
from inserted 
where USESSION.session_id = inserted.session_id
go
go 
--END TYPE:UP2 GROUP:151to151 NAME:TRIGGER_USESSION
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
DECLARE @id INT,@v_auditdata_id int,@tblexists int
declare @sql_stmt NVARCHAR(100) = 'UPDATE PRMAUDIT SET @id = auditdata_id = @id + 1';
SET @id = 0
SELECT @tblexists=count(*) FROM sys.objects where type ='U' and name ='PRMAUDIT' 
IF @tblexists > 0 
begin
IF COL_LENGTH('prmaudit', 'auditdata_id') IS NOT NULL
 begin
	EXECUTE sp_executesql @sql_stmt, N'@id INT', @id;
	--UPDATE PRMAUDIT SET @id = auditdata_id = @id + 1
    UPDATE NEXTKEY SET key_seq_num = @id + 1 
    WHERE key_name = lower('PRMAUDIT_auditdata_id')
 end
end
go

--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
declare @v_chk_null varchar(3),@tblexists int
SELECT @tblexists=count(*) FROM sys.objects where type ='U' and name ='PRMAUDIT' 
IF @tblexists > 0 
begin
IF COL_LENGTH('prmaudit', 'auditdata_id') IS NOT NULL
 begin
    select @v_chk_null=is_nullable from information_schema.columns
        where lower(table_name)='prmaudit' and lower(column_name)= 'auditdata_id'
    if upper(@v_chk_null)='YES'	
     alter table prmaudit alter column auditdata_id integer not null 
 end
end
go

--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
declare @v_cnt int,@tblexists int
SELECT @tblexists=count(*) FROM sys.objects where type ='U' and name ='PRMAUDIT' 
IF @tblexists > 0 
begin
IF COL_LENGTH('prmaudit', 'auditdata_id') IS NOT NULL
 begin
    select @v_cnt=count(*) from sysobjects where type ='k' and upper(name) = 'PK_PRMAUDIT'
    if @v_cnt = 0
     alter table prmaudit add constraint pk_prmaudit primary key (auditdata_id)
 end
end
go  

--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
declare @v_num int,@v_cnt int
select @v_cnt=count(*) from settings 
where namespace = 'database.audit' and setting_name = 'Enabled' ;
if @v_cnt = 0 
begin
exec getnextkeys 'settings_setting_id',1,@v_num OUTPUT
insert into settings 
(namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id)
values ('database.audit','Enabled','false',null,getDate(),'admin',getDate(),'admin',null,null,@v_num)
end
go
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
Delete from vwprefdata where
view_pref_key IN ('VT_ACTIVITY.DetailWindowPositions' ,'VT_PROJECT.DetailWindowPositions')
go
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update prefer set phase_label='WBS Catagories'
go 
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user)select distinct p.prof_id,176,'N', getdate(), session_user
from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=176) 
go
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
declare @v_view_pref_id int
declare @cur_view_pref cursor 
SET @cur_view_pref = CURSOR FAST_FORWARD 
for select view_pref_id  from vwprefdata 
where view_pref_id in (select view_pref_id from viewpref where view_pref_type = 'vt_uiview')
and view_pref_key = 'uiview.projectactivities' and upper(view_pref_value) in ('FALSE','N');
open @cur_view_pref
FETCH NEXT FROM @cur_view_pref INTO @v_view_pref_id
WHILE @@FETCH_STATUS = 0
begin
insert into vwprefdata   (view_pref_id,view_pref_key,view_pref_value) values(@v_view_pref_id,'uiview.projectactivitiesclassicview','N' );
insert into vwprefdata  (view_pref_id,view_pref_key,view_pref_value) values(@v_view_pref_id,'uiview.projectactivitiesclassicviewdefault','N' );
FETCH NEXT FROM @cur_view_pref INTO @v_view_pref_id
END
CLOSE @cur_view_pref
DEALLOCATE @cur_view_pref
go
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E63417_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update task set est_wt=1 where est_wt is null
go
--METADATA TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
update projwbs set est_wt=1 where est_wt is null
go

go 
--END TYPE:UP2 GROUP:151to152 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
update project set publish_spread_assign_level='SL_Taskrsrc'
go

--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
declare @v_num int
exec getnextkeys 'viewpref_view_pref_id',1,@v_num OUTPUT
insert into viewpref (view_pref_id, view_pref_name, view_pref_type) select @v_num,'WBSOnly', 'VT_FILTER_STANDARD' from prefer where not exists( select 1 from viewpref where view_pref_name='WBSOnly' and  view_pref_type='VT_FILTER_STANDARD')
go

--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
declare 
     @v_streamfile_path nvarchar(300),
     @v_streamfile_path_name nvarchar(300),
	 @v_sql nvarchar(4000),
	 @FILE_CNT int,
	 @FILE_GRP_CNT int;
DECLARE @DB_NAME sysname
--SELECT @FILE_CNT=COUNT(*) FROM master.sys.master_files WHERE NAME ='fs_file1';
--IF @FILE_CNT = 0 
--BEGIN
SELECT @DB_NAME=DB_NAME()
SELECT @FILE_GRP_CNT=count(*) FROM SYS.filegroups WHERE NAME = @DB_NAME +'_fs_files';
set @v_streamfile_path=(SELECT SUBSTRING(physical_name, 1, CHARINDEX(N'master.mdf', LOWER(physical_name)) - 1)
				  FROM master.sys.master_files
				  WHERE database_id = 1 AND file_id = 1);
--filestrem file path with file name
--set @v_streamfile_path_name=@v_streamfile_path + 'filestream_doc.mdf';
--Adding filestrem filegroup to existing database
IF @FILE_GRP_CNT = 0
BEGIN
SET @v_sql = 'alter database ' + @DB_NAME + ' add filegroup '+ @DB_NAME +'_fs_files contains filestream'
EXEC (@v_sql)
END
SET @v_streamfile_path_name= @v_streamfile_path +@DB_NAME +'_fs_doc.mdf'
SELECT @FILE_CNT=COUNT(*) FROM sys.master_files WHERE NAME ='fs_file1' and PHYSICAL_NAME LIKE '%' + @DB_NAME + '_fs_doc.mdf' ;

IF @FILE_CNT = 0 
BEGIN
SET @v_sql = 'ALTER DATABASE '+ @DB_NAME +' ADD FILE (NAME= ''fs_file1'',FILENAME = '''+@v_streamfile_path_name+''') TO FILEGROUP '+ @DB_NAME +'_fs_files'
EXEC (@v_sql)
END
go
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
alter table jobsvc add job_data_x_id uniqueidentifier ROWGUIDCOL not null unique default NEWID()
go
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
if exists(select * from sys.columns where name = 'job_data_x' and object_id = object_id('jobsvc'))
alter table jobsvc drop column job_data_x;
go
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
alter table jobsvc add job_data_x varbinary(max) filestream null;
go
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
delete from settings where lower(setting_name) in( 'usermiforapi' ,'rmiurl')
go
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
update doc set doc_update_date=update_date where doc_update_date is null;
go
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
declare @v_view_pref_id int,@v_view_pref_key varchar(255)
declare @cur_view_pref cursor 
SET @cur_view_pref = CURSOR FAST_FORWARD
for select view_pref_id,view_pref_key from vwprefdata 
where view_pref_id in (select view_pref_id from viewpref where view_pref_type = 'VT_UIVIEW')
and view_pref_key in ('UIView.ProjectActivities','UIView.ProjectEPS') and upper(view_pref_value) in ('TRUE','Y')
open @cur_view_pref
FETCH NEXT FROM @cur_view_pref INTO @v_view_pref_id,@v_view_pref_key
WHILE @@FETCH_STATUS = 0
begin
if @v_view_pref_key = 'UIView.ProjectActivities' 
begin
MERGE vwprefdata AS target
    USING (SELECT @v_view_pref_id,'UIView.ProjectActivitiesClassicView') AS source (view_pref_id,view_pref_key)
    ON (target.view_pref_id = source.view_pref_id and target.view_pref_key = source.view_pref_key)
    WHEN MATCHED THEN 
        UPDATE SET view_pref_value = 'Y'
WHEN NOT MATCHED THEN
    insert  (view_pref_id,view_pref_key,view_pref_value) values(source.view_pref_id,source.view_pref_key,'Y');

MERGE vwprefdata AS target
    USING (SELECT @v_view_pref_id,'UIView.ProjectActivitiesClassicViewDefault') AS source (view_pref_id,view_pref_key)
    ON (target.view_pref_id = source.view_pref_id and target.view_pref_key = source.view_pref_key)
    WHEN MATCHED THEN 
        UPDATE SET view_pref_value = 'N'
WHEN NOT MATCHED THEN
    insert  (view_pref_id,view_pref_key,view_pref_value) values(source.view_pref_id,source.view_pref_key,'N');

MERGE vwprefdata AS target
    USING (SELECT @v_view_pref_id,'UIView.ProjectActivitiesBasicView') AS source (view_pref_id,view_pref_key)
    ON (target.view_pref_id = source.view_pref_id and target.view_pref_key = source.view_pref_key)
    WHEN MATCHED THEN 
        UPDATE SET view_pref_value = 'Y'
WHEN NOT MATCHED THEN
    insert  (view_pref_id,view_pref_key,view_pref_value) values(source.view_pref_id,source.view_pref_key,'Y');
	
MERGE vwprefdata AS target
    USING (SELECT @v_view_pref_id,'UIView.ProjectActivitiesBasicViewDefault') AS source (view_pref_id,view_pref_key)
    ON (target.view_pref_id = source.view_pref_id and target.view_pref_key = source.view_pref_key)
    WHEN MATCHED THEN 
        UPDATE SET view_pref_value = 'Y'
WHEN NOT MATCHED THEN
    insert  (view_pref_id,view_pref_key,view_pref_value) values(source.view_pref_id,source.view_pref_key,'Y');	
end
if @v_view_pref_key = 'UIView.ProjectEPS' 
begin
MERGE vwprefdata AS target
    USING (SELECT @v_view_pref_id,'UIView.ProjectEPSClassicView') AS source (view_pref_id,view_pref_key)
    ON (target.view_pref_id = source.view_pref_id and target.view_pref_key = source.view_pref_key)
    WHEN MATCHED THEN 
        UPDATE SET view_pref_value = 'Y'
WHEN NOT MATCHED THEN
    insert  (view_pref_id,view_pref_key,view_pref_value) values(source.view_pref_id,source.view_pref_key,'Y');

MERGE vwprefdata AS target
    USING (SELECT @v_view_pref_id,'UIView.ProjectEPSClassicViewDefault') AS source (view_pref_id,view_pref_key)
    ON (target.view_pref_id = source.view_pref_id and target.view_pref_key = source.view_pref_key)
    WHEN MATCHED THEN 
        UPDATE SET view_pref_value = 'N'
WHEN NOT MATCHED THEN
    insert  (view_pref_id,view_pref_key,view_pref_value) values(source.view_pref_id,source.view_pref_key,'N');

MERGE vwprefdata AS target
    USING (SELECT @v_view_pref_id,'UIView.ProjectEPSBasicView') AS source (view_pref_id,view_pref_key)
    ON (target.view_pref_id = source.view_pref_id and target.view_pref_key = source.view_pref_key)
    WHEN MATCHED THEN 
        UPDATE SET view_pref_value = 'Y'
WHEN NOT MATCHED THEN
    insert  (view_pref_id,view_pref_key,view_pref_value) values(source.view_pref_id,source.view_pref_key,'Y');
	
MERGE vwprefdata AS target
    USING (SELECT @v_view_pref_id,'UIView.ProjectEPSBasicViewDefault') AS source (view_pref_id,view_pref_key)
    ON (target.view_pref_id = source.view_pref_id and target.view_pref_key = source.view_pref_key)
    WHEN MATCHED THEN 
        UPDATE SET view_pref_value = 'Y'
WHEN NOT MATCHED THEN
    insert  (view_pref_id,view_pref_key,view_pref_value) values(source.view_pref_id,source.view_pref_key,'Y');
end
FETCH NEXT FROM @cur_view_pref INTO @v_view_pref_id,@v_view_pref_key
END
CLOSE @cur_view_pref
DEALLOCATE @cur_view_pref
go
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
declare @v_num int,@v_cnt int
select @v_cnt=count(*) from settings 
where namespace = 'PxService.Project.Arbiter' and setting_name = 'PublishRsrcRoleSpread' ;
if @v_cnt = 0 
begin
exec getnextkeys 'settings_setting_id',1,@v_num OUTPUT
insert into settings 
(namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id)
values ('PxService.Project.Arbiter','PublishRsrcRoleSpread','N',null,getDate(),'admin',getDate(),'admin',null,null,@v_num)
end
go
--METADATA TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E68202_01' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:152to161 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
UPDATE PROJECT SET etl_interval  = 24
go
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
UPDATE PROJECT SET etl_hour  = 0
go
--METADATA TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E75426_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
--METADATA NAME:sspm_settings TYPE:EXEC
declare 
@v_setting_id int,@namespace varchar(30),@setting_name varchar(30),@v_itr int
select @v_setting_id=isnull(max(setting_id),0) from settings where setting_id is not null
set @v_itr = @v_setting_id
if @v_setting_id = 0
begin
declare cur_settings CURSOR FOR SELECT namespace,setting_name FROM settings;
set @v_itr = 1
OPEN cur_settings  
FETCH NEXT FROM cur_settings INTO @namespace,@setting_name  
WHILE @@FETCH_STATUS = 0  
BEGIN  
	  print @v_itr;
	  update settings set setting_id=@v_itr where namespace=@namespace and setting_name=@setting_name;
	  set @v_itr = @v_itr + 1
      FETCH NEXT FROM cur_settings INTO @namespace,@setting_name
END 
CLOSE cur_settings  
DEALLOCATE cur_settings
update nextkey set key_seq_num = @v_itr + 1
  where key_name='settings_setting_id'
if not exists (SELECT 1 
    FROM settings 
    WHERE namespace='database.proc')
insert into settings 
(namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id)
values ('database.proc','ExecCleanPxDelete','Y',null,getdate(),'admin',getdate(),'admin',null,null,@v_itr) 
end
else
BEGIN
update nextkey set key_seq_num = @v_itr + 2
  where key_name='settings_setting_id'
if not exists (SELECT 1 
    FROM settings 
    WHERE namespace='database.proc')
insert into settings 
(namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id)
values ('database.proc','ExecCleanPxDelete','Y',null,getdate(),'admin',getdate(),'admin',null,null,@v_itr+1) 
END
go

--METADATA NAME:sspm_settings TYPE:EXEC
declare 
@v_setting_id int
select @v_setting_id=max(setting_id) from settings where setting_id is not null
update nextkey set key_seq_num = @v_setting_id + 2
  where key_name='settings_setting_id'
if not exists (SELECT 1 
    FROM settings 
    WHERE namespace='PxService.TimeDistribution')
insert into settings 
(namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id)
values ('PxService.TimeDistribution','Interval','SBT_WEEK',null,getdate(),'admin',getdate(),'admin',null,null,@v_setting_id +1) 
go
go 
--END TYPE:UP2 GROUP:161to162 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:162to171 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:162to171 NAME:MISC_UPDATES
insert into nextkey select  lower('project_etl_list_etl_id'),1 from PREFER where not exists (select * from nextkey where key_name=lower('project_etl_list_etl_id')) 
go
--METADATA TYPE:UP2 GROUP:162to171 NAME:MISC_UPDATES
declare @v_project_proj_id int,@etl_id int
declare @cur_project_proj_id  cursor 
SET @cur_project_proj_id = CURSOR FAST_FORWARD 
for select proj_id from project where px_enable_publication_flag ='Y';
open @cur_project_proj_id
FETCH NEXT FROM @cur_project_proj_id INTO @v_project_proj_id
WHILE @@FETCH_STATUS = 0
begin
exec getnextkeys 'project_etl_list_etl_id',1,@etl_id output
insert into project_etl_list (etl_id,proj_id)values(@etl_id,@v_project_proj_id);
FETCH NEXT FROM @cur_project_proj_id INTO @v_project_proj_id
END
CLOSE @cur_project_proj_id
DEALLOCATE @cur_project_proj_id
go
--METADATA TYPE:UP2 GROUP:162to171 NAME:MISC_UPDATES
declare
 @v_attr_id int,@val_exists int
 exec getnextkeys 'attr_master_attr_id', 1,@v_attr_id output
 select @val_exists=count(*) FROM attr_master where attr_id=@v_attr_id 
 while @val_exists >= 1 
  begin
    exec getnextkeys 'attr_master_attr_id', 1,@v_attr_id output
    select @val_exists=count(*) FROM attr_master where attr_id=@v_attr_id 
  end
 Insert into attr_master(attr_id,attr_name,attr_type)
  select @v_attr_id,'LastAccessedTime','Date' from prefer where not exists (select * from attr_master where attr_id=@v_attr_id and attr_name='LastAccessedTime' and attr_type='Date');
go
--METADATA TYPE:UP2 GROUP:162to171 NAME:MISC_UPDATES
update project set etl_interval=24 where etl_interval=-1
go
--METADATA TYPE:UP2 GROUP:162to171 NAME:MISC_UPDATES
update vwprefdata set view_pref_value = 'DEFAULT_LANDING_PAGE_URL' 
where view_pref_key = 'UIView.DefaultLandingPage' 
and view_pref_id in (select view_pref_id from vwprefdata where view_pref_key = 'UIView.DefaultLandingPage' and view_pref_value = '/action/home?globalscheduledservices')
go


go 
--END TYPE:UP2 GROUP:162to171 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:171to172 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:171to172 NAME:MISC_UPDATES
Insert into NEXTKEY select 'settings_setting_id',(select count(*)+1 from settings) from prefer where not exists (select * from nextkey where lower(key_name)='settings_setting_id');
go
--METADATA TYPE:UP2 GROUP:171to172 NAME:MISC_UPDATES
declare 
@v_setting_id int
select @v_setting_id=max(setting_id) from settings where setting_id is not null
update nextkey set key_seq_num = @v_setting_id + 2
  where key_name='settings_setting_id'
if not exists (SELECT 1 
    FROM settings 
    WHERE namespace='database.proc')
insert into settings 
(namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id)
values ('database.proc','ExecCleanPxDelete','Y',null,getdate(),'admin',getdate(),'admin',null,null,@v_setting_id +1) 
go
go 
--END TYPE:UP2 GROUP:171to172 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:172to173 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:172to173 NAME:MISC_UPDATES
Insert into NEXTKEY select 'settings_setting_id',(select count(*)+1 from settings) from prefer where not exists (select * from nextkey where lower(key_name)='settings_setting_id');
go
go 
--END TYPE:UP2 GROUP:172to173 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:174to175 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:174to175 NAME:MISC_UPDATES
update task set est_wt=1 where est_wt is null
go
--METADATA TYPE:UP2 GROUP:174to175 NAME:MISC_UPDATES
update projwbs set est_wt=1 where est_wt is null
go

go 
--END TYPE:UP2 GROUP:174to175 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:175to176 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:174to175 NAME:MISC_UPDATES
update project set hist_interval = 'Month' where hist_interval ='Daily'
go

go 
--END TYPE:UP2 GROUP:175to176 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:176to177 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:176to177 NAME:MISC_UPDATES
Insert into ATTR_MASTER (ATTR_ID,ATTR_NAME,ATTR_TYPE) SELECT 16,'OutsideInConversionStatus','String'  from prefer where not exists 
(SELECT * FROM ATTR_MASTER WHERE ATTR_ID=16 AND ATTR_NAME ='OutsideInConversionStatus' AND ATTR_TYPE='String' );
go


go 
--END TYPE:UP2 GROUP:176to177 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:177to178 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:177to178 NAME:MISC_UPDATES
update profpriv set AllOW_FLAG='Y' where priv_num=176 and prof_id=23
go
--METADATA TYPE:UP2 GROUP:177to178 NAME:MISC_UPDATES
update profpriv set Allow_FLAG='Y' where prof_id=12 and allow_flag='N'
go
--METADATA TYPE:UP2 GROUP:177to178 NAME:MISC_UPDATES
DECLARE 
  @v_settings_setting_id int,@namespace varchar(255),@setting_name varchar(255)
  declare auditing_cur cursor 
for 
select setting_id, namespace, setting_name 
    from settings where namespace like 'database.audit%' and setting_id is null
OPEN auditing_cur
FETCH NEXT FROM auditing_cur INTO @v_settings_setting_id,@namespace,@setting_name
WHILE @@FETCH_STATUS = 0
BEGIN 
    exec getnextkeys 'settings_setting_id', 1, @v_settings_setting_id output
    set @v_settings_setting_id=@v_settings_setting_id
    update settings set setting_id = @v_settings_setting_id 
    where namespace=@namespace and 
	setting_name=@setting_name; 
	FETCH NEXT FROM auditing_cur INTO @v_settings_setting_id,@namespace,@setting_name
  END ;  
CLOSE auditing_cur
DEALLOCATE auditing_cur
go

--METADATA TYPE:UP2 GROUP:177to178 NAME:MISC_UPDATES
insert into nextkey select  lower('settings_setting_id'),1 from PREFER where not exists (select * from nextkey where key_name=lower('settings_setting_id')) 
go


go 
--END TYPE:UP2 GROUP:177to178 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1710to1711 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:177to178 NAME:MISC_UPDATES
update project set proj_short_name=rtrim(ltrim(proj_short_name))
go
--METADATA TYPE:UP2 GROUP:177to178 NAME:MISC_UPDATES
update projwbs set wbs_short_name=rtrim(ltrim(wbs_short_name)) where proj_node_flag='Y'
go
go 
--END TYPE:UP2 GROUP:1710to1711 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1711to1712 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1711to1712 NAME:MISC_UPDATES
UPDATE profpriv  Set priv_num= 60
FROM profpriv a
WHERE NOT EXISTS (select 1 from profpriv b where b.prof_id=a.prof_id and b.priv_num =60) and a.priv_num= 58
go

--METADATA TYPE:UP2 GROUP:1711to1712 NAME:MISC_UPDATES
delete from profpriv where priv_num=58
go

go 
--END TYPE:UP2 GROUP:1711to1712 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/E90748_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:1712to1801 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1801to1802 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1801to1802 NAME:MISC_UPDATES
go 
--END TYPE:UP2 GROUP:1801to1802 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1801to1802 NAME:MISC_UPDATES
update prefer set license_data=null
go
go 
--END TYPE:UP2 GROUP:1802to1803 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
insert into nextkey select  lower('leantask_lean_task_id'),1 from PREFER where not exists (select * from nextkey where key_name=lower('leantask_lean_task_id')) 
go
--METADATA TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
declare @v_prof_id int,@v_prof_id_pv int
declare @profile_cur cursor 
SET @profile_cur = CURSOR FAST_FORWARD for select prof_id from profile;
open @profile_cur
FETCH NEXT FROM @profile_cur INTO @v_prof_id
WHILE @@FETCH_STATUS = 0
begin
select @v_prof_id_pv=prof_id from profpriv where prof_id= @v_prof_id and priv_num=177;
if @@rowcount > 0
  begin
   if @v_prof_id=12
    update profpriv set allow_flag ='Y' where prof_id= @v_prof_id and priv_num=177;
   else
    update profpriv set allow_flag ='N' where prof_id= @v_prof_id and priv_num=177;
  end
else
  begin
   if @v_prof_id=12
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,177,'Y');
   else
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,177,'N');
  end
FETCH NEXT FROM @profile_cur INTO @v_prof_id
END
CLOSE @profile_cur
DEALLOCATE @profile_cur
go


go 
--END TYPE:UP2 GROUP:1804to1805 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
update prefer set ts_rsrc_def_asgn_out_actv_flag= 'N' where ts_rsrc_def_asgn_actv_flag= 'N'
go

--METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
update project set rsrc_self_add_out_flag = 'N' where rsrc_self_add_flag = 'N'
go
---METADATA TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
update  PROJECT set wbs_max_sum_level =0 where wbs_max_sum_level is NULL
go
go 
--END TYPE:UP2 GROUP:1805to1806 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1806to1807 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1806to1807 NAME:MISC_UPDATES
DELETE  from vwprefdata where view_pref_id = 513 and  view_pref_key like 'PortfolioView.ColumnGroupByLwf'
GO

go 
--END TYPE:UP2 GROUP:1806to1807 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1807to1808 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1807to1808 NAME:MISC_UPDATES
declare @v_nxt_key integer, @v_no_data_found integer
begin
exec getnextkeys 'settings_setting_id',1,@v_nxt_key out
print @v_nxt_key
insert into settings(namespace,setting_name,setting_value,setting_id)  
select 'Administrator_Settings','IsAppletFree','Y',@v_nxt_key from prefer
 where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='IsAppletFree');
end
go
go 
--END TYPE:UP2 GROUP:1807to1808 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1883to1884 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1883to1884 NAME:MISC_UPDATES
insert into nextkey select  lower('jobproj_lkp_jobproj_lkp_id'),1 from PREFER where not exists (select * from nextkey where key_name=lower('jobproj_lkp_jobproj_lkp_id')) 
go
--METADATA TYPE:UP2 GROUP:1883to1884 NAME:MISC_UPDATES
declare @tblexists int
SELECT @tblexists=count(*) FROM sys.objects where type ='U' and name ='JOBPROJ_LKP'
IF @tblexists > 0 
  BEGIN
   alter table jobproj_lkp drop constraint fk_jobproj_jobsvc;
   ALTER TABLE JOBPROJ_LKP ADD CONSTRAINT fk_jobproj_jobsvc FOREIGN KEY (job_id)REFERENCES JOBSVC (job_id) ON DELETE CASCADE;
  END
go

go 
--END TYPE:UP2 GROUP:1883to1884 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1884to1901 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1884to1901 NAME:MISC_UPDATES
insert into nextkey select  lower('announcement_announcement_id'),1 from PREFER where not exists (select * from nextkey where key_name=lower('announcement_announcement_id')) 
go

go 
--END TYPE:UP2 GROUP:1884to1901 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1901to1902 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1884to1901 NAME:MISC_UPDATES
select 'no update' 
go

go 
--END TYPE:UP2 GROUP:1901to1902 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12057_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
--METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
merge profpriv pp
using (select prof_id ,'179' as priv_num,'n' as allow_flag from profile where scope_type='st_project') p
on (pp.prof_id = p.prof_id and pp.priv_num = p.priv_num)
  when matched then
    update set pp.allow_flag = p.allow_flag
  when not matched then
    insert (prof_id,priv_num,allow_flag)
    values (p.prof_id,p.priv_num, p.allow_flag);
go
--METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
insert into rsrcoveralloc(rsrc_id,overalloc_date)
select distinct rsrc_id,overalloc_date 
from rsrcroleasgnmentspread
where proj_id IS NULL AND rsrc_id IS NOT NULL and overalloc_date IS NOT NULL
go
--METADATA TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
declare @setting_id integer
exec getnextkeys 'settings_setting_id', 1, @setting_id OUTPUT
insert into settings(namespace,setting_name,setting_value,setting_id) values ('database.dml.transactions','Batch','3000',@setting_id)
go

go 
--END TYPE:UP2 GROUP:1902to1903 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F12059_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
declare 
@view_pref_id int
exec getnextkeys 'viewpref_view_pref_id',1,@view_pref_id OUTPUT
insert into viewpref (view_pref_id, view_pref_name, view_pref_type) select @view_pref_id,'ResourceId','VT_FILTER_STANDARD' from prefer where not exists( select 1 from viewpref where view_pref_name='ResourceId' and  view_pref_type='VT_FILTER_STANDARD')
exec getnextkeys 'viewpref_view_pref_id',1,@view_pref_id OUTPUT
insert into viewpref (view_pref_id, view_pref_name, view_pref_type) select @view_pref_id,'RoleId','VT_FILTER_STANDARD' from prefer where not exists( select 1 from viewpref where view_pref_name='RoleId' and  view_pref_type='VT_FILTER_STANDARD')
go
--METADATA TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
merge profpriv pp
using (select prof_id ,'178' as priv_num,'y' as allow_flag from profile where scope_type='st_project') p
on (pp.prof_id = p.prof_id and pp.priv_num = p.priv_num)
  when matched then
    update set pp.allow_flag = p.allow_flag
  when not matched then
    insert (prof_id,priv_num,allow_flag)
    values (p.prof_id,p.priv_num, p.allow_flag);
go

go 
--END TYPE:UP2 GROUP:1903to1904 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1904to1905 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1904to1905 NAME:MISC_UPDATES
select null 
go

go 
--END TYPE:UP2 GROUP:1904to1905 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1905to1906 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1905to1906 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_SHORT_LEN=60 WHERE PROJ_CATG_TYPE='Prime Workspace'
go

--METADATA TYPE:UP2 GROUP:1905to1906 NAME:MISC_UPDATES
UPDATE PCATTYPE SET PROJ_CATG_TYPE='Primavera Workspace' WHERE PROJ_CATG_TYPE='Prime Workspace'
go

--METADATA TYPE:UP2 GROUP:1905to1906 NAME:MISC_UPDATES
UPDATE GATEWAYPROVIDER SET PROVIDER_NAME='Primavera Cloud Provider' WHERE PROVIDER_NAME='Prime Provider'
go

--METADATA TYPE:UP2 GROUP:1905to1906 NAME:MISC_UPDATES
merge profpriv pp
using (select prof_id ,'180' as priv_num,'n' as allow_flag from profile where scope_type='st_project') p
on (pp.prof_id = p.prof_id and pp.priv_num = p.priv_num)
  when matched then
    update set pp.allow_flag = p.allow_flag
  when not matched then
    insert (prof_id,priv_num,allow_flag)
    values (p.prof_id,p.priv_num, p.allow_flag);
go

--METADATA TYPE:UP2 GROUP:1905to1906 NAME:MISC_UPDATES
UPDATE RSRC SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
go

--METADATA TYPE:UP2 GROUP:1905to1906 NAME:MISC_UPDATES
UPDATE PROJWBS SET INTG_TYPE='PrimaveraCloudScope' WHERE INTG_TYPE='PrimeScope'
go

--METADATA TYPE:UP2 GROUP:1905to1906 NAME:MISC_UPDATES
UPDATE GATEWAYDEPLOYMENT SET DEPLOYMENT_NAME='Primavera Cloud Deployment' WHERE DEPLOYMENT_NAME='Prime Deployment'
go
go 
--END TYPE:UP2 GROUP:1905to1906 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
IF EXISTS ( SELECT name FROM sysobjects where name = 'tr_rsrcroleasgnmentspread' and 
 type = 'TR' )
     drop trigger tr_rsrcroleasgnmentspread
go


go 
--END TYPE:UP2 GROUP:1906to1907 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
DECLARE
  @col_exists integer,
  @image_name varchar(100),
  @image_id varchar(100)
DECLARE @cur as CURSOR
 SET @cur = CURSOR FOR
 SELECT image_id,image_name
 FROM imagedata;
 OPEN @cur;
 FETCH NEXT FROM @cur INTO @image_id,@image_name;
WHILE @@FETCH_STATUS = 0
 BEGIN
 begin try
   if NULLIF(@image_name, '') IS NOT NULL and charindex('.',@image_name)>0
	begin
    update imagedata
      set image_name =left(@image_name,len(@image_name)- charindex('.', reverse(@image_name))),
          image_extension = reverse(left(reverse(@image_name), charindex('.', reverse(@image_name)) -1))
    where image_id=@image_id;
	end;
  FETCH NEXT FROM @cur INTO @image_id,@image_name;
  end try
  begin catch
  select null
  end catch
 END 
CLOSE @cur;
DEALLOCATE @cur;
go
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
declare @v_clobber_point INTEGER,@v_loc_point integer;
DECLARE @v_view_name varchar(255),@v_blob_col_val varchar(max),@v_len INTEGER,@v_rowid_val INTEGER;
declare @v_start_point INTEGER,@v_final varchar(max),@v_count integer,@v_rem varchar(max);

SELECT @v_view_name=view_name,@v_blob_col_val=view_data
 FROM viewprop
WHERE view_name = 'Default Import Template';
set @v_len = DATALENGTH(@v_blob_col_val);
if(@v_len IS NOT NULL AND @v_len > 0)
begin
 set @v_clobber_point = charindex('ClobberOptions',@v_blob_col_val)
 IF ( @v_clobber_point IS NOT NULL AND @v_clobber_point > 0 )
  begin
    set @v_loc_point = charindex('P_PROJISSU',@v_blob_col_val)
   IF ( @v_loc_point IS NOT NULL AND @v_loc_point >0 )
    begin
      set @v_start_point = charindex('P_PROJISSU',@v_blob_col_val) + 49
     IF (@v_start_point IS NOT NULL AND @v_start_point > 0)
       begin
          set @v_final = left(@v_blob_col_val,@v_start_point)
		  set @v_rem = right(@v_blob_col_val,(@v_len-@v_start_point))
		  set @v_final = @v_final + '(0||P_SCHEDOPTIONS(import_option|K|delete_unref|N)())'
          set @v_final = @v_final + @v_rem
          UPDATE VIEWPROP SET view_data = @v_final where view_name = 'Default Import Template';
       end
    end
  end
end
go
--METADATA TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
declare @v_config_name varchar(255),@v_blob_col_val varchar(max),@v_len integer,@v_rowid_val integer;
declare @v_start_point integer,@v_final varchar(max),@v_count integer,@v_rem varchar(max);
select @v_config_name=config_name,@v_blob_col_val=config_data
from admin_config where config_name = 'myprimavera.bre.Primavera P6 Configuration';
set @v_len = datalength(@v_blob_col_val)
if(@v_len is not null and @v_len > 0)
begin
set @v_start_point = charindex('MaxPortletsPerDashboard',@v_blob_col_val)-2;
 if ( @v_start_point is not null and @v_start_point > 0)
  begin
    set @v_final = left(@v_blob_col_val,@v_start_point)
    set @v_rem = right(@v_blob_col_val,(@v_len-@v_start_point))
    set @v_final = @v_final + '<MaxLoadedResourcesAndRolesInTeamUsageAndResourceAnalysis desc="SET_MAX_LOADED_RESOURCES_AND_ROLES_IN_TEAM_USAGE_AND_RESOURCE_ANALYSIS" max="5000" min="1" type="java.lang.Integer">1000</MaxLoadedResourcesAndRolesInTeamUsageAndResourceAnalysis>'
    set @v_final = @v_final + char(10) + '        ' + @v_rem
    update admin_config set config_data = @v_final where config_name = 'myprimavera.bre.Primavera P6 Configuration';
  end
end
go
go 
--END TYPE:UP2 GROUP:1907to1908 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1908to1909 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1908to1909 NAME:MISC_UPDATES
select 'no update' 
go

go 
--END TYPE:UP2 GROUP:1908to1909 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1911to1912 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1911to1912 NAME:MISC_UPDATES
declare @tblexists int
SELECT @tblexists=count(*) FROM sys.objects where type ='U' and name ='TASK'
IF @tblexists > 0 
  BEGIN
   ALTER TABLE TASK ALTER COLUMN pre_criticality_index NUMERIC(10,2);
  END
go


--METADATA TYPE:UP2 GROUP:1911to1912 NAME:MISC_UPDATES
declare @tblexists int
SELECT @tblexists=count(*) FROM sys.objects where type ='U' and name ='TASK'
IF @tblexists > 0 
  BEGIN
   ALTER TABLE TASK ALTER COLUMN post_criticality_index NUMERIC(10,2);
  END
go

go 
--END TYPE:UP2 GROUP:1911to1912 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
DECLARE
  @issue_notes varchar(MAX),
  @issue_id integer,
  @v_len integer
DECLARE @cur as CURSOR
 SET @cur = CURSOR FOR
 SELECT issue_id,issue_notes
 FROM projissu where issue_notes is NOT NULL;
 OPEN @cur;
 FETCH NEXT FROM @cur INTO @issue_id,@issue_notes;
WHILE @@FETCH_STATUS = 0
 BEGIN
 begin try
  set @v_len=DATALENGTH(@issue_notes);
   if @v_len IS NOT NULL  and @v_len > 0
	begin
	if (PATINDEX('%DOCTYPE%',@issue_notes)=0 or PATINDEX('%DOCTYPE%',@issue_notes) is NULL) 
	begin
    update projissu
      set issue_notes ='<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><HTML><HEAD><META content="text/html; charset=unicode" http-equiv=Content-Type><META name=GENERATOR content="MSHTML 11.00.10570.1001"></HEAD><BODY><SPAN style="FONT-SIZE: medium; FONT-FAMILY: serif; WHITE-SPACE: normal; WORD-SPACING: 0px; TEXT-TRANSFORM: none; FLOAT: none; FONT-WEIGHT: 400; COLOR: rgb(0,0,0); FONT-STYLE: normal; ORPHANS: 2; WIDOWS: 2; DISPLAY: inline !important; LETTER-SPACING: normal; TEXT-INDENT: 0px; font-variant-ligatures: normal; font-variant-caps: normal; -webkit-text-stroke-width: 0px; text-decoration-style: initial; text-decoration-color: initial">'+
	  @issue_notes+'</SPAN></BODY></HTML>'
    where issue_id=@issue_id;
	end;
	end;
  FETCH NEXT FROM @cur INTO @issue_id,@issue_notes;
  end try
  begin catch
  select null
  end catch
 END 
CLOSE @cur;
DEALLOCATE @cur;
go

--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
DECLARE @discussion_id INTEGER
	,@rej_dis_data VARCHAR(max)
	,@v_len INTEGER
	,@v_len1 INTEGER
	,@v_start_point INTEGER
	,@v_final VARCHAR(max)
	,@v_rem VARCHAR(max)
	,@v_rem1 VARCHAR(max)
	,@v_rem2 VARCHAR(max)
	,@V_TEST VARCHAR(max)
	,@v_final_point INTEGER
	,@v_final_point_1 INTEGER
	,@v_final_point_2 INTEGER
DECLARE @cur AS CURSOR

SET @cur = CURSOR
FOR

SELECT discussion_id
	,rej_dis_data
FROM discussion
WHERE rej_dis_data IS NOT NULL;

OPEN @cur;

FETCH NEXT
FROM @cur
INTO @discussion_id
	,@rej_dis_data;

WHILE @@FETCH_STATUS = 0
BEGIN
	BEGIN TRY
		SET @v_len = DATALENGTH(@rej_dis_data);

		IF (@v_len IS NOT NULL AND @v_len > 0)
		BEGIN
			SET @v_start_point = charindex('commentHeader', @rej_dis_data) + 14;

			IF (@v_start_point IS NOT NULL AND @v_start_point > 0)
			BEGIN
				SET @v_final = left(@rej_dis_data, @v_start_point);
			END

			IF ((PATINDEX('%update for%', @rej_dis_data) > 0) AND (PATINDEX('%submitted by%', @rej_dis_data) > 0))
			BEGIN
				SET @v_final_point = charindex('update for', @rej_dis_data) + 11;

				IF (@v_final_point IS NOT NULL AND @v_final_point > 0)
				BEGIN
					SET @v_final_point_1 = charindex('submitted by', @rej_dis_data) - 1;

					IF (@v_final_point_1 IS NOT NULL AND @v_final_point_1 > 0)
					BEGIN
						SET @v_rem = substring(@rej_dis_data, @v_final_point, @v_final_point_1 - @v_final_point);
					END;

					SET @v_final_point_2 = charindex('was rejected', @rej_dis_data);

					IF (@v_final_point_2 IS NOT NULL AND @v_final_point_2 > 0)
					BEGIN
						SET @v_rem1 = substring(@rej_dis_data, @v_final_point_1 + 14, @v_final_point_2 - (@v_final_point_1 + 14));
						SET @v_rem2 = right(@rej_dis_data, @v_len - @v_final_point_2 - 12)
					END;

					SET @v_final = @v_final + '[' + CHAR(34) + ltrim(rtrim(@v_rem)) + CHAR(34) + CHAR(44) + CHAR(34) + ltrim(rtrim(@v_rem1)) + CHAR(34) + ']' + @v_rem2;
				END;
			END;
			ELSE IF ((PATINDEX('%update for%', @rej_dis_data) = 0) AND (PATINDEX('%submitted by%', @rej_dis_data) > 0))
			BEGIN
				SET @v_final_point = charindex('submitted by', @rej_dis_data) + 13;

				IF (@v_final_point IS NOT NULL AND @v_final_point > 0)
				BEGIN
					SET @v_final_point_1 = charindex('was rejected', @rej_dis_data) - 1;

					IF (@v_final_point_1 IS NOT NULL AND @v_final_point_1 > 0)
					BEGIN
						SET @v_rem = substring(@rej_dis_data, @v_final_point, @v_final_point_1 - @v_final_point);
						SET @v_rem1 = right(@rej_dis_data, @v_len - @v_final_point_1 - 14)
					END;

					SET @v_final = @v_final + '[' + CHAR(34) + ltrim(rtrim(@v_rem)) + CHAR(34) + ']' + @v_rem1;
				END;
			END;
			ELSE IF ((PATINDEX('%update for%', @rej_dis_data) = 0) AND (PATINDEX('%submitted by%', @rej_dis_data) = 0))
			BEGIN
				IF (SUBSTRING(@rej_dis_data, @v_start_point + 1, 1) = '"')
				BEGIN
					SET @v_rem = right(@rej_dis_data, @v_len - @v_start_point);
					SET @v_final_point = charindex('"', @v_rem, (charindex('"', @v_rem, 1)) + 1);
					SET @v_rem1 = substring(@v_rem, 1, @v_final_point);
					SET @v_len1 = DATALENGTH(@v_rem);
					SET @v_rem2 = right(@v_rem, @v_len1 - @v_final_point);
					SET @v_final = @v_final + '['+ @v_rem1 + CHAR(44)+'true'+ ']' + @v_rem2;
				END;
			END;
			ELSE
			BEGIN
				SELECT NULL
			END;

			UPDATE discussion
			SET rej_dis_data = @v_final
			WHERE discussion_id = @discussion_id;
		END;

		FETCH NEXT
		FROM @cur
		INTO @discussion_id
			,@rej_dis_data;
	END TRY

	BEGIN CATCH
		SELECT NULL
	END CATCH
END

CLOSE @cur;

DEALLOCATE @cur;
GO

--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
update udftype
set SUMMARY_METHOD='NONE'
where table_name='PROJECT'
and LOGICAL_DATA_TYPE not in ('FT_TEXT','FT_STATICTYPE') and SUMMARY_METHOD='None'
go
--METADATA TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F25600_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go





go 
--END TYPE:UP2 GROUP:1912to2001 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2001to2002 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2001to2002 NAME:MISC_UPDATES
update udftype
set SUMMARY_METHOD='NONE'
where table_name='PROJECT'
and SUMMARY_METHOD='None'
go







go 
--END TYPE:UP2 GROUP:2001to2002 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES
declare @v_prof_id int,@v_prof_id_pv int,@v_scope_type varchar(12)
declare @profile_cur cursor 
SET @profile_cur = CURSOR FAST_FORWARD for select prof_id ,scope_type from profile;
open @profile_cur
FETCH NEXT FROM @profile_cur INTO @v_prof_id,@v_scope_type
WHILE @@FETCH_STATUS = 0
begin
if @v_scope_type='ST_Global'
begin
select @v_prof_id_pv=prof_id from profpriv where prof_id= @v_prof_id and priv_num=184;
if @@rowcount > 0
  begin
   if @v_prof_id=12
    update profpriv set allow_flag ='Y' where prof_id= @v_prof_id and priv_num=184;
   else
    update profpriv set allow_flag ='N' where prof_id= @v_prof_id and priv_num=184;
  end
else
  begin
   if @v_prof_id=12
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,184,'Y');
   else
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,184,'N');
  end
end
FETCH NEXT FROM @profile_cur INTO @v_prof_id,@v_scope_type
END
CLOSE @profile_cur
DEALLOCATE @profile_cur
go

--METADATA TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES
INSERT INTO SETTINGS (NAMESPACE,SETTING_NAME,SETTING_VALUE) 
SELECT 'Administrator_Settings','IsOfflineModeSupported', 'N' WHERE
NOT EXISTS ( SELECT 1 FROM SETTINGS WHERE SETTING_NAME='IsOfflineModeSupported' AND NAMESPACE='Administrator_Settings')
GO

--METADATA TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F25600_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:2002to2003 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2003to2004 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2003to2004 NAME:MISC_UPDATES
select 'no update' 
go

go 
--END TYPE:UP2 GROUP:2003to2004 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
DECLARE @user_data       VARCHAR(max), 
        @user_id         INTEGER, 
        @topic_name      VARCHAR(100), 
        @v_len           INTEGER, 
        @v_str1          INTEGER, 
        @v_str2          INTEGER, 
        @v_count         INTEGER, 
        @v_namespace     VARCHAR(100), 
        @v_setting_name  VARCHAR(100), 
        @v_setting_value VARCHAR(100), 
        @v_initial       VARCHAR(max) 
DECLARE @cur AS CURSOR 

SET @cur = CURSOR 
FOR SELECT user_id,topic_name,user_data 
    FROM   userdata 
    WHERE  user_data IS NOT NULL AND topic_name = 'pm_settings'; 

OPEN @cur; 

FETCH next FROM @cur INTO @user_id, @topic_name, @user_data; 

WHILE @@FETCH_STATUS = 0 
  BEGIN 
      BEGIN try 
          SELECT @v_count = 1,@v_namespace = namespace, 
                 @v_setting_name = setting_name,@v_setting_value = setting_value 
          FROM   settings 
          WHERE  namespace = 'Administrator_Settings' 
                 AND setting_name = 'DisplayCodeValueName'; 

          IF @v_count IS NOT NULL AND @v_count > 0 
            BEGIN 
                SET @v_len=Datalength(Rtrim(Ltrim(@user_data))); 
                SET @v_str1=Charindex('UserSettings', @user_data); 
                SET @v_str2=Charindex('isLoaded', @user_data); 

                IF @v_len IS NOT NULL AND @v_len > 0 
                  BEGIN 
                      IF ( Patindex('%DisplayCodeValue%', @user_data) = 0 
                            OR Patindex('%DisplayCodeValue%', @user_data) IS NULL) 
                        BEGIN 
                            IF ( @v_str1 > 0 AND @v_str1 IS NOT NULL ) 
                              BEGIN 
                                  IF ( @v_str2 > 0 AND @v_str2 IS NOT NULL ) 
                                    BEGIN 
                                        SET @v_initial = RIGHT(@user_data,@v_len - 29); 
                                        UPDATE userdata
										SET user_data ='(0||UserSettings(isLoaded|Y)((0||DisplayCodeValue(DisplayAsName|'+@v_setting_value+')())'+@v_initial 
                                        WHERE  user_id = @user_id AND topic_name = @topic_name; 
                                    END; 
                                  ELSE 
                                    BEGIN 
                                        SET @v_initial = RIGHT(@user_data, @v_len - 19); 
                                        UPDATE userdata 
                                        SET user_data ='(0||UserSettings()((0||DisplayCodeValue(DisplayAsName|'+@v_setting_value+')())'+@v_initial 
                                        WHERE  user_id = @user_id AND topic_name = @topic_name; 
                                    END; 
                              END; 
                            ELSE 
                             SELECT NULL; 
                      END; 
                END; 
          END; 

          FETCH next FROM @cur INTO @user_id, @topic_name, @user_data; 
      END try 

      BEGIN catch 
          SELECT NULL 
      END catch 
  END 
CLOSE @cur; 
DEALLOCATE @cur; 

IF EXISTS (SELECT 1 
           FROM   settings 
           WHERE  namespace = 'Administrator_Settings' 
                  AND setting_name = 'DisplayCodeValueName') 
  DELETE FROM settings 
  WHERE  namespace = 'Administrator_Settings' 
         AND setting_name = 'DisplayCodeValueName'; 
go 

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='rolecattype_role_catg_type_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=21
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('rolecattype_role_catg_type_id',21);
go

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='rolecatval_role_catg_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=56
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('rolecatval_role_catg_id',56);
go

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='rolecatvalx_role_catg_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=1
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('rolecatvalx_role_catg_id',1);
go

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
declare @v_prof_id int,@v_prof_id_pv int,@v_scope_type varchar(12)
declare @i int = 181
WHILE @i < 184
BEGIN
declare @profile_cur cursor 
SET @profile_cur = CURSOR FAST_FORWARD for select prof_id ,scope_type from profile;
open @profile_cur
FETCH NEXT FROM @profile_cur INTO @v_prof_id,@v_scope_type
WHILE @@FETCH_STATUS = 0
begin
if @v_scope_type='ST_Global'
begin
select @v_prof_id_pv=prof_id from profpriv where prof_id= @v_prof_id and priv_num=@i;
if @@rowcount > 0
  begin
   if @v_prof_id=12
    update profpriv set allow_flag ='Y' where prof_id= @v_prof_id and priv_num=@i;
   else
    update profpriv set allow_flag ='N' where prof_id= @v_prof_id and priv_num=@i;
  end
else
  begin
   if @v_prof_id=12
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,@i,'Y');
   else
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,@i,'N');
  end
end
   
FETCH NEXT FROM @profile_cur INTO @v_prof_id,@v_scope_type
END
CLOSE @profile_cur
DEALLOCATE @profile_cur
SET @i = @i + 1
end
go

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
INSERT INTO SETTINGS (NAMESPACE,SETTING_NAME,SETTING_VALUE) 
SELECT 'Administrator_Settings','MaxRoleCodeTreeLevelCnt', '20' WHERE
NOT EXISTS ( SELECT 1 FROM SETTINGS WHERE SETTING_NAME='MaxRoleCodeTreeLevelCnt' AND NAMESPACE='Administrator_Settings')
GO

--METADATA TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
DECLARE @v_role_rate_id int,@v_role_id int,@v_rolelimit_id int,@v_start_date datetime,
        @v_max_qty_per_hr numeric(16,8),@v_cost_per_qty numeric(21,8),
		@v_cost_per_qty2 numeric(21,8),@v_cost_per_qty3 numeric(21,8),
	    @v_cost_per_qty4 numeric(21,8),@v_cost_per_qty5 numeric(21,8),@new_role_rate_id int

SELECT rr.role_rate_id, rr.role_id,rl.rolelimit_id,rl.start_date,rl.max_qty_per_hr,
       rr.cost_per_qty, rr.cost_per_qty2,rr.cost_per_qty3,rr.cost_per_qty4,rr.cost_per_qty5 
	   into #temp
       FROM rolerate rr LEFT OUTER JOIN rolelimit rl ON  rr.role_id = rl.role_id;
	   
DECLARE @cur_rr_rl AS CURSOR 
SET @cur_rr_rl = CURSOR 
             			
FOR SELECT role_rate_id, role_id,rolelimit_id,start_date,max_qty_per_hr,
       cost_per_qty, cost_per_qty2,cost_per_qty3,cost_per_qty4,cost_per_qty5 FROM #temp
 WHERE  role_id IS NOT NULL
 ORDER BY 3;
 
OPEN @cur_rr_rl; 
FETCH next FROM @cur_rr_rl INTO @v_role_rate_id, @v_role_id,@v_rolelimit_id,@v_start_date,@v_max_qty_per_hr,@v_cost_per_qty, @v_cost_per_qty2,@v_cost_per_qty3,@v_cost_per_qty4,@v_cost_per_qty5 
WHILE @@FETCH_STATUS = 0 
BEGIN
IF @v_rolelimit_id is NOT NULL
	  BEGIN
       DELETE FROM rolerate WHERE role_rate_id = @v_role_rate_id;
       exec getnextkeys 'rolerate_role_rate_id', 1, @new_role_rate_id OUTPUT
	   INSERT INTO rolerate (role_rate_id,role_id,start_date,max_qty_per_hr,cost_per_qty,cost_per_qty2,cost_per_qty3,cost_per_qty4,cost_per_qty5)
           VALUES (@new_role_rate_id,@v_role_id,@v_start_date,@v_max_qty_per_hr,@v_cost_per_qty,@v_cost_per_qty2,@v_cost_per_qty3,@v_cost_per_qty4,@v_cost_per_qty5); 
      END;
    ELSE
      BEGIN
       UPDATE rolerate SET max_qty_per_hr = 0 , start_date=Dateadd(yy, Datediff(yy, 0, Getdate()), 0)  WHERE  role_id =@v_role_id ;
      END;
     FETCH next FROM @cur_rr_rl INTO @v_role_rate_id, @v_role_id,@v_rolelimit_id,@v_start_date,@v_max_qty_per_hr,@v_cost_per_qty, @v_cost_per_qty2,@v_cost_per_qty3,@v_cost_per_qty4,@v_cost_per_qty5 
END;
	   
CLOSE @cur_rr_rl; 
DEALLOCATE @cur_rr_rl; 
DELETE FROM rolelimit;
DROP TABLE #temp;
go
go 
--END TYPE:UP2 GROUP:2004to2005 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
alter table rsrchour alter column pend_hr_cnt numeric(14, 6)
go

--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
alter table rsrchour alter column hr_cnt numeric(14, 6)
go

--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
alter table rsrchour alter column pend_ot_hr_cnt numeric (14, 6)
go

--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
alter table rsrchour alter column ot_hr_cnt numeric(14, 6)
go

--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
CREATE TABLE RSRCROLEASGNMENTSPREAD_BKP(
  "id"  integer NULL,
  "proj_id"  integer NULL,
  "rsrc_id"  integer NULL,
  "role_id"  integer NULL,
  "spread_start_date"  datetime NULL,
  "spread_end_date"  datetime NULL,
  "plan_start_date"  datetime NULL,
  "plan_end_date"  datetime NULL,
  "act_start_date"  datetime NULL,
  "act_end_date"  datetime NULL,
  "rem_start_date"  datetime NULL,
  "rem_end_date"  datetime NULL,
  "plan_qty"  numeric(22,6) NULL,
  "staffed_act_qty"  numeric(22,6) NULL,
  "unstaffed_act_qty"  numeric(22,6) NULL,
  "act_this_per_qty"  numeric(22,6) NULL,
  "staffed_remain_qty"  numeric(22,6) NULL,
  "unstaffed_remain_qty"  numeric(22,6) NULL,
  "staffed_total_qty"  numeric(22,6) NULL,
  "unstaffed_total_qty"  numeric(22,6) NULL,
  "total_period_qty"  numeric(22,6) NULL,
  "plan_cost"  numeric(25,6) NULL,
  "staffed_act_cost"  numeric(25,6) NULL,
  "unstaffed_act_cost"  numeric(25,6) NULL,
  "act_this_period_cost"  numeric(25,6) NULL,
  "staffed_remain_cost"  numeric(25,6) NULL,
  "unstaffed_remain_cost"  numeric(25,6) NULL,
  "staffed_total_cost"  numeric(25,6) NULL,
  "unstaffed_total_cost"  numeric(25,6) NULL,
  "total_period_cost"  numeric(25,6) NULL,
  "rolledup_record"  varchar(1) DEFAULT 'N' NULL,
  "update_date"  datetime NULL,
  "update_user"  varchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  varchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL,
  "overalloc_date"  datetime NULL
  )
  GO
  
--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
INSERT INTO RSRCROLEASGNMENTSPREAD_BKP
SELECT * FROM RSRCROLEASGNMENTSPREAD
WHERE (RSRC_ID  NOT LIKE '%[a-z .]%' OR RSRC_ID IS NULL )
AND (ROLE_ID NOT LIKE '%[a-z .]%' OR ROLE_ID IS NULL )
GO

--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
DROP TABLE RSRCROLEASGNMENTSPREAD
GO

--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
EXEC sp_rename 'RSRCROLEASGNMENTSPREAD_BKP', 'RSRCROLEASGNMENTSPREAD'
GO

--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_rsrcrolespread_project'
if @cons_cnt = 0  
ALTER TABLE RSRCROLEASGNMENTSPREAD
ADD CONSTRAINT fk_rsrcrolespread_project FOREIGN KEY (proj_id)
REFERENCES PROJECT (proj_id)  ON DELETE CASCADE 
GO

--METADATA TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
CREATE CLUSTERED  INDEX ndx_rsrcroleasgnmntsprd_proj_id
ON RSRCROLEASGNMENTSPREAD (proj_id)
GO

go 
--END TYPE:UP2 GROUP:2005to2006 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2007to2008 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2007to2008 NAME:MISC_UPDATES
with ILV as (
  select
    P.PROJ_ID,
    P.PROJ_SHORT_NAME,
    P.SUM_BASE_PROJ_ID
  from PROJECT P
  where
    P.ORIG_PROJ_ID is null
    and P.PROJECT_FLAG = 'Y'
    and P.SUM_BASE_PROJ_ID is not null
    and exists (
      select 1
      from PROJECT B
      where
        P.SUM_BASE_PROJ_ID = B.PROJ_ID
        and P.PROJ_ID <> B.ORIG_PROJ_ID
    )
)
update ILV
set ILV.SUM_BASE_PROJ_ID = null;
go


--METADATA TYPE:UP2 GROUP:2007to2008 NAME:MISC_UPDATES
UPDATE project
SET
    sum_base_proj_id = NULL
WHERE
    orig_proj_id IS NOT NULL
    AND sum_base_proj_id IS NOT NULL;
go


go 
--END TYPE:UP2 GROUP:2007to2008 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2008to2009 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2008to2009 NAME:MISC_UPDATES
declare @v_prof_id int,@v_prof_id_pv int,@v_scope_type varchar(12)
declare @i int = 188
declare @profile_cur cursor 
SET @profile_cur = CURSOR FAST_FORWARD for select prof_id ,scope_type from profile where scope_type='ST_Global';
open @profile_cur
FETCH NEXT FROM @profile_cur INTO @v_prof_id,@v_scope_type
WHILE @@FETCH_STATUS = 0
begin
select @v_prof_id_pv=prof_id from profpriv where prof_id= @v_prof_id and priv_num=@i;
if @@rowcount > 0
  begin
   if @v_prof_id=12
    update profpriv set allow_flag ='Y' where prof_id= @v_prof_id and priv_num=@i;
   else
    update profpriv set allow_flag ='N' where prof_id= @v_prof_id and priv_num=@i;
  end
else
  begin
   if @v_prof_id=12
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,@i,'Y');
   else
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,@i,'N');
  end

   
FETCH NEXT FROM @profile_cur INTO @v_prof_id,@v_scope_type
END
CLOSE @profile_cur
DEALLOCATE @profile_cur
go

--METADATA TYPE:UP2 GROUP:2008to2009 NAME:MISC_UPDATES
alter table leantask alter column duration decimal(28,10)
go
go 
--END TYPE:UP2 GROUP:2008to2009 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
insert into nextkey select 'wbsreviewers_wbsreviewers_id',1 
where not exists (select * from nextkey where key_name=lower('wbsreviewers_wbsreviewers_id')) 
go

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
insert into nextkey select 'wbsreviewstatus_wbsreviewstatus_id',1 
where not exists (select * from nextkey where key_name=lower('wbsreviewstatus_wbsreviewstatus_id')) 
go

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
DECLARE @vkey                 INTEGER, 
        @wbs_id               INTEGER, 
        @proj_id              INTEGER, 
        @status_reviewer      INTEGER,
		@cols_count           INTEGER,
		@sql_query            nvarchar(3000)
SET @sql_query = 'DECLARE cur_projwbs CURSOR 
      FOR SELECT pw.wbs_id, pw.proj_id, pw.status_reviewer
      FROM projwbs pw, project p
      WHERE pw.proj_id = p.proj_id
      AND p.project_flag=''Y''
      AND p.control_updates_flag = ''Y''
      AND p.orig_proj_id IS NULL
	  AND exists (select 1 from users u
                   where u.user_id=pw.status_reviewer)'

SELECT  @cols_count=count(*) FROM sys.columns 
where name = 'status_reviewer' and object_id=object_id('projwbs');
 if  @cols_count > 0      
begin
exec sp_executesql @sql_query

OPEN cur_projwbs; 

FETCH next FROM cur_projwbs INTO @wbs_id, @proj_id, @status_reviewer; 

WHILE @@FETCH_STATUS = 0 
  BEGIN 
      BEGIN try 
            BEGIN 
                UPDATE projwbs 
                SET    review_type = 'Review_Any' 
                WHERE  wbs_id = @wbs_id AND proj_id = @proj_id; 

                EXEC getnextkeys 'wbsreviewers_wbsreviewers_id', 1, @vkey output 

                INSERT INTO wbsreviewers(wbsreviewers_id, wbs_id, status_reviewer) 
                SELECT @vkey, @wbs_id, @status_reviewer 
                WHERE  NOT EXISTS (SELECT * FROM   wbsreviewers 
                                   WHERE  wbs_id = @wbs_id and status_reviewer = @status_reviewer); 
            END; 

          FETCH next FROM cur_projwbs INTO @wbs_id, @proj_id, @status_reviewer; 
      END try 

      BEGIN catch 
        SELECT NULL
	  END catch 
  END 
CLOSE cur_projwbs; 
DEALLOCATE cur_projwbs; 
end
go 


--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
INSERT INTO FINTMPL(FINTMPL_ID, FINTMPL_NAME, DEFAULT_FLAG, UPDATE_DATE, CREATE_DATE) 
Select 1, 'Calendar', 'Y', getdate(), getdate()
WHERE NOT EXISTS (SELECT 1 FROM FINTMPL 
WHERE FINTMPL_ID=1 AND FINTMPL_NAME='Calendar' AND DEFAULT_FLAG='Y')
go

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
UPDATE PROJECT SET FINTMPL_ID = 1 WHERE FINTMPL_ID IS NULL AND PROJECT_FLAG = 'Y'
go

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='fintmpl_fintmpl_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=2
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('fintmpl_fintmpl_id',2);
go

--METADATA TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
DECLARE 
    @v_fin_dates_id int, 
    @v_count        int 
BEGIN 
    SELECT @v_count=count(*) 
    FROM   findates; 
    IF @v_count = 0  
      BEGIN 
          EXEC getnextkeys 'findates_fin_dates_id', 1, @v_fin_dates_id OUTPUT; 
          INSERT INTO findates (fin_dates_id, fin_dates_name, start_date, end_date, fintmpl_id,
		  update_date, update_user, create_date, create_user) 
          SELECT @v_fin_dates_id, LEFT(CONVERT(VARCHAR, (DATEADD(month, DATEDIFF(month, 0, GETDATE()), 0)), 120), 10), DATEADD(month, DATEDIFF(month, 0, GETDATE()), 0),DATEADD (dd, -1, DATEADD(mm, DATEDIFF(mm, 0, GETDATE()) + 1, 0)), 1, GETDATE(), 'NotPrmUser', GETDATE(), 'NotPrmUser'       
          WHERE  NOT EXISTS(SELECT 1 FROM   findates 
                            WHERE  fin_dates_id = @v_fin_dates_id AND fin_dates_name=LEFT(CONVERT(VARCHAR, (DATEADD(month, DATEDIFF(month, 0, GETDATE()), 0)), 120), 10) and fintmpl_id = 1); 
               
      END; 
 END; 
 go
 
go 
--END TYPE:UP2 GROUP:2009to2010 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
INSERT INTO SETTINGS (NAMESPACE,SETTING_NAME,SETTING_VALUE) 
SELECT 'Administrator_Settings','MaxAssignmentCodeTreeLevelCnt', '20' WHERE
NOT EXISTS ( SELECT 1 FROM SETTINGS WHERE SETTING_NAME='MaxAssignmentCodeTreeLevelCnt' AND NAMESPACE='Administrator_Settings')
GO

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
declare @v_prof_id int,@v_prof_id_pv int,@v_scope_type varchar(12)
declare @i int = 185
WHILE @i < 188
BEGIN
declare @profile_cur cursor 
SET @profile_cur = CURSOR FAST_FORWARD for select prof_id ,scope_type from profile;
open @profile_cur
FETCH NEXT FROM @profile_cur INTO @v_prof_id,@v_scope_type
WHILE @@FETCH_STATUS = 0
begin
if @v_scope_type='ST_Global'
begin
select @v_prof_id_pv=prof_id from profpriv where prof_id= @v_prof_id and priv_num=@i;
if @@rowcount > 0
  begin
   if @v_prof_id=12
    update profpriv set allow_flag ='Y' where prof_id= @v_prof_id and priv_num=@i;
   else
    update profpriv set allow_flag ='N' where prof_id= @v_prof_id and priv_num=@i;
  end
else
  begin
   if @v_prof_id=12
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,@i,'Y');
   else
    insert into profpriv (prof_id,priv_num,allow_flag) values (@v_prof_id,@i,'N');
  end
end
   
FETCH NEXT FROM @profile_cur INTO @v_prof_id,@v_scope_type
END
CLOSE @profile_cur
DEALLOCATE @profile_cur
SET @i = @i + 1
end
go

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='asgnmntcattype_asgnmnt_catg_type_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=21
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('asgnmntcattype_asgnmnt_catg_type_id',21);
go

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='asgnmntcatval_asgnmnt_catg_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=56
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('asgnmntcatval_asgnmnt_catg_id',56);
go

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
MERGE INTO NEXTKEY
USING PREFER
    ON ( KEY_NAME='asgnmntcatvalx_asgnmnt_catg_id') 
WHEN MATCHED THEN
    UPDATE SET KEY_SEQ_NUM=1
WHEN NOT MATCHED THEN
    INSERT ( KEY_NAME, KEY_SEQ_NUM)
    VALUES ('asgnmntcatvalx_asgnmnt_catg_id',1);
go

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
IF EXISTS ( SELECT name FROM sysobjects where name = 'tr_timesht' and 
 type = 'TR' )
     drop trigger tr_timesht
go

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_chgtaskactv_actvtype' and table_name = 'CHGTASKACTV'
IF @cons_cnt > 0 
  BEGIN
   delete from chgtaskactv where actv_code_type_id not in (select actv_code_type_id from actvtype);
   alter table chgtaskactv drop constraint fk_chgtaskactv_actvtype;
   ALTER TABLE chgtaskactv ADD CONSTRAINT fk_chgtaskactv_actvtype FOREIGN KEY (actv_code_type_id) 
   REFERENCES actvtype (actv_code_type_id) ON DELETE CASCADE;
  END
go

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
insert into nextkey select  lower('trackofflineuser_trackofflineuser_id'),1 from prefer where not exists (select * from nextkey where key_name=lower('trackofflineuser_trackofflineuser_id')) 
go

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
declare @cons_cnt int
select @cons_cnt=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where lower(CONSTRAINT_NAME) ='fk_trackofflineuser_users' and table_name = 'TRACKOFFLINEUSER'
IF @cons_cnt > 0 
  BEGIN
   delete from TRACKOFFLINEUSER where user_id not in (select user_id from USERS);
   alter table TRACKOFFLINEUSER drop constraint fk_trackofflineuser_users;
   ALTER TABLE TRACKOFFLINEUSER ADD CONSTRAINT fk_trackofflineuser_users FOREIGN KEY (user_id) 
   REFERENCES USERS (user_id) ON DELETE CASCADE;
  END
go

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
declare 
  @constraint_exists integer,
  @col_exists integer
  select @constraint_exists=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS 
  where lower(CONSTRAINT_NAME) ='pk_trackofflineuser'
  select @col_exists=count(*) from sys.columns 
  where name = 'trackofflineuser_id' and object_id=object_id('trackofflineuser')
  if @constraint_exists <> 0  
   BEGIN
    alter table TRACKOFFLINEUSER drop CONSTRAINT PK_TRACKOFFLINEUSER;
   END
   if @col_exists = 0
   BEGIN
    alter table TRACKOFFLINEUSER add trackofflineuser_id integer;
   END
go

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
DECLARE @constraint_exists INT, 
        @col_exists        INT, 
        @user_id           INT, 
        @offline_date      DATETIME, 
        @status          VARCHAR(20), 
        @hard_drive_code VARCHAR(40), 
        @vkey            INT 
DECLARE @track_cur AS CURSOR 

SET @track_cur = CURSOR 
FOR SELECT user_id, 
           status, 
           offline_date, 
           hard_drive_code 
    FROM   trackofflineuser; 

SELECT @constraint_exists = count(*) FROM   information_schema.table_constraints 
WHERE  lower(constraint_name) = 'pk_trackofflineuser' 

SELECT @col_exists = count(*) FROM   sys.columns 
WHERE  name = 'trackofflineuser_id' AND object_id = Object_id('trackofflineuser') 

IF @constraint_exists = 0 AND @col_exists <> 0 
  BEGIN 
      OPEN @track_cur; 
      FETCH next FROM @track_cur INTO @user_id, @status, @offline_date, @hard_drive_code; 
      WHILE @@FETCH_STATUS = 0 
        BEGIN 
            BEGIN try 
                EXEC getnextkeys 'trackofflineuser_trackofflineuser_id', 1, @vkey output 
                UPDATE trackofflineuser 
                SET    trackofflineuser_id = @vkey 
                WHERE  user_id = @user_id AND offline_date = @offline_date 
                       AND hard_drive_code = @hard_drive_code AND status = @status; 

                FETCH next FROM @track_cur INTO @user_id, @status, @offline_date, @hard_drive_code; 
            END try 
            BEGIN catch 
                SELECT NULL 
            END catch 
        END 

      CLOSE @track_cur 

      ALTER TABLE trackofflineuser ALTER COLUMN trackofflineuser_id INT NOT NULL; 
  END 
go 

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
declare 
  @constraint_exists integer,
  @col_exists integer
  select @constraint_exists=count(*) from INFORMATION_SCHEMA.TABLE_CONSTRAINTS 
  where lower(CONSTRAINT_NAME) ='pk_trackofflineuser'
  select @col_exists=count(*) from sys.columns 
  where name = 'trackofflineuser_id' and object_id=object_id('trackofflineuser')
  if @constraint_exists = 0 and @col_exists <> 0
   BEGIN
    ALTER TABLE trackofflineuser ADD CONSTRAINT pk_trackofflineuser PRIMARY KEY (trackofflineuser_id); 
   END
go

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
declare
@v_setting_id int
EXEC getnextkeys 'settings_setting_id', 1, @v_setting_id output
insert into settings(namespace,setting_name,setting_value,setting_id)
select 'Administrator_Settings','formattedassignmentexceloutput','0',@v_setting_id
where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='formattedassignmentexceloutput')
go

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
 declare @default_name varchar(255)
 declare @col_name varchar(255)
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('PROJWBS') and col_name(parent_object_id,parent_column_id)='status_reviewer'
 if @default_name is not null
  exec ('alter table dbo.PROJWBS drop constraint '+@default_name)
go

--METADATA TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
declare 
  @col_exists integer
  select @col_exists = count(*) from sys.columns 
  where name = 'STATUS_REVIEWER' and object_id=object_id('PROJWBS')
  if @col_exists <> 0
  ALTER TABLE PROJWBS drop column  status_reviewer
go
go 
--END TYPE:UP2 GROUP:2010to2011 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2011to2012 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2011to2012 NAME:MISC_UPDATES
UPDATE admin_config
SET
    config_data = cast(replace(CAST(config_data AS nvarchar(max)),'>0</MinRepavingTime>','>300000</MinRepavingTime>') AS ntext)
WHERE
    config_type = 'BRE'
GO


go 
--END TYPE:UP2 GROUP:2011to2012 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F37128_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:2012to2101 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES
update prefer set min_pro_version = null
go
go 
--END TYPE:UP2 GROUP:2101to2102 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2103to2104 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2103to2104 NAME:MISC_UPDATES
UPDATE profpriv SET allow_flag='N' WHERE priv_num = 124 AND allow_flag='Y'
go

--METADATA TYPE:UP2 GROUP:2103to2104 NAME:MISC_UPDATES
UPDATE profpriv SET allow_flag='N' WHERE priv_num = 146 AND allow_flag='Y'
go

--METADATA TYPE:UP2 GROUP:2103to2104 NAME:MISC_UPDATES
UPDATE profpriv SET allow_flag='N' WHERE priv_num = 147 AND allow_flag='Y'
go

go 
--END TYPE:UP2 GROUP:2103to2104 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES
declare
 @v_len integer,
 @v_import_point_web integer,
 @v_import_point_pro integer,
 @v_delete_point_web integer,
 @v_delete_point_pro integer,
 @v_extdep_point integer,
 @v_import_value varchar(1),
 @v_delete_value varchar(1),
 @v_start varchar(max),
 @v_end varchar(max),
 @v_final varchar(max),
 @view_id integer,
 @view_data varchar(max);
 
 DECLARE @cur as CURSOR
 SET @cur = CURSOR FOR
 SELECT view_id, view_data
 from viewprop 
 where view_type = 'VP_XML_IMP_DET_OPT'
 and view_data is not null;
 OPEN @cur;
 FETCH NEXT FROM @cur INTO @view_id,@view_data;
WHILE @@FETCH_STATUS = 0
 BEGIN
 begin try
  set @v_len =DATALENGTH(@view_data);
  if(@v_len IS NOT NULL AND @v_len > 0)
  begin
   set @v_extdep_point = charindex('P_EXTDEP',@view_data)
  if (@v_extdep_point is null or @v_extdep_point = 0) 
   begin
    set @v_import_point_web =charindex('(0||P_TASKPRED(import_option|',@view_data);
    set @v_delete_point_pro =charindex('(0||P_TASKPRED(delete_unref|',@view_data);

    if(@v_import_point_web is not null and @v_import_point_web > 0) 
	begin
     set @v_start = left(@view_data,@v_import_point_web-1) 
     set @v_end = right(@view_data,@v_len-@v_import_point_web+1) 
	
	 set @v_delete_point_web =@v_import_point_web+44;
   
     set @v_import_value =substring(@view_data,@v_import_point_web+29,1) ;
     set @v_delete_value =substring(@view_data,@v_delete_point_web,1) ;

     set @v_final=@v_start+'(0||P_EXTDEP(import_option|'+@v_import_value+'|delete_unref|'+@v_delete_value+')())'+@v_end;
	 update viewprop set view_data=@v_final where view_id=@view_id;
	end;	
	else if(@v_delete_point_pro is not null and @v_delete_point_pro > 0)
	begin
	 set @v_start = left(@view_data,@v_delete_point_pro-1) 
     set @v_end = right(@view_data,@v_len-@v_delete_point_pro+1) 
    
     set @v_import_point_pro =@v_delete_point_pro+44;
   
     set @v_delete_value =substring(@view_data,@v_delete_point_pro+28,1) ;
     set @v_import_value =substring(@view_data,@v_import_point_pro,1) ;
 
     set @v_final=@v_start+'(0||P_EXTDEP(delete_unref|'+@v_delete_value+'|import_option|'+@v_import_value+')())'+@v_end;
	 update viewprop set view_data=@v_final where view_id=@view_id;  
	end;    
  end;
 end;
FETCH NEXT FROM @cur INTO @view_id,@view_data;
end try
begin catch
select null
end catch
END 
CLOSE @cur;
DEALLOCATE @cur;
go
go 
--END TYPE:UP2 GROUP:2104to2105 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2105to2106 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2105to2106 NAME:MISC_UPDATES
declare 
@v_nxt_key int
begin
EXEC getnextkeys 'viewpref_view_pref_id', 1, @v_nxt_key output
Insert into VIEWPREF (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
select @v_nxt_key,'CompletedActivitiesOnly','VT_TM_ACT_STAND'
where not exists (select 1 from VIEWPREF where VIEW_PREF_NAME='CompletedActivitiesOnly' and VIEW_PREF_TYPE='VT_TM_ACT_STAND');
Insert into VWPREFDATA (VIEW_PREF_ID,VIEW_PREF_KEY,VIEW_PREF_VALUE) 
select @v_nxt_key,'VT_FILTER.ShowInToolbar','false'
where not exists (select 1 from VWPREFDATA where VIEW_PREF_ID=@v_nxt_key 
and VIEW_PREF_KEY='VT_FILTER.ShowInToolbar' and VIEW_PREF_VALUE='false')
and exists (select 1 from VIEWPREF where VIEW_PREF_ID=@v_nxt_key);

EXEC getnextkeys 'viewpref_view_pref_id', 1, @v_nxt_key output
Insert into VIEWPREF (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
select @v_nxt_key,'NotStartedActivitiesOnly','VT_TM_ACT_STAND'
where not exists (select 1 from VIEWPREF where VIEW_PREF_NAME='NotStartedActivitiesOnly' and VIEW_PREF_TYPE='VT_TM_ACT_STAND');
Insert into VWPREFDATA (VIEW_PREF_ID,VIEW_PREF_KEY,VIEW_PREF_VALUE) 
select @v_nxt_key,'VT_FILTER.ShowInToolbar','false'
where not exists (select 1 from VWPREFDATA where VIEW_PREF_ID=@v_nxt_key 
and VIEW_PREF_KEY='VT_FILTER.ShowInToolbar' and VIEW_PREF_VALUE='false')
and exists (select 1 from VIEWPREF where VIEW_PREF_ID=@v_nxt_key);

EXEC getnextkeys 'viewpref_view_pref_id', 1, @v_nxt_key output
Insert into VIEWPREF (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
select @v_nxt_key,'InProgressActivitiesOnly','VT_TM_ACT_STAND'
where not exists (select 1 from VIEWPREF where VIEW_PREF_NAME='InProgressActivitiesOnly' and VIEW_PREF_TYPE='VT_TM_ACT_STAND');
Insert into VWPREFDATA (VIEW_PREF_ID,VIEW_PREF_KEY,VIEW_PREF_VALUE) 
select @v_nxt_key,'VT_FILTER.ShowInToolbar','false'
where not exists (select 1 from VWPREFDATA where VIEW_PREF_ID=@v_nxt_key 
and VIEW_PREF_KEY='VT_FILTER.ShowInToolbar' and VIEW_PREF_VALUE='false')
and exists (select 1 from VIEWPREF where VIEW_PREF_ID=@v_nxt_key);

EXEC getnextkeys 'viewpref_view_pref_id', 1, @v_nxt_key output
Insert into VIEWPREF (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
select @v_nxt_key,'CompletedActivitiesOnly','VT_TM_TS_STAND'
where not exists (select 1 from VIEWPREF where VIEW_PREF_NAME='CompletedActivitiesOnly' and VIEW_PREF_TYPE='VT_TM_TS_STAND');
Insert into VWPREFDATA (VIEW_PREF_ID,VIEW_PREF_KEY,VIEW_PREF_VALUE) 
select @v_nxt_key,'VT_FILTER.ShowInToolbar','false'
where not exists (select 1 from VWPREFDATA where VIEW_PREF_ID=@v_nxt_key 
and VIEW_PREF_KEY='VT_FILTER.ShowInToolbar' and VIEW_PREF_VALUE='false')
and exists (select 1 from VIEWPREF where VIEW_PREF_ID=@v_nxt_key);

EXEC getnextkeys 'viewpref_view_pref_id', 1, @v_nxt_key output
Insert into VIEWPREF (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
select @v_nxt_key,'NotStartedActivitiesOnly','VT_TM_TS_STAND'
where not exists (select 1 from VIEWPREF where VIEW_PREF_NAME='NotStartedActivitiesOnly' and VIEW_PREF_TYPE='VT_TM_TS_STAND');
Insert into VWPREFDATA (VIEW_PREF_ID,VIEW_PREF_KEY,VIEW_PREF_VALUE) 
select @v_nxt_key,'VT_FILTER.ShowInToolbar','false'
where not exists (select 1 from VWPREFDATA where VIEW_PREF_ID=@v_nxt_key 
and VIEW_PREF_KEY='VT_FILTER.ShowInToolbar' and VIEW_PREF_VALUE='false')
and exists (select 1 from VIEWPREF where VIEW_PREF_ID=@v_nxt_key);

EXEC getnextkeys 'viewpref_view_pref_id', 1, @v_nxt_key output
Insert into VIEWPREF (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
select @v_nxt_key,'InProgressActivitiesOnly','VT_TM_TS_STAND'
where not exists (select 1 from VIEWPREF where VIEW_PREF_NAME='InProgressActivitiesOnly' and VIEW_PREF_TYPE='VT_TM_TS_STAND');
Insert into VWPREFDATA (VIEW_PREF_ID,VIEW_PREF_KEY,VIEW_PREF_VALUE) 
select @v_nxt_key,'VT_FILTER.ShowInToolbar','false'
where not exists (select 1 from VWPREFDATA where VIEW_PREF_ID=@v_nxt_key 
and VIEW_PREF_KEY='VT_FILTER.ShowInToolbar' and VIEW_PREF_VALUE='false')
and exists (select 1 from VIEWPREF where VIEW_PREF_ID=@v_nxt_key);

end;
go
go 
--END TYPE:UP2 GROUP:2105to2106 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2106to2107 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2106to2107 NAME:MISC_UPDATES
declare
 @v_len integer,
 @v_import_point_web integer,
 @v_import_point_pro integer,
 @v_delete_point_web integer,
 @v_delete_point_pro integer,
 @v_actveps_point integer,
 @v_import_value varchar(1),
 @v_delete_value varchar(1),
 @v_start varchar(max),
 @v_end varchar(max),
 @v_final varchar(max),
 @view_id integer,
 @view_data varchar(max);
 
 DECLARE @cur as CURSOR
 SET @cur = CURSOR FOR
 SELECT view_id, view_data
 from viewprop 
 where view_type = 'VP_XML_IMP_DET_OPT'
 and view_data is not null;
 OPEN @cur;
 FETCH NEXT FROM @cur INTO @view_id,@view_data;
WHILE @@FETCH_STATUS = 0
 BEGIN
 begin try
  set @v_len =DATALENGTH(@view_data);
  if(@v_len IS NOT NULL AND @v_len > 0)
  begin
   set @v_actveps_point = charindex('G_ACTVTYPEEPS',@view_data)
  if (@v_actveps_point is null or @v_actveps_point = 0) 
   begin
    set @v_import_point_web =charindex('(0||G_ACTVTYPE(import_option|',@view_data);
    set @v_delete_point_pro =charindex('(0||G_ACTVTYPE(delete_unref|',@view_data);

    if(@v_import_point_web is not null and @v_import_point_web > 0) 
	begin
     set @v_start = left(@view_data,@v_import_point_web-1) 
     set @v_end = right(@view_data,@v_len-@v_import_point_web+1) 
	
	 set @v_delete_point_web =@v_import_point_web+44;
   
     set @v_import_value =substring(@view_data,@v_import_point_web+29,1) ;
     set @v_delete_value =substring(@view_data,@v_delete_point_web,1) ;

     set @v_final=@v_start+'(0||G_ACTVTYPEEPS(import_option|'+@v_import_value+'|delete_unref|'+@v_delete_value+')())(0||G_OBS(import_option|K|delete_unref|N)())'+@v_end;
	 update viewprop set view_data=@v_final where view_id=@view_id;
	end;	
	else if(@v_delete_point_pro is not null and @v_delete_point_pro > 0)
	begin
	 set @v_start = left(@view_data,@v_delete_point_pro-1) 
     set @v_end = right(@view_data,@v_len-@v_delete_point_pro+1) 
    
     set @v_import_point_pro =@v_delete_point_pro+44;
   
     set @v_delete_value =substring(@view_data,@v_delete_point_pro+28,1) ;
     set @v_import_value =substring(@view_data,@v_import_point_pro,1) ;
 
     set @v_final=@v_start+'(0||G_ACTVTYPEEPS(delete_unref|'+@v_delete_value+'|import_option|'+@v_import_value+')())(0||G_OBS(delete_unref|N|import_option|K)())'+@v_end;
	 update viewprop set view_data=@v_final where view_id=@view_id;  
	end;    
  end;
 end;
FETCH NEXT FROM @cur INTO @view_id,@view_data;
end try
begin catch
select null
end catch
END 
CLOSE @cur;
DEALLOCATE @cur;
go


go 
--END TYPE:UP2 GROUP:2106to2107 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2107to2108 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2107to2108 NAME:MISC_UPDATES
declare @tab_exist int
select @tab_exist=count(*) from INFORMATION_SCHEMA.TABLES WHERE table_name = upper('RSRCOVERALLOC_BKP');
if @tab_exist = 0
CREATE TABLE RSRCOVERALLOC_BKP(
  "rsrc_id"  integer NULL,
  "role_id"  integer NULL,
  "overalloc_date"  datetime NULL
  )
go
  
--METADATA TYPE:UP2 GROUP:2107to2108 NAME:MISC_UPDATES
INSERT INTO RSRCOVERALLOC_BKP
SELECT rsrc_id,role_id,overalloc_date FROM RSRCOVERALLOC
WHERE (RSRC_ID  NOT LIKE '%[a-z .]%' OR RSRC_ID IS NULL )
AND (ROLE_ID NOT LIKE '%[a-z .]%' OR ROLE_ID IS NULL )
GO

--METADATA TYPE:UP2 GROUP:2107to2108 NAME:MISC_UPDATES
DROP TABLE RSRCOVERALLOC
GO

--METADATA TYPE:UP2 GROUP:2107to2108 NAME:MISC_UPDATES
EXEC sp_rename 'RSRCOVERALLOC_BKP', 'RSRCOVERALLOC'
GO

--METADATA TYPE:UP2 GROUP:2107to2108 NAME:MISC_UPDATES
CREATE  INDEX ndx_rsrcoveralloc_rsrc_id
ON RSRCOVERALLOC (rsrc_id)
GO

--METADATA TYPE:UP2 GROUP:2107to2108 NAME:MISC_UPDATES
CREATE  INDEX ndx_rsrcoveralloc_role_id
ON RSRCOVERALLOC (role_id)
GO

go 
--END TYPE:UP2 GROUP:2107to2108 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
MERGE INTO calendar t
USING (
          SELECT
              r.clndr_id rsrc_clndr_id,
              isNull(r.base_clndr_id, d2.clndr_id) rsrc_base_clndr_id,
              isNull(b.clndr_data, d2.clndr_data) base_clndr_data
          FROM
              calendar   r
              LEFT OUTER JOIN calendar b
                              ON r.base_clndr_id = b.clndr_id
              JOIN (SELECT MIN(clndr_id) clndr_id
                    FROM calendar
                    WHERE default_flag = 'Y') d1 ON 1=1
              JOIN calendar d2 ON d1.clndr_id=d2.clndr_id
          WHERE
              r.clndr_type = 'CA_Rsrc'
              AND r.clndr_data IS NULL
      )
s ON ( t.clndr_id = s.rsrc_clndr_id )
WHEN MATCHED THEN UPDATE
SET t.clndr_data = s.base_clndr_data;
GO

--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
UPDATE vwprefdata
SET
    view_pref_value = '/action/administrationstartpage'
WHERE
        view_pref_key = 'UIView.DefaultLandingPage'
    AND view_pref_value IN ( '/action/useradministration', '/action/adminpreferences', '/action/dictionaries',
                             '/action/home?globalscheduledservices',
                             '/action/managenavigationviews' )
go

--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
if exists (SELECT 1 FROM sys.indexes WHERE name='NDX_PROJECT_PROJECT_FLAG' AND object_id = OBJECT_ID('DBO.PROJECT'))
	DROP INDEX PROJECT.NDX_PROJECT_PROJECT_FLAG
go

--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
declare @count int
 select @count =count(*) from sys.check_constraints where name='ck_proj_rsrc_role_match_flag'
 if (@count=0)
  exec ('alter table PROJECT ADD CONSTRAINT ck_proj_rsrc_role_match_flag CHECK (rsrc_role_match_flag in (''Y'', ''N''))')
go

--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
CREATE  INDEX ndx_project_project_flag
ON PROJECT (PROJECT_FLAG,ORIG_PROJ_ID,DELETE_SESSION_ID,PROJ_SHORT_NAME,PROJ_ID,FINTMPL_ID)
go

--METADATA TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
MERGE INTO asgnmntacat t
USING (
          SELECT
              asgnmntacat.taskrsrc_id,
              asgnmntacat.asgnmnt_catg_type_id,
              asgnmntacat.asgnmnt_catg_id,
              taskrsrc.proj_id taskrsrc_proj_id
          FROM
              asgnmntacat,
              taskrsrc
          WHERE
                  asgnmntacat.taskrsrc_id = taskrsrc.taskrsrc_id
              AND asgnmntacat.proj_id != taskrsrc.proj_id
              AND asgnmntacat.delete_session_id IS NULL
   )
s ON ( t.taskrsrc_id = s.taskrsrc_id
       AND t.asgnmnt_catg_type_id = s.asgnmnt_catg_type_id
       AND t.asgnmnt_catg_id = s.asgnmnt_catg_id )
WHEN MATCHED THEN UPDATE
SET t.proj_id = s.taskrsrc_proj_id;
go
go 
--END TYPE:UP2 GROUP:2108to2109 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES
declare @count int
 select @count =count(*) from sys.check_constraints where name='ck_proj_rsrc_role_match_flag'
 if (@count=0)
  exec ('alter table PROJECT ADD CONSTRAINT ck_proj_rsrc_role_match_flag CHECK (rsrc_role_match_flag in (''Y'', ''N''))')
go
--METADATA TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES
declare @v_clobber_point INTEGER,@v_loc_point integer;
DECLARE @v_view_name varchar(255),@v_blob_col_val varchar(max),@v_len INTEGER,@v_rowid_val INTEGER;
declare @v_start_point INTEGER,@v_final varchar(max),@v_count integer,@v_rem varchar(max);
declare @v_schedoption_start INTEGER,@v_left_endpoint INTEGER,@v_right_startpoint INTEGER;

SELECT @v_view_name=view_name,@v_blob_col_val=view_data
 FROM viewprop
WHERE view_name = 'Default Import Template' and VIEW_TYPE='VP_XML_IMP_DET_OPT';
set @v_len = DATALENGTH(@v_blob_col_val);
if(@v_len IS NOT NULL AND @v_len > 0)
begin
 set @v_clobber_point = charindex('ClobberOptions',@v_blob_col_val)
 IF ( @v_clobber_point IS NOT NULL AND @v_clobber_point > 0 )
  begin
    set @v_loc_point = charindex('P_PROJISSU',@v_blob_col_val)
   IF ( @v_loc_point IS NOT NULL AND @v_loc_point >0 )
    begin
      set @v_start_point = charindex('P_PROJISSU',@v_blob_col_val)+54
	  set @v_schedoption_start = charindex('P_SCHEDOPTIONS',@v_blob_col_val)
     IF (@v_start_point IS NOT NULL AND @v_schedoption_start IS NOT NULL AND @v_schedoption_start > 0 AND (@v_start_point=@v_schedoption_start OR @v_len=@v_schedoption_start+49))
       begin
          set @v_left_endpoint = @v_schedoption_start - 5
		  set @v_right_startpoint = @v_schedoption_start + 48
		  set @v_final = left(@v_blob_col_val,@v_left_endpoint)
		  set @v_rem = right(@v_blob_col_val,(@v_len-@v_right_startpoint))
          set @v_final = @v_final + @v_rem
          UPDATE VIEWPROP SET view_data = @v_final where view_name = 'Default Import Template';
       end
    end
  end
end
go
go 
--END TYPE:UP2 GROUP:2109to2110 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2110to2111 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2110to2111 NAME:MISC_UPDATES
merge profpriv pp
    using (select prof_id ,'124' as priv_num,'Y' as allow_flag from profile where scope_type='ST_Project' and prof_id=51) p
    on (pp.prof_id = p.prof_id and pp.priv_num = p.priv_num)
  when matched then
    update set pp.allow_flag = 'Y'
  when not matched then
    insert (prof_id,priv_num,allow_flag)
    values (p.prof_id,p.priv_num,'Y');
go

--METADATA TYPE:UP2 GROUP:2110to2111 NAME:MISC_UPDATES
declare 
@v_nxt_key int
begin
EXEC getnextkeys 'viewpref_view_pref_id', 1, @v_nxt_key output
Insert into VIEWPREF (VIEW_PREF_ID,VIEW_PREF_NAME,VIEW_PREF_TYPE) 
select @v_nxt_key,'ActivityOwner','VT_TM_ACT_STAND'
where not exists (select 1 from VIEWPREF where VIEW_PREF_NAME='ActivityOwner' and VIEW_PREF_TYPE='VT_TM_ACT_STAND');
Insert into VWPREFDATA (VIEW_PREF_ID,VIEW_PREF_KEY,VIEW_PREF_VALUE) 
select @v_nxt_key,'VT_FILTER.ShowInToolbar','false'
where not exists (select 1 from VWPREFDATA where VIEW_PREF_ID=@v_nxt_key 
and VIEW_PREF_KEY='VT_FILTER.ShowInToolbar' and VIEW_PREF_VALUE='false')
and exists (select 1 from VIEWPREF where VIEW_PREF_ID=@v_nxt_key);
end;
go
go 
--END TYPE:UP2 GROUP:2110to2111 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2111to2112 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2111to2112 NAME:MISC_UPDATES

--Variable Declaration
DECLARE @vactvcode_pattern VARCHAR(26) = '%UPPER(ActivityCodeTypeId%';
DECLARE @vrsrccode_pattern VARCHAR(26) = '%UPPER(ResourceCodeTypeId%';  
DECLARE @vprojcode_pattern VARCHAR(26) = '%UPPER(ProjectCodeId%';
DECLARE @veqlsign VARCHAR(1) = '=';
DECLARE @vview_pref_id INTEGER, @vview_pref_key VARCHAR(25), @vfilter_string VARCHAR(4000), @vfinal VARCHAR(4000);
DECLARE @i1 INTEGER, @i2 INTEGER, @i3 INTEGER, @i4 INTEGER, @i5 INTEGER;

--Cursor Declaration
DECLARE filter_list CURSOR FOR 
SELECT
    view_pref_id,
    view_pref_key,
    view_pref_value
FROM
    vwprefdata
WHERE
    view_pref_key = 'VT_FILTER.FilterCriteria'
    AND (view_pref_value LIKE '%UPPER(ActivityCodeTypeId%' 
         OR view_pref_value LIKE '%UPPER(ResourceCodeTypeId%'
         OR view_pref_value LIKE '%UPPER(ProjectCodeId%');

--Open Cursor
OPEN filter_list

--Fetch record from cursor
FETCH NEXT FROM filter_list INTO @vview_pref_id, @vview_pref_key, @vfilter_string

WHILE @@FETCH_STATUS = 0

BEGIN
  --Remove UPPER Function From ActivityCodeTypeId
  WHILE (PATINDEX(@vactvcode_pattern,@vfilter_string) <> 0)
  BEGIN
     SET @i1 = PATINDEX(@vactvcode_pattern,@vfilter_string)+6;
     SET @i2 = CHARINDEX(')',@vfilter_string,@i1);
     SET @i3 = CHARINDEX('(',@vfilter_string,PATINDEX(@vactvcode_pattern,@vfilter_string)+6);
     SET @i4 = CHARINDEX(')',@vfilter_string,CHARINDEX(')',@vfilter_string,PATINDEX(@vactvcode_pattern,@vfilter_string)+6)+1);
     SET @i5 = LEN(@vfilter_string);
     SET @vfinal = LEFT(@vfilter_string,PATINDEX(@vactvcode_pattern,@vfilter_string)-1);
       SET @vfinal = @vfinal
                   + SUBSTRING(@vfilter_string,@i1,@i2-@i1)
                            + @veqlsign
                            + SUBSTRING(@vfilter_string,@i3+1,(@i4-@i3)-1)
                            + RIGHT(@vfilter_string,(@i5-@i4));
     SET @vfilter_string = @vfinal;
  END;
  --Remove UPPER Function From ResourceCodeTypeId
  WHILE (PATINDEX(@vrsrccode_pattern,@vfilter_string) <> 0)
  BEGIN
     SET @i1 = PATINDEX(@vrsrccode_pattern,@vfilter_string)+6;
     SET @i2 = CHARINDEX(')',@vfilter_string,@i1);
     SET @i3 = CHARINDEX('(',@vfilter_string,PATINDEX(@vrsrccode_pattern,@vfilter_string)+6);
     SET @i4 = CHARINDEX(')',@vfilter_string,CHARINDEX(')',@vfilter_string,PATINDEX(@vrsrccode_pattern,@vfilter_string)+6)+1);
     SET @i5 = LEN(@vfilter_string);
     SET @vfinal = LEFT(@vfilter_string,PATINDEX(@vrsrccode_pattern,@vfilter_string)-1);
       SET @vfinal = @vfinal
                   + SUBSTRING(@vfilter_string,@i1,@i2-@i1)
                            + @veqlsign
                            + SUBSTRING(@vfilter_string,@i3+1,(@i4-@i3)-1)
                            + RIGHT(@vfilter_string,(@i5-@i4));
     SET @vfilter_string = @vfinal;
  END;

  --Remove UPPER Function From ProjectCodeId
  WHILE (PATINDEX(@vprojcode_pattern,@vfilter_string) <> 0)
  BEGIN
       SET @i1 = PATINDEX(@vprojcode_pattern,@vfilter_string)+6;
       SET @i2 = CHARINDEX(')',@vfilter_string,@i1);
       SET @i3 = CHARINDEX('(',@vfilter_string,PATINDEX(@vprojcode_pattern,@vfilter_string)+6);
       SET @i4 = CHARINDEX(')',@vfilter_string,CHARINDEX(')',@vfilter_string,PATINDEX(@vprojcode_pattern,@vfilter_string)+6)+1);
       SET @i5 = LEN(@vfilter_string);
       SET @vfinal = LEFT(@vfilter_string,PATINDEX(@vprojcode_pattern,@vfilter_string)-1);
       SET @vfinal = @vfinal
                   + SUBSTRING(@vfilter_string,@i1,@i2-@i1)
                            + @veqlsign
                            + SUBSTRING(@vfilter_string,@i3+1,(@i4-@i3)-1)
                            + RIGHT(@vfilter_string,(@i5-@i4));
       SET @vfilter_string = @vfinal;
  END;
  
  
  --Update filter string With ActivityCodeTypeId, ResourceCodeTypeId, ProjectCodeId UPPER function(s) removed
  UPDATE vwprefdata
  SET view_pref_value = @vfilter_string
  WHERE view_pref_id = @vview_pref_id AND view_pref_key=@vview_pref_key;

  --Fetch the next record from cursor
  FETCH NEXT FROM filter_list INTO @vview_pref_id, @vview_pref_key, @vfilter_string;

END;

--Close the cursor
CLOSE filter_list;

--Deallocate the cursor
DEALLOCATE filter_list;


--METADATA TYPE:UP2 GROUP:2111to2112 NAME:MISC_UPDATES
DECLARE @v_view_pref_id   INT,
        @v_view_pref_type VARCHAR(200),
        @uiv_cur          CURSOR

SET @uiv_cur =CURSOR
FOR SELECT view_pref_id,
           view_pref_type
    FROM   viewpref
    WHERE  view_pref_type = 'VT_UIVIEW';

OPEN @uiv_cur

FETCH next FROM @uiv_cur INTO @v_view_pref_id, @v_view_pref_type

WHILE @@FETCH_STATUS = 0
  BEGIN
      BEGIN try
          UPDATE vwprefdata
          SET    view_pref_value = 'Y'
          WHERE  view_pref_key = 'UIView.HighLevelPlanning'
                 AND view_pref_id = @v_view_pref_id
                 AND EXISTS (SELECT 1
                             FROM   vwprefdata
                             WHERE  view_pref_key = 'UIView.DetailedPlanning'
                                    AND upper(view_pref_value) in ('TRUE','Y')
                                    AND view_pref_id = @v_view_pref_id);

          FETCH next FROM @uiv_cur INTO @v_view_pref_id, @v_view_pref_type
      END try

      BEGIN catch
          SELECT NULL;
      END catch;
  END

go 

go 
--END TYPE:UP2 GROUP:2111to2112 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F51301_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:2112to2201 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2201to2202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2201to2202 NAME:MISC_UPDATES
select null 
go
go 
--END TYPE:UP2 GROUP:2201to2202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2202to2203 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2202to2203 NAME:MISC_UPDATES
UPDATE project SET last_recalc_date = plan_start_date
WHERE project_flag = 'Y' AND plan_start_date IS NOT NULL AND last_recalc_date < plan_start_date
go

--METADATA TYPE:UP2 GROUP:2202to2203 NAME:MISC_UPDATES
update settings set setting_value = 'https://docs.oracle.com/cd/F51303_01/client_help/' where setting_name = 'OnlineHelpRootUrl'
go

go 
--END TYPE:UP2 GROUP:2202to2203 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update chghead set delete_session_id = 0, delete_date = getdate() where transaction_id IN
(select transaction_id from chghead WHERE request_user_id NOT IN (SELECT user_id FROM USERS))
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update chgtask set delete_session_id = 0, delete_date = getdate() where transaction_id IN
(select transaction_id from chghead WHERE request_user_id NOT IN (SELECT user_id FROM USERS))
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update chgtrsrc set delete_session_id = 0, delete_date = getdate() where transaction_id IN
(select transaction_id from chghead WHERE request_user_id NOT IN (SELECT user_id FROM USERS))
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update chgtaskactv set delete_session_id = 0, delete_date = getdate() where transaction_id IN
(select transaction_id from chghead WHERE request_user_id NOT IN (SELECT user_id FROM USERS))
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update chgtaskproc set delete_session_id = 0, delete_date = getdate() where transaction_id IN
(select transaction_id from chghead WHERE request_user_id NOT IN (SELECT user_id FROM USERS))
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update chgudfvalue set delete_session_id = 0, delete_date = getdate() where transaction_id IN
(select transaction_id from chghead WHERE request_user_id NOT IN (SELECT user_id FROM USERS))
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='Y', DISP_INDICATOR_FLAG='N' 
where table_name = 'PROJECT' 
and  udf_type_label in ('Approved Budget', 'Bugs Fixed', 'Business Case #', 'Change', 'Comments', 'Cost Status', 'Cost-Budget Variance',
 'Count', 'Current Year Approved Hours', 'Customer Satisfaction', 'Date', 'Delivery Date', 'Description', 'Effort (FTE)', 'Est. Costs', 'Estimated IT Costs $',
 'Estimated PC Costs $', 'Expected Finish', 'Forecasted Revenue', 'FTE Reduction', 'Hardware Budget', 'Next Year Approved Hours',
 'NPV $', 'Original Budget', 'Overall Status', 'Phone', 'Planned Finish', 'Prev. Year Approved Hours', 'Projected Final Cost', 'Proposed Budget', 'Quality',
 'Risk', 'Risk Assessment', 'ROI (%)', 'Safety', 'Schedule Status', 'Scope Changes', 'Scope Status', 'Six Sigma Customer Inquires Reduced',
 'Six Sigma Defects', 'Six Sigma Estimated FTE Saved', 'Six Sigma Total Savings ($)', 'Stored Proj Score', 'sys_schedule_freeze', 'sys_scope_freeze',
 'sys_workdown', 'sys_workdown_date', 'sys_workprocess', 'Target %', 'Total Benefits $')
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='Y', DISP_INDICATOR_FLAG='Y' 
where table_name = 'PROJECT' 
and  udf_type_label in ('forecasted remaining duration', 'Market Risk  (20%)', 'Previous Score', 'Product Innovation  (25%)', 'Product Reliability',
 'Product ROI  (30%)', 'Production Impact  (15%)', 'Risk Level', 'Total Weighted Score')
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype 
set DISP_DATA_FLAG='N', DISP_INDICATOR_FLAG='Y' 
where table_name = 'PROJECT' 
and  udf_type_label in ('Cost Variance', 'Current Score', 'Financial ROI  (30%)', 'Overall Score  (weighted)', 'Resource Capacity  (10%)',
'Resource Constraints  (20%)', 'Strategy Alignment  (40%)', 'Technology Fit  (10%)')
go
--METADATA TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
update udftype
set disp_data_flag='Y', disp_indicator_flag='N', udf_code_short_len=7
where table_name = 'PROJECT' 
and logical_data_type like '%DATE'
go

go 
--END TYPE:UP2 GROUP:2204to2205 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2205to2206 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2205to2206 NAME:MISC_UPDATES
UPDATE admin_config
SET
    config_data = cast(replace(CAST(config_data AS nvarchar(max)),'</MaxConnections>
<FetchSize min="0" type="java.lang.Integer" max="2147483647" desc="SET_CONNECTION_POOL_FETCHSIZE">120</FetchSize>', '</MaxConnections>
<FetchSize min="0" type="java.lang.Integer" max="2147483647" desc="SET_CONNECTION_POOL_FETCHSIZE">8192</FetchSize>') AS ntext)
WHERE
    config_type = 'BRE';
GO
--METADATA TYPE:UP2 GROUP:2205to2206 NAME:MISC_UPDATES
declare
@def_con_name varchar(30),
@sqlstring varchar(200);
begin
select @def_con_name=name 
from sys.default_constraints 
where parent_object_id=object_id('project') 
 and col_name(parent_object_id,parent_column_id)='px_priority'

set @sqlstring = 'alter table project drop constraint ' + @def_con_name

exec (@sqlstring)

alter table project 
alter column px_priority numeric(3,0)

alter table project add default 50 for px_priority

end
go
go 
--END TYPE:UP2 GROUP:2205to2206 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2206to2207 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2206to2207 NAME:MISC_UPDATES
declare 
@v_setting_id int
select @v_setting_id=max(setting_id) from settings where setting_id is not null
update nextkey set key_seq_num = @v_setting_id + 2
  where key_name='settings_setting_id'
if not exists (SELECT 1 
    FROM settings 
    WHERE namespace='Administrator_Settings' and setting_name='P6OGLAppId')
insert into settings 
(namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id)
values ('Administrator_Settings','P6OGLAppId','VJeWIBIxQUW3FTuzAIEMFg',null,getdate(),'admin',getdate(),'admin',null,null,@v_setting_id +1) 
go

--METADATA TYPE:UP2 GROUP:2206to2207 NAME:MISC_UPDATES
declare 
@v_setting_id int
select @v_setting_id=max(setting_id) from settings where setting_id is not null
update nextkey set key_seq_num = @v_setting_id + 2
  where key_name='settings_setting_id'
if not exists (SELECT 1 
    FROM settings 
    WHERE namespace='Administrator_Settings' and setting_name='TMOGLAppId')
insert into settings 
(namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id)
values ('Administrator_Settings','TMOGLAppId','lJT0GTABRvKnAZ5Dt8Ynqw',null,getdate(),'admin',getdate(),'admin',null,null,@v_setting_id +1) 
go

--METADATA TYPE:UP2 GROUP:2206to2207 NAME:MISC_UPDATES
UPDATE admin_config
SET
    config_data = cast(replace(CAST(config_data AS nvarchar(max)),'>120</FetchSize>', '>8192</FetchSize>') AS ntext)
WHERE
    config_type = 'BRE';
GO

--METADATA TYPE:UP2 GROUP:2206to2207 NAME:MISC_UPDATES
declare 
@v_setting_id int
select @v_setting_id=max(setting_id) from settings where setting_id is not null
update nextkey set key_seq_num = @v_setting_id + 2
  where key_name='settings_setting_id'
if not exists (SELECT 1 
    FROM settings 
    WHERE namespace='Administrator_Settings' and setting_name='EnableOGLContent')
insert into settings 
(namespace,setting_name,setting_value,user_id,update_date,update_user,create_date,create_user,delete_session_id,delete_date,setting_id)
values ('Administrator_Settings','EnableOGLContent','false',null,getdate(),'admin',getdate(),'admin',null,null,@v_setting_id +1) 
go
go 
--END TYPE:UP2 GROUP:2206to2207 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2208to2209 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2208to2209 NAME:MISC_UPDATES
WITH cte AS (
    SELECT 
        job_type, 
        status_code, 
        job_type_key, 
        ROW_NUMBER() OVER (
            PARTITION BY 
                job_type, 
                status_code, 
                job_type_key
			ORDER BY
				job_type, 
                status_code, 
                job_type_key
        ) row_num
     FROM 
        jobsvc
		WHERE
        job_type = 'JT_RsrcRoleSpread'
        AND status_code = 'JS_Pending'
)
DELETE FROM cte
WHERE row_num > 1;
GO
go 
--END TYPE:UP2 GROUP:2208to2209 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:2209to2210 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:2209to2210 NAME:MISC_UPDATES
ALTER TABLE TASKUSER
DROP CONSTRAINT pk_taskuser
go
--METADATA TYPE:UP2 GROUP:2209to2210 NAME:MISC_UPDATES
ALTER TABLE TASKUSER
ADD CONSTRAINT pk_taskuser PRIMARY KEY (task_id)
go

--METADATA TYPE:UP2 GROUP:2209to2210 NAME:MISC_UPDATES
declare @v_num int
begin
    exec getnextkeys 'settings_setting_id',1,@v_num OUTPUT
	insert into settings(namespace,setting_name,setting_value,setting_id)
	select 'Administrator_Settings','EnablePublicationOnBaselineCreation','N',@v_num
	where not exists (select 1 from settings where namespace='Administrator_Settings' and setting_name='EnablePublicationOnBaselineCreation')
end
go
go 
--END TYPE:UP2 GROUP:2209to2210 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES
UPDATE settings SET setting_value = 'https://docs.oracle.com/cd/F51303_01/client_help/' WHERE setting_name='OnlineHelpRootUrl'
go
go 
--END TYPE:UP2 GROUP:221201to221202 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:221203to221204 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:221203to221204 NAME:MISC_UPDATES
select null
go
go 
--END TYPE:UP2 GROUP:221203to221204 NAME:MISC_UPDATES
--METADATA TYPE:UP2 GROUP:221204to221205 NAME:MISC_UPDATES 
--METADATA TYPE:UP2 GROUP:221204to221205 NAME:MISC_UPDATES
select null
go
go 
--END TYPE:UP2 GROUP:221204to221205 NAME:MISC_UPDATES
--EPPM Version update Scripts
--METADATA TYPE:VERSION_UPDATE DBTYPE:PMDB FROM:2212.0009.0000.0000 TO:2212.0009.0000.0000
disable trigger RT_PREFER on prefer;
disable trigger PRMAUD_PREFER on prefer;
update prefer set database_version='PMDB,2212.0009.0000.0000';
enable trigger RT_PREFER on prefer;
enable trigger PRMAUD_PREFER on prefer
go


--METADATA NAME:MISC_UPDATES TYPE:CONSTRAINT TARGET_OBJECT:TASK CHANGE:CREATE
declare @vproj_id int,@V_WBS_ID int,@v_chk_null varchar(3);
disable trigger prmaud_projrisk on projrisk;
declare @CUR_PROJRISK_PROJ_ID cursor;
set @CUR_PROJRISK_PROJ_ID = cursor for 
SELECT DISTINCT PROJ_ID FROM PROJRISK;
open @CUR_PROJRISK_PROJ_ID;
fetch @CUR_PROJRISK_PROJ_ID into @vproj_id;
WHILE @@FETCH_STATUS = 0
begin
select @V_WBS_ID=WBS_ID from PROJWBS where proj_id= @vproj_id AND PROJ_NODE_FLAG='Y';
UPDATE PROJRISK SET WBS_ID=@V_WBS_ID WHERE PROJ_ID=@vproj_id;
fetch @CUR_PROJRISK_PROJ_ID into @vproj_id;
end;
select @v_chk_null=is_nullable from information_schema.columns
    where lower(table_name)='projrisk' and lower(column_name)= 'wbs_id';
if upper(@v_chk_null)='YES'	
drop index projrisk.ndx_projrisk_projwbs;
alter table projrisk alter column wbs_id int not null;
CREATE INDEX ndx_projrisk_projwbs ON  projrisk(wbs_id );
close @CUR_PROJRISK_PROJ_ID;
deallocate @CUR_PROJRISK_PROJ_ID;
enable trigger prmaud_projrisk on projrisk;
go
--METADATA NAME:MISC_UPDATES TYPE:TABLE TARGET_OBJECT:PROFPRIV CHANGE:UPDATE
insert into profpriv(prof_id,priv_num,allow_flag,update_date,update_user)select distinct p.prof_id,176,'N', getdate(), session_user
from profpriv p,profile pf  where scope_type='ST_Project' and p.prof_id=pf.prof_id and  not  exists(select * from profpriv where prof_id=p.prof_id and priv_num=176) 
go
--METADATA NAME:MISC_UPDATES TYPE:TABLE TARGET_OBJECT:RISKSCRMTX CHANGE:INSERT
declare @v_matrix_id int
declare @cur_riskscrmtx_matrix_id cursor 
SET @cur_riskscrmtx_matrix_id = CURSOR FAST_FORWARD 
for select distinct matrix_id from project where matrix_id is not null 
open @cur_riskscrmtx_matrix_id
FETCH NEXT FROM @cur_riskscrmtx_matrix_id INTO @v_matrix_id
WHILE @@FETCH_STATUS = 0
begin
insert into riskscrmtx (matrix_id,name,description,method,impact_levels,probability_levels) values(@v_matrix_id,'Inserted by Migration Process',null,'SM_High',3,3);
FETCH NEXT FROM @cur_riskscrmtx_matrix_id INTO @v_matrix_id
END
CLOSE @cur_riskscrmtx_matrix_id
DEALLOCATE @cur_riskscrmtx_matrix_id
go
--METADATA NAME:MISC_UPDATES TYPE:TABLE TARGET_OBJECT:RISK CHANGE:INSERT
insert into risk(risk_id,id,proj_id,total_cost,type,status,name)
select risk_id,'Risk_Mig_'+cast(row_number() over (order by (select NULL)) as varchar),proj_id,0,priority_type,status_code,risk_name from projrisk
where risk_id not in (select risk_id from risk);
go
--METADATA NAME:FK_RISK_RISKID TYPE:CONSTRAINT TARGET_OBJECT:TASKRISK CHANGE:CREATE
ALTER TABLE taskrisk DROP CONSTRAINT FK_RISK_RISKID
go
--METADATA NAME:FK_RISK_RISKID TYPE:CONSTRAINT TARGET_OBJECT:TASKRISK CHANGE:CREATE
alter table taskrisk add  constraint FK_RISK_RISKID foreign key (risk_id) REFERENCES RISK (RISK_ID)
go

--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
declare @tblexists int
SELECT @tblexists=count(*) FROM sys.objects where type ='U' and upper(name) !='PRMAUDIT'
IF @tblexists > 0   
DROP TABLE PRMAUDIT
go
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
 declare @default_name varchar(255)
 declare @col_name varchar(255),@colcount int,@colexists int
 select @default_name =name from sys.default_constraints where parent_object_id=object_id('SPIDMAP') and col_name(parent_object_id,parent_column_id)='audit_info_extended'
 select @colcount =count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='SPIDMAP')
 select @colexists=count(*) from sys.columns where object_id=(SELECT object_id FROM sys.objects where type ='U' and name ='SPIDMAP') and name ='audit_info_extended'
 if @default_name is not null 
  exec ('alter table dbo.SPIDMAP drop constraint '+@default_name)
 if (@colcount >1) and (@colexists =1)
ALTER TABLE SPIDMAP drop column  audit_info_extended
go
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
Insert into NEXTKEY select 'settings_setting_id',(select count(*)+1 from settings) from prefer where not exists (select * from nextkey where lower(key_name)='settings_setting_id');
go
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
ALTER TABLE project ALTER COLUMN etl_hour INT NOT NULL
go
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES 
ALTER TABLE project ALTER COLUMN etl_interval INT NOT NULL 
go
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES
disable trigger PRMAUD_PROJRISK on PROJRISK
go
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES 
update PROJRISK set wbs_id = 0
go
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES 
ALTER TABLE PROJRISK ALTER COLUMN wbs_id  integer NOT NULL
go
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES 
update PROJRISK set priority_type = 'PT_Normal'
go
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES 
ALTER TABLE PROJRISK ALTER COLUMN priority_type nvarchar(12) NOT NULL
go
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES 
update PROJRISK set add_date = getdate()
go
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES 
ALTER TABLE PROJRISK ALTER COLUMN add_date datetime NOT NULL
go

--METADATA TYPE:MIGRATION NAME:MISC_UPDATES 
--ALTER TABLE project ALTER COLUMN rsrc_self_add_out_flag  VARCHAR(1) NOT NULL
--go
--METADATA TYPE:MIGRATION NAME:MISC_UPDATES 
--ALTER TABLE PREFER ALTER COLUMN ts_rsrc_def_asgn_out_actv_flag VARCHAR(1) NOT NULL
--go
