--METADATA  TYPE:SSCR NAME:dbtk_clear_database_objects OBJECT_TYPE:PROCEDURE
IF EXISTS (SELECT 1 FROM sysobjects WHERE name = 'dbtk_clear_database_objects' and type='P')
  DROP PROCEDURE dbtk_clear_database_objects
GO

--METADATA NAME:dbtk_clear_database_objects TYPE:PROCEDURE CHANGE:CREATE
CREATE PROCEDURE dbtk_clear_database_objects
AS
  DECLARE base_obj CURSOR FOR
  select so.name object_name, 
  CASE 
    WHEN xtype ='P' THEN 'PROCEDURE' 
    WHEN xtype ='V' THEN 'VIEW' 
    WHEN xtype ='F' THEN 'FOREIGN KEY' 
    WHEN xtype ='FN' THEN 'FUNCTION'
    WHEN xtype ='SN' THEN 'SYNONYM' 
  END type_name
  , su.name user_name
  , (select name from sysobjects so2 where so2.id = so.parent_obj) parent_object
  from sysobjects so, sysusers su
  where xtype in ('P','V','F','FN','SN')
  and so.uid = su.uid
  and so.name not like 'dbtk%'


  declare @object_name sysname, @user_name sysname, @object_type sysname, @parent_object sysname
  declare @ddl nvarchar(4000)

  OPEN base_obj

  FETCH base_obj INTO @object_name,@object_type,@user_name, @parent_object
  WHILE (@@FETCH_STATUS = 0)
  BEGIN
    if ( @object_type != 'FOREIGN KEY')
      set @ddl='DROP ' + @object_type + ' ' +  @user_name + '.' + @object_name
    else
      set @ddl='ALTER TABLE ' + @parent_object + ' DROP CONSTRAINT ' + @object_name
      
    print @ddl
    exec sp_executesql @ddl
    FETCH base_obj INTO @object_name,@object_type,@user_name, @parent_object
  END

  CLOSE base_obj
  DEALLOCATE base_obj

  DECLARE tabs CURSOR FOR
   select TABLE_NAME,table_schema from INFORMATION_SCHEMA.TABLES; 
  OPEN tabs
  FETCH tabs INTO @object_name,@user_name

  WHILE (@@FETCH_STATUS = 0)
  BEGIN
    set @ddl='DROP TABLE ' + @user_name + '.'+ @object_name
      
    print @ddl
    exec sp_executesql @ddl
   
  FETCH tabs INTO @object_name,@user_name
  END
  
  CLOSE tabs
  DEALLOCATE tabs

go

--METADATA NAME:dbtk_clear_database_objects TYPE:EXEC
exec dbtk_clear_database_objects
go

--METADATA NAME:dbtk_clear_database_objects TYPE:PROCEDURE CHANGE:DROP
DROP PROCEDURE dbtk_clear_database_objects
go

