
SET QUOTED_IDENTIFIER ON

print 'Creating table ACCOUNT'

--METADATA NAME:ACCOUNT TYPE:TABLE CHANGE:CREATE

CREATE TABLE ACCOUNT(
  "acct_id"  integer NOT NULL,
  "acct_seq_num"  integer NOT NULL,
  "acct_short_name"  nvarchar(40) NOT NULL,
  "acct_name"  nvarchar(100) NOT NULL,
  "parent_acct_id"  integer NULL,
  "acct_descr"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table ACTVCODE'

--METADATA NAME:ACTVCODE TYPE:TABLE CHANGE:CREATE

CREATE TABLE ACTVCODE(
  "actv_code_id"  integer NOT NULL,
  "actv_code_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "short_name"  nvarchar(60) NOT NULL,
  "parent_actv_code_id"  integer NULL,
  "actv_code_name"  nvarchar(120) NULL,
  "color"  nvarchar(6) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table ACTVTYPE'

--METADATA NAME:ACTVTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE ACTVTYPE(
  "actv_code_type_id"  integer NOT NULL,
  "actv_short_len"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "actv_code_type"  nvarchar(40) NOT NULL,
  "actv_code_type_scope"  nvarchar(10) NOT NULL,
  "proj_id"  integer NULL,
  "super_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table ADMIN_CONFIG'

--METADATA NAME:ADMIN_CONFIG TYPE:TABLE CHANGE:CREATE

CREATE TABLE ADMIN_CONFIG(
  "config_name"  nvarchar(255) NOT NULL,
  "config_type"  nvarchar(10) NULL,
  "factory_version"  nvarchar(10) NULL,
  "last_change_date"  datetime DEFAULT getDate() NOT NULL,
  "config_value"  nvarchar(255) NULL,
  "config_data"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table ASGNMNTACAT'

--METADATA NAME:ASGNMNTACAT TYPE:TABLE CHANGE:CREATE

CREATE TABLE ASGNMNTACAT(
  "taskrsrc_id"  integer NOT NULL,
  "asgnmnt_catg_type_id"  integer NOT NULL,
  "asgnmnt_catg_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table ASGNMNTCATTYPE'

--METADATA NAME:ASGNMNTCATTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE ASGNMNTCATTYPE(
  "asgnmnt_catg_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "asgnmnt_catg_short_len"  integer NOT NULL,
  "asgnmnt_catg_type"  nvarchar(60) NOT NULL,
  "super_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table ASGNMNTCATVAL'

--METADATA NAME:ASGNMNTCATVAL TYPE:TABLE CHANGE:CREATE

CREATE TABLE ASGNMNTCATVAL(
  "asgnmnt_catg_id"  integer NOT NULL,
  "asgnmnt_catg_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "asgnmnt_catg_short_name"  nvarchar(60) NOT NULL,
  "asgnmnt_catg_name"  nvarchar(100) NULL,
  "parent_asgnmnt_catg_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table BASETYPE'

--METADATA NAME:BASETYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE BASETYPE(
  "base_type_id"  integer NOT NULL,
  "base_type_seq_num"  integer NOT NULL,
  "base_type"  nvarchar(40) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table BGPLOG'

--METADATA NAME:BGPLOG TYPE:TABLE CHANGE:CREATE

CREATE TABLE BGPLOG(
  "log_time"  datetime DEFAULT getDate() NULL,
  "source"  nvarchar(255) NULL,
  "type"  nvarchar(255) NULL,
  "description"  nvarchar(4000) NULL
  )

go

print 'Creating table BRE_REGISTRY'

--METADATA NAME:BRE_REGISTRY TYPE:TABLE CHANGE:CREATE

CREATE TABLE BRE_REGISTRY(
  "bre_registry_id"  nvarchar(50) NOT NULL,
  "ip_address"  nvarchar(30) NOT NULL,
  "start_time"  datetime NOT NULL,
  "last_time"  datetime NULL,
  "status_code"  char(1) NOT NULL,
  "torched_time"  datetime NULL,
  "config_name"  nvarchar(30) NOT NULL,
  "config_changed_flag"  char(1) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table BUDGCHNG'

--METADATA NAME:BUDGCHNG TYPE:TABLE CHANGE:CREATE

CREATE TABLE BUDGCHNG(
  "budg_chng_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "chng_date"  datetime NOT NULL,
  "chng_short_name"  nvarchar(32) NOT NULL,
  "chng_cost"  numeric(23,6) NULL,
  "chng_by_name"  nvarchar(255) NULL,
  "status_code"  nvarchar(30) NULL,
  "chng_descr"  nvarchar(130) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table CALENDAR'

--METADATA NAME:CALENDAR TYPE:TABLE CHANGE:CREATE

CREATE TABLE CALENDAR(
  "clndr_id"  integer NOT NULL,
  "default_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "rsrc_private"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "clndr_name"  nvarchar(255) NOT NULL,
  "proj_id"  integer NULL,
  "base_clndr_id"  integer NULL,
  "last_chng_date"  datetime NULL,
  "clndr_type"  nvarchar(16) NULL,
  "clndr_data"  TEXT NULL,
  "day_hr_cnt"  numeric(10,2) NULL,
  "week_hr_cnt"  numeric(10,2) NULL,
  "year_hr_cnt"  numeric(10,2) NULL,
  "month_hr_cnt"  numeric(10,2) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table COSTTYPE'

--METADATA NAME:COSTTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE COSTTYPE(
  "cost_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "cost_type"  nvarchar(36) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table CURRTYPE'

--METADATA NAME:CURRTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE CURRTYPE(
  "curr_id"  integer NOT NULL,
  "decimal_digit_cnt"  integer NOT NULL,
  "curr_symbol"  nvarchar(6) NOT NULL,
  "decimal_symbol"  nvarchar(6) NOT NULL,
  "digit_group_symbol"  nvarchar(6) NOT NULL,
  "pos_curr_fmt_type"  nvarchar(20) NOT NULL,
  "neg_curr_fmt_type"  nvarchar(20) NOT NULL,
  "curr_type"  nvarchar(40) NOT NULL,
  "curr_short_name"  nvarchar(6) NOT NULL,
  "group_digit_cnt"  integer DEFAULT 3 NOT NULL,
  "base_exch_rate"  numeric(22,6) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table DASHBOARD'

--METADATA NAME:DASHBOARD TYPE:TABLE CHANGE:CREATE

CREATE TABLE DASHBOARD(
  "dashboard_id"  integer NOT NULL,
  "dashboard_name"  nvarchar(255) NOT NULL,
  "user_id"  integer NULL,
  "table_name"  nvarchar(30) NULL,
  "fk_id"  integer NULL,
  "lock_filter_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "max_rows_per_portlet"  integer NULL,
  "dashboard_layout_data"  nvarchar(4000) NULL,
  "portlet_settings_data"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table DASHUSER'

--METADATA NAME:DASHUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE DASHUSER(
  "dashboard_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table DISCUSSION'

--METADATA NAME:DISCUSSION TYPE:TABLE CHANGE:CREATE

CREATE TABLE DISCUSSION(
  "discussion_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "discussion_value"  nvarchar(4000) NULL,
  "discussion_date"  datetime NULL,
  "user_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table DISCUSSION_READ'

--METADATA NAME:DISCUSSION_READ TYPE:TABLE CHANGE:CREATE

CREATE TABLE DISCUSSION_READ(
  "discussion_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table DLTACCT'

--METADATA NAME:DLTACCT TYPE:TABLE CHANGE:CREATE

CREATE TABLE DLTACCT(
  "session_id"  integer NOT NULL,
  "acct_id"  integer NOT NULL
  )

go

print 'Creating table DLTACTV'

--METADATA NAME:DLTACTV TYPE:TABLE CHANGE:CREATE

CREATE TABLE DLTACTV(
  "session_id"  integer NOT NULL,
  "actv_code_id"  integer NOT NULL,
  "parent_actv_code_id"  integer NULL
  )

go

print 'Creating table DLTOBS'

--METADATA NAME:DLTOBS TYPE:TABLE CHANGE:CREATE

CREATE TABLE DLTOBS(
  "session_id"  integer NOT NULL,
  "obs_id"  integer NOT NULL
  )

go

print 'Creating table DLTROLE'

--METADATA NAME:DLTROLE TYPE:TABLE CHANGE:CREATE

CREATE TABLE DLTROLE(
  "session_id"  integer NOT NULL,
  "role_id"  integer NOT NULL
  )

go

print 'Creating table DLTRSRC'

--METADATA NAME:DLTRSRC TYPE:TABLE CHANGE:CREATE

CREATE TABLE DLTRSRC(
  "session_id"  integer NOT NULL,
  "rsrc_id"  integer NOT NULL
  )

go

print 'Creating table DLTRSRL'

--METADATA NAME:DLTRSRL TYPE:TABLE CHANGE:CREATE

CREATE TABLE DLTRSRL(
  "session_id"  integer NOT NULL,
  "rsrc_id"  integer NOT NULL,
  "role_id"  integer NOT NULL
  )

go

print 'Creating table DLTUSER'

--METADATA NAME:DLTUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE DLTUSER(
  "session_id"  integer NOT NULL,
  "user_id"  integer NOT NULL
  )

go

print 'Creating table DOCCATG'

--METADATA NAME:DOCCATG TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOCCATG(
  "doc_catg_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "doc_catg_name"  nvarchar(100) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table DOCREVIEW'

--METADATA NAME:DOCREVIEW TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOCREVIEW(
  "doc_review_id"  integer NOT NULL,
  "doc_id"  integer NOT NULL,
  "user_id"  integer NULL,
  "review_name"  nvarchar(255) NULL,
  "review_descr"  nvarchar(255) NULL,
  "review_type"  nvarchar(15) NULL,
  "due_date"  datetime NULL,
  "status"  nvarchar(15) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table DOCREVIEWTASK'

--METADATA NAME:DOCREVIEWTASK TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOCREVIEWTASK(
  "review_task_id"  integer NOT NULL,
  "doc_review_id"  integer NOT NULL,
  "user_id"  integer NULL,
  "review_date"  datetime NULL,
  "comments"  nvarchar(4000) NULL,
  "priority"  integer NULL,
  "status"  nvarchar(15) NULL,
  "attachment_uuid"  nvarchar(4000) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table DOCSTAT'

--METADATA NAME:DOCSTAT TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOCSTAT(
  "doc_status_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "doc_status_code"  nvarchar(36) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table DOCUMENT'

--METADATA NAME:DOCUMENT TYPE:TABLE CHANGE:CREATE

CREATE TABLE DOCUMENT(
  "doc_id"  integer NOT NULL,
  "doc_seq_num"  integer NOT NULL,
  "deliv_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "doc_name"  nvarchar(120) NOT NULL,
  "parent_doc_id"  integer NULL,
  "proj_id"  integer NULL,
  "doc_status_id"  integer NULL,
  "doc_catg_id"  integer NULL,
  "doc_date"  datetime NULL,
  "version_name"  nvarchar(20) DEFAULT '1' NOT NULL,
  "guid"  nvarchar(22) NULL,
  "tmpl_guid"  nvarchar(22) NULL,
  "doc_short_name"  nvarchar(32) NULL,
  "author_name"  nvarchar(255) NULL,
  "private_loc"  nvarchar(255) NULL,
  "public_loc"  nvarchar(255) NULL,
  "doc_content"  TEXT NULL,
  "rsrc_id"  integer NULL,
  "doc_mgmt_type"  nvarchar(10) DEFAULT 'DM_Local' NOT NULL,
  "external_doc_key"  nvarchar(4000) NULL,
  "cr_external_doc_key"  nvarchar(4000) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table EXPPROJ'

--METADATA NAME:EXPPROJ TYPE:TABLE CHANGE:CREATE

CREATE TABLE EXPPROJ(
  "proj_id"  integer NOT NULL,
  "exp_group"  nvarchar(255) NOT NULL,
  "exp_proj_name"  nvarchar(24) NOT NULL,
  "login_supplied_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "exp_user_name"  nvarchar(40) NULL,
  "exp_passwd"  nvarchar(60) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table EXTAPP'

--METADATA NAME:EXTAPP TYPE:TABLE CHANGE:CREATE

CREATE TABLE EXTAPP(
  "app_id"  integer NOT NULL,
  "login_supply_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "app_name"  nvarchar(100) NOT NULL,
  "app_exe_name"  nvarchar(100) NOT NULL,
  "proj_id"  integer NULL,
  "app_user_name"  nvarchar(40) NULL,
  "app_passwd"  nvarchar(100) NULL,
  "app_data_name"  nvarchar(100) NULL,
  "app_parm_string"  nvarchar(255) NULL,
  "app_data_loc"  nvarchar(255) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table FACTOR'

--METADATA NAME:FACTOR TYPE:TABLE CHANGE:CREATE

CREATE TABLE FACTOR(
  "fact_id"  integer NOT NULL,
  "fact_seq_num"  integer NOT NULL,
  "fact_type"  nvarchar(20) NOT NULL,
  "fact_name"  nvarchar(100) NOT NULL,
  "def_fact_val_id"  integer NULL,
  "fact_descr"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table FACTVAL'

--METADATA NAME:FACTVAL TYPE:TABLE CHANGE:CREATE

CREATE TABLE FACTVAL(
  "fact_val_id"  integer NOT NULL,
  "fact_id"  integer NOT NULL,
  "fact_value"  nvarchar(24) NOT NULL,
  "fact_value_descr"  nvarchar(255) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table FILTPROP'

--METADATA NAME:FILTPROP TYPE:TABLE CHANGE:CREATE

CREATE TABLE FILTPROP(
  "filter_id"  integer NOT NULL,
  "table_name"  nvarchar(16) NOT NULL,
  "filter_type"  nvarchar(20) NOT NULL,
  "filter_name"  nvarchar(40) NOT NULL,
  "user_id"  integer NULL,
  "filter_data"  TEXT NULL,
  "rpt_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table FINDATES'

--METADATA NAME:FINDATES TYPE:TABLE CHANGE:CREATE

CREATE TABLE FINDATES(
  "fin_dates_id"  integer NOT NULL,
  "fin_dates_name"  nvarchar(60) NOT NULL,
  "start_date"  datetime NOT NULL,
  "end_date"  datetime NOT NULL,
  "fintmpl_id"  integer DEFAULT 1 NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table FINTMPL'

--METADATA NAME:FINTMPL TYPE:TABLE CHANGE:CREATE

CREATE TABLE FINTMPL(
  "fintmpl_id"  integer NOT NULL,
  "fintmpl_name"  nvarchar(255) NOT NULL,
  "default_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) DEFAULT 'NotPrmUser' NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) DEFAULT 'NotPrmUser' NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table FORMCATG'

--METADATA NAME:FORMCATG TYPE:TABLE CHANGE:CREATE

CREATE TABLE FORMCATG(
  "form_catg_id"  integer NOT NULL,
  "form_catg_name"  nvarchar(255) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table FORMPROJ'

--METADATA NAME:FORMPROJ TYPE:TABLE CHANGE:CREATE

CREATE TABLE FORMPROJ(
  "form_tmpl_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table FORMTMPL'

--METADATA NAME:FORMTMPL TYPE:TABLE CHANGE:CREATE

CREATE TABLE FORMTMPL(
  "form_tmpl_id"  integer NOT NULL,
  "form_tmpl_name"  nvarchar(255) NOT NULL,
  "form_tmpl_desc"  nvarchar(4000) NULL,
  "form_catg_id"  integer NULL,
  "form_tmpl_data"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table FUNDSRC'

--METADATA NAME:FUNDSRC TYPE:TABLE CHANGE:CREATE

CREATE TABLE FUNDSRC(
  "fund_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "fund_name"  nvarchar(100) NOT NULL,
  "parent_fund_id"  integer NULL,
  "fund_descr"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table GCHANGE'

--METADATA NAME:GCHANGE TYPE:TABLE CHANGE:CREATE

CREATE TABLE GCHANGE(
  "gchange_id"  integer NOT NULL,
  "gchange_name"  nvarchar(40) NOT NULL,
  "gchange_data"  TEXT NULL,
  "user_id"  integer NULL,
  "table_name"  nvarchar(20) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table HQDATA'

--METADATA NAME:HQDATA TYPE:TABLE CHANGE:CREATE

CREATE TABLE HQDATA(
  "session_id"  integer NOT NULL,
  "context_id"  integer NOT NULL,
  "fk_id"  integer NOT NULL,
  "value"  integer NOT NULL
  )

go

print 'Creating table HQUERY'

--METADATA NAME:HQUERY TYPE:TABLE CHANGE:CREATE

CREATE TABLE HQUERY(
  "session_id"  integer NOT NULL,
  "context_id"  integer NOT NULL,
  "fk_id"  integer NOT NULL,
  "order_value"  nvarchar(4000) NULL,
  "order_ids"  nvarchar(4000) NULL
  )

go

print 'Creating table IMAGEDATA'

--METADATA NAME:IMAGEDATA TYPE:TABLE CHANGE:CREATE

CREATE TABLE IMAGEDATA(
  "image_id"  integer NOT NULL,
  "image_name"  nvarchar(120) NULL,
  "image_data"  varbinary(max) NOT NULL,
  "image_thumbnail"  varbinary(max) NOT NULL,
  "image_extension"  nvarchar(20) DEFAULT 'png' NOT NULL,
  "default_flag"  nvarchar(1) NOT NULL,
  "image_purpose"  nvarchar(50) NOT NULL,
  "image_description"  nvarchar(250) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table ISSUHIST'

--METADATA NAME:ISSUHIST TYPE:TABLE CHANGE:CREATE

CREATE TABLE ISSUHIST(
  "issue_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "issue_history"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table ITERATION'

--METADATA NAME:ITERATION TYPE:TABLE CHANGE:CREATE

CREATE TABLE ITERATION(
  "iteration_id"  integer NOT NULL,
  "release_id"  integer NOT NULL,
  "iteration_name"  nvarchar(50) NOT NULL,
  "start_date"  datetime NULL,
  "end_date"  datetime NULL,
  "termination_date"  datetime NULL,
  "capacity_pct"  numeric(10,2) DEFAULT 0 NULL,
  "remain_qty"  numeric(17,6) NULL,
  "update_date"  datetime DEFAULT getDate() NULL,
  "update_user"  nvarchar(255) DEFAULT 'SYSTEM' NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "create_user"  nvarchar(255) DEFAULT 'SYSTEM' NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table ITERDAYS'

--METADATA NAME:ITERDAYS TYPE:TABLE CHANGE:CREATE

CREATE TABLE ITERDAYS(
  "task_id"  integer NOT NULL,
  "day_number"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "iteration_id"  integer NOT NULL,
  "act_work_qty"  numeric(17,6) NULL,
  "remain_work_qty"  numeric(17,6) NULL,
  "update_date"  datetime DEFAULT getDate() NULL,
  "update_user"  nvarchar(255) DEFAULT 'SYSTEM' NULL,
  "create_date"  datetime DEFAULT getDate() NULL,
  "create_user"  nvarchar(255) DEFAULT 'SYSTEM' NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table ITERGOAL'

--METADATA NAME:ITERGOAL TYPE:TABLE CHANGE:CREATE

CREATE TABLE ITERGOAL(
  "iter_goal_id"  integer NOT NULL,
  "iteration_id"  integer NOT NULL,
  "goal_name"  nvarchar(255) NOT NULL,
  "goal_descr"  nvarchar(4000) NOT NULL,
  "status_code"  nvarchar(12) DEFAULT 'IG_NotStart' NOT NULL,
  "rfolio_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table JOBLOG'

--METADATA NAME:JOBLOG TYPE:TABLE CHANGE:CREATE

CREATE TABLE JOBLOG(
  "job_id"  integer NOT NULL,
  "job_log_data"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table JOBRPT'

--METADATA NAME:JOBRPT TYPE:TABLE CHANGE:CREATE

CREATE TABLE JOBRPT(
  "job_id"  integer NOT NULL,
  "rpt_id"  integer NOT NULL,
  "table_name"  nvarchar(20) NULL,
  "fk_id"  integer NULL,
  "jobrpt_data"  TEXT NULL,
  "personal_portal_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table JOBSVC'

--METADATA NAME:JOBSVC TYPE:TABLE CHANGE:CREATE

CREATE TABLE JOBSVC(
  "job_id"  integer NOT NULL,
  "parent_job_id"  integer NULL,
  "seq_num"  integer NOT NULL,
  "audit_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "job_type"  nvarchar(20) NOT NULL,
  "job_name"  nvarchar(255) NOT NULL,
  "user_id"  integer NOT NULL,
  "last_run_date"  datetime NULL,
  "status_code"  nvarchar(20) NOT NULL,
  "recur_data"  nvarchar(255) NULL,
  "recur_type"  nvarchar(20) NULL,
  "submitted_date"  datetime NULL,
  "last_error_descr"  nvarchar(255) NULL,
  "audit_file_path"  nvarchar(255) NULL,
  "job_data"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table LOCATION'

--METADATA NAME:LOCATION TYPE:TABLE CHANGE:CREATE

CREATE TABLE LOCATION(
  "location_id"  integer NOT NULL,
  "location_name"  nvarchar(255) NOT NULL,
  "location_type"  nvarchar(24) NULL,
  "address_line1"  nvarchar(200) NULL,
  "address_line2"  nvarchar(200) NULL,
  "address_line3"  nvarchar(200) NULL,
  "city_name"  nvarchar(200) NULL,
  "municipality_name"  nvarchar(200) NULL,
  "state_name"  nvarchar(200) NULL,
  "state_code"  nvarchar(2) NULL,
  "country_name"  nvarchar(200) NULL,
  "country_code"  nvarchar(3) NULL,
  "postal_code"  nvarchar(20) NULL,
  "longitude"  DECIMAL(28,10) NULL,
  "latitude"  DECIMAL(28,10) NULL,
  "geo_location"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table MEMOTYPE'

--METADATA NAME:MEMOTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE MEMOTYPE(
  "memo_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "eps_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "proj_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "wbs_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "task_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "memo_type"  nvarchar(40) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table NEXTKEY'

--METADATA NAME:NEXTKEY TYPE:TABLE CHANGE:CREATE

CREATE TABLE NEXTKEY(
  "key_name"  nvarchar(60) NOT NULL,
  "key_seq_num"  integer NOT NULL
  )

go

print 'Creating table NONWORK'

--METADATA NAME:NONWORK TYPE:TABLE CHANGE:CREATE

CREATE TABLE NONWORK(
  "nonwork_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "nonwork_code"  nvarchar(32) NOT NULL,
  "nonwork_type"  nvarchar(40) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table NOTE'

--METADATA NAME:NOTE TYPE:TABLE CHANGE:CREATE

CREATE TABLE NOTE(
  "note_id"  integer NOT NULL,
  "table_name"  nvarchar(30) NOT NULL,
  "type_name"  nvarchar(30) NOT NULL,
  "fk_id"  integer NOT NULL,
  "note_date"  datetime NOT NULL,
  "note_value"  nvarchar(4000) NULL,
  "user_name"  nvarchar(255) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table OBS'

--METADATA NAME:OBS TYPE:TABLE CHANGE:CREATE

CREATE TABLE OBS(
  "obs_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "obs_name"  nvarchar(100) NOT NULL,
  "parent_obs_id"  integer NULL,
  "guid"  nvarchar(22) NULL,
  "obs_descr"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table OBSPROJ'

--METADATA NAME:OBSPROJ TYPE:TABLE CHANGE:CREATE

CREATE TABLE OBSPROJ(
  "obs_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL
  )

go

print 'Creating table PCATTYPE'

--METADATA NAME:PCATTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE PCATTYPE(
  "proj_catg_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "proj_catg_short_len"  integer NOT NULL,
  "proj_catg_type"  nvarchar(60) NOT NULL,
  "super_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "proj_catg_type_wt"  numeric(10,2) DEFAULT 0 NULL,
  "max_proj_catg_wt"  numeric(10,2) DEFAULT 0 NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PCATUSER'

--METADATA NAME:PCATUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE PCATUSER(
  "proj_catg_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PCATVAL'

--METADATA NAME:PCATVAL TYPE:TABLE CHANGE:CREATE

CREATE TABLE PCATVAL(
  "proj_catg_id"  integer NOT NULL,
  "proj_catg_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "proj_catg_short_name"  nvarchar(60) NOT NULL,
  "parent_proj_catg_id"  integer NULL,
  "proj_catg_name"  nvarchar(100) NULL,
  "proj_catg_wt"  numeric(10,2) DEFAULT 0 NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PFOLIO'

--METADATA NAME:PFOLIO TYPE:TABLE CHANGE:CREATE

CREATE TABLE PFOLIO(
  "pfolio_id"  integer NOT NULL,
  "closed_proj_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "whatif_proj_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "pfolio_type"  nvarchar(20) NOT NULL,
  "pfolio_name"  nvarchar(40) NOT NULL,
  "user_id"  integer NULL,
  "pfolio_descr"  nvarchar(255) NULL,
  "last_refresh_date"  datetime NULL,
  "pfolio_data"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PFOLIOUSER'

--METADATA NAME:PFOLIOUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE PFOLIOUSER(
  "pfolio_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PHASE'

--METADATA NAME:PHASE TYPE:TABLE CHANGE:CREATE

CREATE TABLE PHASE(
  "phase_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "phase_name"  nvarchar(100) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PKXREF'

--METADATA NAME:PKXREF TYPE:TABLE CHANGE:CREATE

CREATE TABLE PKXREF(
  "system_id"  integer NULL,
  "context_name"  nvarchar(30) NULL,
  "pk1"  integer NULL,
  "pk2"  integer NULL,
  "old_pk1"  integer NULL,
  "old_pk2"  integer NULL,
  "old_str"  nvarchar(40) NULL,
  "new_str"  nvarchar(40) NULL,
  "add_date"  datetime DEFAULT getDate() NULL
  )

go

print 'Creating table POBS'

--METADATA NAME:POBS TYPE:TABLE CHANGE:CREATE

CREATE TABLE POBS(
  "pobs_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "pobs_name"  nvarchar(255) NOT NULL,
  "pobs_parent_id"  integer NULL,
  "pobs_descr"  nvarchar(255) NULL,
  "pobs_manager"  nvarchar(255) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PREFER'

--METADATA NAME:PREFER TYPE:TABLE CHANGE:CREATE

CREATE TABLE PREFER(
  "prefer_id"  integer NOT NULL,
  "hr_decimal_cnt"  integer NOT NULL,
  "xfer_complete_day_cnt"  integer NOT NULL,
  "xfer_notstart_day_cnt"  integer NOT NULL,
  "max_wbs_level_cnt"  integer NOT NULL,
  "max_rsrc_level_cnt"  integer NOT NULL,
  "max_acct_level_cnt"  integer NOT NULL,
  "max_task_actv_type_cnt"  integer NOT NULL,
  "future_ts_cnt"  integer NOT NULL,
  "max_obs_level_cnt"  integer NOT NULL,
  "week_start_day_num"  integer NOT NULL,
  "ts_approval_level"  integer NOT NULL,
  "task_code_len"  integer NOT NULL,
  "proj_short_len"  integer NOT NULL,
  "wbs_short_len"  integer NOT NULL,
  "rsrc_short_len"  integer NOT NULL,
  "acct_short_len"  integer NOT NULL,
  "role_short_len"  integer NOT NULL,
  "max_base_cnt"  integer NOT NULL,
  "def_target_drtn_hr_cnt"  numeric(10,2) NOT NULL,
  "day_hr_cnt"  numeric(10,2) NOT NULL,
  "week_hr_cnt"  numeric(10,2) NOT NULL,
  "year_hr_cnt"  numeric(10,2) NOT NULL,
  "month_hr_cnt"  numeric(10,2) NOT NULL,
  "max_actv_level_cnt"  integer NOT NULL,
  "max_eps_level_cnt"  integer NOT NULL,
  "max_pcat_level_cnt"  integer NOT NULL,
  "max_rcat_level_cnt"  integer NOT NULL,
  "complete_task_hrs_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "default_timesheet_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "future_ts_hrs_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "ev_fix_cost_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "ts_daily_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "notstart_task_hrs_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "prestart_task_hrs_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "postend_task_hrs_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "ermm_enabled_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "name_sep_char"  nvarchar(2) NOT NULL,
  "year_char"  nvarchar(4) NOT NULL,
  "month_char"  nvarchar(4) NOT NULL,
  "week_char"  nvarchar(4) NOT NULL,
  "day_char"  nvarchar(4) NOT NULL,
  "hour_char"  nvarchar(4) NOT NULL,
  "minute_char"  nvarchar(4) NOT NULL,
  "ts_approval_type"  nvarchar(20) DEFAULT 'AT_PM_RM' NOT NULL,
  "db_name"  nvarchar(20) NOT NULL,
  "tasksum_period_type"  nvarchar(20) NOT NULL,
  "trsrcsum_period_type"  nvarchar(20) NOT NULL,
  "database_version"  nvarchar(30) NOT NULL,
  "min_pro_version"  nvarchar(10) NULL,
  "phase_label"  nvarchar(40) NOT NULL,
  "ts_approve_user_id"  integer NULL,
  "curr_id"  integer DEFAULT 1 NOT NULL,
  "ev_user_pct"  integer NULL,
  "ev_etc_user_value"  numeric(10,2) NULL,
  "ev_compute_type"  nvarchar(20) NULL,
  "ev_etc_compute_type"  nvarchar(20) NULL,
  "rpt_header_1"  nvarchar(255) NULL,
  "rpt_header_2"  nvarchar(255) NULL,
  "rpt_header_3"  nvarchar(255) NULL,
  "rpt_footer_1"  nvarchar(255) NULL,
  "rpt_footer_2"  nvarchar(255) NULL,
  "rpt_footer_3"  nvarchar(255) NULL,
  "rpt_user_1"  nvarchar(255) NULL,
  "rpt_user_2"  nvarchar(255) NULL,
  "rpt_user_3"  nvarchar(255) NULL,
  "license_data"  TEXT NULL,
  "max_role_level_cnt"  integer NOT NULL,
  "past_ts_cnt"  integer DEFAULT 4 NOT NULL,
  "projinit_admin_user_id"  integer NOT NULL,
  "default_rsrc_sec_id"  integer NULL,
  "allow_user_time_period_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "exp_root_url"  nvarchar(255) NULL,
  "ts_rsrc_def_asgn_actv_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "ts_rsrc_def_asgn_out_actv_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PRMAUDIT'

--METADATA NAME:PRMAUDIT TYPE:TABLE CHANGE:CREATE

CREATE TABLE PRMAUDIT(
  "audit_date"  datetime NULL,
  "table_name"  nvarchar(30) NULL,
  "pk1"  nvarchar(255) NULL,
  "pk2"  nvarchar(255) NULL,
  "pk3"  nvarchar(255) NULL,
  "pk4"  nvarchar(255) NULL,
  "oper"  nvarchar(1) NULL,
  "prm_user_name"  nvarchar(255) NULL,
  "audit_info"  nvarchar(4000) NULL,
  "audit_info_extended"  TEXT NULL,
  "logical_delete_flag"  nvarchar(1) NULL,
  "rdbms_user_name"  nvarchar(255) NULL,
  "os_user_name"  nvarchar(255) NULL,
  "program"  nvarchar(255) NULL,
  "host_name"  nvarchar(255) NULL,
  "app_name"  nvarchar(25) NULL,
  "netaddress"  nvarchar(64) NULL
  )

go

print 'Creating table PRMQUEUE'

--METADATA NAME:PRMQUEUE TYPE:TABLE CHANGE:CREATE

CREATE TABLE PRMQUEUE(
  "queue_name"  nvarchar(30) NOT NULL,
  "msg_key"  nvarchar(32) NOT NULL,
  "enqueue_date"  datetime NOT NULL,
  "enqueue_user"  nvarchar(255) NULL,
  "status_code"  nvarchar(10) NULL,
  "priority"  integer NULL,
  "sender_name"  nvarchar(255) NULL,
  "dequeue_date"  datetime NULL,
  "dequeue_user"  nvarchar(255) NULL,
  "retry_count"  integer NULL,
  "msg_type"  nvarchar(255) NULL,
  "msg_sub_type"  nvarchar(255) NULL,
  "key1"  nvarchar(255) NULL,
  "key2"  nvarchar(255) NULL,
  "err_msg"  nvarchar(4000) NULL,
  "queue_payload"  nvarchar(4000) NULL,
  "queue_payload_extended"  TEXT NULL
  )

go

print 'Creating table PROCGROUP'

--METADATA NAME:PROCGROUP TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROCGROUP(
  "proc_group_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "proc_group_name"  nvarchar(120) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PROCITEM'

--METADATA NAME:PROCITEM TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROCITEM(
  "proc_item_id"  integer NOT NULL,
  "proc_group_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "proc_name"  nvarchar(120) NOT NULL,
  "proc_wt"  numeric(10,2) NULL,
  "proc_descr"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PROFILE'

--METADATA NAME:PROFILE TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROFILE(
  "prof_id"  integer NOT NULL,
  "default_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "superuser_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "scope_type"  nvarchar(12) NOT NULL,
  "prof_name"  nvarchar(100) NOT NULL,
  "prof_descr"  nvarchar(255) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PROFPRIV'

--METADATA NAME:PROFPRIV TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROFPRIV(
  "prof_id"  integer NOT NULL,
  "priv_num"  integer NOT NULL,
  "allow_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PROJCOST'

--METADATA NAME:PROJCOST TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJCOST(
  "cost_item_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "auto_compute_act_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "cost_load_type"  nvarchar(12) NOT NULL,
  "acct_id"  integer NULL,
  "cost_type_id"  integer NULL,
  "target_cost"  numeric(23,6) NULL,
  "act_cost"  numeric(23,6) NULL,
  "remain_cost"  numeric(23,6) NULL,
  "qty_name"  nvarchar(30) NULL,
  "target_qty"  numeric(19,6) NOT NULL,
  "cost_per_qty"  numeric(21,8) NOT NULL,
  "po_number"  nvarchar(32) NULL,
  "vendor_name"  nvarchar(100) NULL,
  "cost_name"  nvarchar(120) NULL,
  "cost_descr"  TEXT NULL,
  "pobs_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PROJECT'

--METADATA NAME:PROJECT TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJECT(
  "proj_id"  integer NOT NULL,
  "fy_start_month_num"  integer NOT NULL,
  "chng_eff_cmp_pct_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "rsrc_self_add_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "rsrc_role_match_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "allow_complete_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "rsrc_multi_assign_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "checkout_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "project_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "step_complete_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "cost_qty_recalc_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "sum_only_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "batch_sum_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "name_sep_char"  nvarchar(2) NOT NULL,
  "def_complete_pct_type"  nvarchar(10) DEFAULT 'CP_Drtn' NOT NULL,
  "proj_short_name"  nvarchar(40) NOT NULL,
  "acct_id"  integer NULL,
  "orig_proj_id"  integer NULL,
  "source_proj_id"  integer NULL,
  "base_type_id"  integer NULL,
  "clndr_id"  integer NULL,
  "sum_base_proj_id"  integer NULL,
  "task_code_base"  integer NULL,
  "task_code_step"  integer NULL,
  "priority_num"  integer NULL,
  "wbs_max_sum_level"  integer NULL,
  "risk_level"  integer NULL,
  "strgy_priority_num"  integer NULL,
  "last_checksum"  integer NULL,
  "critical_drtn_hr_cnt"  numeric(10,2) NULL,
  "def_cost_per_qty"  numeric(21,8) NULL,
  "last_recalc_date"  datetime NULL,
  "plan_start_date"  datetime NULL,
  "plan_end_date"  datetime NULL,
  "scd_end_date"  datetime NULL,
  "add_date"  datetime DEFAULT getDate() NOT NULL,
  "sum_data_date"  datetime NULL,
  "last_tasksum_date"  datetime NULL,
  "fcst_start_date"  datetime NULL,
  "def_duration_type"  nvarchar(12) NULL,
  "task_code_prefix"  nvarchar(20) NULL,
  "guid"  nvarchar(22) NULL,
  "def_qty_type"  nvarchar(24) NULL,
  "add_by_name"  nvarchar(255) NULL,
  "web_local_root_path"  nvarchar(120) NULL,
  "proj_url"  nvarchar(200) NULL,
  "def_rate_type"  nvarchar(14) NULL,
  "act_this_per_link_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "def_task_type"  nvarchar(12) DEFAULT 'TT_Task' NOT NULL,
  "act_pct_link_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "add_act_remain_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "critical_path_type"  nvarchar(12) DEFAULT 'CT_TotFloat' NOT NULL,
  "task_code_prefix_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "def_rollup_dates_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "rem_target_link_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "reset_planned_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "allow_neg_act_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "rsrc_id"  integer NULL,
  "msp_managed_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "msp_update_actuals_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "checkout_date"  datetime NULL,
  "checkout_user_id"  integer NULL,
  "sum_assign_level"  nvarchar(12) DEFAULT 'SL_Taskrsrc' NULL,
  "last_fin_dates_id"  integer NULL,
  "use_project_baseline_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "last_baseline_update_date"  datetime NULL,
  "ts_rsrc_vw_compl_asgn_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "ts_rsrc_mark_act_finish_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "ts_rsrc_vw_inact_actv_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "cr_external_key"  nvarchar(4000) NULL,
  "apply_actuals_date"  datetime NULL,
  "description"  nvarchar(500) NULL,
  "intg_proj_type"  nvarchar(7) NULL,
  "matrix_id"  integer NULL,
  "location_id"  integer NULL,
  "last_schedule_date"  datetime NULL,
  "control_updates_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "hist_interval"  nvarchar(25) DEFAULT 'Month' NOT NULL,
  "hist_level"  nvarchar(10) DEFAULT 'HL_None' NOT NULL,
  "fintmpl_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PROJEST'

--METADATA NAME:PROJEST TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJEST(
  "proj_est_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "applied_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "rsrc_type"  nvarchar(10) DEFAULT 'RT_Labor' NOT NULL,
  "est_type"  nvarchar(20) NOT NULL,
  "est_name"  nvarchar(120) NOT NULL,
  "rsrc_id"  integer NULL,
  "bu_cmplx_value"  integer NULL,
  "adj_mult_pct"  integer NULL,
  "fp_cnt"  integer NULL,
  "fp_cmplx_value"  integer NULL,
  "fp_unadj_cnt"  integer NULL,
  "est_task_cnt"  integer NULL,
  "fp_prod_avg_value"  numeric(10,2) NULL,
  "est_qty"  numeric(17,6) NULL,
  "est_date"  datetime NULL,
  "est_notes"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PROJFUND'

--METADATA NAME:PROJFUND TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJFUND(
  "proj_fund_id"  integer NOT NULL,
  "fund_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "fund_cost"  numeric(23,6) NULL,
  "fund_wt"  numeric(10,2) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PROJISSU'

--METADATA NAME:PROJISSU TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJISSU(
  "issue_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "obs_id"  integer NOT NULL,
  "priority_type"  nvarchar(12) NOT NULL,
  "status_code"  nvarchar(12) NOT NULL,
  "issue_name"  nvarchar(100) NOT NULL,
  "thresh_id"  integer NULL,
  "track_view_id"  integer NULL,
  "wbs_id"  integer NULL,
  "task_id"  integer NULL,
  "rsrc_id"  integer NULL,
  "thresh_parm_id"  integer NULL,
  "base_proj_id"  integer NULL,
  "workspace_id"  integer NULL,
  "issue_value"  numeric(15,2) NULL,
  "lo_parm_value"  numeric(15,2) NULL,
  "hi_parm_value"  numeric(15,2) NULL,
  "add_by_name"  nvarchar(255) NULL,
  "resolv_date"  datetime NULL,
  "add_date"  datetime NULL,
  "issue_notes"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PROJPCAT'

--METADATA NAME:PROJPCAT TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJPCAT(
  "proj_id"  integer NOT NULL,
  "proj_catg_type_id"  integer NOT NULL,
  "proj_catg_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PROJPROP'

--METADATA NAME:PROJPROP TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJPROP(
  "proj_id"  integer NOT NULL,
  "prop_name"  nvarchar(32) NOT NULL,
  "prop_value"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PROJRISK'

--METADATA NAME:PROJRISK TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJRISK(
  "risk_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "add_date"  datetime NULL,
  "status_code"  nvarchar(12) NOT NULL,
  "risk_name"  nvarchar(200) NOT NULL,
  "risk_type_id"  integer NULL,
  "rsrc_id"  integer NULL,
  "risk_descr"  TEXT NULL,
  "risk_to_type"  nvarchar(12) DEFAULT 'RT_Threat' NOT NULL,
  "identified_by_id"  integer NULL,
  "response_type"  nvarchar(12) NULL,
  "response_text"  nvarchar(255) NULL,
  "pre_rsp_prblty"  nvarchar(2) NULL,
  "pre_rsp_schd_prblty"  nvarchar(2) NULL,
  "pre_rsp_cost_prblty"  nvarchar(2) NULL,
  "post_rsp_prblty"  nvarchar(2) NULL,
  "post_rsp_schd_prblty"  nvarchar(2) NULL,
  "post_rsp_cost_prblty"  nvarchar(2) NULL,
  "risk_cause"  nvarchar(4000) NULL,
  "risk_effect"  nvarchar(4000) NULL,
  "notes"  nvarchar(4000) NULL,
  "risk_code"  nvarchar(40) DEFAULT 0 NOT NULL,
  "risk_desc"  nvarchar(4000) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PROJSHAR'

--METADATA NAME:PROJSHAR TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJSHAR(
  "proj_id"  integer NOT NULL,
  "session_id"  integer NOT NULL,
  "access_level"  integer NOT NULL,
  "load_status"  char(1) DEFAULT 'L' NOT NULL
  )

go

print 'Creating table PROJTHRS'

--METADATA NAME:PROJTHRS TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJTHRS(
  "thresh_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "obs_id"  integer NOT NULL,
  "thresh_parm_id"  integer NOT NULL,
  "status_code"  nvarchar(12) NOT NULL,
  "priority_type"  nvarchar(12) DEFAULT 'PT_Normal' NOT NULL,
  "thresh_type"  nvarchar(12) DEFAULT 'TM_WBS' NOT NULL,
  "wbs_id"  integer NULL,
  "track_view_id"  integer NULL,
  "lo_parm_value"  numeric(15,2) NULL,
  "hi_parm_value"  numeric(15,2) NULL,
  "window_start"  nvarchar(50) NULL,
  "window_end"  nvarchar(50) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PROJWBS'

--METADATA NAME:PROJWBS TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJWBS(
  "wbs_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "obs_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "est_wt"  numeric(10,2) NULL,
  "proj_node_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "sum_data_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "status_code"  nvarchar(20) NOT NULL,
  "wbs_short_name"  nvarchar(40) NOT NULL,
  "wbs_name"  nvarchar(100) NOT NULL,
  "phase_id"  integer NULL,
  "parent_wbs_id"  integer NULL,
  "ev_user_pct"  integer NULL,
  "ev_etc_user_value"  numeric(10,2) NULL,
  "orig_cost"  numeric(23,6) NULL,
  "indep_remain_total_cost"  numeric(23,6) NULL,
  "ann_dscnt_rate_pct"  numeric(18,6) NULL,
  "dscnt_period_type"  nvarchar(20) NULL,
  "indep_remain_work_qty"  numeric(17,6) NULL,
  "anticip_start_date"  datetime NULL,
  "anticip_end_date"  datetime NULL,
  "ev_compute_type"  nvarchar(20) NULL,
  "ev_etc_compute_type"  nvarchar(20) NULL,
  "resp_team_id"  integer NULL,
  "iteration_id"  integer NULL,
  "guid"  nvarchar(22) NULL,
  "tmpl_guid"  nvarchar(22) NULL,
  "original_qty"  numeric(17,6) NULL,
  "rqmt_rem_qty"  numeric(17,6) NULL,
  "intg_type"  nvarchar(100) NULL,
  "status_reviewer"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PROJWSRPT'

--METADATA NAME:PROJWSRPT TYPE:TABLE CHANGE:CREATE

CREATE TABLE PROJWSRPT(
  "rpt_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PRPFOLIO'

--METADATA NAME:PRPFOLIO TYPE:TABLE CHANGE:CREATE

CREATE TABLE PRPFOLIO(
  "pfolio_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table PUBUSER'

--METADATA NAME:PUBUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE PUBUSER(
  "public_group_id"  integer NOT NULL,
  "private_db_user_name"  nvarchar(255) NOT NULL,
  "private_db_passwd"  nvarchar(255) NULL
  )

go

print 'Creating table QUERYLIB'

--METADATA NAME:QUERYLIB TYPE:TABLE CHANGE:CREATE

CREATE TABLE QUERYLIB(
  "query_lib_id"  integer NOT NULL,
  "app_name"  nvarchar(25) NOT NULL,
  "core_flag"  nvarchar(1) NOT NULL,
  "match_sql"  nvarchar(4000) NOT NULL,
  "hints"  nvarchar(4000) NULL,
  "replacement_sql"  nvarchar(4000) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RCATTYPE'

--METADATA NAME:RCATTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE RCATTYPE(
  "rsrc_catg_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "rsrc_catg_short_len"  integer NOT NULL,
  "rsrc_catg_type"  nvarchar(40) NOT NULL,
  "super_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RCATVAL'

--METADATA NAME:RCATVAL TYPE:TABLE CHANGE:CREATE

CREATE TABLE RCATVAL(
  "rsrc_catg_id"  integer NOT NULL,
  "rsrc_catg_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "rsrc_catg_short_name"  nvarchar(32) NOT NULL,
  "rsrc_catg_name"  nvarchar(100) NULL,
  "parent_rsrc_catg_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table REFRDEL'

--METADATA NAME:REFRDEL TYPE:TABLE CHANGE:CREATE

CREATE TABLE REFRDEL(
  "delete_date"  datetime DEFAULT getDate() NOT NULL,
  "table_name"  nvarchar(30) NOT NULL,
  "pk1"  nvarchar(255) NOT NULL,
  "pk2"  nvarchar(255) NULL,
  "pk3"  nvarchar(255) NULL,
  "pk4"  nvarchar(255) NULL,
  "proj_id"  integer NULL
  )

go

print 'Creating table REITTYPE'

--METADATA NAME:REITTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE REITTYPE(
  "related_item_type_id"  integer NOT NULL,
  "related_item"  nvarchar(32) NOT NULL,
  "table_name"  nvarchar(30) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RELEASE'

--METADATA NAME:RELEASE TYPE:TABLE CHANGE:CREATE

CREATE TABLE RELEASE(
  "release_id"  integer NOT NULL,
  "rfolio_id"  integer NULL,
  "release_name"  nvarchar(60) NOT NULL,
  "start_date"  datetime NOT NULL,
  "proj_id"  integer NOT NULL,
  "release_theme"  nvarchar(255) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RELITEMS'

--METADATA NAME:RELITEMS TYPE:TABLE CHANGE:CREATE

CREATE TABLE RELITEMS(
  "item_type_id"  integer NOT NULL,
  "fk_id"  integer NOT NULL,
  "related_item_type_id"  integer NOT NULL,
  "related_fk_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RFOLIO'

--METADATA NAME:RFOLIO TYPE:TABLE CHANGE:CREATE

CREATE TABLE RFOLIO(
  "rfolio_id"  integer NOT NULL,
  "user_id"  integer NULL,
  "rfolio_name"  nvarchar(40) NOT NULL,
  "rfolio_type"  nvarchar(20) NOT NULL,
  "rfolio_descr"  nvarchar(255) NULL,
  "team_capacity_pct"  numeric(10,2) NULL,
  "parent_rfolio_id"  integer NULL,
  "rfolio_data"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RISKCTRL'

--METADATA NAME:RISKCTRL TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKCTRL(
  "risk_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "risk_control"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RISKTYPE'

--METADATA NAME:RISKTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE RISKTYPE(
  "risk_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "risk_type"  nvarchar(40) NOT NULL,
  "parent_risk_type_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RLFOLIO'

--METADATA NAME:RLFOLIO TYPE:TABLE CHANGE:CREATE

CREATE TABLE RLFOLIO(
  "rlfolio_id"  integer NOT NULL,
  "user_id"  integer NULL,
  "rlfolio_name"  nvarchar(40) NOT NULL,
  "rlfolio_type"  nvarchar(20) NOT NULL,
  "rlfolio_descr"  nvarchar(255) NULL,
  "rlfolio_data"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table ROLECATTYPE'

--METADATA NAME:ROLECATTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLECATTYPE(
  "role_catg_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "role_catg_short_len"  integer NOT NULL,
  "role_catg_type"  nvarchar(60) NOT NULL,
  "super_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table ROLECATVAL'

--METADATA NAME:ROLECATVAL TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLECATVAL(
  "role_catg_id"  integer NOT NULL,
  "role_catg_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "role_catg_short_name"  nvarchar(60) NOT NULL,
  "role_catg_name"  nvarchar(100) NULL,
  "parent_role_catg_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table ROLELIMIT'

--METADATA NAME:ROLELIMIT TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLELIMIT(
  "rolelimit_id"  integer NOT NULL,
  "role_id"  integer NOT NULL,
  "start_date"  datetime NOT NULL,
  "max_qty_per_hr"  numeric(16,8) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table ROLERATE'

--METADATA NAME:ROLERATE TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLERATE(
  "role_rate_id"  integer NOT NULL,
  "role_id"  integer NOT NULL,
  "start_date"  datetime DEFAULT getDate() NOT NULL,
  "max_qty_per_hr"  numeric(16,8) DEFAULT 1 NULL,
  "cost_per_qty"  numeric(21,8) NULL,
  "cost_per_qty2"  numeric(21,8) NULL,
  "cost_per_qty3"  numeric(21,8) NULL,
  "cost_per_qty4"  numeric(21,8) NULL,
  "cost_per_qty5"  numeric(21,8) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table ROLERCAT'

--METADATA NAME:ROLERCAT TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLERCAT(
  "role_id"  integer NOT NULL,
  "role_catg_type_id"  integer NOT NULL,
  "role_catg_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table ROLES'

--METADATA NAME:ROLES TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLES(
  "role_id"  integer NOT NULL,
  "role_short_name"  nvarchar(40) NOT NULL,
  "role_name"  nvarchar(100) NOT NULL,
  "seq_num"  integer NOT NULL,
  "parent_role_id"  integer NULL,
  "def_cost_qty_link_flag"  nvarchar(1) NOT NULL,
  "cost_qty_type"  nvarchar(24) DEFAULT 'QT_Hour' NOT NULL,
  "pobs_id"  integer NULL,
  "role_descr"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table ROLFOLIO'

--METADATA NAME:ROLFOLIO TYPE:TABLE CHANGE:CREATE

CREATE TABLE ROLFOLIO(
  "rlfolio_id"  integer NOT NULL,
  "role_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RPT'

--METADATA NAME:RPT TYPE:TABLE CHANGE:CREATE

CREATE TABLE RPT(
  "rpt_id"  integer NOT NULL,
  "global_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "rpt_type"  nvarchar(12) NOT NULL,
  "rpt_name"  nvarchar(80) NOT NULL,
  "rpt_area"  nvarchar(32) DEFAULT 'Unknown' NOT NULL,
  "rpt_group_id"  integer NULL,
  "proj_id"  integer NULL,
  "rpt_state"  nvarchar(10) NULL,
  "rpt_data"  TEXT NULL,
  "last_run_date"  datetime NULL,
  "user_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RPTBATCH'

--METADATA NAME:RPTBATCH TYPE:TABLE CHANGE:CREATE

CREATE TABLE RPTBATCH(
  "rpt_batch_id"  integer NOT NULL,
  "rpt_batch_name"  nvarchar(80) NOT NULL,
  "proj_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RPTGROUP'

--METADATA NAME:RPTGROUP TYPE:TABLE CHANGE:CREATE

CREATE TABLE RPTGROUP(
  "rpt_group_id"  integer NOT NULL,
  "rpt_group_seq_num"  integer NOT NULL,
  "rpt_group_name"  nvarchar(80) NOT NULL,
  "parent_group_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RPTLIST'

--METADATA NAME:RPTLIST TYPE:TABLE CHANGE:CREATE

CREATE TABLE RPTLIST(
  "rpt_batch_id"  integer NOT NULL,
  "rpt_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RSRC'

--METADATA NAME:RSRC TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRC(
  "rsrc_id"  integer NOT NULL,
  "clndr_id"  integer NOT NULL,
  "rsrc_seq_num"  integer NOT NULL,
  "timesheet_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "active_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "rsrc_type"  nvarchar(10) DEFAULT 'RT_Labor' NOT NULL,
  "auto_compute_act_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "ot_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "def_cost_qty_link_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "rsrc_short_name"  nvarchar(255) NOT NULL,
  "rsrc_name"  nvarchar(255) NOT NULL,
  "parent_rsrc_id"  integer NULL,
  "xfer_complete_day_cnt"  integer NULL,
  "xfer_notstart_day_cnt"  integer NULL,
  "ts_approve_user_id"  integer NULL,
  "user_id"  integer NULL,
  "role_id"  integer NULL,
  "curr_id"  integer DEFAULT 1 NOT NULL,
  "last_checksum"  integer NULL,
  "shift_id"  integer NULL,
  "ot_factor"  numeric(10,3) NULL,
  "def_qty_per_hr"  numeric(16,8) NULL,
  "guid"  nvarchar(22) NULL,
  "cost_qty_type"  nvarchar(24) NULL,
  "office_phone"  nvarchar(32) NULL,
  "other_phone"  nvarchar(32) NULL,
  "employee_code"  nvarchar(40) NULL,
  "rsrc_title_name"  nvarchar(100) NULL,
  "email_addr"  nvarchar(120) NULL,
  "unit_id"  integer NULL,
  "pobs_id"  integer NULL,
  "rsrc_notes"  TEXT NULL,
  "intg_type"  nvarchar(100) NULL,
  "update_date"  datetime NULL,
  "location_id"  integer NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RSRCANDASH'

--METADATA NAME:RSRCANDASH TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCANDASH(
  "dashboard_id"  integer NOT NULL,
  "rsrcan_view_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RSRCANVIEW'

--METADATA NAME:RSRCANVIEW TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCANVIEW(
  "rsrcan_view_id"  integer NOT NULL,
  "rsrcan_view_name"  nvarchar(255) NOT NULL,
  "user_id"  integer NULL,
  "rsrcan_view_type"  nvarchar(20) NULL,
  "rsrcan_view_data"  nvarchar(4000) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RSRCCURV'

--METADATA NAME:RSRCCURV TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCCURV(
  "curv_id"  integer NOT NULL,
  "curv_name"  nvarchar(60) NOT NULL,
  "default_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "curv_data"  TEXT NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RSRCHOUR'

--METADATA NAME:RSRCHOUR TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCHOUR(
  "rsrc_hr_id"  integer NOT NULL,
  "rsrc_id"  integer NOT NULL,
  "ts_id"  integer NOT NULL,
  "task_ts_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "taskrsrc_id"  integer NULL,
  "nonwork_type_id"  integer NULL,
  "proj_id"  integer NULL,
  "pend_hr_cnt"  numeric(10,2) NULL,
  "hr_cnt"  numeric(10,2) NULL,
  "pend_ot_hr_cnt"  numeric(10,2) NULL,
  "ot_hr_cnt"  numeric(10,2) NULL,
  "work_date"  datetime NULL,
  "status_code"  nvarchar(20) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RSRCPROP'

--METADATA NAME:RSRCPROP TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCPROP(
  "rsrc_id"  integer NOT NULL,
  "prop_name"  nvarchar(20) NOT NULL,
  "prop_value"  nvarchar(255) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RSRCRATE'

--METADATA NAME:RSRCRATE TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCRATE(
  "rsrc_rate_id"  integer NOT NULL,
  "rsrc_id"  integer NOT NULL,
  "start_date"  datetime NOT NULL,
  "shift_period_id"  integer NULL,
  "max_qty_per_hr"  numeric(16,8) NULL,
  "cost_per_qty"  numeric(21,8) NULL,
  "cost_per_qty2"  numeric(21,8) NULL,
  "cost_per_qty3"  numeric(21,8) NULL,
  "cost_per_qty4"  numeric(21,8) NULL,
  "cost_per_qty5"  numeric(21,8) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RSRCRCAT'

--METADATA NAME:RSRCRCAT TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCRCAT(
  "rsrc_id"  integer NOT NULL,
  "rsrc_catg_type_id"  integer NOT NULL,
  "rsrc_catg_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RSRCROLE'

--METADATA NAME:RSRCROLE TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCROLE(
  "rsrc_id"  integer NOT NULL,
  "role_id"  integer NOT NULL,
  "skill_level"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RSRCSEC'

--METADATA NAME:RSRCSEC TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRCSEC(
  "user_id"  integer NOT NULL,
  "rsrc_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table RSRFOLIO'

--METADATA NAME:RSRFOLIO TYPE:TABLE CHANGE:CREATE

CREATE TABLE RSRFOLIO(
  "rfolio_id"  integer NOT NULL,
  "rsrc_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table SCENARIO'

--METADATA NAME:SCENARIO TYPE:TABLE CHANGE:CREATE

CREATE TABLE SCENARIO(
  "scenario_id"  integer NOT NULL,
  "scenario_name"  nvarchar(255) NOT NULL,
  "user_id"  integer NULL,
  "table_name"  nvarchar(30) NULL,
  "fk_id"  integer NULL,
  "scenario_type"  nvarchar(30) NULL,
  "view_pref_id"  integer NULL,
  "view_type"  nvarchar(30) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table SCENPROJ'

--METADATA NAME:SCENPROJ TYPE:TABLE CHANGE:CREATE

CREATE TABLE SCENPROJ(
  "scenario_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "selected_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table SCENROLE'

--METADATA NAME:SCENROLE TYPE:TABLE CHANGE:CREATE

CREATE TABLE SCENROLE(
  "scenario_id"  integer NOT NULL,
  "role_id"  integer NOT NULL,
  "selected_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table SCENUSER'

--METADATA NAME:SCENUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE SCENUSER(
  "scenario_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table SETTINGS'

--METADATA NAME:SETTINGS TYPE:TABLE CHANGE:CREATE

CREATE TABLE SETTINGS(
  "namespace"  nvarchar(255) NOT NULL,
  "setting_name"  nvarchar(255) NOT NULL,
  "setting_value"  nvarchar(4000) NULL,
  "user_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table SHIFT'

--METADATA NAME:SHIFT TYPE:TABLE CHANGE:CREATE

CREATE TABLE SHIFT(
  "shift_id"  integer NOT NULL,
  "shift_name"  nvarchar(60) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table SHIFTPER'

--METADATA NAME:SHIFTPER TYPE:TABLE CHANGE:CREATE

CREATE TABLE SHIFTPER(
  "shift_period_id"  integer NOT NULL,
  "shift_id"  integer NOT NULL,
  "shift_start_hr_num"  numeric(10,3) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table SPIDMAP'

--METADATA NAME:SPIDMAP TYPE:TABLE CHANGE:CREATE

CREATE TABLE SPIDMAP(
  "spid"  integer NOT NULL,
  "user_id"  integer NULL,
  "user_name"  nvarchar(255) NULL,
  "app_name"  nvarchar(25) NULL,
  "refrdel_project_bypass"  integer NULL,
  "audit_info_extended"  TEXT NULL
  )

go

print 'Creating table SUMPROJCOST'

--METADATA NAME:SUMPROJCOST TYPE:TABLE CHANGE:CREATE

CREATE TABLE SUMPROJCOST(
  "proj_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "cost_type_id"  integer NOT NULL,
  "start_date"  datetime NULL,
  "end_date"  datetime NULL,
  "spread_type"  nvarchar(20) NULL,
  "act_cost"  numeric(23,6) NULL,
  "remain_cost"  numeric(23,6) NULL,
  "target_cost"  numeric(23,6) NULL,
  "total_cost"  numeric(23,6) NULL
  )

go

print 'Creating table SUMTASK'

--METADATA NAME:SUMTASK TYPE:TABLE CHANGE:CREATE

CREATE TABLE SUMTASK(
  "proj_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "bcwp"  numeric(25,6) NULL,
  "bcws"  numeric(25,6) NULL,
  "eac"  numeric(25,6) NULL,
  "eac_work_qty"  numeric(22,6) NULL,
  "etc"  numeric(25,6) NULL,
  "etc_work_qty"  numeric(22,6) NULL,
  "perfm_work_qty"  numeric(22,6) NULL,
  "sched_work_qty"  numeric(22,6) NULL,
  "complete_cnt"  integer NULL,
  "active_cnt"  integer NULL,
  "notstarted_cnt"  integer NULL,
  "base_complete_cnt"  integer NULL,
  "base_active_cnt"  integer NULL,
  "base_notstarted_cnt"  integer NULL,
  "act_drtn_hr_cnt"  numeric(17,6) NULL,
  "total_drtn_hr_cnt"  numeric(17,6) NULL,
  "base_drtn_hr_cnt"  numeric(17,6) NULL,
  "remain_drtn_hr_cnt"  numeric(17,6) NULL,
  "total_float_hr_cnt"  numeric(17,6) NULL,
  "act_end_date"  datetime NULL,
  "act_start_date"  datetime NULL,
  "base_end_date"  datetime NULL,
  "base_start_date"  datetime NULL,
  "reend_date"  datetime NULL,
  "restart_date"  datetime NULL,
  "act_this_per_work_cost"  numeric(25,6) NULL,
  "act_this_per_work_qty"  numeric(22,6) NULL,
  "act_this_per_equip_cost"  numeric(25,6) NULL,
  "act_this_per_equip_qty"  numeric(22,6) NULL,
  "act_this_per_mat_cost"  numeric(25,6) NULL,
  "act_cost"  numeric(25,6) NULL,
  "act_equip_cost"  numeric(25,6) NULL,
  "act_expense_cost"  numeric(25,6) NULL,
  "act_mat_cost"  numeric(25,6) NULL,
  "act_work_cost"  numeric(25,6) NULL,
  "act_equip_qty"  numeric(22,6) NULL,
  "act_work_qty"  numeric(22,6) NULL,
  "base_cost"  numeric(25,6) NULL,
  "base_equip_cost"  numeric(25,6) NULL,
  "base_expense_cost"  numeric(25,6) NULL,
  "base_mat_cost"  numeric(25,6) NULL,
  "base_work_cost"  numeric(25,6) NULL,
  "base_equip_qty"  numeric(22,6) NULL,
  "base_work_qty"  numeric(22,6) NULL,
  "remain_cost"  numeric(25,6) NULL,
  "remain_equip_cost"  numeric(25,6) NULL,
  "remain_expense_cost"  numeric(25,6) NULL,
  "remain_mat_cost"  numeric(25,6) NULL,
  "remain_work_cost"  numeric(25,6) NULL,
  "remain_equip_qty"  numeric(22,6) NULL,
  "remain_work_qty"  numeric(22,6) NULL,
  "target_cost"  numeric(25,6) NULL,
  "target_equip_cost"  numeric(25,6) NULL,
  "target_expense_cost"  numeric(25,6) NULL,
  "target_mat_cost"  numeric(25,6) NULL,
  "target_work_cost"  numeric(25,6) NULL,
  "target_equip_qty"  numeric(22,6) NULL,
  "target_work_qty"  numeric(22,6) NULL,
  "total_cost"  numeric(25,6) NULL,
  "total_equip_cost"  numeric(25,6) NULL,
  "total_expense_cost"  numeric(25,6) NULL,
  "total_mat_cost"  numeric(25,6) NULL,
  "total_work_cost"  numeric(25,6) NULL,
  "total_equip_qty"  numeric(22,6) NULL,
  "total_work_qty"  numeric(22,6) NULL,
  "target_start_date"  datetime NULL,
  "target_end_date"  datetime NULL,
  "target_drtn_hr_cnt"  numeric(17,6) NULL
  )

go

print 'Creating table SUMTASKSPREAD'

--METADATA NAME:SUMTASKSPREAD TYPE:TABLE CHANGE:CREATE

CREATE TABLE SUMTASKSPREAD(
  "proj_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "start_date"  datetime NOT NULL,
  "end_date"  datetime NOT NULL,
  "spread_type"  nvarchar(20) NOT NULL,
  "act_cost"  numeric(25,6) NULL,
  "act_equip_cost"  numeric(25,6) NULL,
  "act_expense_cost"  numeric(25,6) NULL,
  "act_mat_cost"  numeric(25,6) NULL,
  "act_work_cost"  numeric(25,6) NULL,
  "act_equip_qty"  numeric(22,6) NULL,
  "act_work_qty"  numeric(22,6) NULL,
  "base_cost"  numeric(25,6) NULL,
  "base_equip_cost"  numeric(25,6) NULL,
  "base_expense_cost"  numeric(25,6) NULL,
  "base_mat_cost"  numeric(25,6) NULL,
  "base_work_cost"  numeric(25,6) NULL,
  "base_equip_qty"  numeric(22,6) NULL,
  "base_work_qty"  numeric(22,6) NULL,
  "late_remain_cost"  numeric(25,6) NULL,
  "late_remain_equip_cost"  numeric(25,6) NULL,
  "late_remain_expense_cost"  numeric(25,6) NULL,
  "late_remain_mat_cost"  numeric(25,6) NULL,
  "late_remain_work_cost"  numeric(25,6) NULL,
  "late_remain_equip_qty"  numeric(22,6) NULL,
  "late_remain_work_qty"  numeric(22,6) NULL,
  "remain_cost"  numeric(25,6) NULL,
  "remain_equip_cost"  numeric(25,6) NULL,
  "remain_expense_cost"  numeric(25,6) NULL,
  "remain_mat_cost"  numeric(25,6) NULL,
  "remain_work_cost"  numeric(25,6) NULL,
  "remain_equip_qty"  numeric(22,6) NULL,
  "remain_work_qty"  numeric(22,6) NULL,
  "target_cost"  numeric(25,6) NULL,
  "target_equip_cost"  numeric(25,6) NULL,
  "target_expense_cost"  numeric(25,6) NULL,
  "target_mat_cost"  numeric(25,6) NULL,
  "target_work_cost"  numeric(25,6) NULL,
  "target_equip_qty"  numeric(22,6) NULL,
  "target_work_qty"  numeric(22,6) NULL,
  "total_cost"  numeric(25,6) NULL,
  "total_equip_cost"  numeric(25,6) NULL,
  "total_expense_cost"  numeric(25,6) NULL,
  "total_mat_cost"  numeric(25,6) NULL,
  "total_work_cost"  numeric(25,6) NULL,
  "total_equip_qty"  numeric(22,6) NULL,
  "total_work_qty"  numeric(22,6) NULL,
  "bcwp"  numeric(25,6) NULL,
  "bcws"  numeric(25,6) NULL,
  "eac"  numeric(25,6) NULL,
  "eac_work_qty"  numeric(22,6) NULL,
  "etc"  numeric(25,6) NULL,
  "etc_work_qty"  numeric(22,6) NULL,
  "perfm_work_qty"  numeric(22,6) NULL,
  "sched_work_qty"  numeric(22,6) NULL,
  "fin_period_act_work_qty"  numeric(22,6) NULL,
  "fin_period_act_work_cost"  numeric(25,6) NULL,
  "fin_period_act_equip_qty"  numeric(22,6) NULL,
  "fin_period_act_equip_cost"  numeric(25,6) NULL,
  "fin_period_act_mat_cost"  numeric(25,6) NULL,
  "fin_period_act_expense_cost"  numeric(25,6) NULL,
  "fin_period_total_work_qty"  numeric(22,6) NULL,
  "fin_period_total_work_cost"  numeric(25,6) NULL,
  "fin_period_total_equip_qty"  numeric(22,6) NULL,
  "fin_period_total_equip_cost"  numeric(25,6) NULL,
  "fin_period_total_mat_cost"  numeric(25,6) NULL,
  "fin_period_total_expense_cost"  numeric(25,6) NULL,
  "fin_period_total_cost"  numeric(25,6) NULL,
  "fin_period_act_cost"  numeric(25,6) NULL,
  "fin_period_bcwp"  numeric(25,6) NULL,
  "fin_period_perfm_work_qty"  numeric(22,6) NULL,
  "fin_period_eac"  numeric(25,6) NULL,
  "fin_period_eac_work_qty"  numeric(22,6) NULL,
  "fin_period_bcws"  numeric(25,6) NULL,
  "fin_period_sched_work_qty"  numeric(22,6) NULL
  )

go

print 'Creating table SUMTRSRC'

--METADATA NAME:SUMTRSRC TYPE:TABLE CHANGE:CREATE

CREATE TABLE SUMTRSRC(
  "sumtrsrc_id"  integer NOT NULL,
  "proj_id"  integer NULL,
  "wbs_id"  integer NULL,
  "start_date"  datetime NULL,
  "end_date"  datetime NULL,
  "spread_type"  nvarchar(20) NULL,
  "rsrc_id"  integer NULL,
  "role_id"  integer NULL,
  "act_start_date"  datetime NULL,
  "act_end_date"  datetime NULL,
  "remain_start_date"  datetime NULL,
  "remain_end_date"  datetime NULL,
  "overalloc_date"  datetime NULL,
  "staffed_act_qty"  numeric(23,6) NULL,
  "unstaffed_act_qty"  numeric(23,6) NULL,
  "staffed_act_cost"  numeric(23,6) NULL,
  "unstaffed_act_cost"  numeric(23,6) NULL,
  "staffed_act_ot_qty"  numeric(23,6) NULL,
  "unstaffed_act_ot_qty"  numeric(23,6) NULL,
  "staffed_act_ot_cost"  numeric(23,6) NULL,
  "unstaffed_act_ot_cost"  numeric(23,6) NULL,
  "staffed_act_reg_cost"  numeric(23,6) NULL,
  "unstaffed_act_reg_cost"  numeric(23,6) NULL,
  "staffed_act_reg_qty"  numeric(23,6) NULL,
  "unstaffed_act_reg_qty"  numeric(23,6) NULL,
  "staffed_late_remain_qty"  numeric(23,6) NULL,
  "unstaffed_late_remain_qty"  numeric(23,6) NULL,
  "staffed_late_remain_cost"  numeric(23,6) NULL,
  "unstaffed_late_remain_cost"  numeric(23,6) NULL,
  "staffed_remain_qty"  numeric(23,6) NULL,
  "unstaffed_remain_qty"  numeric(23,6) NULL,
  "staffed_remain_cost"  numeric(23,6) NULL,
  "unstaffed_remain_cost"  numeric(23,6) NULL,
  "staffed_target_qty"  numeric(23,6) NULL,
  "unstaffed_target_qty"  numeric(23,6) NULL,
  "staffed_target_cost"  numeric(23,6) NULL,
  "unstaffed_target_cost"  numeric(23,6) NULL,
  "staffed_total_qty"  numeric(23,6) NULL,
  "unstaffed_total_qty"  numeric(23,6) NULL,
  "staffed_total_cost"  numeric(23,6) NULL,
  "unstaffed_total_cost"  numeric(23,6) NULL,
  "fin_period_act_qty"  numeric(23,6) NULL,
  "fin_period_act_cost"  numeric(23,6) NULL,
  "fin_period_total_qty"  numeric(23,6) NULL,
  "fin_period_total_cost"  numeric(23,6) NULL
  )

go

print 'Creating table TASK'

--METADATA NAME:TASK TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASK(
  "task_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "clndr_id"  integer NOT NULL,
  "est_wt"  numeric(10,2) NULL,
  "phys_complete_pct"  numeric(10,2) DEFAULT 0 NOT NULL,
  "rev_fdbk_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "lock_plan_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "auto_compute_act_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "complete_pct_type"  nvarchar(10) DEFAULT 'CP_Drtn' NOT NULL,
  "task_type"  nvarchar(10) NOT NULL,
  "duration_type"  nvarchar(12) NOT NULL,
  "review_type"  nvarchar(12) DEFAULT 'RV_OK' NOT NULL,
  "status_code"  nvarchar(12) NOT NULL,
  "task_code"  nvarchar(40) NOT NULL,
  "task_name"  nvarchar(120) NOT NULL,
  "rsrc_id"  integer NULL,
  "total_float_hr_cnt"  numeric(17,6) NULL,
  "free_float_hr_cnt"  numeric(17,6) NULL,
  "remain_drtn_hr_cnt"  numeric(17,6) NULL,
  "act_work_qty"  numeric(17,6) NULL,
  "remain_work_qty"  numeric(17,6) NULL,
  "target_work_qty"  numeric(17,6) NULL,
  "target_drtn_hr_cnt"  numeric(17,6) NULL,
  "target_equip_qty"  numeric(17,6) NULL,
  "act_equip_qty"  numeric(17,6) NULL,
  "remain_equip_qty"  numeric(17,6) NULL,
  "cstr_date"  datetime NULL,
  "act_start_date"  datetime NULL,
  "act_end_date"  datetime NULL,
  "late_start_date"  datetime NULL,
  "late_end_date"  datetime NULL,
  "expect_end_date"  datetime NULL,
  "early_start_date"  datetime NULL,
  "early_end_date"  datetime NULL,
  "restart_date"  datetime NULL,
  "reend_date"  datetime NULL,
  "target_start_date"  datetime NULL,
  "target_end_date"  datetime NULL,
  "review_end_date"  datetime NULL,
  "rem_late_start_date"  datetime NULL,
  "rem_late_end_date"  datetime NULL,
  "cstr_type"  nvarchar(12) NULL,
  "priority_type"  nvarchar(12) NULL,
  "guid"  nvarchar(22) NULL,
  "tmpl_guid"  nvarchar(22) NULL,
  "cstr_date2"  datetime NULL,
  "cstr_type2"  nvarchar(12) NULL,
  "float_path"  integer NULL,
  "float_path_order"  integer NULL,
  "act_this_per_work_qty"  numeric(17,6) NULL,
  "act_this_per_equip_qty"  numeric(17,6) NULL,
  "driving_path_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "suspend_date"  datetime NULL,
  "resume_date"  datetime NULL,
  "external_early_start_date"  datetime NULL,
  "external_late_end_date"  datetime NULL,
  "location_id"  integer NULL,
  "control_updates_flag"  nvarchar(1) DEFAULT 'N' NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TASKACTV'

--METADATA NAME:TASKACTV TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKACTV(
  "task_id"  integer NOT NULL,
  "actv_code_type_id"  integer NOT NULL,
  "actv_code_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TASKDOC'

--METADATA NAME:TASKDOC TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKDOC(
  "taskdoc_id"  integer NOT NULL,
  "doc_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "wp_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "task_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TASKFDBK'

--METADATA NAME:TASKFDBK TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKFDBK(
  "task_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "task_fdbk"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TASKFIN'

--METADATA NAME:TASKFIN TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKFIN(
  "fin_dates_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "act_work_qty"  numeric(17,6) NULL,
  "act_work_cost"  numeric(23,6) NULL,
  "act_equip_qty"  numeric(17,6) NULL,
  "act_equip_cost"  numeric(23,6) NULL,
  "act_mat_cost"  numeric(23,6) NULL,
  "act_expense_cost"  numeric(23,6) NULL,
  "bcwp"  numeric(23,6) NULL,
  "sched_work_qty"  numeric(17,6) NULL,
  "bcws"  numeric(23,6) NULL,
  "perfm_work_qty"  numeric(17,6) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TASKMEMO'

--METADATA NAME:TASKMEMO TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKMEMO(
  "memo_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "memo_type_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "task_memo"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TASKNOTE'

--METADATA NAME:TASKNOTE TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKNOTE(
  "task_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "task_notes"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TASKPRED'

--METADATA NAME:TASKPRED TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKPRED(
  "task_pred_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "pred_task_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "pred_proj_id"  integer NOT NULL,
  "pred_type"  nvarchar(12) NOT NULL,
  "lag_hr_cnt"  numeric(17,6) NULL,
  "comments"  nvarchar(250) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TASKPROC'

--METADATA NAME:TASKPROC TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKPROC(
  "proc_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "complete_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "proc_name"  nvarchar(120) NOT NULL,
  "proc_wt"  numeric(10,2) NULL,
  "complete_pct"  numeric(10,2) NULL,
  "proc_descr"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TASKRISK'

--METADATA NAME:TASKRISK TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKRISK(
  "task_id"  integer NOT NULL,
  "risk_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TASKRSRC'

--METADATA NAME:TASKRSRC TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKRSRC(
  "taskrsrc_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "rsrc_type"  nvarchar(10) DEFAULT 'RT_Labor' NOT NULL,
  "cost_qty_link_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "role_id"  integer NULL,
  "acct_id"  integer NULL,
  "rsrc_id"  integer NULL,
  "pobs_id"  integer NULL,
  "skill_level"  integer NULL,
  "pend_complete_pct"  numeric(10,2) NULL,
  "remain_qty"  numeric(17,6) NULL,
  "pend_remain_qty"  numeric(17,6) NULL,
  "target_qty"  numeric(17,6) NULL,
  "remain_qty_per_hr"  numeric(16,8) NULL,
  "pend_act_reg_qty"  numeric(17,6) NULL,
  "target_lag_drtn_hr_cnt"  numeric(17,6) NULL,
  "target_qty_per_hr"  numeric(16,8) NULL,
  "act_ot_qty"  numeric(17,6) NULL,
  "pend_act_ot_qty"  numeric(17,6) NULL,
  "act_reg_qty"  numeric(17,6) NULL,
  "relag_drtn_hr_cnt"  numeric(17,6) NULL,
  "ot_factor"  numeric(10,3) NULL,
  "cost_per_qty"  numeric(21,8) NULL,
  "target_cost"  numeric(23,6) NULL,
  "act_reg_cost"  numeric(23,6) NULL,
  "act_ot_cost"  numeric(23,6) NULL,
  "remain_cost"  numeric(23,6) NULL,
  "act_start_date"  datetime NULL,
  "act_end_date"  datetime NULL,
  "restart_date"  datetime NULL,
  "reend_date"  datetime NULL,
  "target_start_date"  datetime NULL,
  "target_end_date"  datetime NULL,
  "rem_late_start_date"  datetime NULL,
  "rem_late_end_date"  datetime NULL,
  "guid"  nvarchar(22) NULL,
  "rate_type"  nvarchar(14) DEFAULT 'COST_PER_QTY' NULL,
  "act_this_per_cost"  numeric(23,6) NULL,
  "act_this_per_qty"  numeric(17,6) NULL,
  "curv_id"  integer NULL,
  "rollup_dates_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "cost_per_qty_source_type"  nvarchar(24) DEFAULT 'ST_Rsrc' NOT NULL,
  "remain_crv"  nvarchar(4000) NULL,
  "target_crv"  nvarchar(4000) NULL,
  "actual_crv"  nvarchar(4000) NULL,
  "rsrc_request_data"  TEXT NULL,
  "ts_pend_act_end_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "prior_ts_act_reg_qty"  numeric(17,6) NULL,
  "prior_ts_act_ot_qty"  numeric(17,6) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TASKSUM'

--METADATA NAME:TASKSUM TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKSUM(
  "task_sum_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "complete_cnt"  integer NULL,
  "active_cnt"  integer NULL,
  "notstarted_cnt"  integer NULL,
  "base_complete_cnt"  integer NULL,
  "base_active_cnt"  integer NULL,
  "base_notstarted_cnt"  integer NULL,
  "act_drtn_hr_cnt"  numeric(17,6) NULL,
  "act_equip_qty"  numeric(22,6) NULL,
  "act_work_qty"  numeric(22,6) NULL,
  "total_drtn_hr_cnt"  numeric(17,6) NULL,
  "base_drtn_hr_cnt"  numeric(17,6) NULL,
  "base_work_qty"  numeric(22,6) NULL,
  "base_equip_qty"  numeric(22,6) NULL,
  "etc_work_qty"  numeric(22,6) NULL,
  "remain_drtn_hr_cnt"  numeric(17,6) NULL,
  "remain_work_qty"  numeric(22,6) NULL,
  "remain_equip_qty"  numeric(22,6) NULL,
  "total_float_hr_cnt"  numeric(17,6) NULL,
  "act_expense_cost"  numeric(25,6) NULL,
  "act_work_cost"  numeric(25,6) NULL,
  "act_equip_cost"  numeric(25,6) NULL,
  "base_expense_cost"  numeric(25,6) NULL,
  "base_work_cost"  numeric(25,6) NULL,
  "base_equip_cost"  numeric(25,6) NULL,
  "bcwp"  numeric(25,6) NULL,
  "etc"  numeric(25,6) NULL,
  "bcws"  numeric(25,6) NULL,
  "remain_expense_cost"  numeric(25,6) NULL,
  "remain_work_cost"  numeric(25,6) NULL,
  "remain_equip_cost"  numeric(25,6) NULL,
  "perfm_work_qty"  numeric(22,6) NULL,
  "sched_work_qty"  numeric(22,6) NULL,
  "act_end_date"  datetime NULL,
  "act_start_date"  datetime NULL,
  "base_end_date"  datetime NULL,
  "base_start_date"  datetime NULL,
  "reend_date"  datetime NULL,
  "restart_date"  datetime NULL,
  "act_this_per_work_cost"  numeric(25,6) NULL,
  "act_this_per_work_qty"  numeric(22,6) NULL,
  "act_this_per_equip_cost"  numeric(25,6) NULL,
  "act_this_per_equip_qty"  numeric(22,6) NULL,
  "base_mat_cost"  numeric(25,6) NULL,
  "remain_mat_cost"  numeric(25,6) NULL,
  "act_mat_cost"  numeric(25,6) NULL,
  "act_this_per_mat_cost"  numeric(25,6) NULL,
  "spread_data"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TASKSUMFIN'

--METADATA NAME:TASKSUMFIN TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKSUMFIN(
  "task_sum_fin_id"  integer NOT NULL,
  "fin_dates_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "task_sum_id"  integer NOT NULL,
  "act_work_qty"  numeric(22,6) NULL,
  "act_work_cost"  numeric(25,6) NULL,
  "act_equip_qty"  numeric(22,6) NULL,
  "act_equip_cost"  numeric(25,6) NULL,
  "act_mat_cost"  numeric(25,6) NULL,
  "act_expense_cost"  numeric(25,6) NULL,
  "total_work_qty"  numeric(22,6) NULL,
  "total_work_cost"  numeric(25,6) NULL,
  "total_equip_qty"  numeric(22,6) NULL,
  "total_equip_cost"  numeric(25,6) NULL,
  "total_mat_cost"  numeric(25,6) NULL,
  "total_expense_cost"  numeric(25,6) NULL,
  "total_cost"  numeric(23,6) NULL,
  "act_cost"  numeric(23,6) NULL,
  "bcwp"  numeric(25,6) NULL,
  "perfm_work_qty"  numeric(22,6) NULL,
  "etc"  numeric(25,6) NULL,
  "etc_work_qty"  numeric(22,6) NULL,
  "eac"  numeric(25,6) NULL,
  "eac_work"  numeric(22,6) NULL,
  "bcws"  numeric(25,6) NULL,
  "acwp"  numeric(25,6) NULL,
  "sched_work_qty"  numeric(22,6) NULL,
  "base_cost"  numeric(23,6) NULL,
  "base_work_qty"  numeric(22,6) NULL,
  "base_work_cost"  numeric(25,6) NULL,
  "base_mat_cost"  numeric(25,6) NULL,
  "base_equip_cost"  numeric(25,6) NULL,
  "base_equip_qty"  numeric(22,6) NULL,
  "base_expense_cost"  numeric(25,6) NULL,
  "remain_cost"  numeric(23,6) NULL,
  "remain_work_qty"  numeric(22,6) NULL,
  "remain_work_cost"  numeric(25,6) NULL,
  "remain_mat_cost"  numeric(25,6) NULL,
  "remain_equip_cost"  numeric(25,6) NULL,
  "remain_equip_qty"  numeric(22,6) NULL,
  "remain_expense_cost"  numeric(25,6) NULL,
  "target_cost"  numeric(23,6) NULL,
  "target_equip_cost"  numeric(25,6) NULL,
  "target_equip_qty"  numeric(22,6) NULL,
  "target_expense_cost"  numeric(25,6) NULL,
  "target_mat_cost"  numeric(25,6) NULL,
  "target_work_cost"  numeric(25,6) NULL,
  "target_work_qty"  numeric(22,6) NULL,
  "late_remain_work_qty"  numeric(22,6) NULL,
  "late_remain_work_cost"  numeric(25,6) NULL,
  "late_remain_equip_cost"  numeric(25,6) NULL,
  "late_remain_equip_qty"  numeric(22,6) NULL,
  "late_remain_cost"  numeric(23,6) NULL,
  "late_remain_mat_cost"  numeric(25,6) NULL,
  "late_remain_expense_cost"  numeric(25,6) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TASKUSER'

--METADATA NAME:TASKUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKUSER(
  "task_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "proj_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TASKWKSP'

--METADATA NAME:TASKWKSP TYPE:TABLE CHANGE:CREATE

CREATE TABLE TASKWKSP(
  "workspace_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "cr_external_key"  nvarchar(4000) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TEMPKEYS'

--METADATA NAME:TEMPKEYS TYPE:TABLE CHANGE:CREATE

CREATE TABLE TEMPKEYS(
  "pk1"  integer NULL,
  "pk2"  integer NULL
  )

go

print 'Creating table THRSPARM'

--METADATA NAME:THRSPARM TYPE:TABLE CHANGE:CREATE

CREATE TABLE THRSPARM(
  "thresh_parm_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "wbs_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "task_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "rsrc_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "thresh_parm_type"  nvarchar(12) NOT NULL,
  "thresh_parm_name"  nvarchar(80) NOT NULL,
  "thresh_field_name"  nvarchar(40) NULL,
  "thresh_short_name"  nvarchar(80) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TIMESHT'

--METADATA NAME:TIMESHT TYPE:TABLE CHANGE:CREATE

CREATE TABLE TIMESHT(
  "ts_id"  integer NOT NULL,
  "rsrc_id"  integer NOT NULL,
  "daily_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "status_code"  nvarchar(20) NOT NULL,
  "user_id"  integer NULL,
  "last_recv_date"  datetime NULL,
  "status_date"  datetime NULL,
  "ts_notes"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TMPLCATG'

--METADATA NAME:TMPLCATG TYPE:TABLE CHANGE:CREATE

CREATE TABLE TMPLCATG(
  "tmplcatg_catg_id"  integer NOT NULL,
  "catg_name"  nvarchar(255) NOT NULL,
  "project_flag"  nvarchar(1) NOT NULL,
  "process_flag"  nvarchar(1) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TPROJMAP'

--METADATA NAME:TPROJMAP TYPE:TABLE CHANGE:CREATE

CREATE TABLE TPROJMAP(
  "session_id"  integer NOT NULL,
  "context_id"  integer NOT NULL,
  "source_proj_id"  integer NOT NULL,
  "target_proj_id"  integer NOT NULL,
  "target_wbs_id"  integer NOT NULL
  )

go

print 'Creating table TRAKVIEW'

--METADATA NAME:TRAKVIEW TYPE:TABLE CHANGE:CREATE

CREATE TABLE TRAKVIEW(
  "track_view_id"  integer NOT NULL,
  "display_type"  nvarchar(12) NOT NULL,
  "track_view_name"  nvarchar(80) NOT NULL,
  "web_view_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "user_id"  integer NULL,
  "track_view_data"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TRSRCFIN'

--METADATA NAME:TRSRCFIN TYPE:TABLE CHANGE:CREATE

CREATE TABLE TRSRCFIN(
  "fin_dates_id"  integer NOT NULL,
  "taskrsrc_id"  integer NOT NULL,
  "task_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "act_qty"  numeric(17,6) NULL,
  "act_cost"  numeric(23,6) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TRSRCSUM'

--METADATA NAME:TRSRCSUM TYPE:TABLE CHANGE:CREATE

CREATE TABLE TRSRCSUM(
  "taskrsrc_sum_id"  integer NOT NULL,
  "proj_id"  integer NULL,
  "rsrc_id"  integer NULL,
  "role_id"  integer NULL,
  "skill_level"  integer NULL,
  "overalloc_date"  datetime NULL,
  "spread_data"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TRSRCSUMFN'

--METADATA NAME:TRSRCSUMFN TYPE:TABLE CHANGE:CREATE

CREATE TABLE TRSRCSUMFN(
  "trsrc_sum_fin_id"  integer NOT NULL,
  "fin_dates_id"  integer NOT NULL,
  "proj_id"  integer NULL,
  "rsrc_id"  integer NULL,
  "role_id"  integer NULL,
  "taskrsrc_sum_id"  integer NOT NULL,
  "act_qty"  numeric(17,6) NULL,
  "act_cost"  numeric(23,6) NULL,
  "act_ot_qty"  numeric(17,6) NULL,
  "act_reg_qty"  numeric(17,6) NULL,
  "act_ot_cost"  numeric(23,6) NULL,
  "act_reg_cost"  numeric(23,6) NULL,
  "total_qty"  numeric(22,6) NULL,
  "total_cost"  numeric(23,6) NULL,
  "remain_qty"  numeric(17,6) NULL,
  "remain_cost"  numeric(23,6) NULL,
  "target_qty"  numeric(19,6) NULL,
  "target_cost"  numeric(23,6) NULL,
  "staffed_remain_qty"  numeric(17,6) NULL,
  "unstaffed_remain_qty"  numeric(17,6) NULL,
  "staffed_remain_cost"  numeric(25,6) NULL,
  "unstaffed_remain_cost"  numeric(25,6) NULL,
  "staffed_late_remain_qty"  numeric(17,6) NULL,
  "unstaffed_late_remain_qty"  numeric(17,6) NULL,
  "staffed_late_remain_cost"  numeric(25,6) NULL,
  "unstaffed_late_remain_cost"  numeric(25,6) NULL,
  "late_remain_qty"  numeric(17,6) NULL,
  "late_remain_cost"  numeric(25,6) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TSAUDIT'

--METADATA NAME:TSAUDIT TYPE:TABLE CHANGE:CREATE

CREATE TABLE TSAUDIT(
  "ts_audit_id"  integer NOT NULL,
  "audit_date"  datetime NULL,
  "rsrc_id"  integer NULL,
  "rsrc_short_name"  nvarchar(255) NULL,
  "rsrc_name"  nvarchar(255) NULL,
  "ts_status_code"  nvarchar(20) NULL,
  "reg_hrs"  numeric(17,6) NULL,
  "reg_ot_hrs"  numeric(17,6) NULL,
  "pend_reg_hrs"  numeric(17,6) NULL,
  "pend_reg_ot_hrs"  numeric(17,6) NULL,
  "oh_hrs"  numeric(17,6) NULL,
  "oh_ot_hrs"  numeric(17,6) NULL,
  "pend_oh_hrs"  numeric(17,6) NULL,
  "pend_oh_ot_hrs"  numeric(17,6) NULL,
  "ts_id"  integer NULL,
  "ts_start_date"  datetime NULL,
  "ts_end_date"  datetime NULL,
  "proj_id"  integer NULL,
  "proj_short_name"  nvarchar(40) NULL,
  "ts_task_status"  nvarchar(20) NULL,
  "user_id"  integer NULL,
  "user_name"  nvarchar(255) NULL,
  "approving_as"  nvarchar(50) NULL
  )

go

print 'Creating table TSDATES'

--METADATA NAME:TSDATES TYPE:TABLE CHANGE:CREATE

CREATE TABLE TSDATES(
  "ts_id"  integer NOT NULL,
  "start_date"  datetime NOT NULL,
  "end_date"  datetime NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table TSDELEGATE'

--METADATA NAME:TSDELEGATE TYPE:TABLE CHANGE:CREATE

CREATE TABLE TSDELEGATE(
  "ts_delegate_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "ts_delegate_user_id"  integer NOT NULL,
  "proj_id"  integer NULL,
  "active_flag"  nvarchar(1) DEFAULT 'N' NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table UACCESS'

--METADATA NAME:UACCESS TYPE:TABLE CHANGE:CREATE

CREATE TABLE UACCESS(
  "user_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "access_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "wbs_id"  integer NULL,
  "parent_wbs_id"  integer NULL
  )

go

print 'Creating table UDFCODE'

--METADATA NAME:UDFCODE TYPE:TABLE CHANGE:CREATE

CREATE TABLE UDFCODE(
  "udf_code_id"  integer NOT NULL,
  "udf_type_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "short_name"  nvarchar(60) NOT NULL,
  "udf_code_name"  nvarchar(120) NOT NULL,
  "parent_udf_code_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table UDFTYPE'

--METADATA NAME:UDFTYPE TYPE:TABLE CHANGE:CREATE

CREATE TABLE UDFTYPE(
  "udf_type_id"  integer NOT NULL,
  "table_name"  nvarchar(30) NOT NULL,
  "udf_type_name"  nvarchar(32) NOT NULL,
  "udf_type_label"  nvarchar(40) NOT NULL,
  "logical_data_type"  nvarchar(20) NOT NULL,
  "super_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "udf_code_short_len"  integer NULL,
  "formula"  nvarchar(4000) NULL,
  "indicator_expression"  nvarchar(4000) NULL,
  "disp_data_flag"  nvarchar(1) DEFAULT 'Y' NULL,
  "disp_indicator_flag"  nvarchar(1) DEFAULT 'Y' NULL,
  "summary_indicator_expression"  nvarchar(4000) NULL,
  "summary_method"  nvarchar(20) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table UDFVALUE'

--METADATA NAME:UDFVALUE TYPE:TABLE CHANGE:CREATE

CREATE TABLE UDFVALUE(
  "udf_type_id"  integer NOT NULL,
  "fk_id"  integer NOT NULL,
  "proj_id"  integer NULL,
  "udf_date"  datetime NULL,
  "udf_text"  nvarchar(255) NULL,
  "udf_number"  DECIMAL(28,10) NULL,
  "udf_code_id"  integer NULL,
  "table_name"  nvarchar(30) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table UEVNTREG'

--METADATA NAME:UEVNTREG TYPE:TABLE CHANGE:CREATE

CREATE TABLE UEVNTREG(
  "user_id"  integer NOT NULL,
  "app_name"  nvarchar(255) NOT NULL,
  "operation_name"  nvarchar(255) NOT NULL,
  "action_name"  nvarchar(255) NOT NULL,
  "action_level"  integer NULL,
  "user_name"  nvarchar(255) NULL,
  "event_reg_data"  nvarchar(4000) NULL
  )

go

print 'Creating table UMEASURE'

--METADATA NAME:UMEASURE TYPE:TABLE CHANGE:CREATE

CREATE TABLE UMEASURE(
  "unit_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "unit_name"  nvarchar(100) NOT NULL,
  "unit_abbrev"  nvarchar(16) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table UPKLIST'

--METADATA NAME:UPKLIST TYPE:TABLE CHANGE:CREATE

CREATE TABLE UPKLIST(
  "session_id"  integer NOT NULL,
  "context_id"  integer NULL,
  "pk_id"  integer NOT NULL,
  "pk2_id"  integer NULL
  )

go

print 'Creating table USERCOL'

--METADATA NAME:USERCOL TYPE:TABLE CHANGE:CREATE

CREATE TABLE USERCOL(
  "user_col_id"  integer NOT NULL,
  "table_name"  nvarchar(16) NOT NULL,
  "logical_data_type"  nvarchar(20) NOT NULL,
  "user_col_name"  nvarchar(32) NOT NULL,
  "user_col_label"  nvarchar(40) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table USERDATA'

--METADATA NAME:USERDATA TYPE:TABLE CHANGE:CREATE

CREATE TABLE USERDATA(
  "user_data_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "topic_name"  nvarchar(20) NOT NULL,
  "user_data"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table USERENG'

--METADATA NAME:USERENG TYPE:TABLE CHANGE:CREATE

CREATE TABLE USERENG(
  "user_eng_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "db_engine_type"  nvarchar(20) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table USEROBS'

--METADATA NAME:USEROBS TYPE:TABLE CHANGE:CREATE

CREATE TABLE USEROBS(
  "user_id"  integer NOT NULL,
  "obs_id"  integer NOT NULL,
  "prof_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table USEROPEN'

--METADATA NAME:USEROPEN TYPE:TABLE CHANGE:CREATE

CREATE TABLE USEROPEN(
  "user_open_id"  integer NOT NULL,
  "user_open_name"  nvarchar(255) NOT NULL,
  "user_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table USERS'

--METADATA NAME:USERS TYPE:TABLE CHANGE:CREATE

CREATE TABLE USERS(
  "user_id"  integer NOT NULL,
  "global_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "email_type"  nvarchar(16) DEFAULT 'ET_Internet' NOT NULL,
  "user_name"  nvarchar(255) NOT NULL,
  "prof_id"  integer NULL,
  "curr_id"  integer DEFAULT 1 NOT NULL,
  "all_rsrc_access_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "report_user_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "guid"  nvarchar(22) NULL,
  "email_srv_user_name"  nvarchar(32) NULL,
  "office_phone"  nvarchar(32) NULL,
  "actual_name"  nvarchar(255) NULL,
  "email_send_server"  nvarchar(120) NULL,
  "email_addr"  nvarchar(120) NULL,
  "email_srv_passwd"  nvarchar(255) NULL,
  "passwd"  nvarchar(255) NULL,
  "notify_prefs"  nvarchar(255) NULL,
  "navi_view_id"  integer NULL,
  "override_naviview_flag"  nvarchar(1) NULL,
  "ui_view_pref_id"  integer NULL,
  "cr_external_key"  nvarchar(4000) NULL,
  "cr_user_name"  nvarchar(255) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL,
  "failed_login_attempts_cnt"  integer DEFAULT 0 NULL
  )

go

print 'Creating table USERSET'

--METADATA NAME:USERSET TYPE:TABLE CHANGE:CREATE

CREATE TABLE USERSET(
  "namespace"  nvarchar(255) NOT NULL,
  "setting_name"  nvarchar(255) NOT NULL,
  "setting_value"  nvarchar(4000) NULL,
  "user_id"  integer NOT NULL,
  "userset_blob"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table USERWKSP'

--METADATA NAME:USERWKSP TYPE:TABLE CHANGE:CREATE

CREATE TABLE USERWKSP(
  "user_id"  integer NOT NULL,
  "workspace_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table USER_ACCEPTANCE_CONSENT'

--METADATA NAME:USER_ACCEPTANCE_CONSENT TYPE:TABLE CHANGE:CREATE

CREATE TABLE USER_ACCEPTANCE_CONSENT(
  "user_id"  integer NOT NULL,
  "status"  integer NULL,
  "modified_date"  datetime DEFAULT getDate() NULL,
  "consent_type"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table USESSAUD'

--METADATA NAME:USESSAUD TYPE:TABLE CHANGE:CREATE

CREATE TABLE USESSAUD(
  "session_id"  integer NULL,
  "login_date"  datetime NULL,
  "logout_date"  datetime NULL,
  "last_active_time"  datetime NULL,
  "user_name"  nvarchar(255) NULL,
  "user_id"  integer NULL,
  "host_name"  nvarchar(50) NULL,
  "app_name"  nvarchar(25) NULL,
  "hard_drive_code"  nvarchar(40) NULL,
  "db_engine_type"  nvarchar(20) NULL,
  "os_user_name"  nvarchar(255) NULL
  )

go

print 'Creating table USESSION'

--METADATA NAME:USESSION TYPE:TABLE CHANGE:CREATE

CREATE TABLE USESSION(
  "session_id"  integer NOT NULL,
  "login_time"  datetime NOT NULL,
  "last_active_time"  datetime NOT NULL,
  "host_name"  nvarchar(50) NOT NULL,
  "user_id"  integer NULL,
  "process_num"  integer NULL,
  "app_name"  nvarchar(25) NULL,
  "hard_drive_code"  nvarchar(40) NULL,
  "db_engine_type"  nvarchar(20) NULL,
  "os_user_name"  nvarchar(255) NULL,
  "vdb_instance_guid"  nvarchar(22) NULL,
  "spid"  integer NULL,
  "operation_name"  nvarchar(255) NULL,
  "operation_start_date"  datetime NULL,
  "long_operation_flag"  nvarchar(1) DEFAULT 'N' NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table USROPNVAL'

--METADATA NAME:USROPNVAL TYPE:TABLE CHANGE:CREATE

CREATE TABLE USROPNVAL(
  "user_open_id"  integer NOT NULL,
  "pk_id"  integer NOT NULL,
  "usropn_type"  nvarchar(20) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table VIEWPREF'

--METADATA NAME:VIEWPREF TYPE:TABLE CHANGE:CREATE

CREATE TABLE VIEWPREF(
  "view_pref_id"  integer NOT NULL,
  "view_pref_name"  nvarchar(255) NOT NULL,
  "view_pref_type"  nvarchar(20) NOT NULL,
  "user_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table VIEWPROP'

--METADATA NAME:VIEWPROP TYPE:TABLE CHANGE:CREATE

CREATE TABLE VIEWPROP(
  "view_id"  integer NOT NULL,
  "view_name"  nvarchar(40) NOT NULL,
  "user_id"  integer NULL,
  "proj_id"  integer NULL,
  "view_type"  nvarchar(20) NULL,
  "view_data"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table VWPREFDASH'

--METADATA NAME:VWPREFDASH TYPE:TABLE CHANGE:CREATE

CREATE TABLE VWPREFDASH(
  "dashboard_id"  integer NOT NULL,
  "view_pref_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table VWPREFDATA'

--METADATA NAME:VWPREFDATA TYPE:TABLE CHANGE:CREATE

CREATE TABLE VWPREFDATA(
  "view_pref_id"  integer NOT NULL,
  "view_pref_key"  nvarchar(255) NOT NULL,
  "view_pref_value"  nvarchar(4000) NULL,
  "view_pref_value_blob"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table VWPREFUSER'

--METADATA NAME:VWPREFUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE VWPREFUSER(
  "view_pref_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table WBRSCAT'

--METADATA NAME:WBRSCAT TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBRSCAT(
  "wbrs_cat_id"  integer NOT NULL,
  "wbrs_cat_name"  nvarchar(36) NOT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table WBSBUDG'

--METADATA NAME:WBSBUDG TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSBUDG(
  "wbs_budg_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "start_date"  datetime NOT NULL,
  "spend_cost"  numeric(23,6) NULL,
  "benefit_cost"  numeric(23,6) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table WBSMEMO'

--METADATA NAME:WBSMEMO TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSMEMO(
  "wbs_memo_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "memo_type_id"  integer NOT NULL,
  "wbs_memo"  TEXT NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table WBSRSRC'

--METADATA NAME:WBSRSRC TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSRSRC(
  "wbsrsrc_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "rsrc_id"  integer NULL,
  "proj_id"  integer NOT NULL,
  "committed_flag"  nvarchar(1) DEFAULT 'Y' NOT NULL,
  "start_date"  datetime NULL,
  "end_date"  datetime NULL,
  "auto_compute_dates_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "role_id"  integer NULL,
  "rsrc_request_data"  nvarchar(4000) NULL,
  "allocation_pct"  numeric(10,2) NULL,
  "wbrs_cat_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table WBSRSRC_QTY'

--METADATA NAME:WBSRSRC_QTY TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSRSRC_QTY(
  "wbsrsrc_id"  integer NOT NULL,
  "week_start"  datetime NOT NULL,
  "month_start"  datetime NOT NULL,
  "qty"  numeric(17,6) NOT NULL,
  "fin_dates_id1"  integer NULL,
  "fin_qty1"  numeric(17,6) NULL,
  "fin_dates_id2"  integer NULL,
  "fin_qty2"  numeric(17,6) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table WBSSTEP'

--METADATA NAME:WBSSTEP TYPE:TABLE CHANGE:CREATE

CREATE TABLE WBSSTEP(
  "wbs_step_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "wbs_id"  integer NOT NULL,
  "seq_num"  integer NOT NULL,
  "complete_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "step_name"  nvarchar(120) NOT NULL,
  "step_wt"  numeric(10,2) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table WKFLTMPL'

--METADATA NAME:WKFLTMPL TYPE:TABLE CHANGE:CREATE

CREATE TABLE WKFLTMPL(
  "wkfl_tmpl_id"  integer NOT NULL,
  "template_name"  nvarchar(255) NOT NULL,
  "project_flag"  nvarchar(1) NOT NULL,
  "wk_external_key"  nvarchar(255) NULL,
  "tmplcatg_catg_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table WKFLUSER'

--METADATA NAME:WKFLUSER TYPE:TABLE CHANGE:CREATE

CREATE TABLE WKFLUSER(
  "work_flow_id"  integer NOT NULL,
  "user_id"  integer NOT NULL,
  "stage_num"  integer NOT NULL,
  "comments"  nvarchar(4000) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table WORKFLOW'

--METADATA NAME:WORKFLOW TYPE:TABLE CHANGE:CREATE

CREATE TABLE WORKFLOW(
  "work_flow_id"  integer NOT NULL,
  "proj_id"  integer NOT NULL,
  "workflow_name"  nvarchar(255) NOT NULL,
  "external_key"  nvarchar(512) NOT NULL,
  "stage_num"  integer NOT NULL,
  "status"  nvarchar(15) NOT NULL,
  "existing_project_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "stage_name"  nvarchar(255) NOT NULL,
  "stage_modified_flag"  nvarchar(1) DEFAULT 'N' NOT NULL,
  "initiated_date"  datetime DEFAULT getDate() NOT NULL,
  "workspace_id"  integer NULL,
  "user_id"  integer NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

print 'Creating table WORKSPACE'

--METADATA NAME:WORKSPACE TYPE:TABLE CHANGE:CREATE

CREATE TABLE WORKSPACE(
  "workspace_id"  integer NOT NULL,
  "workspace_type"  nvarchar(12) NOT NULL,
  "proj_id"  integer NOT NULL,
  "workspace_name"  nvarchar(255) NOT NULL,
  "workspace_prefs"  TEXT NULL,
  "cr_external_key"  nvarchar(4000) NULL,
  "update_date"  datetime NULL,
  "update_user"  nvarchar(255) NULL,
  "create_date"  datetime NULL,
  "create_user"  nvarchar(255) NULL,
  "delete_session_id"  integer NULL,
  "delete_date"  datetime NULL
  )

go

--METADATA NAME:ACCOUNT TYPE:GRANT TABLE_NAME:ACCOUNT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ACCOUNT TO PRIVUSER
go

--METADATA NAME:ACTVCODE TYPE:GRANT TABLE_NAME:ACTVCODE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ACTVCODE TO PRIVUSER
go

--METADATA NAME:ACTVTYPE TYPE:GRANT TABLE_NAME:ACTVTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ACTVTYPE TO PRIVUSER
go

--METADATA NAME:ADMIN_CONFIG TYPE:GRANT TABLE_NAME:ADMIN_CONFIG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ADMIN_CONFIG TO PRIVUSER
go

--METADATA NAME:ASGNMNTACAT TYPE:GRANT TABLE_NAME:ASGNMNTACAT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ASGNMNTACAT TO PRIVUSER
go

--METADATA NAME:ASGNMNTCATTYPE TYPE:GRANT TABLE_NAME:ASGNMNTCATTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ASGNMNTCATTYPE TO PRIVUSER
go

--METADATA NAME:ASGNMNTCATVAL TYPE:GRANT TABLE_NAME:ASGNMNTCATVAL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ASGNMNTCATVAL TO PRIVUSER
go

--METADATA NAME:BASETYPE TYPE:GRANT TABLE_NAME:BASETYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON BASETYPE TO PRIVUSER
go

--METADATA NAME:BGPLOG TYPE:GRANT TABLE_NAME:BGPLOG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON BGPLOG TO PRIVUSER
go

--METADATA NAME:BRE_REGISTRY TYPE:GRANT TABLE_NAME:BRE_REGISTRY CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON BRE_REGISTRY TO PRIVUSER
go

--METADATA NAME:BUDGCHNG TYPE:GRANT TABLE_NAME:BUDGCHNG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON BUDGCHNG TO PRIVUSER
go

--METADATA NAME:CALENDAR TYPE:GRANT TABLE_NAME:CALENDAR CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON CALENDAR TO PRIVUSER
go

--METADATA NAME:COSTTYPE TYPE:GRANT TABLE_NAME:COSTTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON COSTTYPE TO PRIVUSER
go

--METADATA NAME:CURRTYPE TYPE:GRANT TABLE_NAME:CURRTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON CURRTYPE TO PRIVUSER
go

--METADATA NAME:DASHBOARD TYPE:GRANT TABLE_NAME:DASHBOARD CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DASHBOARD TO PRIVUSER
go

--METADATA NAME:DASHUSER TYPE:GRANT TABLE_NAME:DASHUSER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DASHUSER TO PRIVUSER
go

--METADATA NAME:DISCUSSION TYPE:GRANT TABLE_NAME:DISCUSSION CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DISCUSSION TO PRIVUSER
go

--METADATA NAME:DISCUSSION_READ TYPE:GRANT TABLE_NAME:DISCUSSION_READ CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DISCUSSION_READ TO PRIVUSER
go

--METADATA NAME:DLTACCT TYPE:GRANT TABLE_NAME:DLTACCT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DLTACCT TO PRIVUSER
go

--METADATA NAME:DLTACTV TYPE:GRANT TABLE_NAME:DLTACTV CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DLTACTV TO PRIVUSER
go

--METADATA NAME:DLTOBS TYPE:GRANT TABLE_NAME:DLTOBS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DLTOBS TO PRIVUSER
go

--METADATA NAME:DLTROLE TYPE:GRANT TABLE_NAME:DLTROLE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DLTROLE TO PRIVUSER
go

--METADATA NAME:DLTRSRC TYPE:GRANT TABLE_NAME:DLTRSRC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DLTRSRC TO PRIVUSER
go

--METADATA NAME:DLTRSRL TYPE:GRANT TABLE_NAME:DLTRSRL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DLTRSRL TO PRIVUSER
go

--METADATA NAME:DLTUSER TYPE:GRANT TABLE_NAME:DLTUSER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DLTUSER TO PRIVUSER
go

--METADATA NAME:DOCCATG TYPE:GRANT TABLE_NAME:DOCCATG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DOCCATG TO PRIVUSER
go

--METADATA NAME:DOCREVIEW TYPE:GRANT TABLE_NAME:DOCREVIEW CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DOCREVIEW TO PRIVUSER
go

--METADATA NAME:DOCREVIEWTASK TYPE:GRANT TABLE_NAME:DOCREVIEWTASK CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DOCREVIEWTASK TO PRIVUSER
go

--METADATA NAME:DOCSTAT TYPE:GRANT TABLE_NAME:DOCSTAT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DOCSTAT TO PRIVUSER
go

--METADATA NAME:DOCUMENT TYPE:GRANT TABLE_NAME:DOCUMENT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON DOCUMENT TO PRIVUSER
go

--METADATA NAME:EXPPROJ TYPE:GRANT TABLE_NAME:EXPPROJ CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON EXPPROJ TO PRIVUSER
go

--METADATA NAME:EXTAPP TYPE:GRANT TABLE_NAME:EXTAPP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON EXTAPP TO PRIVUSER
go

--METADATA NAME:FACTOR TYPE:GRANT TABLE_NAME:FACTOR CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON FACTOR TO PRIVUSER
go

--METADATA NAME:FACTVAL TYPE:GRANT TABLE_NAME:FACTVAL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON FACTVAL TO PRIVUSER
go

--METADATA NAME:FILTPROP TYPE:GRANT TABLE_NAME:FILTPROP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON FILTPROP TO PRIVUSER
go

--METADATA NAME:FINDATES TYPE:GRANT TABLE_NAME:FINDATES CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON FINDATES TO PRIVUSER
go

--METADATA NAME:FINTMPL TYPE:GRANT TABLE_NAME:FINTMPL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON FINTMPL TO PRIVUSER
go

--METADATA NAME:FORMCATG TYPE:GRANT TABLE_NAME:FORMCATG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON FORMCATG TO PRIVUSER
go

--METADATA NAME:FORMPROJ TYPE:GRANT TABLE_NAME:FORMPROJ CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON FORMPROJ TO PRIVUSER
go

--METADATA NAME:FORMTMPL TYPE:GRANT TABLE_NAME:FORMTMPL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON FORMTMPL TO PRIVUSER
go

--METADATA NAME:FUNDSRC TYPE:GRANT TABLE_NAME:FUNDSRC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON FUNDSRC TO PRIVUSER
go

--METADATA NAME:GCHANGE TYPE:GRANT TABLE_NAME:GCHANGE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON GCHANGE TO PRIVUSER
go

--METADATA NAME:HQDATA TYPE:GRANT TABLE_NAME:HQDATA CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON HQDATA TO PRIVUSER
go

--METADATA NAME:HQUERY TYPE:GRANT TABLE_NAME:HQUERY CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON HQUERY TO PRIVUSER
go

--METADATA NAME:IMAGEDATA TYPE:GRANT TABLE_NAME:IMAGEDATA CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON IMAGEDATA TO PRIVUSER
go

--METADATA NAME:ISSUHIST TYPE:GRANT TABLE_NAME:ISSUHIST CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ISSUHIST TO PRIVUSER
go

--METADATA NAME:ITERATION TYPE:GRANT TABLE_NAME:ITERATION CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ITERATION TO PRIVUSER
go

--METADATA NAME:ITERDAYS TYPE:GRANT TABLE_NAME:ITERDAYS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ITERDAYS TO PRIVUSER
go

--METADATA NAME:ITERGOAL TYPE:GRANT TABLE_NAME:ITERGOAL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ITERGOAL TO PRIVUSER
go

--METADATA NAME:JOBLOG TYPE:GRANT TABLE_NAME:JOBLOG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON JOBLOG TO PRIVUSER
go

--METADATA NAME:JOBRPT TYPE:GRANT TABLE_NAME:JOBRPT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON JOBRPT TO PRIVUSER
go

--METADATA NAME:JOBSVC TYPE:GRANT TABLE_NAME:JOBSVC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON JOBSVC TO PRIVUSER
go

--METADATA NAME:LOCATION TYPE:GRANT TABLE_NAME:LOCATION CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON LOCATION TO PRIVUSER
go

--METADATA NAME:MEMOTYPE TYPE:GRANT TABLE_NAME:MEMOTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON MEMOTYPE TO PRIVUSER
go

--METADATA NAME:NEXTKEY TYPE:GRANT TABLE_NAME:NEXTKEY CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON NEXTKEY TO PRIVUSER
go

--METADATA NAME:NONWORK TYPE:GRANT TABLE_NAME:NONWORK CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON NONWORK TO PRIVUSER
go

--METADATA NAME:NOTE TYPE:GRANT TABLE_NAME:NOTE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON NOTE TO PRIVUSER
go

--METADATA NAME:OBS TYPE:GRANT TABLE_NAME:OBS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON OBS TO PRIVUSER
go

--METADATA NAME:OBSPROJ TYPE:GRANT TABLE_NAME:OBSPROJ CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON OBSPROJ TO PRIVUSER
go

--METADATA NAME:PCATTYPE TYPE:GRANT TABLE_NAME:PCATTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PCATTYPE TO PRIVUSER
go

--METADATA NAME:PCATUSER TYPE:GRANT TABLE_NAME:PCATUSER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PCATUSER TO PRIVUSER
go

--METADATA NAME:PCATVAL TYPE:GRANT TABLE_NAME:PCATVAL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PCATVAL TO PRIVUSER
go

--METADATA NAME:PFOLIO TYPE:GRANT TABLE_NAME:PFOLIO CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PFOLIO TO PRIVUSER
go

--METADATA NAME:PFOLIOUSER TYPE:GRANT TABLE_NAME:PFOLIOUSER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PFOLIOUSER TO PRIVUSER
go

--METADATA NAME:PHASE TYPE:GRANT TABLE_NAME:PHASE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PHASE TO PRIVUSER
go

--METADATA NAME:PKXREF TYPE:GRANT TABLE_NAME:PKXREF CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PKXREF TO PRIVUSER
go

--METADATA NAME:POBS TYPE:GRANT TABLE_NAME:POBS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON POBS TO PRIVUSER
go

--METADATA NAME:PREFER TYPE:GRANT TABLE_NAME:PREFER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PREFER TO PRIVUSER
go

--METADATA NAME:PRMAUDIT TYPE:GRANT TABLE_NAME:PRMAUDIT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PRMAUDIT TO PRIVUSER
go

--METADATA NAME:PRMQUEUE TYPE:GRANT TABLE_NAME:PRMQUEUE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PRMQUEUE TO PRIVUSER
go

--METADATA NAME:PROCGROUP TYPE:GRANT TABLE_NAME:PROCGROUP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROCGROUP TO PRIVUSER
go

--METADATA NAME:PROCITEM TYPE:GRANT TABLE_NAME:PROCITEM CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROCITEM TO PRIVUSER
go

--METADATA NAME:PROFILE TYPE:GRANT TABLE_NAME:PROFILE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROFILE TO PRIVUSER
go

--METADATA NAME:PROFPRIV TYPE:GRANT TABLE_NAME:PROFPRIV CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROFPRIV TO PRIVUSER
go

--METADATA NAME:PROJCOST TYPE:GRANT TABLE_NAME:PROJCOST CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJCOST TO PRIVUSER
go

--METADATA NAME:PROJECT TYPE:GRANT TABLE_NAME:PROJECT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJECT TO PRIVUSER
go

--METADATA NAME:PROJEST TYPE:GRANT TABLE_NAME:PROJEST CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJEST TO PRIVUSER
go

--METADATA NAME:PROJFUND TYPE:GRANT TABLE_NAME:PROJFUND CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJFUND TO PRIVUSER
go

--METADATA NAME:PROJISSU TYPE:GRANT TABLE_NAME:PROJISSU CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJISSU TO PRIVUSER
go

--METADATA NAME:PROJPCAT TYPE:GRANT TABLE_NAME:PROJPCAT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJPCAT TO PRIVUSER
go

--METADATA NAME:PROJPROP TYPE:GRANT TABLE_NAME:PROJPROP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJPROP TO PRIVUSER
go

--METADATA NAME:PROJRISK TYPE:GRANT TABLE_NAME:PROJRISK CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJRISK TO PRIVUSER
go

--METADATA NAME:PROJSHAR TYPE:GRANT TABLE_NAME:PROJSHAR CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJSHAR TO PRIVUSER
go

--METADATA NAME:PROJTHRS TYPE:GRANT TABLE_NAME:PROJTHRS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJTHRS TO PRIVUSER
go

--METADATA NAME:PROJWBS TYPE:GRANT TABLE_NAME:PROJWBS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJWBS TO PRIVUSER
go

--METADATA NAME:PROJWSRPT TYPE:GRANT TABLE_NAME:PROJWSRPT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PROJWSRPT TO PRIVUSER
go

--METADATA NAME:PRPFOLIO TYPE:GRANT TABLE_NAME:PRPFOLIO CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PRPFOLIO TO PRIVUSER
go

--METADATA NAME:PUBUSER TYPE:GRANT TABLE_NAME:PUBUSER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON PUBUSER TO PRIVUSER
go

--METADATA NAME:PUBUSER TYPE:GRANT TABLE_NAME:PUBUSER CHANGE:CREATE
GRANT SELECT ON PUBUSER TO PUBUSER
go

--METADATA NAME:QUERYLIB TYPE:GRANT TABLE_NAME:QUERYLIB CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON QUERYLIB TO PRIVUSER
go

--METADATA NAME:RCATTYPE TYPE:GRANT TABLE_NAME:RCATTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RCATTYPE TO PRIVUSER
go

--METADATA NAME:RCATVAL TYPE:GRANT TABLE_NAME:RCATVAL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RCATVAL TO PRIVUSER
go

--METADATA NAME:REFRDEL TYPE:GRANT TABLE_NAME:REFRDEL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON REFRDEL TO PRIVUSER
go

--METADATA NAME:REITTYPE TYPE:GRANT TABLE_NAME:REITTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON REITTYPE TO PRIVUSER
go

--METADATA NAME:RELEASE TYPE:GRANT TABLE_NAME:RELEASE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RELEASE TO PRIVUSER
go

--METADATA NAME:RELITEMS TYPE:GRANT TABLE_NAME:RELITEMS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RELITEMS TO PRIVUSER
go

--METADATA NAME:RFOLIO TYPE:GRANT TABLE_NAME:RFOLIO CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RFOLIO TO PRIVUSER
go

--METADATA NAME:RISKCTRL TYPE:GRANT TABLE_NAME:RISKCTRL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RISKCTRL TO PRIVUSER
go

--METADATA NAME:RISKTYPE TYPE:GRANT TABLE_NAME:RISKTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RISKTYPE TO PRIVUSER
go

--METADATA NAME:RLFOLIO TYPE:GRANT TABLE_NAME:RLFOLIO CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RLFOLIO TO PRIVUSER
go

--METADATA NAME:ROLECATTYPE TYPE:GRANT TABLE_NAME:ROLECATTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ROLECATTYPE TO PRIVUSER
go

--METADATA NAME:ROLECATVAL TYPE:GRANT TABLE_NAME:ROLECATVAL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ROLECATVAL TO PRIVUSER
go

--METADATA NAME:ROLELIMIT TYPE:GRANT TABLE_NAME:ROLELIMIT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ROLELIMIT TO PRIVUSER
go

--METADATA NAME:ROLERATE TYPE:GRANT TABLE_NAME:ROLERATE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ROLERATE TO PRIVUSER
go

--METADATA NAME:ROLERCAT TYPE:GRANT TABLE_NAME:ROLERCAT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ROLERCAT TO PRIVUSER
go

--METADATA NAME:ROLES TYPE:GRANT TABLE_NAME:ROLES CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ROLES TO PRIVUSER
go

--METADATA NAME:ROLFOLIO TYPE:GRANT TABLE_NAME:ROLFOLIO CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON ROLFOLIO TO PRIVUSER
go

--METADATA NAME:RPT TYPE:GRANT TABLE_NAME:RPT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RPT TO PRIVUSER
go

--METADATA NAME:RPTBATCH TYPE:GRANT TABLE_NAME:RPTBATCH CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RPTBATCH TO PRIVUSER
go

--METADATA NAME:RPTGROUP TYPE:GRANT TABLE_NAME:RPTGROUP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RPTGROUP TO PRIVUSER
go

--METADATA NAME:RPTLIST TYPE:GRANT TABLE_NAME:RPTLIST CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RPTLIST TO PRIVUSER
go

--METADATA NAME:RSRC TYPE:GRANT TABLE_NAME:RSRC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRC TO PRIVUSER
go

--METADATA NAME:RSRCANDASH TYPE:GRANT TABLE_NAME:RSRCANDASH CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRCANDASH TO PRIVUSER
go

--METADATA NAME:RSRCANVIEW TYPE:GRANT TABLE_NAME:RSRCANVIEW CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRCANVIEW TO PRIVUSER
go

--METADATA NAME:RSRCCURV TYPE:GRANT TABLE_NAME:RSRCCURV CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRCCURV TO PRIVUSER
go

--METADATA NAME:RSRCHOUR TYPE:GRANT TABLE_NAME:RSRCHOUR CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRCHOUR TO PRIVUSER
go

--METADATA NAME:RSRCPROP TYPE:GRANT TABLE_NAME:RSRCPROP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRCPROP TO PRIVUSER
go

--METADATA NAME:RSRCRATE TYPE:GRANT TABLE_NAME:RSRCRATE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRCRATE TO PRIVUSER
go

--METADATA NAME:RSRCRCAT TYPE:GRANT TABLE_NAME:RSRCRCAT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRCRCAT TO PRIVUSER
go

--METADATA NAME:RSRCROLE TYPE:GRANT TABLE_NAME:RSRCROLE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRCROLE TO PRIVUSER
go

--METADATA NAME:RSRCSEC TYPE:GRANT TABLE_NAME:RSRCSEC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRCSEC TO PRIVUSER
go

--METADATA NAME:RSRFOLIO TYPE:GRANT TABLE_NAME:RSRFOLIO CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON RSRFOLIO TO PRIVUSER
go

--METADATA NAME:SCENARIO TYPE:GRANT TABLE_NAME:SCENARIO CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SCENARIO TO PRIVUSER
go

--METADATA NAME:SCENPROJ TYPE:GRANT TABLE_NAME:SCENPROJ CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SCENPROJ TO PRIVUSER
go

--METADATA NAME:SCENROLE TYPE:GRANT TABLE_NAME:SCENROLE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SCENROLE TO PRIVUSER
go

--METADATA NAME:SCENUSER TYPE:GRANT TABLE_NAME:SCENUSER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SCENUSER TO PRIVUSER
go

--METADATA NAME:SETTINGS TYPE:GRANT TABLE_NAME:SETTINGS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SETTINGS TO PRIVUSER
go

--METADATA NAME:SHIFT TYPE:GRANT TABLE_NAME:SHIFT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SHIFT TO PRIVUSER
go

--METADATA NAME:SHIFTPER TYPE:GRANT TABLE_NAME:SHIFTPER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SHIFTPER TO PRIVUSER
go

--METADATA NAME:SPIDMAP TYPE:GRANT TABLE_NAME:SPIDMAP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SPIDMAP TO PRIVUSER
go

--METADATA NAME:SUMPROJCOST TYPE:GRANT TABLE_NAME:SUMPROJCOST CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SUMPROJCOST TO PRIVUSER
go

--METADATA NAME:SUMTASK TYPE:GRANT TABLE_NAME:SUMTASK CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SUMTASK TO PRIVUSER
go

--METADATA NAME:SUMTASKSPREAD TYPE:GRANT TABLE_NAME:SUMTASKSPREAD CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SUMTASKSPREAD TO PRIVUSER
go

--METADATA NAME:SUMTRSRC TYPE:GRANT TABLE_NAME:SUMTRSRC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON SUMTRSRC TO PRIVUSER
go

--METADATA NAME:TASK TYPE:GRANT TABLE_NAME:TASK CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASK TO PRIVUSER
go

--METADATA NAME:TASKACTV TYPE:GRANT TABLE_NAME:TASKACTV CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKACTV TO PRIVUSER
go

--METADATA NAME:TASKDOC TYPE:GRANT TABLE_NAME:TASKDOC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKDOC TO PRIVUSER
go

--METADATA NAME:TASKFDBK TYPE:GRANT TABLE_NAME:TASKFDBK CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKFDBK TO PRIVUSER
go

--METADATA NAME:TASKFIN TYPE:GRANT TABLE_NAME:TASKFIN CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKFIN TO PRIVUSER
go

--METADATA NAME:TASKMEMO TYPE:GRANT TABLE_NAME:TASKMEMO CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKMEMO TO PRIVUSER
go

--METADATA NAME:TASKNOTE TYPE:GRANT TABLE_NAME:TASKNOTE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKNOTE TO PRIVUSER
go

--METADATA NAME:TASKPRED TYPE:GRANT TABLE_NAME:TASKPRED CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKPRED TO PRIVUSER
go

--METADATA NAME:TASKPROC TYPE:GRANT TABLE_NAME:TASKPROC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKPROC TO PRIVUSER
go

--METADATA NAME:TASKRISK TYPE:GRANT TABLE_NAME:TASKRISK CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKRISK TO PRIVUSER
go

--METADATA NAME:TASKRSRC TYPE:GRANT TABLE_NAME:TASKRSRC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKRSRC TO PRIVUSER
go

--METADATA NAME:TASKSUM TYPE:GRANT TABLE_NAME:TASKSUM CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKSUM TO PRIVUSER
go

--METADATA NAME:TASKSUMFIN TYPE:GRANT TABLE_NAME:TASKSUMFIN CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKSUMFIN TO PRIVUSER
go

--METADATA NAME:TASKUSER TYPE:GRANT TABLE_NAME:TASKUSER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKUSER TO PRIVUSER
go

--METADATA NAME:TASKWKSP TYPE:GRANT TABLE_NAME:TASKWKSP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TASKWKSP TO PRIVUSER
go

--METADATA NAME:TEMPKEYS TYPE:GRANT TABLE_NAME:TEMPKEYS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TEMPKEYS TO PRIVUSER
go

--METADATA NAME:THRSPARM TYPE:GRANT TABLE_NAME:THRSPARM CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON THRSPARM TO PRIVUSER
go

--METADATA NAME:TIMESHT TYPE:GRANT TABLE_NAME:TIMESHT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TIMESHT TO PRIVUSER
go

--METADATA NAME:TMPLCATG TYPE:GRANT TABLE_NAME:TMPLCATG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TMPLCATG TO PRIVUSER
go

--METADATA NAME:TPROJMAP TYPE:GRANT TABLE_NAME:TPROJMAP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TPROJMAP TO PRIVUSER
go

--METADATA NAME:TRAKVIEW TYPE:GRANT TABLE_NAME:TRAKVIEW CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TRAKVIEW TO PRIVUSER
go

--METADATA NAME:TRSRCFIN TYPE:GRANT TABLE_NAME:TRSRCFIN CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TRSRCFIN TO PRIVUSER
go

--METADATA NAME:TRSRCSUM TYPE:GRANT TABLE_NAME:TRSRCSUM CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TRSRCSUM TO PRIVUSER
go

--METADATA NAME:TRSRCSUMFN TYPE:GRANT TABLE_NAME:TRSRCSUMFN CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TRSRCSUMFN TO PRIVUSER
go

--METADATA NAME:TSAUDIT TYPE:GRANT TABLE_NAME:TSAUDIT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TSAUDIT TO PRIVUSER
go

--METADATA NAME:TSDATES TYPE:GRANT TABLE_NAME:TSDATES CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TSDATES TO PRIVUSER
go

--METADATA NAME:TSDELEGATE TYPE:GRANT TABLE_NAME:TSDELEGATE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON TSDELEGATE TO PRIVUSER
go

--METADATA NAME:UACCESS TYPE:GRANT TABLE_NAME:UACCESS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON UACCESS TO PRIVUSER
go

--METADATA NAME:UDFCODE TYPE:GRANT TABLE_NAME:UDFCODE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON UDFCODE TO PRIVUSER
go

--METADATA NAME:UDFTYPE TYPE:GRANT TABLE_NAME:UDFTYPE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON UDFTYPE TO PRIVUSER
go

--METADATA NAME:UDFVALUE TYPE:GRANT TABLE_NAME:UDFVALUE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON UDFVALUE TO PRIVUSER
go

--METADATA NAME:UEVNTREG TYPE:GRANT TABLE_NAME:UEVNTREG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON UEVNTREG TO PRIVUSER
go

--METADATA NAME:UMEASURE TYPE:GRANT TABLE_NAME:UMEASURE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON UMEASURE TO PRIVUSER
go

--METADATA NAME:UPKLIST TYPE:GRANT TABLE_NAME:UPKLIST CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON UPKLIST TO PRIVUSER
go

--METADATA NAME:USERCOL TYPE:GRANT TABLE_NAME:USERCOL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USERCOL TO PRIVUSER
go

--METADATA NAME:USERDATA TYPE:GRANT TABLE_NAME:USERDATA CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USERDATA TO PRIVUSER
go

--METADATA NAME:USERENG TYPE:GRANT TABLE_NAME:USERENG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USERENG TO PRIVUSER
go

--METADATA NAME:USEROBS TYPE:GRANT TABLE_NAME:USEROBS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USEROBS TO PRIVUSER
go

--METADATA NAME:USEROPEN TYPE:GRANT TABLE_NAME:USEROPEN CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USEROPEN TO PRIVUSER
go

--METADATA NAME:USERS TYPE:GRANT TABLE_NAME:USERS CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USERS TO PRIVUSER
go

--METADATA NAME:USERSET TYPE:GRANT TABLE_NAME:USERSET CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USERSET TO PRIVUSER
go

--METADATA NAME:USERWKSP TYPE:GRANT TABLE_NAME:USERWKSP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USERWKSP TO PRIVUSER
go

--METADATA NAME:USER_ACCEPTANCE_CONSENT TYPE:GRANT TABLE_NAME:USER_ACCEPTANCE_CONSENT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USER_ACCEPTANCE_CONSENT TO PRIVUSER
go

--METADATA NAME:USESSAUD TYPE:GRANT TABLE_NAME:USESSAUD CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USESSAUD TO PRIVUSER
go

--METADATA NAME:USESSION TYPE:GRANT TABLE_NAME:USESSION CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USESSION TO PRIVUSER
go

--METADATA NAME:USROPNVAL TYPE:GRANT TABLE_NAME:USROPNVAL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON USROPNVAL TO PRIVUSER
go

--METADATA NAME:VIEWPREF TYPE:GRANT TABLE_NAME:VIEWPREF CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON VIEWPREF TO PRIVUSER
go

--METADATA NAME:VIEWPROP TYPE:GRANT TABLE_NAME:VIEWPROP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON VIEWPROP TO PRIVUSER
go

--METADATA NAME:VWPREFDASH TYPE:GRANT TABLE_NAME:VWPREFDASH CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON VWPREFDASH TO PRIVUSER
go

--METADATA NAME:VWPREFDATA TYPE:GRANT TABLE_NAME:VWPREFDATA CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON VWPREFDATA TO PRIVUSER
go

--METADATA NAME:VWPREFUSER TYPE:GRANT TABLE_NAME:VWPREFUSER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON VWPREFUSER TO PRIVUSER
go

--METADATA NAME:WBRSCAT TYPE:GRANT TABLE_NAME:WBRSCAT CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WBRSCAT TO PRIVUSER
go

--METADATA NAME:WBSBUDG TYPE:GRANT TABLE_NAME:WBSBUDG CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WBSBUDG TO PRIVUSER
go

--METADATA NAME:WBSMEMO TYPE:GRANT TABLE_NAME:WBSMEMO CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WBSMEMO TO PRIVUSER
go

--METADATA NAME:WBSRSRC TYPE:GRANT TABLE_NAME:WBSRSRC CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WBSRSRC TO PRIVUSER
go

--METADATA NAME:WBSRSRC_QTY TYPE:GRANT TABLE_NAME:WBSRSRC_QTY CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WBSRSRC_QTY TO PRIVUSER
go

--METADATA NAME:WBSSTEP TYPE:GRANT TABLE_NAME:WBSSTEP CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WBSSTEP TO PRIVUSER
go

--METADATA NAME:WKFLTMPL TYPE:GRANT TABLE_NAME:WKFLTMPL CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WKFLTMPL TO PRIVUSER
go

--METADATA NAME:WKFLUSER TYPE:GRANT TABLE_NAME:WKFLUSER CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WKFLUSER TO PRIVUSER
go

--METADATA NAME:WORKFLOW TYPE:GRANT TABLE_NAME:WORKFLOW CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WORKFLOW TO PRIVUSER
go

--METADATA NAME:WORKSPACE TYPE:GRANT TABLE_NAME:WORKSPACE CHANGE:CREATE
GRANT SELECT,INSERT,UPDATE,DELETE ON WORKSPACE TO PRIVUSER
go
